/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.TIcebergContentFileStore;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.ListMap;

public class IcebergContentFileStore {
    private MapListContainer dataFilesWithoutDeletes_ = new MapListContainer();
    private MapListContainer dataFilesWithDeletes_ = new MapListContainer();
    private MapListContainer positionDeleteFiles_ = new MapListContainer();
    private MapListContainer equalityDeleteFiles_ = new MapListContainer();
    private final ConcurrentMap<String, HdfsPartition.FileDescriptor> oldFileDescMap_ = new ConcurrentHashMap<String, HdfsPartition.FileDescriptor>();
    private boolean hasAvro_ = false;
    private boolean hasOrc_ = false;
    private boolean hasParquet_ = false;

    public void addDataFileWithoutDeletes(String pathHash, HdfsPartition.FileDescriptor desc) {
        if (this.dataFilesWithoutDeletes_.add(pathHash, desc)) {
            this.updateFileFormats(desc);
        }
    }

    public void addDataFileWithDeletes(String pathHash, HdfsPartition.FileDescriptor desc) {
        if (this.dataFilesWithDeletes_.add(pathHash, desc)) {
            this.updateFileFormats(desc);
        }
    }

    public void addPositionDeleteFile(String pathHash, HdfsPartition.FileDescriptor desc) {
        if (this.positionDeleteFiles_.add(pathHash, desc)) {
            this.updateFileFormats(desc);
        }
    }

    public void addEqualityDeleteFile(String pathHash, HdfsPartition.FileDescriptor desc) {
        Preconditions.checkState((desc.getFbFileMetadata().icebergMetadata().equalityFieldIdsLength() > 0 ? 1 : 0) != 0);
        if (this.equalityDeleteFiles_.add(pathHash, desc)) {
            this.updateFileFormats(desc);
        }
    }

    public void addOldFileDescriptor(String pathHash, HdfsPartition.FileDescriptor desc) {
        this.oldFileDescMap_.put(pathHash, desc);
    }

    public HdfsPartition.FileDescriptor getDataFileDescriptor(String pathHash) {
        HdfsPartition.FileDescriptor desc = this.dataFilesWithoutDeletes_.get(pathHash);
        if (desc != null) {
            return desc;
        }
        return this.dataFilesWithDeletes_.get(pathHash);
    }

    public HdfsPartition.FileDescriptor getDeleteFileDescriptor(String pathHash) {
        HdfsPartition.FileDescriptor ret = this.positionDeleteFiles_.get(pathHash);
        if (ret != null) {
            return ret;
        }
        return this.equalityDeleteFiles_.get(pathHash);
    }

    public HdfsPartition.FileDescriptor getOldFileDescriptor(String pathHash) {
        return (HdfsPartition.FileDescriptor)this.oldFileDescMap_.get(pathHash);
    }

    public List<HdfsPartition.FileDescriptor> getDataFilesWithoutDeletes() {
        return this.dataFilesWithoutDeletes_.getList();
    }

    public List<HdfsPartition.FileDescriptor> getDataFilesWithDeletes() {
        return this.dataFilesWithDeletes_.getList();
    }

    public List<HdfsPartition.FileDescriptor> getPositionDeleteFiles() {
        return this.positionDeleteFiles_.getList();
    }

    public List<HdfsPartition.FileDescriptor> getEqualityDeleteFiles() {
        return this.equalityDeleteFiles_.getList();
    }

    public long getNumFiles() {
        return this.dataFilesWithoutDeletes_.getNumFiles() + this.dataFilesWithDeletes_.getNumFiles() + this.positionDeleteFiles_.getNumFiles() + this.equalityDeleteFiles_.getNumFiles();
    }

    public Iterable<HdfsPartition.FileDescriptor> getAllFiles() {
        return Iterables.concat(this.dataFilesWithoutDeletes_.getList(), this.dataFilesWithDeletes_.getList(), this.positionDeleteFiles_.getList(), this.equalityDeleteFiles_.getList());
    }

    public Iterable<HdfsPartition.FileDescriptor> getAllDataFiles() {
        return Iterables.concat(this.dataFilesWithoutDeletes_.getList(), this.dataFilesWithDeletes_.getList());
    }

    public boolean hasAvro() {
        return this.hasAvro_;
    }

    public boolean hasOrc() {
        return this.hasOrc_;
    }

    public boolean hasParquet() {
        return this.hasParquet_;
    }

    private void updateFileFormats(HdfsPartition.FileDescriptor desc) {
        byte fileFormat = desc.getFbFileMetadata().icebergMetadata().fileFormat();
        if (fileFormat == 0) {
            this.hasParquet_ = true;
        } else if (fileFormat == 1) {
            this.hasOrc_ = true;
        } else if (fileFormat == 2) {
            this.hasAvro_ = true;
        }
    }

    public TIcebergContentFileStore toThrift() {
        TIcebergContentFileStore ret = new TIcebergContentFileStore();
        ret.setPath_hash_to_data_file_without_deletes(this.dataFilesWithoutDeletes_.toThrift());
        ret.setPath_hash_to_data_file_with_deletes(this.dataFilesWithDeletes_.toThrift());
        ret.setPath_hash_to_position_delete_file(this.positionDeleteFiles_.toThrift());
        ret.setPath_hash_to_equality_delete_file(this.equalityDeleteFiles_.toThrift());
        ret.setHas_avro(this.hasAvro_);
        ret.setHas_orc(this.hasOrc_);
        ret.setHas_parquet(this.hasParquet_);
        return ret;
    }

    public static IcebergContentFileStore fromThrift(TIcebergContentFileStore tFileStore, List<TNetworkAddress> networkAddresses, ListMap<TNetworkAddress> hostIndex) {
        IcebergContentFileStore ret = new IcebergContentFileStore();
        if (tFileStore.isSetPath_hash_to_data_file_without_deletes()) {
            ret.dataFilesWithoutDeletes_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_data_file_without_deletes(), networkAddresses, hostIndex);
        }
        if (tFileStore.isSetPath_hash_to_data_file_with_deletes()) {
            ret.dataFilesWithDeletes_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_data_file_with_deletes(), networkAddresses, hostIndex);
        }
        if (tFileStore.isSetPath_hash_to_position_delete_file()) {
            ret.positionDeleteFiles_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_position_delete_file(), networkAddresses, hostIndex);
        }
        if (tFileStore.isSetPath_hash_to_equality_delete_file()) {
            ret.equalityDeleteFiles_ = MapListContainer.fromThrift(tFileStore.getPath_hash_to_equality_delete_file(), networkAddresses, hostIndex);
        }
        ret.hasAvro_ = tFileStore.isSetHas_avro() ? tFileStore.isHas_avro() : false;
        ret.hasOrc_ = tFileStore.isSetHas_orc() ? tFileStore.isHas_orc() : false;
        ret.hasParquet_ = tFileStore.isSetHas_parquet() ? tFileStore.isHas_parquet() : false;
        return ret;
    }

    private static class MapListContainer {
        private final Map<String, HdfsPartition.FileDescriptor> fileDescMap_ = new HashMap<String, HdfsPartition.FileDescriptor>();
        private final List<HdfsPartition.FileDescriptor> fileDescList_ = new ArrayList<HdfsPartition.FileDescriptor>();

        private MapListContainer() {
        }

        public boolean add(String pathHash, HdfsPartition.FileDescriptor desc) {
            if (this.fileDescMap_.put(pathHash, desc) == null) {
                this.fileDescList_.add(desc);
                return true;
            }
            return false;
        }

        public HdfsPartition.FileDescriptor get(String pathHash) {
            return this.fileDescMap_.get(pathHash);
        }

        public long getNumFiles() {
            return this.fileDescList_.size();
        }

        List<HdfsPartition.FileDescriptor> getList() {
            return this.fileDescList_;
        }

        Map<String, THdfsFileDesc> toThrift() {
            HashMap<String, THdfsFileDesc> ret = new HashMap<String, THdfsFileDesc>();
            for (Map.Entry<String, HdfsPartition.FileDescriptor> entry : this.fileDescMap_.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().toThrift());
            }
            return ret;
        }

        static MapListContainer fromThrift(Map<String, THdfsFileDesc> thriftMap, List<TNetworkAddress> networkAddresses, ListMap<TNetworkAddress> hostIndex) {
            MapListContainer ret = new MapListContainer();
            for (Map.Entry<String, THdfsFileDesc> entry : thriftMap.entrySet()) {
                HdfsPartition.FileDescriptor fd = HdfsPartition.FileDescriptor.fromThrift(entry.getValue());
                Preconditions.checkNotNull((Object)fd);
                if (networkAddresses != null) {
                    Preconditions.checkNotNull(hostIndex);
                    fd = fd.cloneWithNewHostIndex(networkAddresses, hostIndex);
                }
                ret.add(entry.getKey(), fd);
            }
            return ret;
        }
    }
}

