/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnDescriptor;

public class IcebergColumn
extends Column {
    private final int fieldId_;
    private final int fieldMapKeyId_;
    private final int fieldMapValueId_;
    private final boolean isNullable_;

    public IcebergColumn(String name, Type type, String comment, int position, int fieldId, int fieldMapKeyId, int fieldMapValueId, boolean isNullable) {
        super(name.toLowerCase(), type, comment, position);
        this.fieldId_ = fieldId;
        this.fieldMapKeyId_ = fieldMapKeyId;
        this.fieldMapValueId_ = fieldMapValueId;
        this.isNullable_ = isNullable;
    }

    public static IcebergColumn cloneWithNullability(IcebergColumn source, boolean isNullable) {
        return new IcebergColumn(source.name_, source.type_, source.comment_, source.position_, source.fieldId_, source.fieldMapKeyId_, source.fieldMapKeyId_, isNullable);
    }

    public int getFieldId() {
        return this.fieldId_;
    }

    public boolean isNullable() {
        return this.isNullable_;
    }

    @Override
    public TColumn toThrift() {
        TColumn tcol = super.toThrift();
        tcol.setIs_iceberg_column(true);
        tcol.setIceberg_field_id(this.fieldId_);
        tcol.setIceberg_field_map_key_id(this.fieldMapKeyId_);
        tcol.setIceberg_field_map_value_id(this.fieldMapValueId_);
        tcol.setIs_nullable(this.isNullable_);
        return tcol;
    }

    @Override
    public TColumnDescriptor toDescriptor() {
        TColumnDescriptor desc = super.toDescriptor();
        desc.setIcebergFieldId(this.fieldId_);
        desc.setIcebergFieldMapKeyId(this.fieldMapKeyId_);
        desc.setIcebergFieldMapValueId(this.fieldMapValueId_);
        return desc;
    }
}

