/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.thrift.THdfsFileFormat;

public class HiveStorageDescriptorFactory {
    public static StorageDescriptor createSd(THdfsFileFormat fileFormat, RowFormat rowFormat) {
        Preconditions.checkNotNull((Object)((Object)fileFormat));
        Preconditions.checkNotNull((Object)rowFormat);
        StorageDescriptor sd = new StorageDescriptor();
        sd.setSerdeInfo(new SerDeInfo());
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.setCompressed(false);
        HdfsFileFormat hdfsFileFormat = HdfsFileFormat.fromThrift(fileFormat);
        sd.setInputFormat(hdfsFileFormat.inputFormat());
        sd.setOutputFormat(hdfsFileFormat.outputFormat());
        sd.getSerdeInfo().setSerializationLib(hdfsFileFormat.serializationLib());
        sd.setBucketCols(new ArrayList(0));
        sd.setSortCols(new ArrayList(0));
        HiveStorageDescriptorFactory.setSerdeInfo(rowFormat, sd.getSerdeInfo());
        return sd;
    }

    public static void setSerdeInfo(RowFormat rowFormat, SerDeInfo serdeInfo) {
        if (rowFormat.getFieldDelimiter() != null) {
            serdeInfo.putToParameters("serialization.format", rowFormat.getFieldDelimiter());
            serdeInfo.putToParameters("field.delim", rowFormat.getFieldDelimiter());
        }
        if (rowFormat.getEscapeChar() != null) {
            serdeInfo.putToParameters("escape.delim", rowFormat.getEscapeChar());
        }
        if (rowFormat.getLineDelimiter() != null) {
            serdeInfo.putToParameters("line.delim", rowFormat.getLineDelimiter());
        }
    }
}

