/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.HdfsTableLoadParams;
import org.apache.impala.util.EventSequence;

public class HdfsTableLoadParamsBuilder {
    boolean reuseMetadata_;
    IMetaStoreClient client_;
    Table msTbl_;
    boolean loadPartitionFileMetadata_;
    boolean loadTableSchema_;
    boolean refreshUpdatedPartitions_;
    Set<String> partitionsToUpdate_;
    String debugAction_;
    Map<String, Long> partitionToEventId_;
    String reason_;
    EventSequence catalogTimeline_;
    boolean isPreLoadForInsert_;

    public HdfsTableLoadParamsBuilder(IMetaStoreClient client, Table msTbl) {
        this.client_ = client;
        this.msTbl_ = msTbl;
    }

    public HdfsTableLoadParamsBuilder reuseMetadata(boolean reuseMetadata) {
        this.reuseMetadata_ = reuseMetadata;
        return this;
    }

    public HdfsTableLoadParamsBuilder setMsClient(IMetaStoreClient client) {
        this.client_ = client;
        return this;
    }

    public HdfsTableLoadParamsBuilder setMetastoreTable(Table msTbl) {
        this.msTbl_ = msTbl;
        return this;
    }

    public HdfsTableLoadParamsBuilder setLoadPartitionFileMetadata(boolean loadPartitionFileMetadata) {
        this.loadPartitionFileMetadata_ = loadPartitionFileMetadata;
        return this;
    }

    public HdfsTableLoadParamsBuilder setLoadTableSchema(boolean loadTableSchema) {
        this.loadTableSchema_ = loadTableSchema;
        return this;
    }

    public HdfsTableLoadParamsBuilder setRefreshUpdatedPartitions(boolean refreshUpdatedPartitions) {
        this.refreshUpdatedPartitions_ = refreshUpdatedPartitions;
        return this;
    }

    public HdfsTableLoadParamsBuilder setPartitionsToUpdate(Set<String> partitionsToUpdate) {
        if (partitionsToUpdate != null) {
            this.partitionsToUpdate_ = new HashSet<String>(partitionsToUpdate);
        }
        return this;
    }

    public HdfsTableLoadParamsBuilder setDebugAction(String debugAction) {
        this.debugAction_ = debugAction;
        return this;
    }

    public HdfsTableLoadParamsBuilder setPartitionToEventId(Map<String, Long> partitionToEventId) {
        this.partitionToEventId_ = partitionToEventId;
        return this;
    }

    public HdfsTableLoadParamsBuilder setReason(String reason) {
        this.reason_ = reason;
        return this;
    }

    public HdfsTableLoadParamsBuilder setCatalogTimeline(EventSequence catalogTimeline) {
        this.catalogTimeline_ = catalogTimeline;
        return this;
    }

    public HdfsTableLoadParamsBuilder setIsPreLoadForInsert(boolean isPreLoadForInsert) {
        this.isPreLoadForInsert_ = isPreLoadForInsert;
        return this;
    }

    public HdfsTableLoadParams build() {
        return new HdfsTableLoadParams(this.reuseMetadata_, this.client_, this.msTbl_, this.loadPartitionFileMetadata_, this.loadTableSchema_, this.refreshUpdatedPartitions_, this.partitionsToUpdate_, this.debugAction_, this.partitionToEventId_, this.reason_, this.catalogTimeline_, this.isPreLoadForInsert_);
    }
}

