/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FileMetadataLoadOpts;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.HdfsTableLoadParams;
import org.apache.impala.catalog.HdfsTableLoadParamsBuilder;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.ParallelFileMetadataLoader;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.fb.FbFileBlock;
import org.apache.impala.hive.common.MutableValidReaderWriteIdList;
import org.apache.impala.hive.common.MutableValidWriteIdList;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TSqlConstraints;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.AvroSchemaConverter;
import org.apache.impala.util.AvroSchemaUtils;
import org.apache.impala.util.DebugUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.FsPermissionCache;
import org.apache.impala.util.FsPermissionChecker;
import org.apache.impala.util.HdfsCachingUtil;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.impala.util.TAccessLevelUtil;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.impala.util.ThreadNameAnnotator;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTable
extends Table
implements FeFsTable {
    public static final String DEFAULT_PARTITION_NAME = "";
    private static final int NUM_PARTITION_FETCH_RETRIES = 5;
    public static final String TBL_PROP_ENABLE_STATS_EXTRAPOLATION = "impala.enable.stats.extrapolation";
    public static final String TBL_PROP_DISABLE_RECURSIVE_LISTING = "impala.disable.recursive.listing";
    private static final long PER_PARTITION_MEM_USAGE_BYTES = 2048L;
    private static final long PER_FD_MEM_USAGE_BYTES = 500L;
    private static final long PER_BLOCK_MEM_USAGE_BYTES = 150L;
    public static final String CATALOG_UPDATE_DURATION_METRIC = "catalog-update-duration";
    public static final String NUM_PARTITIONS_METRIC = "num-partitions";
    public static final String NUM_FILES_METRIC = "num-files";
    public static final String NUM_BLOCKS_METRIC = "num-blocks";
    public static final String TOTAL_FILE_BYTES_METRIC = "total-file-size-bytes";
    public static final String MEMORY_ESTIMATE_METRIC = "memory-estimate-bytes";
    public static final String HAS_INCREMENTAL_STATS_METRIC = "has-incremental-stats";
    public static final String FILEMETADATA_CACHE_MISS_METRIC = "filemetadata-cache-miss";
    public static final String FILEMETADATA_CACHE_HIT_METRIC = "filemetadata-cache-hit";
    public static final String NUM_LOAD_FILEMETADATA_METRIC = "num-load-filemetadata";
    public static final String LOAD_DURATION_ALL_PARTITIONS = "load-duration.all-partitions";
    public static final String LOAD_DURATION_FILE_METADATA_ALL_PARTITIONS = "load-duration.all-partitions.file-metadata";
    private static final THdfsPartition FAKE_THDFS_PARTITION = new THdfsPartition();
    private String nullColumnValue_;
    private String nullPartitionKeyValue_;
    private String avroSchema_ = null;
    private boolean hasAvroData_ = false;
    private boolean isMarkedCached_ = false;
    protected final List<TreeMap<LiteralExpr, Set<Long>>> partitionValuesMap_ = new ArrayList<TreeMap<LiteralExpr, Set<Long>>>();
    protected final List<Set<Long>> nullPartitionIds_ = new ArrayList<Set<Long>>();
    protected final Map<Long, HdfsPartition> partitionMap_ = new HashMap<Long, HdfsPartition>();
    private GroupedContentFiles icebergFiles_;
    private boolean canDataBeOutsideOfTableLocation_ = false;
    protected final Map<String, HdfsPartition> nameToPartitionMap_ = new HashMap<String, HdfsPartition>();
    @VisibleForTesting
    HdfsPartition prototypePartition_;
    public static final long STATS_SIZE_PER_COLUMN_BYTES = 200L;
    private final ListMap<TNetworkAddress> hostIndex_ = new ListMap();
    private boolean hasIncrementalStats_ = false;
    protected HdfsPartitionLocationCompressor partitionLocationCompressor_;
    protected String hdfsBaseDir_;
    private final List<FieldSchema> nonPartFieldSchemas_ = new ArrayList<FieldSchema>();
    private boolean isSchemaLoaded_ = false;
    private SqlConstraints sqlConstraints_ = new SqlConstraints(new ArrayList<SQLPrimaryKey>(), new ArrayList<SQLForeignKey>());
    protected MutableValidWriteIdList validWriteIds_ = null;
    private long lastCompactionId_ = -1L;
    private final Map<Long, HdfsPartition.Builder> dirtyPartitions_ = new HashMap<Long, HdfsPartition.Builder>();
    private long maxSentPartitionId_ = -1L;
    private final Set<HdfsPartition> droppedPartitions_ = new HashSet<HdfsPartition>();
    private long pendingVersionNumber_ = -1L;
    private final Object pendingVersionLock_ = new Object();
    private long lastVersionSeenByTopicUpdate_ = -1L;
    private final FileMetadataStats fileMetadataStats_ = new FileMetadataStats();
    private static final Logger LOG = LoggerFactory.getLogger(HdfsTable.class);
    public static final long LOADING_WARNING_TIME_NS = 5000000000L;

    public void setIcebergFiles(GroupedContentFiles icebergFiles) {
        this.icebergFiles_ = icebergFiles;
    }

    public void setCanDataBeOutsideOfTableLocation(boolean canDataBeOutsideOfTableLocation) {
        this.canDataBeOutsideOfTableLocation_ = canDataBeOutsideOfTableLocation;
    }

    public HdfsTable(org.apache.hadoop.hive.metastore.api.Table msTbl, Db db, String name, String owner) {
        super(msTbl, db, name, owner);
        this.partitionLocationCompressor_ = new HdfsPartitionLocationCompressor(this.numClusteringCols_);
        this.icebergFiles_ = new GroupedContentFiles();
    }

    @Override
    public boolean isLocationCacheable() {
        return FileSystemUtil.isPathCacheable(new Path(this.getLocation()));
    }

    @Override
    public boolean isCacheable() {
        if (!this.isLocationCacheable()) {
            return false;
        }
        if (!this.isMarkedCached() && this.numClusteringCols_ > 0) {
            for (FeFsPartition feFsPartition : this.partitionMap_.values()) {
                if (feFsPartition.isCacheable()) continue;
                return false;
            }
        }
        return true;
    }

    public void computeHdfsStatsForTesting() {
        Preconditions.checkState((this.fileMetadataStats_.numFiles == -1L && this.fileMetadataStats_.totalFileBytes == -1L ? 1 : 0) != 0);
        this.fileMetadataStats_.init();
        for (HdfsPartition partition : this.partitionMap_.values()) {
            this.fileMetadataStats_.numFiles += (long)partition.getNumFileDescriptors();
            this.fileMetadataStats_.totalFileBytes += partition.getSize();
        }
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public boolean isMarkedCached() {
        return this.isMarkedCached_;
    }

    @Override
    public Collection<? extends PrunablePartition> getPartitions() {
        return this.partitionMap_.values();
    }

    @Override
    public Map<Long, ? extends PrunablePartition> getPartitionMap() {
        return this.partitionMap_;
    }

    public List<FeFsPartition> loadPartitions(Collection<Long> ids) {
        ArrayList partitions = Lists.newArrayListWithCapacity((int)ids.size());
        for (Long id : ids) {
            HdfsPartition partition = this.partitionMap_.get(id);
            if (partition == null) {
                throw new IllegalArgumentException("no such partition id " + id);
            }
            partitions.add(partition);
        }
        return partitions;
    }

    @Override
    public Set<Long> getNullPartitionIds(int i) {
        return this.nullPartitionIds_.get(i);
    }

    public HdfsPartitionLocationCompressor getPartitionLocationCompressor() {
        return this.partitionLocationCompressor_;
    }

    @Override
    public Set<Long> getPartitionIds() {
        return Collections.unmodifiableSet(this.partitionMap_.keySet());
    }

    @Override
    public TreeMap<LiteralExpr, Set<Long>> getPartitionValueMap(int i) {
        return this.partitionValuesMap_.get(i);
    }

    @Override
    public String getNullPartitionKeyValue() {
        return this.nullPartitionKeyValue_;
    }

    @Override
    public String getLocation() {
        return super.getMetaStoreTable().getSd().getLocation();
    }

    List<FieldSchema> getNonPartitionFieldSchemas() {
        return this.nonPartFieldSchemas_;
    }

    @Override
    public boolean hasWriteAccessToBaseDir() {
        return TAccessLevelUtil.impliesWriteAccess(this.accessLevel_);
    }

    @Override
    public String getFirstLocationWithoutWriteAccess() {
        if (!this.hasWriteAccessToBaseDir()) {
            return this.hdfsBaseDir_;
        }
        for (HdfsPartition partition : this.partitionMap_.values()) {
            if (TAccessLevelUtil.impliesWriteAccess(partition.getAccessLevel())) continue;
            return partition.getLocation();
        }
        return null;
    }

    public void markDirtyPartition(HdfsPartition.Builder partBuilder) {
        this.dirtyPartitions_.put(partBuilder.getOldId(), partBuilder);
    }

    public void markDirtyPartitions(Collection<HdfsPartition.Builder> partBuilders) {
        for (HdfsPartition.Builder b : partBuilders) {
            this.markDirtyPartition(b);
        }
    }

    public HdfsPartition.Builder pickInprogressPartitionBuilder(HdfsPartition partition) {
        return this.dirtyPartitions_.remove(partition.getId());
    }

    @Override
    public boolean hasInProgressModification() {
        return !this.dirtyPartitions_.isEmpty();
    }

    @Override
    public void resetInProgressModification() {
        this.dirtyPartitions_.clear();
    }

    public static PrunablePartition getPartition(FeFsTable table, List<PartitionKeyValue> partitionSpec) {
        ArrayList<TPartitionKeyValue> partitionKeyValues = new ArrayList<TPartitionKeyValue>();
        for (PartitionKeyValue kv : partitionSpec) {
            Preconditions.checkArgument((boolean)kv.isStatic(), (String)"unexpected dynamic partition: %s", (Object)kv);
            String value = PartitionKeyValue.getPartitionKeyValueString(kv.getLiteralValue(), table.getNullPartitionKeyValue());
            partitionKeyValues.add(new TPartitionKeyValue(kv.getColName(), value));
        }
        return FeFsTable.Utils.getPartitionFromThriftPartitionSpec(table, partitionKeyValues);
    }

    public HdfsPartition getPartition(List<LiteralExpr> partValues) {
        Preconditions.checkNotNull(partValues);
        for (HdfsPartition partition : this.partitionMap_.values()) {
            if (!partValues.equals(partition.getPartitionValues())) continue;
            return partition;
        }
        return null;
    }

    public HdfsPartition getPartitionFromThriftPartitionSpec(List<TPartitionKeyValue> partitionSpec) {
        return (HdfsPartition)FeFsTable.Utils.getPartitionFromThriftPartitionSpec(this, partitionSpec);
    }

    public List<HdfsPartition> getPartitionsFromPartitionSet(List<List<TPartitionKeyValue>> partitionSet) {
        return FeFsTable.Utils.getPartitionsFromPartitionSet(this, partitionSet);
    }

    private void addColumnsFromFieldSchemas(List<FieldSchema> fieldSchemas) throws TableLoadingException {
        int pos = this.colsByPos_.size();
        for (FieldSchema s : fieldSchemas) {
            Type type = this.parseColumnType(s);
            if (pos < this.numClusteringCols_ && !type.supportsTablePartitioning()) {
                throw new TableLoadingException(String.format("Failed to load metadata for table '%s' because of unsupported partition-column type '%s' in partition column '%s'", this.getFullName(), type.toString(), s.getName()));
            }
            Column col = new Column(s.getName(), type, s.getComment(), pos);
            this.addColumn(col);
            ++pos;
        }
    }

    private void addColumnsForFullAcidTable(List<FieldSchema> fieldSchemas) throws TableLoadingException {
        this.addColumn(AcidUtils.getRowIdColumnType(this.colsByPos_.size()));
        this.addColumnsFromFieldSchemas(fieldSchemas);
    }

    private void addVirtualColumns() {
        this.addVirtualColumn(VirtualColumn.INPUT_FILE_NAME);
        this.addVirtualColumn(VirtualColumn.FILE_POSITION);
    }

    protected void resetPartitions() {
        this.partitionMap_.clear();
        this.nameToPartitionMap_.clear();
        this.partitionValuesMap_.clear();
        this.nullPartitionIds_.clear();
        if (this.isStoredInImpaladCatalogCache()) {
            for (int i = 0; i < this.numClusteringCols_; ++i) {
                this.getColumns().get(i).getStats().setNumNulls(0L);
                this.getColumns().get(i).getStats().setNumDistinctValues(0L);
                this.partitionValuesMap_.add(new TreeMap());
                this.nullPartitionIds_.add(new HashSet());
            }
        }
        this.fileMetadataStats_.init();
    }

    public void initializePartitionMetadata(org.apache.hadoop.hive.metastore.api.Table msTbl) throws CatalogException {
        Preconditions.checkNotNull((Object)msTbl);
        this.resetPartitions();
        this.hdfsBaseDir_ = msTbl.getSd().getLocation();
        this.setPrototypePartition(msTbl.getSd());
        this.isMarkedCached_ = HdfsCachingUtil.validateCacheParams(msTbl.getParameters());
    }

    private long loadAllPartitions(IMetaStoreClient client, List<Partition> msPartitions, org.apache.hadoop.hive.metastore.api.Table msTbl, EventSequence catalogTimeline) throws IOException, CatalogException {
        Preconditions.checkNotNull((Object)msTbl);
        Clock clock = Clock.defaultClock();
        long startTime = clock.getTick();
        this.initializePartitionMetadata(msTbl);
        FsPermissionCache permCache = this.preloadPermissionsCache(msPartitions, catalogTimeline);
        Path tblLocation = FileSystemUtil.createFullyQualifiedPath(this.getHdfsBaseDirPath());
        this.accessLevel_ = HdfsTable.getAvailableAccessLevel(this.getFullName(), tblLocation, permCache);
        catalogTimeline.markEvent("Got access level");
        ArrayList<HdfsPartition.Builder> partBuilders = new ArrayList<HdfsPartition.Builder>();
        if (msTbl.getPartitionKeysSize() == 0) {
            if (!IcebergTable.isIcebergTable(msTbl)) {
                Preconditions.checkArgument((msPartitions == null || msPartitions.isEmpty() ? 1 : 0) != 0);
            }
            HdfsPartition.Builder partBuilder = this.createPartitionBuilder(msTbl.getSd(), null, permCache);
            partBuilder.setIsMarkedCached(this.isMarkedCached_);
            this.setUnpartitionedTableStats(partBuilder);
            partBuilders.add(partBuilder);
        } else {
            for (Partition msPartition : msPartitions) {
                partBuilders.add(this.createPartitionBuilder(msPartition.getSd(), msPartition, permCache));
            }
            catalogTimeline.markEvent("Created partition builders");
        }
        Timer.Context fileMetadataLdContext = this.getMetrics().getTimer(LOAD_DURATION_FILE_METADATA_ALL_PARTITIONS).time();
        this.loadFileMetadataForPartitions(client, partBuilders, false, catalogTimeline);
        fileMetadataLdContext.stop();
        for (HdfsPartition.Builder p : partBuilders) {
            this.addPartition(p.build());
        }
        return clock.getTick() - startTime;
    }

    private ValidTxnList loadValidTxns(IMetaStoreClient client) throws CatalogException {
        try {
            return MetastoreShim.getValidTxns(client);
        }
        catch (TException exception) {
            throw new CatalogException(exception.getMessage());
        }
    }

    public long loadFileMetadataForPartitions(IMetaStoreClient client, Collection<HdfsPartition.Builder> partBuilders, boolean isRefresh, EventSequence catalogTimeline) throws CatalogException {
        return this.loadFileMetadataForPartitions(client, partBuilders, isRefresh, null, catalogTimeline);
    }

    private long loadFileMetadataForPartitions(IMetaStoreClient client, Collection<HdfsPartition.Builder> partBuilders, boolean isRefresh, String debugActions, EventSequence catalogTimeline) throws CatalogException {
        this.getMetrics().getCounter(NUM_LOAD_FILEMETADATA_METRIC).inc();
        Clock clock = Clock.defaultClock();
        long startTime = clock.getTick();
        catalogTimeline.markEvent(String.format("Start %s file metadata", isRefresh ? "refreshing" : "loading"));
        if (DebugUtils.hasDebugAction(debugActions, "catalogd_load_file_metadata_throw_exception")) {
            throw new CatalogException("Threw a catalog exception due to the debug action during loading file metadata.");
        }
        ValidTxnList validTxnList = this.validWriteIds_ != null ? this.loadValidTxns(client) : null;
        String logPrefix = String.format("%s file and block metadata for %s paths for table %s", isRefresh ? "Refreshing" : "Loading", partBuilders.size(), this.getFullName());
        new ParallelFileMetadataLoader(this.getFileSystem(), partBuilders, this.validWriteIds_, validTxnList, FeFsTable.Utils.shouldRecursivelyListPartitions(this), this.getHostIndex(), debugActions, logPrefix, this.icebergFiles_, this.canDataBeOutsideOfTableLocation_).load();
        String partNames = Joiner.on((String)", ").join(Iterables.limit((Iterable)Iterables.transform(partBuilders, HdfsPartition.Builder::getPartitionName), (int)3));
        if (partBuilders.size() > 3) {
            partNames = partNames + String.format(", and %s others", Iterables.size(partBuilders) - 3);
        }
        catalogTimeline.markEvent(String.format("Loaded file metadata for %d partitions", partBuilders.size()));
        long duration = clock.getTick() - startTime;
        LOG.info("Loaded file and block metadata for {} partitions: {}. Time taken: {}", new Object[]{this.getFullName(), partNames, PrintUtils.printTimeNs(duration)});
        return duration;
    }

    private static TAccessLevel getAvailableAccessLevel(String tableName, Path location, FsPermissionCache permCache) throws IOException {
        Preconditions.checkNotNull((Object)location);
        FileSystem fs = location.getFileSystem(CONF);
        if (HdfsTable.assumeReadWriteAccess(fs)) {
            return TAccessLevel.READ_WRITE;
        }
        while (location != null) {
            try {
                FsPermissionChecker.Permissions perms = permCache.getPermissions(location);
                if (perms.canReadAndWrite()) {
                    return TAccessLevel.READ_WRITE;
                }
                if (perms.canRead()) {
                    return TAccessLevel.READ_ONLY;
                }
                if (perms.canWrite()) {
                    return TAccessLevel.WRITE_ONLY;
                }
                return TAccessLevel.NONE;
            }
            catch (FileNotFoundException e) {
                location = location.getParent();
            }
        }
        throw new NullPointerException("Error determining access level for table " + tableName + ": no path ancestor exists for path: " + location);
    }

    private static boolean assumeReadWriteAccess(FileSystem fs) {
        if (BackendConfig.INSTANCE.isMinimalTopicMode()) {
            return true;
        }
        if (FileSystemUtil.isDistributedFileSystem(fs) && BackendConfig.INSTANCE.getAuthorizationProvider().equalsIgnoreCase("ranger")) {
            return true;
        }
        if (FileSystemUtil.isS3AFileSystem(fs)) {
            return true;
        }
        if (FileSystemUtil.isADLFileSystem(fs)) {
            return true;
        }
        if (FileSystemUtil.isABFSFileSystem(fs)) {
            return true;
        }
        if (FileSystemUtil.isGCSFileSystem(fs)) {
            return true;
        }
        if (FileSystemUtil.isCOSFileSystem(fs)) {
            return true;
        }
        return FileSystemUtil.isOSSFileSystem(fs);
    }

    public List<HdfsPartition> createAndLoadPartitions(IMetaStoreClient client, List<Partition> msPartitions, @Nullable Map<String, Long> msPartitionsToEventId, EventSequence catalogTimeline) throws CatalogException {
        ArrayList<HdfsPartition.Builder> addedPartBuilders = new ArrayList<HdfsPartition.Builder>();
        FsPermissionCache permCache = this.preloadPermissionsCache(msPartitions, catalogTimeline);
        for (Partition partition : msPartitions) {
            HdfsPartition.Builder partBuilder = this.createPartitionBuilder(partition.getSd(), partition, permCache);
            Preconditions.checkNotNull((Object)partBuilder);
            long eventId = -1L;
            if (msPartitionsToEventId != null) {
                String partName = FeCatalogUtils.getPartitionName(this, partition.getValues());
                if (!msPartitionsToEventId.containsKey(partName)) {
                    LOG.warn("Create event id for partition {} not found. Using -1.", (Object)partName);
                }
                eventId = msPartitionsToEventId.getOrDefault(partName, -1L);
            }
            partBuilder.setCreateEventId(eventId);
            addedPartBuilders.add(partBuilder);
        }
        this.loadFileMetadataForPartitions(client, addedPartBuilders, false, catalogTimeline);
        return addedPartBuilders.stream().map(HdfsPartition.Builder::build).collect(Collectors.toList());
    }

    private HdfsPartition.Builder createPartitionBuilder(StorageDescriptor storageDescriptor, Partition msPartition, FsPermissionCache permCache) throws CatalogException {
        return this.createOrUpdatePartitionBuilder(storageDescriptor, msPartition, permCache, null);
    }

    private HdfsPartition.Builder createOrUpdatePartitionBuilder(StorageDescriptor storageDescriptor, Partition msPartition, FsPermissionCache permCache, HdfsPartition.Builder partBuilder) throws CatalogException {
        if (partBuilder == null) {
            partBuilder = new HdfsPartition.Builder(this);
        }
        partBuilder.setMsPartition(msPartition).setFileFormatDescriptor(HdfsStorageDescriptor.fromStorageDescriptor(this.name_, storageDescriptor));
        Path partDirPath = new Path(storageDescriptor.getLocation());
        try {
            if (msPartition != null) {
                boolean isCached = HdfsCachingUtil.validateCacheParams(partBuilder.getParameters());
                partBuilder.setIsMarkedCached(isCached);
            }
            TAccessLevel accessLevel = HdfsTable.getAvailableAccessLevel(this.getFullName(), partDirPath, permCache);
            partBuilder.setAccessLevel(accessLevel);
            partBuilder.checkWellFormed();
            if (!TAccessLevelUtil.impliesWriteAccess(accessLevel)) {
                this.accessLevel_ = TAccessLevel.READ_ONLY;
            }
            return partBuilder;
        }
        catch (IOException e) {
            throw new CatalogException("Error initializing partition", e);
        }
    }

    public void addPartition(HdfsPartition partition) throws CatalogException {
        if (this.partitionMap_.containsKey(partition.getId())) {
            throw new CatalogException(String.format("Partition %s already exists in table %s", partition.getPartitionName(), this.getFullName()));
        }
        this.addPartitionNoThrow(partition);
    }

    public boolean addPartitionNoThrow(HdfsPartition partition) {
        if (this.partitionMap_.containsKey(partition.getId())) {
            return false;
        }
        if (partition.getFileFormat() == HdfsFileFormat.AVRO) {
            this.hasAvroData_ = true;
        }
        this.partitionMap_.put(partition.getId(), partition);
        this.fileMetadataStats_.totalFileBytes += partition.getSize();
        this.fileMetadataStats_.numFiles += (long)partition.getNumFileDescriptors();
        this.updatePartitionMdAndColStats(partition);
        this.lastCompactionId_ = Math.max(this.lastCompactionId_, partition.getLastCompactionId());
        return true;
    }

    protected void updatePartitionMdAndColStats(HdfsPartition partition) {
        if (partition.getPartitionValues().size() != this.numClusteringCols_) {
            return;
        }
        this.nameToPartitionMap_.put(partition.getPartitionName(), partition);
        if (!this.isStoredInImpaladCatalogCache()) {
            return;
        }
        for (int i = 0; i < partition.getPartitionValues().size(); ++i) {
            ColumnStats stats = this.getColumns().get(i).getStats();
            LiteralExpr literal = partition.getPartitionValues().get(i);
            if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
                stats.setNumNulls(stats.getNumNulls() + 1L);
                if (this.nullPartitionIds_.get(i).isEmpty()) {
                    stats.setNumDistinctValues(stats.getNumDistinctValues() + 1L);
                }
                this.nullPartitionIds_.get(i).add(partition.getId());
                continue;
            }
            stats.updateLowAndHighValue(literal);
            Set<Long> partitionIds = this.partitionValuesMap_.get(i).get(literal);
            if (partitionIds == null) {
                partitionIds = new HashSet<Long>();
                this.partitionValuesMap_.get(i).put(literal, partitionIds);
                stats.setNumDistinctValues(stats.getNumDistinctValues() + 1L);
            }
            partitionIds.add(partition.getId());
        }
    }

    public void updatePartitions(List<HdfsPartition.Builder> partBuilders) throws CatalogException {
        for (HdfsPartition.Builder p : partBuilders) {
            this.updatePartition(p);
        }
    }

    public void updatePartition(HdfsPartition.Builder partBuilder) throws CatalogException {
        HdfsPartition oldPartition = partBuilder.getOldInstance();
        Preconditions.checkNotNull((Object)oldPartition, (Object)"Old partition instance should exist for updates");
        Preconditions.checkState((boolean)this.partitionMap_.containsKey(oldPartition.getId()), (Object)"Updating a non existing partition instance");
        Preconditions.checkState((this.partitionMap_.get(partBuilder.getOldId()) == oldPartition ? 1 : 0) != 0, (Object)"Concurrent modification on partitions: old instance changed");
        boolean partitionNotChanged = partBuilder.equalsToOriginal(oldPartition);
        LOG.trace("Partition {} {}", (Object)oldPartition.getName(), (Object)(partitionNotChanged ? "changed" : "unchanged"));
        if (partitionNotChanged) {
            return;
        }
        HdfsPartition newPartition = partBuilder.build();
        this.dropPartition(oldPartition, false);
        this.addPartition(newPartition);
    }

    public HdfsPartition dropPartition(List<TPartitionKeyValue> partitionSpec) {
        return this.dropPartition(this.getPartitionFromThriftPartitionSpec(partitionSpec));
    }

    public HdfsPartition dropPartition(long partitionId) {
        return this.dropPartition(this.partitionMap_.get(partitionId));
    }

    private HdfsPartition dropPartition(HdfsPartition partition, boolean removeCacheDirective) {
        if (partition == null) {
            return null;
        }
        this.fileMetadataStats_.totalFileBytes -= partition.getSize();
        this.fileMetadataStats_.numFiles -= (long)partition.getNumFileDescriptors();
        Preconditions.checkArgument((partition.getPartitionValues().size() == this.numClusteringCols_ ? 1 : 0) != 0);
        Long partitionId = partition.getId();
        this.partitionMap_.remove(partitionId);
        this.nameToPartitionMap_.remove(partition.getPartitionName());
        if (removeCacheDirective && partition.isMarkedCached()) {
            try {
                HdfsCachingUtil.removePartitionCacheDirective(Maps.newHashMap(partition.getParameters()));
            }
            catch (ImpalaException e) {
                LOG.error("Unable to remove the cache directive on table " + this.getFullName() + ", partition " + partition.getPartitionName() + ": ", (Throwable)e);
            }
        }
        if (!this.isStoredInImpaladCatalogCache()) {
            this.dirtyPartitions_.remove(partitionId);
            if (BackendConfig.INSTANCE.isIncrementalMetadataUpdatesEnabled()) {
                this.droppedPartitions_.add(partition.genMinimalPartition());
            }
            return partition;
        }
        for (int i = 0; i < partition.getPartitionValues().size(); ++i) {
            ColumnStats stats = this.getColumns().get(i).getStats();
            LiteralExpr literal = partition.getPartitionValues().get(i);
            if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
                this.nullPartitionIds_.get(i).remove(partitionId);
                stats.setNumNulls(stats.getNumNulls() - 1L);
                if (!this.nullPartitionIds_.get(i).isEmpty()) continue;
                stats.setNumDistinctValues(stats.getNumDistinctValues() - 1L);
                continue;
            }
            Set<Long> partitionIds = this.partitionValuesMap_.get(i).get(literal);
            if (partitionIds.size() > 1) {
                partitionIds.remove(partitionId);
                continue;
            }
            this.partitionValuesMap_.get(i).remove(literal);
            stats.setNumDistinctValues(stats.getNumDistinctValues() - 1L);
        }
        return partition;
    }

    public HdfsPartition dropPartition(HdfsPartition partition) {
        return this.dropPartition(partition, true);
    }

    public List<HdfsPartition> dropPartitions(List<HdfsPartition> partitions, boolean removeCacheDirective) {
        ArrayList<HdfsPartition> droppedPartitions = new ArrayList<HdfsPartition>();
        for (HdfsPartition partition : partitions) {
            HdfsPartition hdfsPartition = this.dropPartition(partition, removeCacheDirective);
            if (hdfsPartition == null) continue;
            droppedPartitions.add(hdfsPartition);
        }
        return droppedPartitions;
    }

    public List<HdfsPartition> dropPartitions(List<HdfsPartition> partitions) {
        return this.dropPartitions(partitions, true);
    }

    public void setPrototypePartition(StorageDescriptor storageDescriptor) throws CatalogException {
        HdfsStorageDescriptor hdfsStorageDescriptor = HdfsStorageDescriptor.fromStorageDescriptor(this.name_, storageDescriptor);
        this.prototypePartition_ = HdfsPartition.prototypePartition(this, hdfsStorageDescriptor);
    }

    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        this.load(reuseMetadata, client, msTbl, true, true, false, null, null, null, reason, catalogTimeline);
    }

    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, boolean loadPartitionFileMetadata, boolean loadTableSchema, boolean refreshUpdatedPartitions, @Nullable Set<String> partitionsToUpdate, @Nullable String debugAction, @Nullable Map<String, Long> partitionToEventId, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        this.load(new HdfsTableLoadParamsBuilder(client, msTbl).reuseMetadata(reuseMetadata).setLoadPartitionFileMetadata(loadPartitionFileMetadata).setLoadTableSchema(loadTableSchema).setRefreshUpdatedPartitions(refreshUpdatedPartitions).setPartitionsToUpdate(partitionsToUpdate).setDebugAction(debugAction).setReason(reason).setPartitionToEventId(partitionToEventId).setIsPreLoadForInsert(false).setCatalogTimeline(catalogTimeline).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(HdfsTableLoadParams loadParams) throws TableLoadingException {
        Timer.Context context = this.getMetrics().getTimer("load-duration").time();
        IMetaStoreClient msClient = loadParams.getMsClient();
        org.apache.hadoop.hive.metastore.api.Table msTbl = loadParams.getMsTable();
        EventSequence catalogTimeline = loadParams.getCatalogTimeline();
        Set<String> partitionsToUpdate = loadParams.getPartitionsToUpdate();
        String annotation = String.format("%s metadata for %s%s partition(s) of %s.%s (%s)", loadParams.getIsReuseMetadata() ? "Reloading" : "Loading", loadParams.getLoadTableSchema() ? "table definition and " : DEFAULT_PARTITION_NAME, partitionsToUpdate == null ? "all" : String.valueOf(partitionsToUpdate.size()), msTbl.getDbName(), msTbl.getTableName(), loadParams.getReason());
        LOG.info(annotation);
        Timer storageLdTimer = this.getMetrics().getTimer("load-duration.storage-metadata");
        this.storageMetadataLoadTime_ = 0L;
        Table.LOADING_TABLES.incrementAndGet();
        try (ThreadNameAnnotator tna = new ThreadNameAnnotator(annotation);){
            this.msTable_ = msTbl;
            try {
                if (loadParams.getLoadTableSchema()) {
                    this.nullPartitionKeyValue_ = MetaStoreUtil.getNullPartitionKeyValue(msClient).intern();
                    this.loadSchema(msTbl);
                    this.loadAllColumnStats(msClient, catalogTimeline);
                    this.loadConstraintsInfo(msClient, msTbl);
                    catalogTimeline.markEvent("Loaded table schema");
                }
                this.loadValidWriteIdList(msClient);
                this.setTableStats(msTbl);
                if (loadParams.getIsReuseMetadata()) {
                    if (!loadParams.getIsPreLoadForInsert()) {
                        Preconditions.checkState((partitionsToUpdate == null || loadParams.isLoadPartitionFileMetadata() ? 1 : 0) != 0, (Object)"Conflicts in 'partitionsToUpdate' and 'loadPartitionFileMetadata'");
                    }
                    this.storageMetadataLoadTime_ += this.updateMdFromHmsTable(msTbl);
                    if (msTbl.getPartitionKeysSize() == 0) {
                        if (loadParams.isLoadPartitionFileMetadata()) {
                            this.storageMetadataLoadTime_ += this.updateUnpartitionedTableFileMd(msClient, loadParams.getDebugAction(), catalogTimeline);
                        } else {
                            this.updateUnpartitionedTableStats();
                        }
                    } else {
                        this.storageMetadataLoadTime_ += this.updatePartitionsFromHms(msClient, partitionsToUpdate, loadParams.isLoadPartitionFileMetadata(), loadParams.getRefreshUpdatedPartitions(), loadParams.getPartitionToEventId(), loadParams.getDebugAction(), catalogTimeline, loadParams.getIsPreLoadForInsert());
                    }
                    LOG.info("Incrementally loaded table metadata for: " + this.getFullName());
                } else {
                    LOG.info("Fetching partition metadata from the Metastore: " + this.getFullName());
                    Timer.Context allPartitionsLdContext = this.getMetrics().getTimer(LOAD_DURATION_ALL_PARTITIONS).time();
                    List<Partition> msPartitions = MetaStoreUtil.fetchAllPartitions(msClient, msTbl, 5);
                    LOG.info("Fetched partition metadata from the Metastore: " + this.getFullName());
                    this.storageMetadataLoadTime_ = this.loadAllPartitions(msClient, msPartitions, msTbl, catalogTimeline);
                    allPartitionsLdContext.stop();
                }
                if (loadParams.getLoadTableSchema()) {
                    this.setAvroSchema(msClient, msTbl, catalogTimeline);
                }
                this.fileMetadataStats_.unset();
                this.refreshLastUsedTime();
                Preconditions.checkState((boolean)this.dirtyPartitions_.isEmpty());
            }
            catch (TableLoadingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TableLoadingException("Failed to load metadata for table: " + this.getFullName(), e);
            }
        }
        finally {
            storageLdTimer.update(this.storageMetadataLoadTime_, TimeUnit.NANOSECONDS);
            long load_time_duration = context.stop();
            if (load_time_duration > 5000000000L) {
                LOG.warn("Time taken on loading table " + this.getFullName() + " exceeded warning threshold. Time: " + PrintUtils.printTimeNs(load_time_duration));
            }
            this.updateTableLoadingTime();
            Table.LOADING_TABLES.decrementAndGet();
        }
    }

    protected void loadConstraintsInfo(IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl) throws TableLoadingException {
        try {
            this.sqlConstraints_ = new SqlConstraints(client.getPrimaryKeys(new PrimaryKeysRequest(msTbl.getDbName(), msTbl.getTableName())), client.getForeignKeys(new ForeignKeysRequest(null, null, msTbl.getDbName(), msTbl.getTableName())));
        }
        catch (Exception e) {
            throw new TableLoadingException("Failed to load primary keys/foreign keys for table: " + this.getFullName(), e);
        }
    }

    protected long updateMdFromHmsTable(org.apache.hadoop.hive.metastore.api.Table msTbl) throws IOException {
        Preconditions.checkNotNull((Object)msTbl);
        Clock clock = Clock.defaultClock();
        long filesystemAccessTime = 0L;
        long startTime = clock.getTick();
        this.hdfsBaseDir_ = msTbl.getSd().getLocation();
        this.isMarkedCached_ = HdfsCachingUtil.validateCacheParams(msTbl.getParameters());
        Path location = new Path(this.hdfsBaseDir_);
        this.accessLevel_ = HdfsTable.getAvailableAccessLevel(this.getFullName(), location, new FsPermissionCache());
        filesystemAccessTime = clock.getTick() - startTime;
        this.setMetaStoreTable(msTbl);
        return filesystemAccessTime;
    }

    private long updateUnpartitionedTableFileMd(IMetaStoreClient client, String debugAction, EventSequence catalogTimeline) throws CatalogException {
        Preconditions.checkState((this.getNumClusteringCols() == 0 ? 1 : 0) != 0);
        if (LOG.isTraceEnabled()) {
            LOG.trace("update unpartitioned table: " + this.getFullName());
        }
        HdfsPartition oldPartition = (HdfsPartition)Iterables.getOnlyElement(this.partitionMap_.values());
        org.apache.hadoop.hive.metastore.api.Table msTbl = this.getMetaStoreTable();
        Preconditions.checkNotNull((Object)msTbl);
        HdfsPartition.Builder partBuilder = this.createPartitionBuilder(msTbl.getSd(), null, new FsPermissionCache());
        partBuilder.setFileDescriptors(oldPartition);
        partBuilder.setIsMarkedCached(this.isMarkedCached_);
        partBuilder.setPrevId(oldPartition.getId());
        long fileMdLoadTime = this.loadFileMetadataForPartitions(client, (Collection<HdfsPartition.Builder>)ImmutableList.of((Object)partBuilder), true, debugAction, catalogTimeline);
        this.resetPartitions();
        this.setPrototypePartition(msTbl.getSd());
        this.setUnpartitionedTableStats(partBuilder);
        this.addPartition(partBuilder.build());
        return fileMdLoadTime;
    }

    private void updateUnpartitionedTableStats() throws CatalogException {
        HdfsPartition oldPartition = (HdfsPartition)Iterables.getOnlyElement(this.partitionMap_.values());
        if (oldPartition.getNumRows() != this.getNumRows()) {
            HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(oldPartition).setNumRows(this.getNumRows());
            this.updatePartition(partBuilder);
        }
    }

    private long updatePartitionsFromHms(IMetaStoreClient client, Set<String> partitionsToUpdate, boolean loadPartitionFileMetadata, boolean refreshUpdatedPartitions, Map<String, Long> partitionToEventId, String debugAction, EventSequence catalogTimeline, boolean isPreLoadForInsert) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sync table partitions: " + this.getFullName());
        }
        org.apache.hadoop.hive.metastore.api.Table msTbl = this.getMetaStoreTable();
        Preconditions.checkNotNull((Object)msTbl);
        Preconditions.checkState((msTbl.getPartitionKeysSize() != 0 ? 1 : 0) != 0);
        if (!isPreLoadForInsert) {
            Preconditions.checkState((loadPartitionFileMetadata || partitionsToUpdate == null ? 1 : 0) != 0);
        }
        PartitionDeltaUpdater deltaUpdater = refreshUpdatedPartitions ? new PartBasedDeltaUpdater(client, loadPartitionFileMetadata, partitionsToUpdate, partitionToEventId, debugAction, catalogTimeline) : new PartNameBasedDeltaUpdater(client, loadPartitionFileMetadata, partitionsToUpdate, partitionToEventId, debugAction, catalogTimeline);
        deltaUpdater.apply();
        return deltaUpdater.loadTimeForFileMdNs_;
    }

    public List<String> getClusteringColNames() {
        ArrayList<String> colNames = new ArrayList<String>(this.getNumClusteringCols());
        for (Column column : this.getClusteringColumns()) {
            colNames.add(column.name_);
        }
        return colNames;
    }

    public List<HdfsPartition> getPartitionsForNames(Collection<String> partitionNames) {
        ArrayList parts = Lists.newArrayListWithCapacity((int)partitionNames.size());
        for (String partitionName : partitionNames) {
            String partName = DEFAULT_PARTITION_NAME;
            if (partitionName.length() > 0) {
                partName = partitionName;
            }
            HdfsPartition partition = this.nameToPartitionMap_.get(partName);
            Preconditions.checkNotNull((Object)partition, (Object)("Invalid partition name: " + partName));
            parts.add(partition);
        }
        return parts;
    }

    public boolean addInflightInsertEventToPartition(String partName, long eventId) {
        HdfsPartition partition = this.nameToPartitionMap_.get(partName);
        if (partition == null) {
            return false;
        }
        partition.addToVersionsForInflightEvents(true, eventId);
        return true;
    }

    private void setUnpartitionedTableStats(HdfsPartition.Builder partBuilder) {
        Preconditions.checkState((this.numClusteringCols_ == 0 ? 1 : 0) != 0);
        partBuilder.setNumRows(this.getNumRows());
    }

    protected void setAvroSchema(IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, EventSequence catalogTimeline) throws Exception {
        Preconditions.checkState((boolean)this.isSchemaLoaded_);
        String inputFormat = msTbl.getSd().getInputFormat();
        String serDeLib = msTbl.getSd().getSerdeInfo().getSerializationLib();
        if (HdfsFileFormat.fromJavaClassName(inputFormat, serDeLib) == HdfsFileFormat.AVRO || this.hasAvroData_) {
            this.setAvroSchemaInternal(client, this.msTable_, catalogTimeline);
        }
    }

    protected void setAvroSchemaInternal(IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, EventSequence catalogTimeline) throws Exception {
        ArrayList<Map<String, String>> schemaSearchLocations = new ArrayList<Map<String, String>>();
        schemaSearchLocations.add(this.getMetaStoreTable().getSd().getSerdeInfo().getParameters());
        schemaSearchLocations.add(this.getMetaStoreTable().getParameters());
        this.avroSchema_ = AvroSchemaUtils.getAvroSchema(schemaSearchLocations);
        if (this.avroSchema_ == null) {
            Schema inferredSchema = AvroSchemaConverter.convertFieldSchemas(msTbl.getSd().getCols(), this.getFullName());
            this.avroSchema_ = inferredSchema.toString();
        }
        catalogTimeline.markEvent("Loaded avro schema");
        String serdeLib = msTbl.getSd().getSerdeInfo().getSerializationLib();
        if (serdeLib == null || serdeLib.equals("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe")) {
            return;
        }
        List<FieldSchema> reconciledFieldSchemas = AvroSchemaUtils.reconcileAvroSchema(msTbl, this.avroSchema_);
        this.nonPartFieldSchemas_.clear();
        this.nonPartFieldSchemas_.addAll(reconciledFieldSchemas);
        this.clearColumns();
        this.addColumnsFromFieldSchemas(msTbl.getPartitionKeys());
        this.addColumnsFromFieldSchemas(this.nonPartFieldSchemas_);
        this.addVirtualColumns();
        this.loadAllColumnStats(client, catalogTimeline);
    }

    public void loadSchema(org.apache.hadoop.hive.metastore.api.Table msTbl) throws TableLoadingException {
        this.nonPartFieldSchemas_.clear();
        this.nullColumnValue_ = (String)msTbl.getParameters().get("serialization.null.format");
        if (this.nullColumnValue_ == null) {
            this.nullColumnValue_ = "\\N";
        }
        this.nonPartFieldSchemas_.addAll(msTbl.getSd().getCols());
        this.numClusteringCols_ = msTbl.getPartitionKeys().size();
        this.partitionLocationCompressor_.setClusteringColumns(this.numClusteringCols_);
        this.clearColumns();
        this.addColumnsFromFieldSchemas(msTbl.getPartitionKeys());
        if (AcidUtils.isFullAcidTable(msTbl.getParameters())) {
            this.addColumnsForFullAcidTable(this.nonPartFieldSchemas_);
        } else {
            this.addColumnsFromFieldSchemas(this.nonPartFieldSchemas_);
        }
        this.addVirtualColumns();
        this.isSchemaLoaded_ = true;
        LOG.info("Loaded {} columns from HMS. Actual columns: {}", (Object)(this.nonPartFieldSchemas_.size() + this.numClusteringCols_), (Object)this.colsByPos_.size());
    }

    private long loadPartitionsFromMetastore(Set<String> partitionNames, Map<String, HdfsPartition.Builder> inprogressPartBuilders, @Nullable Map<String, Long> partitionToEventId, IMetaStoreClient client, EventSequence catalogTimeline) throws Exception {
        Preconditions.checkNotNull(partitionNames);
        if (partitionNames.isEmpty()) {
            return 0L;
        }
        ArrayList<Partition> msPartitions = new ArrayList<Partition>(MetaStoreUtil.fetchPartitionsByName(client, Lists.newArrayList(partitionNames), this.msTable_));
        return this.loadPartitionsFromMetastore(msPartitions, inprogressPartBuilders, partitionToEventId, client, catalogTimeline);
    }

    private long loadPartitionsFromMetastore(List<Partition> msPartitions, Map<String, HdfsPartition.Builder> inprogressPartBuilders, @Nullable Map<String, Long> partitionToEventId, IMetaStoreClient client, EventSequence catalogTimeline) throws Exception {
        FsPermissionCache permCache = this.preloadPermissionsCache(msPartitions, catalogTimeline);
        ArrayList<HdfsPartition.Builder> partBuilders = new ArrayList<HdfsPartition.Builder>(msPartitions.size());
        for (Partition msPartition : msPartitions) {
            String partName = FeCatalogUtils.getPartitionName(this, msPartition.getValues());
            HdfsPartition.Builder partBuilder = null;
            if (inprogressPartBuilders != null) {
                partBuilder = inprogressPartBuilders.get(partName);
                Preconditions.checkNotNull((Object)partBuilder);
            }
            partBuilder = this.createOrUpdatePartitionBuilder(msPartition.getSd(), msPartition, permCache, partBuilder);
            if (partitionToEventId != null) {
                partBuilder.setCreateEventId(partitionToEventId.getOrDefault(partName, -1L));
            }
            partBuilders.add(partBuilder);
        }
        long latestEventId = MetastoreEventsProcessor.getCurrentEventIdNoThrow(client);
        catalogTimeline.markEvent("Got current Metastore event id " + latestEventId);
        long fileMdLoadTime = this.loadFileMetadataForPartitions(client, partBuilders, false, catalogTimeline);
        for (HdfsPartition.Builder p : partBuilders) {
            if (inprogressPartBuilders == null) {
                this.addPartition(p.build());
            } else {
                this.updatePartition(p);
            }
            if (latestEventId <= -1L) continue;
            p.setLastRefreshEventId(latestEventId);
        }
        LOG.info("Setting the latest refresh event id to {} for the loaded partitions for the table {}", (Object)latestEventId, (Object)this.getFullName());
        return fileMdLoadTime;
    }

    private FsPermissionCache preloadPermissionsCache(List<Partition> msPartitions, EventSequence catalogTimeline) {
        FsPermissionCache permCache = new FsPermissionCache();
        if (msPartitions.size() <= this.partitionMap_.size() * 3) {
            return permCache;
        }
        HashMultiset parentPaths = HashMultiset.create();
        for (Partition p : msPartitions) {
            Path parent;
            String loc = p.getSd().getLocation();
            if (!loc.startsWith(this.hdfsBaseDir_) || (parent = new Path(loc).getParent()) == null) continue;
            parentPaths.add((Object)parent);
        }
        for (Multiset.Entry entry : parentPaths.entrySet()) {
            if (entry.getCount() == 1) continue;
            Path p = (Path)entry.getElement();
            try {
                FileSystem fs = p.getFileSystem(CONF);
                if (HdfsTable.assumeReadWriteAccess(fs)) continue;
                permCache.precacheChildrenOf(fs, p);
            }
            catch (IOException ioe) {
                LOG.debug("Unable to bulk-load permissions for parent path: " + p, (Throwable)ioe);
            }
        }
        catalogTimeline.markEvent(String.format("Preloaded permissions cache for %d partitions", msPartitions.size()));
        return permCache;
    }

    @Override
    protected List<String> getColumnNamesWithHmsStats() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Column column : this.getColumns().subList(this.numClusteringCols_, this.getColumns().size())) {
            ret.add(column.getName().toLowerCase());
        }
        return ret;
    }

    @Override
    protected synchronized void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        THdfsTable hdfsTable = thriftTable.getHdfs_table();
        this.partitionLocationCompressor_ = new HdfsPartitionLocationCompressor(this.numClusteringCols_, hdfsTable.getPartition_prefixes());
        this.hdfsBaseDir_ = hdfsTable.getHdfsBaseDir();
        this.nullColumnValue_ = hdfsTable.nullColumnValue;
        this.nullPartitionKeyValue_ = hdfsTable.nullPartitionKeyValue;
        this.hostIndex_.populate(hdfsTable.getNetwork_addresses());
        this.sqlConstraints_ = SqlConstraints.fromThrift(hdfsTable.getSql_constraints());
        this.resetPartitions();
        try {
            if (hdfsTable.has_full_partitions) {
                for (THdfsPartition tPart : hdfsTable.getPartitions().values()) {
                    this.addPartition(new HdfsPartition.Builder(this, tPart.id).fromThrift(tPart).build());
                }
            }
            this.prototypePartition_ = new HdfsPartition.Builder(this, -1L).fromThrift(hdfsTable.prototype_partition).build();
        }
        catch (CatalogException e) {
            throw new TableLoadingException(e.getMessage());
        }
        this.avroSchema_ = hdfsTable.isSetAvroSchema() ? hdfsTable.getAvroSchema() : null;
        this.isMarkedCached_ = HdfsCachingUtil.validateCacheParams(this.getMetaStoreTable().getParameters());
        if (hdfsTable.isSetValid_write_ids()) {
            this.validWriteIds_ = new MutableValidReaderWriteIdList(MetastoreShim.getValidWriteIdListFromThrift(this.getFullName(), hdfsTable.getValid_write_ids()));
        }
    }

    public void validatePartitions(Set<Long> expectedPartitionIds) throws TableLoadingException {
        if (!this.partitionMap_.keySet().equals(expectedPartitionIds)) {
            HashSet<Long> missingIds = new HashSet<Long>(expectedPartitionIds);
            missingIds.removeAll(this.partitionMap_.keySet());
            HashSet<Long> staleIds = new HashSet<Long>(this.partitionMap_.keySet());
            staleIds.removeAll(expectedPartitionIds);
            throw new TableLoadingException(String.format("Error applying incremental updates on table %s. Missing partition ids: %s. Stale partition ids: %s. Total partitions: %d.", this.getFullName(), missingIds, staleIds, this.partitionMap_.size()));
        }
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDesc = new TTableDescriptor(tableId, TTableType.HDFS_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        tableDesc.setHdfsTable(this.getTHdfsTable(CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY, referencedPartitions));
        return tableDesc;
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.HDFS_TABLE);
        table.setHdfs_table(this.getTHdfsTable(CatalogObject.ThriftObjectType.FULL, null));
        return table;
    }

    @Override
    public TTable toHumanReadableThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.HDFS_TABLE);
        table.setHdfs_table(this.getTHdfsTable(CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY, null));
        return table;
    }

    public TTable toThriftWithMinimalPartitions() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.HDFS_TABLE);
        THdfsTable hdfsTable = this.getTHdfsTable(CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY, Collections.emptySet());
        hdfsTable.setNetwork_addresses(this.hostIndex_.getList());
        for (long partId : this.partitionMap_.keySet()) {
            THdfsPartition part = new THdfsPartition();
            part.setId(partId);
            hdfsTable.putToPartitions(partId, part);
        }
        hdfsTable.setHas_full_partitions(false);
        hdfsTable.setHas_partition_names(false);
        table.setHdfs_table(hdfsTable);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCatalogObject toMinimalTCatalogObject() {
        TCatalogObject catalogObject = super.toMinimalTCatalogObject();
        if (!BackendConfig.INSTANCE.isIncrementalMetadataUpdatesEnabled()) {
            return catalogObject;
        }
        if (!this.tryReadLock()) {
            LOG.warn("Not returning the partition ids and names of table {} since not holding the table read lock", (Object)this.getFullName());
            return catalogObject;
        }
        try {
            catalogObject.getTable().setTable_type(TTableType.HDFS_TABLE);
            THdfsTable hdfsTable = new THdfsTable(this.hdfsBaseDir_, Collections.emptyList(), this.nullPartitionKeyValue_, this.nullColumnValue_, new HashMap<Long, THdfsPartition>(), FAKE_THDFS_PARTITION);
            for (HdfsPartition part : this.partitionMap_.values()) {
                hdfsTable.partitions.put(part.getId(), part.toMinimalTHdfsPartition());
            }
            for (HdfsPartition part : this.droppedPartitions_) {
                hdfsTable.addToDropped_partitions(part.toMinimalTHdfsPartition());
            }
            hdfsTable.setHas_full_partitions(false);
            hdfsTable.setHas_partition_names(true);
            catalogObject.getTable().setHdfs_table(hdfsTable);
            TCatalogObject tCatalogObject = catalogObject;
            return tCatalogObject;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public long getMaxSentPartitionId() {
        return this.maxSentPartitionId_;
    }

    public void setMaxSentPartitionId(long maxSentPartitionId) {
        this.maxSentPartitionId_ = maxSentPartitionId;
    }

    public void resetMaxSentPartitionId() {
        this.maxSentPartitionId_ = -1L;
    }

    public List<HdfsPartition> getDroppedPartitions() {
        return ImmutableList.copyOf(this.droppedPartitions_);
    }

    public void resetDroppedPartitions() {
        this.droppedPartitions_.clear();
    }

    public List<TCatalogObject> getNewPartitionsSinceLastUpdate() {
        ArrayList<TCatalogObject> result = new ArrayList<TCatalogObject>();
        int numSkippedParts = 0;
        for (HdfsPartition partition : this.partitionMap_.values()) {
            if (partition.getId() <= this.maxSentPartitionId_) {
                ++numSkippedParts;
                continue;
            }
            TCatalogObject catalogPart = new TCatalogObject(TCatalogObjectType.HDFS_PARTITION, this.getCatalogVersion());
            partition.setTCatalogObject(catalogPart);
            result.add(catalogPart);
        }
        LOG.info("Skipped {} partitions of table {} in the incremental update", (Object)numSkippedParts, (Object)this.getFullName());
        return result;
    }

    public TGetPartialCatalogObjectResponse getPartialInfo(TGetPartialCatalogObjectRequest req, Map<HdfsPartition, TPartialPartitionInfo> missingPartitionInfos) throws CatalogException {
        Collection<Long> partIds;
        boolean wantPartitionInfo;
        Preconditions.checkNotNull(missingPartitionInfos);
        TGetPartialCatalogObjectResponse resp = super.getPartialInfo(req);
        boolean bl = wantPartitionInfo = req.table_info_selector.want_partition_files || req.table_info_selector.want_partition_metadata || req.table_info_selector.want_partition_names || req.table_info_selector.want_partition_stats;
        if (req.table_info_selector.want_partition_metadata && req.table_info_selector.want_hms_partition) {
            LOG.warn("Bad request that has both want_partition_metadata and want_hms_partition set to true. Duplicated data will be returned. {}", (Object)StringUtils.abbreviate((String)req.toString(), (int)1000));
        }
        if ((partIds = req.table_info_selector.partition_ids) == null && wantPartitionInfo) {
            partIds = this.partitionMap_.keySet();
        }
        ValidWriteIdList reqWriteIdList = req.table_info_selector.valid_write_ids == null ? null : MetastoreShim.getValidWriteIdListFromThrift(this.getFullName(), req.table_info_selector.valid_write_ids);
        Counter misses = this.metrics_.getCounter(FILEMETADATA_CACHE_MISS_METRIC);
        Counter hits = this.metrics_.getCounter(FILEMETADATA_CACHE_HIT_METRIC);
        int numFilesFiltered = 0;
        if (partIds != null) {
            resp.table_info.partitions = Lists.newArrayListWithCapacity((int)partIds.size());
            for (long partId : partIds) {
                HdfsPartition part = this.partitionMap_.get(partId);
                if (part == null) {
                    LOG.warn(String.format("Missing partition ID: %s, Table: %s", partId, this.getFullName()));
                    return new TGetPartialCatalogObjectResponse().setLookup_status(CatalogLookupStatus.PARTITION_NOT_FOUND);
                }
                TPartialPartitionInfo partInfo = new TPartialPartitionInfo(partId);
                if (req.table_info_selector.want_partition_names) {
                    partInfo.setName(part.getPartitionName());
                }
                if (req.table_info_selector.want_partition_metadata) {
                    part.setPartitionMetadata(partInfo);
                    partInfo.setHas_incremental_stats(part.hasIncrementalStats());
                }
                if (req.table_info_selector.want_hms_partition) {
                    partInfo.hms_partition = part.toHmsPartition();
                }
                if (req.table_info_selector.want_partition_files) {
                    partInfo.setLast_compaction_id(part.getLastCompactionId());
                    try {
                        if (!part.getInsertFileDescriptors().isEmpty()) {
                            partInfo.file_descriptors = new ArrayList<THdfsFileDesc>();
                            partInfo.insert_file_descriptors = new ArrayList<THdfsFileDesc>();
                            numFilesFiltered += this.addFilteredFds(part.getInsertFileDescriptors(), partInfo.insert_file_descriptors, reqWriteIdList);
                            partInfo.delete_file_descriptors = new ArrayList<THdfsFileDesc>();
                            numFilesFiltered += this.addFilteredFds(part.getDeleteFileDescriptors(), partInfo.delete_file_descriptors, reqWriteIdList);
                        } else {
                            partInfo.file_descriptors = new ArrayList<THdfsFileDesc>();
                            numFilesFiltered += this.addFilteredFds(part.getFileDescriptors(), partInfo.file_descriptors, reqWriteIdList);
                            partInfo.insert_file_descriptors = new ArrayList<THdfsFileDesc>();
                            partInfo.delete_file_descriptors = new ArrayList<THdfsFileDesc>();
                        }
                        hits.inc();
                    }
                    catch (CatalogException ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Could not use cached file descriptors of partition {} of table {} for writeIdList {}", new Object[]{part.getPartitionName(), this.getFullName(), reqWriteIdList, ex});
                        }
                        misses.inc();
                        missingPartitionInfos.put(part, partInfo);
                    }
                }
                if (req.table_info_selector.want_partition_stats) {
                    partInfo.setPartition_stats(part.getPartitionStatsCompressed());
                }
                partInfo.setIs_marked_cached(part.isMarkedCached());
                resp.table_info.partitions.add(partInfo);
            }
        }
        resp.table_info.setPartition_prefixes(this.partitionLocationCompressor_.getPrefixes());
        if (reqWriteIdList != null) {
            LOG.debug("{} files filtered out of table {} for {}. Hit rate : {}", new Object[]{numFilesFiltered, this.getFullName(), reqWriteIdList, this.getFileMetadataCacheHitRate()});
        }
        if (req.table_info_selector.want_partition_files) {
            resp.table_info.setNetwork_addresses(this.hostIndex_.getList());
        }
        if (req.table_info_selector.want_table_constraints) {
            TSqlConstraints sqlConstraints = new TSqlConstraints(this.sqlConstraints_.getPrimaryKeys(), this.sqlConstraints_.getForeignKeys());
            resp.table_info.setSql_constraints(sqlConstraints);
        }
        resp.table_info.setIs_marked_cached(this.isMarkedCached_);
        return resp;
    }

    private int addFilteredFds(List<HdfsPartition.FileDescriptor> fds, List<THdfsFileDesc> thriftFds, ValidWriteIdList writeIdList) throws CatalogException {
        ArrayList<HdfsPartition.FileDescriptor> filteredFds = new ArrayList<HdfsPartition.FileDescriptor>(fds);
        int numFilesFiltered = AcidUtils.filterFdsForAcidState(filteredFds, writeIdList);
        for (HdfsPartition.FileDescriptor fd : filteredFds) {
            thriftFds.add(fd.toThrift());
        }
        return numFilesFiltered;
    }

    private double getFileMetadataCacheHitRate() {
        long hits = this.metrics_.getCounter(FILEMETADATA_CACHE_HIT_METRIC).getCount();
        long misses = this.metrics_.getCounter(FILEMETADATA_CACHE_MISS_METRIC).getCount();
        return (double)hits / (double)(hits + misses);
    }

    public THdfsTable getTHdfsTable(CatalogObject.ThriftObjectType type, Set<Long> refPartitions) {
        if (type == CatalogObject.ThriftObjectType.FULL) {
            Preconditions.checkArgument((refPartitions == null ? 1 : 0) != 0);
        }
        long memUsageEstimate = 0L;
        int numPartitions = refPartitions == null ? this.partitionMap_.values().size() : refPartitions.size();
        memUsageEstimate += (long)numPartitions * 2048L;
        FileMetadataStats stats = new FileMetadataStats();
        HashMap<Long, THdfsPartition> idToPartition = new HashMap<Long, THdfsPartition>();
        for (HdfsPartition partition : this.partitionMap_.values()) {
            long id = partition.getId();
            if (refPartitions != null && !refPartitions.contains(id)) continue;
            THdfsPartition tHdfsPartition = FeCatalogUtils.fsPartitionToThrift(partition, type);
            if (partition.hasIncrementalStats()) {
                memUsageEstimate += (long)this.getColumns().size() * 200L;
                this.hasIncrementalStats_ = true;
            }
            if (type == CatalogObject.ThriftObjectType.FULL) {
                Preconditions.checkState((tHdfsPartition.isSetNum_blocks() && tHdfsPartition.isSetTotal_file_size_bytes() ? 1 : 0) != 0);
                stats.numBlocks += tHdfsPartition.getNum_blocks();
                stats.numFiles = stats.numFiles + (tHdfsPartition.isSetFile_desc() ? (long)tHdfsPartition.getFile_desc().size() : 0L);
                stats.numFiles = stats.numFiles + (tHdfsPartition.isSetInsert_file_desc() ? (long)tHdfsPartition.getInsert_file_desc().size() : 0L);
                stats.numFiles = stats.numFiles + (tHdfsPartition.isSetDelete_file_desc() ? (long)tHdfsPartition.getDelete_file_desc().size() : 0L);
                stats.totalFileBytes += tHdfsPartition.getTotal_file_size_bytes();
            }
            idToPartition.put(id, tHdfsPartition);
        }
        if (type == CatalogObject.ThriftObjectType.FULL) {
            this.fileMetadataStats_.set(stats);
        }
        THdfsPartition prototypePartition = FeCatalogUtils.fsPartitionToThrift(this.prototypePartition_, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY);
        memUsageEstimate += this.fileMetadataStats_.numFiles * 500L + this.fileMetadataStats_.numBlocks * 150L;
        if (type == CatalogObject.ThriftObjectType.FULL) {
            this.setEstimatedMetadataSize(memUsageEstimate);
            this.setNumFiles(this.fileMetadataStats_.numFiles);
        }
        THdfsTable hdfsTable = new THdfsTable(this.hdfsBaseDir_, this.getColumnNames(), this.getNullPartitionKeyValue(), this.nullColumnValue_, idToPartition, prototypePartition);
        hdfsTable.setAvroSchema(this.avroSchema_);
        hdfsTable.setSql_constraints(this.sqlConstraints_.toThrift());
        if (type == CatalogObject.ThriftObjectType.FULL) {
            hdfsTable.setHas_full_partitions(true);
            hdfsTable.setNetwork_addresses(this.hostIndex_.getList());
        }
        hdfsTable.setPartition_prefixes(this.partitionLocationCompressor_.getPrefixes());
        if (AcidUtils.isFullAcidTable(this.getMetaStoreTable().getParameters())) {
            hdfsTable.setIs_full_acid(true);
        }
        if (this.validWriteIds_ != null) {
            hdfsTable.setValid_write_ids(MetastoreShim.convertToTValidWriteIdList(this.validWriteIds_));
        }
        return hdfsTable;
    }

    @Override
    public long getTotalHdfsBytes() {
        return this.fileMetadataStats_.totalFileBytes;
    }

    @Override
    public String getHdfsBaseDir() {
        return this.hdfsBaseDir_;
    }

    public Path getHdfsBaseDirPath() {
        Preconditions.checkNotNull((Object)this.hdfsBaseDir_, (Object)"HdfsTable base dir is null");
        return new Path(this.hdfsBaseDir_);
    }

    @Override
    public boolean usesAvroSchemaOverride() {
        return this.avroSchema_ != null;
    }

    @Override
    public ListMap<TNetworkAddress> getHostIndex() {
        return this.hostIndex_;
    }

    @Override
    public SqlConstraints getSqlConstraints() {
        return this.sqlConstraints_;
    }

    @Override
    public Set<HdfsFileFormat> getFileFormats() {
        Iterable partitionsToConsider = Iterables.concat(this.partitionMap_.values(), Collections.singleton(this.prototypePartition_));
        return FeCatalogUtils.getFileFormats(partitionsToConsider);
    }

    public List<List<String>> getPathsWithoutPartitions(@Nullable String debugAction) throws CatalogException {
        HashSet<List<LiteralExpr>> existingPartitions = new HashSet<List<LiteralExpr>>();
        for (HdfsPartition partition : this.partitionMap_.values()) {
            existingPartitions.add(partition.getPartitionValues());
        }
        ArrayList<String> partitionKeys = new ArrayList<String>();
        for (int i = 0; i < this.numClusteringCols_; ++i) {
            partitionKeys.add(this.getColumns().get(i).getName());
        }
        Path basePath = new Path(this.hdfsBaseDir_);
        ArrayList<List<String>> partitionsNotInHms = new ArrayList<List<String>>();
        try {
            this.getAllPartitionsNotInHms(basePath, partitionKeys, existingPartitions, partitionsNotInHms);
            DebugUtils.executeDebugAction(debugAction, "catalogd_table_recover_delay");
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to recover partitions for %s with exception:%s.", this.getFullName(), e));
        }
        return partitionsNotInHms;
    }

    private void getAllPartitionsNotInHms(Path path, List<String> partitionKeys, Set<List<LiteralExpr>> existingPartitions, List<List<String>> partitionsNotInHms) throws IOException {
        FileSystem fs = path.getFileSystem(CONF);
        ArrayList<String> partitionValues = new ArrayList<String>();
        ArrayList<LiteralExpr> partitionExprs = new ArrayList<LiteralExpr>();
        this.getAllPartitionsNotInHms(path, partitionKeys, 0, fs, partitionValues, partitionExprs, existingPartitions, partitionsNotInHms);
    }

    private void getAllPartitionsNotInHms(Path path, List<String> partitionKeys, int depth, FileSystem fs, List<String> partitionValues, List<LiteralExpr> partitionExprs, Set<List<LiteralExpr>> existingPartitions, List<List<String>> partitionsNotInHms) throws IOException {
        if (depth == partitionKeys.size()) {
            if (existingPartitions.contains(partitionExprs)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Skip recovery of path '%s' because it already exists in metastore", path.toString()));
                }
            } else {
                partitionsNotInHms.add(partitionValues);
                existingPartitions.add(partitionExprs);
            }
            return;
        }
        RemoteIterator statuses = fs.listStatusIterator(path);
        if (statuses == null) {
            return;
        }
        while (statuses.hasNext()) {
            Pair<String, LiteralExpr> keyValues;
            FileStatus status = (FileStatus)statuses.next();
            if (!status.isDirectory() || (keyValues = this.getTypeCompatibleValue(status.getPath(), partitionKeys.get(depth))) == null) continue;
            ArrayList currentPartitionValues = Lists.newArrayList(partitionValues);
            ArrayList currentPartitionExprs = Lists.newArrayList(partitionExprs);
            currentPartitionValues.add(keyValues.first);
            currentPartitionExprs.add(keyValues.second);
            this.getAllPartitionsNotInHms(status.getPath(), partitionKeys, depth + 1, fs, currentPartitionValues, currentPartitionExprs, existingPartitions, partitionsNotInHms);
        }
    }

    public List<LiteralExpr> getTypeCompatiblePartValues(List<String> values) {
        ArrayList<LiteralExpr> result = new ArrayList<LiteralExpr>();
        List<Column> partitionColumns = this.getClusteringColumns();
        Preconditions.checkState((partitionColumns.size() == values.size() ? 1 : 0) != 0);
        for (int i = 0; i < partitionColumns.size(); ++i) {
            Pair<String, LiteralExpr> pair = this.getPartitionExprFromValue(values.get(i), partitionColumns.get(i).getType());
            if (pair == null) {
                LOG.error("Could not get a type compatible value for key {} with value {}", (Object)i, (Object)values.get(i));
                return null;
            }
            result.add((LiteralExpr)pair.second);
        }
        return result;
    }

    private Pair<String, LiteralExpr> getTypeCompatibleValue(Path path, String partitionKey) {
        String[] partName = path.getName().split("=");
        if (partName.length != 2 || !partName[0].equals(partitionKey)) {
            return null;
        }
        Column column = this.getColumn(partName[0]);
        Preconditions.checkNotNull((Object)column);
        Type type = column.getType();
        return this.getPartitionExprFromValue(partName[1], type);
    }

    private Pair<String, LiteralExpr> getPartitionExprFromValue(String partValue, Type type) {
        LiteralExpr expr;
        String value;
        block5: {
            value = FileUtils.unescapePathName((String)partValue);
            if (!value.equals(this.getNullPartitionKeyValue())) {
                try {
                    expr = LiteralExpr.createFromUnescapedStr(value, type);
                    if (expr instanceof NumericLiteral && NumericLiteral.isOverflow(((NumericLiteral)expr).getValue(), type)) {
                        LOG.warn(String.format("Skip the overflow value (%s) for Type (%s).", value, type.toSql()));
                        return null;
                    }
                    break block5;
                }
                catch (Exception ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(String.format("Invalid partition value (%s) for Type (%s).", value, type.toSql()));
                    }
                    return null;
                }
            }
            expr = new NullLiteral();
        }
        return new Pair<String, LiteralExpr>(value, expr);
    }

    @Override
    public TResultSet getTableStats() {
        return HdfsTable.getTableStats(this);
    }

    @Override
    public FileSystemUtil.FsType getFsType() {
        Preconditions.checkNotNull((Object)this.getHdfsBaseDirPath().toUri().getScheme(), (Object)("Cannot get scheme from path " + this.getHdfsBaseDirPath()));
        return FileSystemUtil.FsType.getFsType(this.getHdfsBaseDirPath().toUri().getScheme());
    }

    public static TResultSet getTableStats(FeFsTable table) {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        result.setSchema(resultSchema);
        for (int i = 0; i < table.getNumClusteringCols(); ++i) {
            Column partCol = table.getColumns().get(i);
            TColumn colDesc = new TColumn(partCol.getName(), Type.STRING.toThrift());
            resultSchema.addToColumns(colDesc);
        }
        boolean statsExtrap = FeFsTable.Utils.isStatsExtrapolationEnabled(table);
        resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
        if (statsExtrap) {
            resultSchema.addToColumns(new TColumn("Extrap #Rows", Type.BIGINT.toThrift()));
        }
        resultSchema.addToColumns(new TColumn("#Files", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Size", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Bytes Cached", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Cache Replication", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Format", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Incremental stats", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Location", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("EC Policy", Type.STRING.toThrift()));
        ArrayList<? extends FeFsPartition> orderedPartitions = new ArrayList<FeFsPartition>(FeCatalogUtils.loadAllPartitions(table));
        Collections.sort(orderedPartitions, HdfsPartition.KV_COMPARATOR);
        long totalCachedBytes = 0L;
        long totalBytes = 0L;
        long totalNumFiles = 0L;
        for (FeFsPartition feFsPartition : orderedPartitions) {
            int numFiles = feFsPartition.getNumFileDescriptors();
            long size = feFsPartition.getSize();
            totalNumFiles += (long)numFiles;
            totalBytes += size;
            TResultRowBuilder rowBuilder = new TResultRowBuilder();
            for (LiteralExpr expr : feFsPartition.getPartitionValues()) {
                rowBuilder.add(expr.getStringValue());
            }
            rowBuilder.add(feFsPartition.getNumRows());
            if (statsExtrap) {
                rowBuilder.add(FeFsTable.Utils.getExtrapolatedNumRows(table, size));
            }
            rowBuilder.add(numFiles).addBytes(size);
            if (!feFsPartition.isMarkedCached()) {
                rowBuilder.add("NOT CACHED");
                rowBuilder.add("NOT CACHED");
            } else {
                long cachedBytes = 0L;
                for (HdfsPartition.FileDescriptor fd : feFsPartition.getFileDescriptors()) {
                    int numBlocks = fd.getNumFileBlocks();
                    for (int i = 0; i < numBlocks; ++i) {
                        FbFileBlock block = fd.getFbFileBlock(i);
                        if (!HdfsPartition.FileBlock.hasCachedReplica(block)) continue;
                        cachedBytes += HdfsPartition.FileBlock.getLength(block);
                    }
                }
                totalCachedBytes += cachedBytes;
                rowBuilder.addBytes(cachedBytes);
                Short rep = HdfsCachingUtil.getCachedCacheReplication(table.getNumClusteringCols() == 0 ? feFsPartition.getTable().getMetaStoreTable().getParameters() : feFsPartition.getParameters());
                rowBuilder.add(rep.toString());
            }
            rowBuilder.add(feFsPartition.getFileFormat().toString());
            rowBuilder.add(String.valueOf(feFsPartition.hasIncrementalStats()));
            rowBuilder.add(feFsPartition.getLocation());
            rowBuilder.add(FileSystemUtil.getErasureCodingPolicy(feFsPartition.getLocationPath()));
            result.addToRows(rowBuilder.get());
        }
        if (table.getNumClusteringCols() > 0) {
            TResultRowBuilder rowBuilder = new TResultRowBuilder();
            int n = table.getNumClusteringCols() - 1;
            rowBuilder.add("Total");
            for (int i = 0; i < n; ++i) {
                rowBuilder.add(DEFAULT_PARTITION_NAME);
            }
            rowBuilder.add(table.getNumRows());
            if (statsExtrap) {
                rowBuilder.add(FeFsTable.Utils.getExtrapolatedNumRows(table, table.getTotalHdfsBytes()));
            }
            rowBuilder.add(totalNumFiles).addBytes(totalBytes).addBytes(totalCachedBytes).add(DEFAULT_PARTITION_NAME).add(DEFAULT_PARTITION_NAME).add(DEFAULT_PARTITION_NAME).add(DEFAULT_PARTITION_NAME).add(DEFAULT_PARTITION_NAME);
            result.addToRows(rowBuilder.get());
        }
        return result;
    }

    public static String constructPartitionName(List<TPartitionKeyValue> partitionSpec) {
        ArrayList<String> partitionCols = new ArrayList<String>();
        ArrayList<String> partitionVals = new ArrayList<String>();
        for (TPartitionKeyValue kv : partitionSpec) {
            partitionCols.add(kv.getName());
            partitionVals.add(kv.getValue());
        }
        return org.apache.hadoop.hive.common.FileUtils.makePartName(partitionCols, partitionVals);
    }

    private static String generateDebugStr(List<String> items, int limit) {
        String result = Joiner.on((char)',').join(Iterables.limit(items, (int)limit));
        if (items.size() > limit) {
            result = String.format("%s... and %s others", result, items.size() - limit);
        }
        return result;
    }

    public int reloadPartitionsFromNames(IMetaStoreClient client, List<String> partNames, String reason, FileMetadataLoadOpts fileMetadataLoadOpts) throws CatalogException {
        Preconditions.checkState((partNames != null && !partNames.isEmpty() ? 1 : 0) != 0);
        LOG.info(String.format("Reloading partition metadata: %s %s (%s)", this.getFullName(), HdfsTable.generateDebugStr(partNames, 3), reason));
        HashMap<Partition, HdfsPartition> hmsPartToHdfsPart = new HashMap<Partition, HdfsPartition>();
        try {
            List<Partition> hmsPartitions = MetaStoreUtil.fetchPartitionsByName(client, partNames, this.msTable_);
            for (Partition partition : hmsPartitions) {
                List<LiteralExpr> partExprs = this.getTypeCompatiblePartValues(partition.getValues());
                HdfsPartition hdfsPartition = this.getPartition(partExprs);
                if (hdfsPartition == null) continue;
                hmsPartToHdfsPart.put(partition, hdfsPartition);
            }
            this.reloadPartitions(client, hmsPartToHdfsPart, fileMetadataLoadOpts, (EventSequence)NoOpEventSequence.INSTANCE);
            return hmsPartToHdfsPart.size();
        }
        catch (InvalidObjectException | NoSuchObjectException e) {
            throw new TableLoadingException("Error when reloading partitions for table " + this.getFullName(), e);
        }
        catch (TException e2) {
            throw new CatalogException("Unexpected error while retrieving partitions for table " + this.getFullName(), e2);
        }
    }

    public int reloadPartitionsFromEvent(IMetaStoreClient client, List<Partition> partsFromEvent, boolean loadFileMetadata, String reason) throws CatalogException {
        Preconditions.checkArgument((partsFromEvent != null && !partsFromEvent.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isWriteLockedByCurrentThread(), (Object)"Write Lock should be held before reloadPartitionsFromEvent");
        LOG.info("Reloading partition metadata for table: {} ({})", (Object)this.getFullName(), (Object)reason);
        HashMap<Partition, HdfsPartition> hmsPartToHdfsPart = new HashMap<Partition, HdfsPartition>();
        for (Partition partition : partsFromEvent) {
            List<LiteralExpr> partExprs = this.getTypeCompatiblePartValues(partition.getValues());
            HdfsPartition hdfsPartition = this.getPartition(partExprs);
            if (hdfsPartition == null || AcidUtils.isTransactionalTable(this.msTable_.getParameters()) && hdfsPartition.getWriteId() > MetastoreShim.getWriteIdFromMSPartition(partition)) continue;
            hmsPartToHdfsPart.put(partition, hdfsPartition);
        }
        this.reloadPartitions(client, hmsPartToHdfsPart, loadFileMetadata, (EventSequence)NoOpEventSequence.INSTANCE);
        return hmsPartToHdfsPart.size();
    }

    public void reloadPartitions(IMetaStoreClient client, Map<Partition, HdfsPartition> hmsPartsToHdfsParts, boolean loadFileMetadata, EventSequence catalogTimeline) throws CatalogException {
        if (loadFileMetadata) {
            this.reloadPartitions(client, hmsPartsToHdfsParts, FileMetadataLoadOpts.FORCE_LOAD, catalogTimeline);
        } else {
            this.reloadPartitions(client, hmsPartsToHdfsParts, FileMetadataLoadOpts.NO_LOAD, catalogTimeline);
        }
    }

    public void reloadPartitions(IMetaStoreClient client, Map<Partition, HdfsPartition> hmsPartsToHdfsParts, FileMetadataLoadOpts fileMetadataLoadOpts, EventSequence catalogTimeline) throws CatalogException {
        Preconditions.checkState((boolean)this.isWriteLockedByCurrentThread(), (Object)"Write Lock should be held before reloadPartitions");
        FsPermissionCache permissionCache = new FsPermissionCache();
        HashMap<HdfsPartition.Builder, HdfsPartition> partBuilderToPartitions = new HashMap<HdfsPartition.Builder, HdfsPartition>();
        HashSet<HdfsPartition.Builder> partBuildersFileMetadataRefresh = new HashSet<HdfsPartition.Builder>();
        long latestEventId = MetastoreEventsProcessor.getCurrentEventIdNoThrow(client);
        catalogTimeline.markEvent("Got current Metastore event id " + latestEventId);
        for (Map.Entry<Partition, HdfsPartition> entry : hmsPartsToHdfsParts.entrySet()) {
            Partition hmsPartition = entry.getKey();
            HdfsPartition oldPartition = entry.getValue();
            HdfsPartition.Builder partBuilder = this.createPartitionBuilder(hmsPartition.getSd(), hmsPartition, permissionCache);
            Preconditions.checkArgument((oldPartition == null || HdfsPartition.comparePartitionKeyValues(oldPartition.getPartitionValues(), partBuilder.getPartitionValues()) == 0 ? 1 : 0) != 0);
            if (oldPartition != null) {
                partBuilder.setFileDescriptors(oldPartition);
                partBuilder.setCreateEventId(oldPartition.getCreateEventId());
                partBuilder.setLastCompactionId(oldPartition.getLastCompactionId());
            }
            partBuilder.setLastRefreshEventId(latestEventId);
            switch (fileMetadataLoadOpts) {
                case FORCE_LOAD: {
                    partBuildersFileMetadataRefresh.add(partBuilder);
                    break;
                }
                case LOAD_IF_SD_CHANGED: {
                    if (oldPartition != null && oldPartition.compareSd(hmsPartition.getSd()) && !partBuilder.isMarkedCached()) break;
                    partBuildersFileMetadataRefresh.add(partBuilder);
                    break;
                }
                case NO_LOAD: {
                    break;
                }
                default: {
                    throw new CatalogException("Invalid filemetadataOpts: " + fileMetadataLoadOpts.name() + " in reloadPartitions()");
                }
            }
            partBuilderToPartitions.put(partBuilder, oldPartition);
        }
        LOG.info("Setting the latest refresh event id to {} for the reloaded {} partitions", (Object)latestEventId, (Object)partBuilderToPartitions.size());
        if (!partBuildersFileMetadataRefresh.isEmpty()) {
            LOG.info("for table {}, file metadataOps: {}, refreshing file metadata for {} out of {} partitions to reload in reloadPartitions()", new Object[]{this.getFullName(), fileMetadataLoadOpts.name(), partBuildersFileMetadataRefresh.size(), partBuilderToPartitions.size()});
            this.loadFileMetadataForPartitions(client, partBuildersFileMetadataRefresh, true, catalogTimeline);
        }
        for (Map.Entry<Object, HdfsPartition> entry : partBuilderToPartitions.entrySet()) {
            if (entry.getValue() != null) {
                this.dropPartition(entry.getValue(), false);
            }
            this.addPartition(((HdfsPartition.Builder)entry.getKey()).build());
        }
    }

    @Override
    public void initMetrics() {
        super.initMetrics();
        this.metrics_.addGauge(NUM_PARTITIONS_METRIC, new Gauge<Integer>(){

            public Integer getValue() {
                return HdfsTable.this.partitionMap_.values().size();
            }
        });
        this.metrics_.addGauge(NUM_FILES_METRIC, new Gauge<Long>(){

            public Long getValue() {
                return ((HdfsTable)HdfsTable.this).fileMetadataStats_.numFiles;
            }
        });
        this.metrics_.addGauge(NUM_BLOCKS_METRIC, new Gauge<Long>(){

            public Long getValue() {
                return ((HdfsTable)HdfsTable.this).fileMetadataStats_.numBlocks;
            }
        });
        this.metrics_.addGauge(TOTAL_FILE_BYTES_METRIC, new Gauge<Long>(){

            public Long getValue() {
                return ((HdfsTable)HdfsTable.this).fileMetadataStats_.totalFileBytes;
            }
        });
        this.metrics_.addGauge(MEMORY_ESTIMATE_METRIC, new Gauge<Long>(){

            public Long getValue() {
                return HdfsTable.this.getEstimatedMetadataSize();
            }
        });
        this.metrics_.addGauge(HAS_INCREMENTAL_STATS_METRIC, new Gauge<Boolean>(){

            public Boolean getValue() {
                return HdfsTable.this.hasIncrementalStats_;
            }
        });
        this.metrics_.addTimer(CATALOG_UPDATE_DURATION_METRIC);
        this.metrics_.addCounter(FILEMETADATA_CACHE_HIT_METRIC);
        this.metrics_.addCounter(FILEMETADATA_CACHE_MISS_METRIC);
        this.metrics_.addCounter(NUM_LOAD_FILEMETADATA_METRIC);
    }

    public static HdfsTable createCtasTarget(Db db, org.apache.hadoop.hive.metastore.api.Table msTbl) throws CatalogException {
        HdfsTable tmpTable = new HdfsTable(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        HiveConf hiveConf = new HiveConf(HdfsTable.class);
        tmpTable.nullPartitionKeyValue_ = hiveConf.get("hive.exec.default.partition.name", "__HIVE_DEFAULT_PARTITION__");
        tmpTable.loadSchema(msTbl);
        tmpTable.initializePartitionMetadata(msTbl);
        tmpTable.setTableStats(msTbl);
        return tmpTable;
    }

    protected ValidWriteIdList fetchValidWriteIds(IMetaStoreClient client) throws TableLoadingException {
        String tblFullName = this.getFullName();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Get valid writeIds for table: " + tblFullName);
        }
        try {
            ValidWriteIdList validWriteIds = MetastoreShim.fetchValidWriteIds(client, tblFullName);
            LOG.info("Valid writeIds of table {}: {}", (Object)tblFullName, (Object)validWriteIds.writeToString());
            return validWriteIds;
        }
        catch (Exception e) {
            throw new TableLoadingException(String.format("Error loading ValidWriteIds for table '%s'", tblFullName), e);
        }
    }

    protected boolean loadValidWriteIdList(IMetaStoreClient client) throws TableLoadingException {
        Stopwatch sw = Stopwatch.createStarted();
        Preconditions.checkState((this.msTable_ != null && this.msTable_.getParameters() != null ? 1 : 0) != 0);
        boolean prevWriteIdChanged = false;
        if (MetastoreShim.getMajorVersion() > 2L && AcidUtils.isTransactionalTable(this.msTable_.getParameters())) {
            ValidWriteIdList writeIdList = this.fetchValidWriteIds(client);
            prevWriteIdChanged = writeIdList.toString().equals(this.validWriteIds_);
            this.validWriteIds_ = new MutableValidReaderWriteIdList(writeIdList);
        } else {
            this.validWriteIds_ = null;
        }
        LOG.debug("Load Valid Write Id List Done. Time taken: " + PrintUtils.printTimeNs(sw.elapsed(TimeUnit.NANOSECONDS)));
        return prevWriteIdChanged;
    }

    @Override
    public ValidWriteIdList getValidWriteIds() {
        if (this.validWriteIds_ == null) {
            return null;
        }
        return MetastoreShim.getValidWriteIdListFromString(this.validWriteIds_.toString());
    }

    public void setValidWriteIds(ValidWriteIdList writeIdList) {
        this.validWriteIds_ = writeIdList != null ? new MutableValidReaderWriteIdList(writeIdList) : null;
    }

    public boolean addWriteIds(List<Long> writeIds, MutableValidWriteIdList.WriteIdStatus status) throws CatalogException {
        Preconditions.checkState((boolean)this.isWriteLockedByCurrentThread(), (Object)"Write Lock should be held before addWriteIds.");
        Preconditions.checkArgument((writeIds != null ? 1 : 0) != 0, (Object)"Cannot add null write ids");
        Preconditions.checkState((this.validWriteIds_ != null ? 1 : 0) != 0, (Object)"Write id list should not be null");
        switch (status) {
            case OPEN: {
                return this.validWriteIds_.addOpenWriteId(Collections.max(writeIds));
            }
            case COMMITTED: {
                return this.validWriteIds_.addCommittedWriteIds(writeIds);
            }
            case ABORTED: {
                return this.validWriteIds_.addAbortedWriteIds(writeIds);
            }
        }
        throw new CatalogException("Unknown write id status " + (Object)((Object)status) + " for table " + this.getFullName());
    }

    public long getLastCompactionId() {
        return this.lastCompactionId_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePendingVersion(long expectedTblVersion, long newPendingVersion) {
        Object object = this.pendingVersionLock_;
        synchronized (object) {
            if (expectedTblVersion == this.getCatalogVersion()) {
                this.pendingVersionNumber_ = newPendingVersion;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalogVersion(long version) {
        Object object = this.pendingVersionLock_;
        synchronized (object) {
            long versionToBeSet = version;
            if (this.pendingVersionNumber_ > version) {
                LOG.trace("Pending table version {} is higher than requested version {}", (Object)this.pendingVersionNumber_, (Object)version);
                versionToBeSet = this.pendingVersionNumber_;
            }
            LOG.trace("Setting the hdfs table {} version {}", (Object)this.getFullName(), (Object)versionToBeSet);
            super.setCatalogVersion(versionToBeSet);
        }
    }

    public long getLastVersionSeenByTopicUpdate() {
        return this.lastVersionSeenByTopicUpdate_;
    }

    public void setLastVersionSeenByTopicUpdate(long version) {
        this.lastVersionSeenByTopicUpdate_ = version;
    }

    public boolean isParquetTable() {
        for (FeFsPartition feFsPartition : this.partitionMap_.values()) {
            if (feFsPartition.getFileFormat().isParquetBased()) continue;
            return false;
        }
        return true;
    }

    private class PartNameBasedDeltaUpdater
    extends PartitionDeltaUpdater {
        private final Set<String> partitionNamesFromHms_;

        public PartNameBasedDeltaUpdater(IMetaStoreClient client, boolean loadPartitionFileMetadata, Set<String> partitionsToUpdate, Map<String, Long> partitionToEventId, String debugAction, EventSequence catalogTimeline) throws Exception {
            super(client, loadPartitionFileMetadata, partitionsToUpdate, partitionToEventId, debugAction, catalogTimeline);
            this.partitionNamesFromHms_ = new HashSet<String>(this.client_.listPartitionNames(HdfsTable.this.db_.getName(), HdfsTable.this.name_, (short)-1));
        }

        @Override
        public boolean isRemoved(HdfsPartition hdfsPartition) {
            return !this.partitionNamesFromHms_.contains(hdfsPartition.getPartitionName());
        }

        @Override
        public HdfsPartition.Builder getUpdatedPartition(HdfsPartition hdfsPartition) {
            return HdfsTable.this.pickInprogressPartitionBuilder(hdfsPartition);
        }

        @Override
        public long loadNewPartitions(Set<String> knownPartitionNames, Set<String> addedPartNames) throws Exception {
            addedPartNames.addAll((Collection<String>)Sets.difference(this.partitionNamesFromHms_, knownPartitionNames));
            return HdfsTable.this.loadPartitionsFromMetastore(addedPartNames, (Map<String, HdfsPartition.Builder>)null, (Map<String, Long>)this.partitionToEventId_, this.client_, this.catalogTimeline_);
        }

        @Override
        public long loadUpdatedPartitions(Map<String, HdfsPartition.Builder> updatedPartitionBuilders) throws Exception {
            return HdfsTable.this.loadPartitionsFromMetastore(updatedPartitionBuilders.keySet(), (Map<String, HdfsPartition.Builder>)updatedPartitionBuilders, (Map<String, Long>)null, this.client_, this.catalogTimeline_);
        }
    }

    private class PartBasedDeltaUpdater
    extends PartitionDeltaUpdater {
        private final Map<String, Partition> msPartitions_;
        private final FsPermissionCache permCache_;

        public PartBasedDeltaUpdater(IMetaStoreClient client, boolean loadPartitionFileMetadata, Set<String> partitionsToUpdate, Map<String, Long> partitionToEventId, String debugAction, EventSequence catalogTimeline) throws Exception {
            super(client, loadPartitionFileMetadata, partitionsToUpdate, partitionToEventId, debugAction, catalogTimeline);
            this.msPartitions_ = new HashMap<String, Partition>();
            this.permCache_ = new FsPermissionCache();
            Stopwatch sw = Stopwatch.createStarted();
            List<Partition> partitionList = partitionsToUpdate != null ? MetaStoreUtil.fetchPartitionsByName(client, Lists.newArrayList(partitionsToUpdate), HdfsTable.this.msTable_) : MetaStoreUtil.fetchAllPartitions(this.client_, HdfsTable.this.msTable_, 5);
            LOG.debug("Time taken to fetch all partitions of table {}: {} msec", (Object)HdfsTable.this.getFullName(), (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
            List<String> partitionColNames = HdfsTable.this.getClusteringColNames();
            for (Partition part : partitionList) {
                this.msPartitions_.put(MetastoreShim.makePartName(partitionColNames, part.getValues()), part);
            }
        }

        @Override
        public boolean isRemoved(HdfsPartition hdfsPartition) {
            return !this.msPartitions_.containsKey(hdfsPartition.getPartitionName());
        }

        @Override
        public HdfsPartition.Builder getUpdatedPartition(HdfsPartition hdfsPartition) throws Exception {
            HdfsPartition.Builder updatedPartitionBuilder = HdfsTable.this.pickInprogressPartitionBuilder(hdfsPartition);
            Partition msPartition = (Partition)Preconditions.checkNotNull((Object)this.msPartitions_.get(hdfsPartition.getPartitionName()));
            Preconditions.checkNotNull((Object)msPartition.getSd());
            if (!hdfsPartition.compareSd(msPartition.getSd())) {
                if (updatedPartitionBuilder == null) {
                    updatedPartitionBuilder = new HdfsPartition.Builder(hdfsPartition);
                }
                updatedPartitionBuilder = HdfsTable.this.createOrUpdatePartitionBuilder(msPartition.getSd(), msPartition, this.permCache_, updatedPartitionBuilder);
            }
            return updatedPartitionBuilder;
        }

        @Override
        public long loadNewPartitions(Set<String> knownPartitions, Set<String> addedPartNames) throws Exception {
            ArrayList<Partition> newMsPartitions = new ArrayList<Partition>();
            for (String partNameInMs : this.msPartitions_.keySet()) {
                if (knownPartitions.contains(partNameInMs)) continue;
                newMsPartitions.add(this.msPartitions_.get(partNameInMs));
                addedPartNames.add(partNameInMs);
            }
            return HdfsTable.this.loadPartitionsFromMetastore(newMsPartitions, (Map<String, HdfsPartition.Builder>)null, (Map<String, Long>)this.partitionToEventId_, this.client_, this.catalogTimeline_);
        }

        @Override
        public long loadUpdatedPartitions(Map<String, HdfsPartition.Builder> updatedPartBuilders) throws Exception {
            ArrayList<Object> updatedPartitions = new ArrayList<Object>();
            for (String partName : updatedPartBuilders.keySet()) {
                updatedPartitions.add(Preconditions.checkNotNull((Object)this.msPartitions_.get(partName)));
            }
            return HdfsTable.this.loadPartitionsFromMetastore(updatedPartitions, (Map<String, HdfsPartition.Builder>)updatedPartBuilders, (Map<String, Long>)null, this.client_, this.catalogTimeline_);
        }
    }

    private abstract class PartitionDeltaUpdater {
        private final boolean loadFileMd_;
        private long loadTimeForFileMdNs_;
        protected final IMetaStoreClient client_;
        private final Set<String> partitionsToUpdate_;
        private final String debugAction_;
        protected final Map<String, Long> partitionToEventId_;
        protected final EventSequence catalogTimeline_;

        PartitionDeltaUpdater(IMetaStoreClient client, boolean loadPartitionFileMetadata, @Nullable Set<String> partitionsToUpdate, Map<String, Long> partitionToEventId, String debugAction, EventSequence catalogTimeline) {
            this.client_ = client;
            this.loadFileMd_ = loadPartitionFileMetadata;
            this.partitionsToUpdate_ = partitionsToUpdate;
            this.debugAction_ = debugAction;
            this.partitionToEventId_ = partitionToEventId;
            this.catalogTimeline_ = catalogTimeline;
        }

        public abstract boolean isRemoved(HdfsPartition var1);

        public abstract long loadNewPartitions(Set<String> var1, Set<String> var2) throws Exception;

        public abstract HdfsPartition.Builder getUpdatedPartition(HdfsPartition var1) throws Exception;

        public abstract long loadUpdatedPartitions(Map<String, HdfsPartition.Builder> var1) throws Exception;

        public void apply() throws Exception {
            ArrayList<HdfsPartition> removedPartitions = new ArrayList<HdfsPartition>();
            HashMap<String, HdfsPartition.Builder> updatedPartitions = new HashMap<String, HdfsPartition.Builder>();
            ArrayList<HdfsPartition.Builder> partitionsToLoadFiles = new ArrayList<HdfsPartition.Builder>();
            HashSet<String> partitionNames = new HashSet<String>();
            for (HdfsPartition partition : HdfsTable.this.partitionMap_.values()) {
                if (this.isRemoved(partition)) {
                    removedPartitions.add(partition);
                } else {
                    HdfsPartition.Builder updatedPartBuilder = this.getUpdatedPartition(partition);
                    if (updatedPartBuilder != null) {
                        updatedPartitions.put(partition.getPartitionName(), updatedPartBuilder);
                    } else if (this.loadFileMd_ && this.partitionsToUpdate_ == null) {
                        partitionsToLoadFiles.add(new HdfsPartition.Builder(partition));
                    }
                }
                Preconditions.checkNotNull((Object)partition.getCachedMsPartitionDescriptor());
                partitionNames.add(partition.getPartitionName());
            }
            HdfsTable.this.dropPartitions(removedPartitions);
            this.loadTimeForFileMdNs_ = this.loadUpdatedPartitions(updatedPartitions);
            Preconditions.checkState((!HdfsTable.this.hasInProgressModification() ? 1 : 0) != 0);
            HashSet<String> addedPartitions = new HashSet<String>();
            this.loadTimeForFileMdNs_ += this.loadNewPartitions(partitionNames, addedPartitions);
            if (this.partitionsToUpdate_ != null) {
                this.partitionsToUpdate_.removeAll(addedPartitions);
            }
            if (this.loadFileMd_) {
                if (this.partitionsToUpdate_ != null) {
                    Preconditions.checkState((boolean)partitionsToLoadFiles.isEmpty());
                    List<HdfsPartition> parts = HdfsTable.this.getPartitionsForNames(this.partitionsToUpdate_);
                    partitionsToLoadFiles = parts.stream().map(HdfsPartition.Builder::new).collect(Collectors.toList());
                }
                if (!partitionsToLoadFiles.isEmpty()) {
                    this.loadTimeForFileMdNs_ += HdfsTable.this.loadFileMetadataForPartitions(this.client_, partitionsToLoadFiles, true, this.debugAction_, this.catalogTimeline_);
                    HdfsTable.this.updatePartitions(partitionsToLoadFiles);
                }
            }
        }

        public long getTotalFileMdLoadTime() {
            return this.loadTimeForFileMdNs_;
        }
    }

    public static final class FileMetadataStats {
        public long numFiles;
        public long numBlocks;
        public long totalFileBytes;

        public void unset() {
            this.numFiles = -1L;
            this.numBlocks = -1L;
            this.totalFileBytes = -1L;
        }

        public void init() {
            this.numFiles = 0L;
            this.numBlocks = 0L;
            this.totalFileBytes = 0L;
        }

        public void set(FileMetadataStats stats) {
            this.numFiles = stats.numFiles;
            this.numBlocks = stats.numBlocks;
            this.totalFileBytes = stats.totalFileBytes;
        }
    }
}

