/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.impala.catalog.HdfsCompression;
import org.apache.impala.thrift.THdfsFileFormat;

public enum HdfsFileFormat {
    RC_FILE("org.apache.hadoop.hive.ql.io.RCFileInputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", "org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe", false, true, false),
    TEXT("org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", false, false, true),
    JSON("org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "org.apache.hadoop.hive.serde2.JsonSerDe", false, false, true),
    LZO_TEXT("com.hadoop.mapred.DeprecatedLzoTextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", "", false, false, true),
    SEQUENCE_FILE("org.apache.hadoop.mapred.SequenceFileInputFormat", "org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", false, true, false),
    AVRO("org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat", "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat", "org.apache.hadoop.hive.serde2.avro.AvroSerDe", false, false, true),
    PARQUET("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", true, true, true),
    ORC("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcSerde", true, true, true),
    KUDU("org.apache.hadoop.hive.kudu.KuduInputFormat", "org.apache.hadoop.hive.kudu.KuduOutputFormat", "org.apache.hadoop.hive.kudu.KuduSerDe", false, false, false),
    HUDI_PARQUET("org.apache.hudi.hadoop.HoodieParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat", "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", true, true, true),
    ICEBERG("org.apache.iceberg.mr.hive.HiveIcebergInputFormat", "org.apache.iceberg.mr.hive.HiveIcebergOutputFormat", "org.apache.iceberg.mr.hive.HiveIcebergSerDe", false, false, false),
    JDBC("org.apache.hadoop.hive.jdbc.JdbcInputFormat", "org.apache.hadoop.hive.jdbc.JdbcOutputFormat", "org.apache.hadoop.hive.jdbc.JdbcSerDe", false, false, true);

    private final String inputFormat_;
    private final String outputFormat_;
    private final String serializationLib_;
    private final boolean isComplexTypesSupported_;
    private final boolean canSkipColumnTypes_;
    private final boolean isDateTypeSupported_;
    private static final String[] PARQUET_LEGACY_INPUT_FORMATS;
    private static final String JSON_SERDE = "org.apache.hadoop.hive.serde2.JsonSerDe";
    private static Map<String, HdfsFileFormat> VALID_INPUT_FORMATS;

    private HdfsFileFormat(String inputFormat, String outputFormat, String serializationLib, boolean isComplexTypesSupported, boolean canSkipColumnTypes, boolean isDateTypeSupported) {
        this.inputFormat_ = inputFormat;
        this.outputFormat_ = outputFormat;
        this.serializationLib_ = serializationLib;
        this.isComplexTypesSupported_ = isComplexTypesSupported;
        this.canSkipColumnTypes_ = canSkipColumnTypes;
        this.isDateTypeSupported_ = isDateTypeSupported;
    }

    public String inputFormat() {
        return this.inputFormat_;
    }

    public String outputFormat() {
        return this.outputFormat_;
    }

    public String serializationLib() {
        return this.serializationLib_;
    }

    public static boolean isHdfsInputFormatClass(String inputFormatClass) {
        return VALID_INPUT_FORMATS.containsKey(inputFormatClass);
    }

    public static HdfsFileFormat fromHdfsInputFormatClass(String inputFormatClass, String serDe) {
        Preconditions.checkNotNull((Object)inputFormatClass);
        if (serDe != null && inputFormatClass.equals(TEXT.inputFormat()) && JSON_SERDE.equals(serDe)) {
            return JSON;
        }
        return VALID_INPUT_FORMATS.get(inputFormatClass);
    }

    public static HdfsFileFormat fromJavaClassName(String className, String serDe) {
        Preconditions.checkNotNull((Object)className);
        if (serDe != null && className.equals(TEXT.inputFormat()) && JSON_SERDE.equals(serDe)) {
            return JSON;
        }
        if (HdfsFileFormat.isHdfsInputFormatClass(className)) {
            return VALID_INPUT_FORMATS.get(className);
        }
        throw new IllegalArgumentException(className);
    }

    public static HdfsFileFormat fromThrift(THdfsFileFormat thriftFormat) {
        switch (thriftFormat) {
            case RC_FILE: {
                return RC_FILE;
            }
            case TEXT: {
                return TEXT;
            }
            case SEQUENCE_FILE: {
                return SEQUENCE_FILE;
            }
            case AVRO: {
                return AVRO;
            }
            case ORC: {
                return ORC;
            }
            case HUDI_PARQUET: {
                return HUDI_PARQUET;
            }
            case PARQUET: {
                return PARQUET;
            }
            case KUDU: {
                return KUDU;
            }
            case ICEBERG: {
                return ICEBERG;
            }
            case JSON: {
                return JSON;
            }
            case JDBC: {
                return JDBC;
            }
        }
        throw new RuntimeException("Unknown THdfsFileFormat: " + (Object)((Object)thriftFormat) + " - should never happen!");
    }

    public THdfsFileFormat toThrift() {
        switch (this) {
            case RC_FILE: {
                return THdfsFileFormat.RC_FILE;
            }
            case TEXT: {
                return THdfsFileFormat.TEXT;
            }
            case SEQUENCE_FILE: {
                return THdfsFileFormat.SEQUENCE_FILE;
            }
            case AVRO: {
                return THdfsFileFormat.AVRO;
            }
            case ORC: {
                return THdfsFileFormat.ORC;
            }
            case HUDI_PARQUET: 
            case PARQUET: {
                return THdfsFileFormat.PARQUET;
            }
            case KUDU: {
                return THdfsFileFormat.KUDU;
            }
            case ICEBERG: {
                return THdfsFileFormat.ICEBERG;
            }
            case JSON: {
                return THdfsFileFormat.JSON;
            }
            case JDBC: {
                return THdfsFileFormat.JDBC;
            }
        }
        throw new RuntimeException("Unknown HdfsFormat: " + (Object)((Object)this) + " - should never happen!");
    }

    public String toSql(HdfsCompression compressionType) {
        switch (this) {
            case RC_FILE: {
                return "RCFILE";
            }
            case ORC: {
                return "ORC";
            }
            case TEXT: {
                if (compressionType == HdfsCompression.LZO || compressionType == HdfsCompression.LZO_INDEX) {
                    return String.format("INPUTFORMAT '%s' OUTPUTFORMAT '%s'", LZO_TEXT.inputFormat(), LZO_TEXT.outputFormat());
                }
                return "TEXTFILE";
            }
            case SEQUENCE_FILE: {
                return "SEQUENCEFILE";
            }
            case AVRO: {
                return "AVRO";
            }
            case PARQUET: {
                return "PARQUET";
            }
            case KUDU: {
                return "KUDU";
            }
            case HUDI_PARQUET: {
                return "HUDIPARQUET";
            }
            case ICEBERG: {
                return "ICEBERG";
            }
            case JSON: {
                return "JSONFILE";
            }
            case JDBC: {
                return "JDBC";
            }
        }
        throw new RuntimeException("Unknown HdfsFormat: " + (Object)((Object)this) + " - should never happen!");
    }

    public boolean isSplittable(HdfsCompression compression) {
        switch (this) {
            case TEXT: 
            case JSON: {
                return compression == HdfsCompression.NONE;
            }
            case RC_FILE: 
            case SEQUENCE_FILE: 
            case AVRO: 
            case ORC: 
            case HUDI_PARQUET: 
            case PARQUET: 
            case ICEBERG: {
                return true;
            }
            case KUDU: {
                return false;
            }
            case JDBC: {
                return false;
            }
        }
        throw new RuntimeException("Unknown HdfsFormat: " + (Object)((Object)this) + " - should never happen!");
    }

    public boolean isComplexTypesSupported() {
        return this.isComplexTypesSupported_;
    }

    public boolean canSkipComplexTypes() {
        return this.canSkipColumnTypes_;
    }

    public boolean isDateTypeSupported() {
        return this.isDateTypeSupported_;
    }

    public static List<HdfsFileFormat> complexTypesFormats() {
        ArrayList<HdfsFileFormat> result = new ArrayList<HdfsFileFormat>();
        for (HdfsFileFormat f : HdfsFileFormat.values()) {
            if (!f.isComplexTypesSupported()) continue;
            result.add(f);
        }
        return result;
    }

    public boolean isParquetBased() {
        return this == PARQUET || this == HUDI_PARQUET;
    }

    static {
        PARQUET_LEGACY_INPUT_FORMATS = new String[]{"com.cloudera.impala.hive.serde.ParquetInputFormat", "parquet.hive.DeprecatedParquetInputFormat", "parquet.hive.MapredParquetInputFormat"};
        VALID_INPUT_FORMATS = ImmutableMap.builder().put((Object)RC_FILE.inputFormat(), (Object)RC_FILE).put((Object)TEXT.inputFormat(), (Object)TEXT).put((Object)LZO_TEXT.inputFormat(), (Object)TEXT).put((Object)SEQUENCE_FILE.inputFormat(), (Object)SEQUENCE_FILE).put((Object)AVRO.inputFormat(), (Object)AVRO).put((Object)PARQUET.inputFormat(), (Object)PARQUET).put((Object)PARQUET_LEGACY_INPUT_FORMATS[0], (Object)PARQUET).put((Object)PARQUET_LEGACY_INPUT_FORMATS[1], (Object)PARQUET).put((Object)PARQUET_LEGACY_INPUT_FORMATS[2], (Object)PARQUET).put((Object)KUDU.inputFormat(), (Object)KUDU).put((Object)ORC.inputFormat(), (Object)ORC).put((Object)HUDI_PARQUET.inputFormat(), (Object)HUDI_PARQUET).put((Object)ICEBERG.inputFormat(), (Object)ICEBERG).build();
    }
}

