/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;

public class HBaseTable
extends Table
implements FeHBaseTable {
    private static final String HBASE_INPUT_FORMAT = "org.apache.hadoop.hive.hbase.HiveHBaseTableInputFormat";
    private static final String HBASE_SERIALIZATION_LIB = "org.apache.hadoop.hive.hbase.HBaseSerDe";
    private String hbaseTableName_;
    private HColumnDescriptor[] columnFamilies_ = null;

    protected HBaseTable(org.apache.hadoop.hive.metastore.api.Table msTbl, Db db, String name, String owner) {
        super(msTbl, db, name, owner);
    }

    public static boolean isHBaseTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        if (msTbl.getParameters() != null && msTbl.getParameters().containsKey("org.apache.hadoop.hive.hbase.HBaseStorageHandler")) {
            return true;
        }
        StorageDescriptor sd = msTbl.getSd();
        if (sd == null) {
            return false;
        }
        if (sd.getInputFormat() != null && sd.getInputFormat().equals(HBASE_INPUT_FORMAT)) {
            return true;
        }
        return sd.getSerdeInfo() != null && sd.getSerdeInfo().getSerializationLib() != null && sd.getSerdeInfo().getSerializationLib().equals(HBASE_SERIALIZATION_LIB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        Preconditions.checkNotNull((Object)this.getMetaStoreTable());
        Table.LOADING_TABLES.incrementAndGet();
        try (Timer.Context timer = this.getMetrics().getTimer("load-duration").time();){
            List<Column> cols;
            this.msTable_ = msTbl;
            Timer.Context storageLoadTimer = this.getMetrics().getTimer("load-duration.storage-metadata").time();
            try {
                this.hbaseTableName_ = FeHBaseTable.Util.getHBaseTableName(this.getMetaStoreTable());
                FeHBaseTable.Util.getHBaseTable(this.hbaseTableName_).close();
                catalogTimeline.markEvent("Checked HBase table exists");
                this.columnFamilies_ = null;
                this.getColumnFamilies();
                cols = FeHBaseTable.Util.loadColumns(this.msTable_);
            }
            finally {
                this.storageMetadataLoadTime_ = storageLoadTimer.stop();
            }
            this.clearColumns();
            for (Column col : cols) {
                this.addColumn(col);
            }
            this.setTableStats(this.msTable_);
            this.numClusteringCols_ = 1;
            this.loadAllColumnStats(client, catalogTimeline);
            this.refreshLastUsedTime();
        }
        catch (Exception e) {
            throw new TableLoadingException("Failed to load metadata for HBase table: " + this.name_, e);
        }
        finally {
            Table.LOADING_TABLES.decrementAndGet();
        }
    }

    @Override
    protected void loadFromThrift(TTable table) throws TableLoadingException {
        super.loadFromThrift(table);
        try {
            this.hbaseTableName_ = FeHBaseTable.Util.getHBaseTableName(this.getMetaStoreTable());
            this.columnFamilies_ = null;
            this.getColumnFamilies();
        }
        catch (Exception e) {
            throw new TableLoadingException("Failed to load metadata for HBase table from thrift table: " + this.name_, e);
        }
    }

    @Override
    public Pair<Long, Long> getEstimatedRowStats(byte[] startRowKey, byte[] endRowKey) {
        return FeHBaseTable.Util.getEstimatedRowStats(this, startRowKey, endRowKey);
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        return this.getColumns();
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDescriptor = new TTableDescriptor(tableId, TTableType.HBASE_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        tableDescriptor.setHbaseTable(FeHBaseTable.Util.getTHBaseTable(this));
        return tableDescriptor;
    }

    @Override
    public String getHBaseTableName() {
        return this.hbaseTableName_;
    }

    @Override
    public TResultSet getTableStats() {
        return FeHBaseTable.Util.getTableStats(this);
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.HBASE_TABLE);
        table.setHbase_table(FeHBaseTable.Util.getTHBaseTable(this));
        return table;
    }

    @Override
    public String getStorageHandlerClassName() {
        return "org.apache.hadoop.hive.hbase.HBaseStorageHandler";
    }

    @Override
    public HColumnDescriptor[] getColumnFamilies() throws IOException {
        if (this.columnFamilies_ == null) {
            try (org.apache.hadoop.hbase.client.Table hBaseTable = FeHBaseTable.Util.getHBaseTable(this.getHBaseTableName());){
                this.columnFamilies_ = hBaseTable.getTableDescriptor().getColumnFamilies();
            }
        }
        return this.columnFamilies_;
    }
}

