/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableInfoSelector;

public class GetPartialCatalogObjectRequestBuilder {
    private boolean wantFileMetadata_;
    private boolean wantHmsPartition_;
    private boolean wantPartitionNames_;
    private String tblName_;
    private String dbName_;
    private boolean wantHmsTable_;
    private boolean wantStatsForAllColumns_;
    private long tableId = -1L;
    private ValidWriteIdList writeIdList_;

    public GetPartialCatalogObjectRequestBuilder db(String db) {
        this.dbName_ = db;
        return this;
    }

    public GetPartialCatalogObjectRequestBuilder tbl(String tbl) {
        this.tblName_ = tbl;
        return this;
    }

    public GetPartialCatalogObjectRequestBuilder wantFiles() {
        this.wantFileMetadata_ = true;
        this.wantHmsPartition_ = true;
        this.wantPartitionNames_ = true;
        return this;
    }

    public GetPartialCatalogObjectRequestBuilder wantPartitions() {
        this.wantPartitionNames_ = true;
        this.wantHmsPartition_ = true;
        return this;
    }

    public GetPartialCatalogObjectRequestBuilder wantPartitionNames() {
        this.wantPartitionNames_ = true;
        return this;
    }

    public GetPartialCatalogObjectRequestBuilder wantStatsForAllColums() {
        this.wantStatsForAllColumns_ = true;
        return this;
    }

    GetPartialCatalogObjectRequestBuilder tableId(long id) {
        this.tableId = id;
        return this;
    }

    GetPartialCatalogObjectRequestBuilder writeId(String writeIdList) {
        Preconditions.checkNotNull((Object)writeIdList);
        this.writeIdList_ = new ValidReaderWriteIdList();
        this.writeIdList_.readFromString(writeIdList);
        return this;
    }

    GetPartialCatalogObjectRequestBuilder writeId(ValidWriteIdList validWriteIdList) {
        this.writeIdList_ = (ValidWriteIdList)Preconditions.checkNotNull((Object)validWriteIdList);
        return this;
    }

    public TGetPartialCatalogObjectRequest build() {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        req.object_desc = new TCatalogObject();
        req.object_desc.setType(TCatalogObjectType.TABLE);
        req.object_desc.table = new TTable(this.dbName_, this.tblName_);
        req.table_info_selector = new TTableInfoSelector();
        req.table_info_selector.want_hms_table = true;
        req.table_info_selector.table_id = this.tableId;
        if (this.writeIdList_ != null) {
            req.table_info_selector.valid_write_ids = MetastoreShim.convertToTValidWriteIdList(this.writeIdList_);
        }
        if (this.wantPartitionNames_) {
            req.table_info_selector.want_partition_names = true;
        }
        if (this.wantHmsPartition_) {
            req.table_info_selector.want_hms_partition = true;
        }
        if (this.wantFileMetadata_) {
            req.table_info_selector.want_partition_files = true;
        }
        if (this.wantStatsForAllColumns_) {
            req.table_info_selector.want_stats_for_all_columns = true;
        }
        return req;
    }
}

