/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.NotImplementedException;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TAggregateFunction;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TScalarFunction;
import org.apache.impala.thrift.TSymbolLookupParams;
import org.apache.impala.thrift.TSymbolLookupResult;
import org.apache.impala.thrift.TSymbolType;

public class Function
extends CatalogObjectImpl {
    protected final FunctionName name_;
    protected final Type retType_;
    protected final Type[] argTypes_;
    protected boolean hasVarArgs_;
    private boolean userVisible_;
    protected HdfsUri location_;
    protected TFunctionBinaryType binaryType_;
    private boolean isPersistent_;
    protected boolean isUnsupported_;

    public Function(FunctionName name, Type[] argTypes, Type retType, boolean varArgs) {
        this.name_ = name;
        this.hasVarArgs_ = varArgs;
        this.argTypes_ = argTypes == null ? new Type[0] : argTypes;
        this.retType_ = retType == null ? ScalarType.INVALID : retType;
        this.userVisible_ = true;
        this.isUnsupported_ = false;
    }

    public Function(FunctionName name, List<Type> args, Type retType, boolean varArgs) {
        this(name, args != null && args.size() > 0 ? args.toArray(new Type[args.size()]) : new Type[]{}, retType, varArgs);
    }

    public static Function createFunction(String db, String fnName, List<Type> args, Type retType, boolean varArgs, TFunctionBinaryType fnType) {
        Function fn = new Function(new FunctionName(db, fnName), args, retType, varArgs);
        fn.setBinaryType(fnType);
        return fn;
    }

    public FunctionName getFunctionName() {
        return this.name_;
    }

    public String functionName() {
        return this.name_.getFunction();
    }

    public String dbName() {
        return this.name_.getDb();
    }

    public Type getReturnType() {
        return this.retType_;
    }

    public Type[] getArgs() {
        return this.argTypes_;
    }

    public int getNumArgs() {
        return this.argTypes_.length;
    }

    public HdfsUri getLocation() {
        return this.location_;
    }

    public TFunctionBinaryType getBinaryType() {
        return this.binaryType_;
    }

    public boolean hasVarArgs() {
        return this.hasVarArgs_;
    }

    public boolean isPersistent() {
        return this.isPersistent_;
    }

    public boolean userVisible() {
        return this.userVisible_;
    }

    public Type getVarArgsType() {
        if (!this.hasVarArgs_) {
            return Type.INVALID;
        }
        Preconditions.checkState((this.argTypes_.length > 0 ? 1 : 0) != 0);
        return this.argTypes_[this.argTypes_.length - 1];
    }

    public boolean isUnsupported() {
        return this.isUnsupported_;
    }

    public void setLocation(HdfsUri loc) {
        this.location_ = loc;
    }

    public void setBinaryType(TFunctionBinaryType type) {
        this.binaryType_ = type;
    }

    public void setHasVarArgs(boolean v) {
        this.hasVarArgs_ = v;
    }

    public void setIsPersistent(boolean v) {
        this.isPersistent_ = v;
    }

    public void setUserVisible(boolean b) {
        this.userVisible_ = b;
    }

    protected void setUnsupported() {
        this.isUnsupported_ = true;
    }

    public String signatureString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name_.getFunction()).append("(").append(Joiner.on((String)", ").join((Object[])this.argTypes_));
        if (this.hasVarArgs_) {
            sb.append("...");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Function)) {
            return false;
        }
        return this.compare((Function)o, CompareMode.IS_IDENTICAL);
    }

    public int hashCode() {
        return Objects.hash(this.name_);
    }

    public boolean compare(Function other, CompareMode mode) {
        return this.calcMatchScore(other, mode) >= 0;
    }

    public int calcMatchScore(Function other, CompareMode mode) {
        switch (mode) {
            case IS_IDENTICAL: {
                return this.calcIdenticalMatchScore(other);
            }
            case IS_INDISTINGUISHABLE: {
                return this.calcIndistinguishableMatchScore(other);
            }
            case IS_SUPERTYPE_OF: {
                return this.calcSuperTypeOfMatchScore(other, TypeCompatibility.ALL_STRICT);
            }
            case IS_NONSTRICT_SUPERTYPE_OF: {
                return this.calcSuperTypeOfMatchScore(other, TypeCompatibility.DEFAULT);
            }
        }
        Preconditions.checkState((boolean)false);
        return -1;
    }

    private Type[] tryExtendArgTypesToLength(int length) {
        if (!this.hasVarArgs_ || this.argTypes_.length >= length) {
            return this.argTypes_;
        }
        Object[] ret = Arrays.copyOf(this.argTypes_, length);
        Arrays.fill(ret, this.argTypes_.length, length, this.getVarArgsType());
        return ret;
    }

    private int calcSuperTypeOfMatchScore(Function other, TypeCompatibility compatibility) {
        if (!other.name_.equals(this.name_)) {
            return -1;
        }
        if (!this.hasVarArgs_ && other.argTypes_.length != this.argTypes_.length) {
            return -1;
        }
        if (this.hasVarArgs_ && other.argTypes_.length < this.argTypes_.length) {
            return -1;
        }
        Type[] extendedArgTypes = this.tryExtendArgTypesToLength(other.argTypes_.length);
        int num_matches = 0;
        for (int i = 0; i < extendedArgTypes.length; ++i) {
            if (other.argTypes_[i].matchesType(extendedArgTypes[i])) {
                ++num_matches;
                continue;
            }
            if (Type.isImplicitlyCastable(other.argTypes_[i], extendedArgTypes[i], compatibility)) continue;
            return -1;
        }
        return num_matches;
    }

    public Function promoteCharsToStrings() {
        Type[] promoted = (Type[])this.argTypes_.clone();
        for (int i = 0; i < promoted.length; ++i) {
            if (!promoted[i].isScalarType(PrimitiveType.CHAR)) continue;
            promoted[i] = ScalarType.STRING;
        }
        return new Function(this.name_, promoted, this.retType_, this.hasVarArgs_);
    }

    private int calcIdenticalMatchScore(Function o) {
        if (!o.name_.equals(this.name_)) {
            return -1;
        }
        if (o.argTypes_.length != this.argTypes_.length) {
            return -1;
        }
        if (o.hasVarArgs_ != this.hasVarArgs_) {
            return -1;
        }
        for (int i = 0; i < this.argTypes_.length; ++i) {
            if (o.argTypes_[i].matchesType(this.argTypes_[i])) continue;
            return -1;
        }
        return this.argTypes_.length;
    }

    private int calcIndistinguishableMatchScore(Function o) {
        int i;
        if (!o.name_.equals(this.name_)) {
            return -1;
        }
        int minArgs = Math.min(o.argTypes_.length, this.argTypes_.length);
        int num_matches = 0;
        for (i = 0; i < minArgs; ++i) {
            if (o.argTypes_[i].isNull() || this.argTypes_[i].isNull()) continue;
            if (!o.argTypes_[i].matchesType(this.argTypes_[i])) {
                return -1;
            }
            ++num_matches;
        }
        if (o.argTypes_.length == this.argTypes_.length) {
            return num_matches;
        }
        if (o.hasVarArgs_ && this.hasVarArgs_) {
            if (!o.getVarArgsType().matchesType(this.getVarArgsType())) {
                return -1;
            }
            if (this.getNumArgs() > o.getNumArgs()) {
                for (i = minArgs; i < this.getNumArgs(); ++i) {
                    if (this.argTypes_[i].isNull()) continue;
                    if (!this.argTypes_[i].matchesType(o.getVarArgsType())) {
                        return -1;
                    }
                    ++num_matches;
                }
            } else {
                for (i = minArgs; i < o.getNumArgs(); ++i) {
                    if (o.argTypes_[i].isNull()) continue;
                    if (!o.argTypes_[i].matchesType(this.getVarArgsType())) {
                        return -1;
                    }
                    ++num_matches;
                }
            }
            return num_matches;
        }
        if (o.hasVarArgs_) {
            if (o.getNumArgs() > minArgs) {
                return -1;
            }
            for (i = minArgs; i < this.getNumArgs(); ++i) {
                if (this.argTypes_[i].isNull()) continue;
                if (!this.argTypes_[i].matchesType(o.getVarArgsType())) {
                    return -1;
                }
                ++num_matches;
            }
            return num_matches;
        }
        if (this.hasVarArgs_) {
            if (this.getNumArgs() > minArgs) {
                return -1;
            }
            for (i = minArgs; i < o.getNumArgs(); ++i) {
                if (o.argTypes_[i].isNull()) continue;
                if (!o.argTypes_[i].matchesType(this.getVarArgsType())) {
                    return -1;
                }
                ++num_matches;
            }
            return num_matches;
        }
        return -1;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.FUNCTION;
    }

    @Override
    public String getName() {
        return this.getFunctionName().toString();
    }

    public String toSql(boolean ifNotExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setFn(this.toThrift());
    }

    public TFunction toThrift() {
        TFunction fn = new TFunction();
        fn.setSignature(this.signatureString());
        fn.setName(this.name_.toThrift());
        fn.setBinary_type(this.binaryType_);
        if (this.location_ != null) {
            fn.setHdfs_location(this.location_.toString());
        }
        fn.setArg_types(Type.toThrift(this.argTypes_));
        fn.setRet_type(this.getReturnType().toThrift());
        fn.setHas_var_args(this.hasVarArgs_);
        fn.setIs_persistent(this.isPersistent_);
        return fn;
    }

    public static Function fromThrift(TFunction fn) {
        Preconditions.checkArgument((boolean)fn.isSetBinary_type());
        Preconditions.checkArgument((boolean)fn.isSetArg_types());
        Preconditions.checkArgument((boolean)fn.isSetRet_type());
        Preconditions.checkArgument((boolean)fn.isSetHas_var_args());
        ArrayList<Type> argTypes = new ArrayList<Type>();
        for (TColumnType t : fn.getArg_types()) {
            argTypes.add(Type.fromThrift(t));
        }
        Function function = null;
        if (fn.isSetScalar_fn()) {
            TScalarFunction scalarFn = fn.getScalar_fn();
            function = new ScalarFunction(FunctionName.fromThrift(fn.getName()), argTypes, Type.fromThrift(fn.getRet_type()), new HdfsUri(fn.getHdfs_location()), scalarFn.getSymbol(), scalarFn.getPrepare_fn_symbol(), scalarFn.getClose_fn_symbol());
        } else if (fn.isSetAggregate_fn()) {
            TAggregateFunction aggFn = fn.getAggregate_fn();
            function = new AggregateFunction(FunctionName.fromThrift(fn.getName()), argTypes, Type.fromThrift(fn.getRet_type()), Type.fromThrift(aggFn.getIntermediate_type()), new HdfsUri(fn.getHdfs_location()), aggFn.getUpdate_fn_symbol(), aggFn.getInit_fn_symbol(), aggFn.getSerialize_fn_symbol(), aggFn.getMerge_fn_symbol(), aggFn.getGet_value_fn_symbol(), null, aggFn.getFinalize_fn_symbol());
        } else {
            function = new Function(FunctionName.fromThrift(fn.getName()), argTypes, Type.fromThrift(fn.getRet_type()), fn.isHas_var_args());
        }
        function.setBinaryType(fn.getBinary_type());
        function.setHasVarArgs(fn.isHas_var_args());
        if (fn.isSetIs_persistent()) {
            function.setIsPersistent(fn.isIs_persistent());
        } else {
            function.setIsPersistent(false);
        }
        return function;
    }

    protected final TSymbolLookupParams buildLookupParams(String symbol, TSymbolType symbolType, Type retArgType, boolean hasVarArgs, boolean needsRefresh, Type ... argTypes) {
        TSymbolLookupParams lookup = new TSymbolLookupParams();
        lookup.location = this.binaryType_ != TFunctionBinaryType.BUILTIN ? this.location_.toString() : "";
        lookup.symbol = symbol;
        lookup.symbol_type = symbolType;
        lookup.fn_binary_type = this.binaryType_;
        lookup.arg_types = Type.toThrift(argTypes);
        lookup.has_var_args = hasVarArgs;
        lookup.needs_refresh = needsRefresh;
        if (retArgType != null) {
            lookup.setRet_arg_type(retArgType.toThrift());
        }
        return lookup;
    }

    protected TSymbolLookupParams getLookupParams() {
        throw new NotImplementedException("getLookupParams not implemented for " + this.getClass().getSimpleName());
    }

    public final long getLastModifiedTime() {
        if (!this.isBuiltinOrJava()) {
            TSymbolLookupParams lookup = (TSymbolLookupParams)Preconditions.checkNotNull((Object)this.getLookupParams());
            try {
                TSymbolLookupResult result = FeSupport.LookupSymbol(lookup);
                return result.last_modified_time;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to get last modified time for lib file: " + this.getLocation().toString(), e);
            }
        }
        return -1L;
    }

    private boolean isBuiltinOrJava() {
        return this.getBinaryType() == TFunctionBinaryType.BUILTIN || this.getBinaryType() == TFunctionBinaryType.JAVA && (this.getLocation() == null || this.getLocation().toString().isEmpty());
    }

    public String lookupSymbol(String symbol, TSymbolType symbolType, Type retArgType, boolean hasVarArgs, Type ... argTypes) throws AnalysisException {
        if (symbol.length() == 0) {
            if (this.binaryType_ == TFunctionBinaryType.BUILTIN) {
                return symbol;
            }
            throw new AnalysisException("Could not find symbol ''");
        }
        TSymbolLookupParams lookup = this.buildLookupParams(symbol, symbolType, retArgType, hasVarArgs, true, argTypes);
        try {
            TSymbolLookupResult result = FeSupport.LookupSymbol(lookup);
            switch (result.result_code) {
                case SYMBOL_FOUND: {
                    return result.symbol;
                }
                case BINARY_NOT_FOUND: {
                    Preconditions.checkState((this.binaryType_ != TFunctionBinaryType.BUILTIN ? 1 : 0) != 0);
                    throw new AnalysisException("Could not load binary: " + this.location_.getLocation() + "\n" + result.error_msg);
                }
                case SYMBOL_NOT_FOUND: {
                    throw new AnalysisException(result.error_msg);
                }
            }
            throw new AnalysisException("Internal Error");
        }
        catch (InternalException e) {
            e.printStackTrace();
            throw new AnalysisException("Could not find symbol: " + symbol, e);
        }
    }

    public String lookupSymbol(String symbol, TSymbolType symbolType) throws AnalysisException {
        Preconditions.checkState((symbolType == TSymbolType.UDF_PREPARE || symbolType == TSymbolType.UDF_CLOSE ? 1 : 0) != 0);
        return this.lookupSymbol(symbol, symbolType, null, false, new Type[0]);
    }

    public static String getUdfType(Type t) {
        switch (t.getPrimitiveType()) {
            case BOOLEAN: {
                return "BooleanVal";
            }
            case TINYINT: {
                return "TinyIntVal";
            }
            case SMALLINT: {
                return "SmallIntVal";
            }
            case INT: {
                return "IntVal";
            }
            case BIGINT: {
                return "BigIntVal";
            }
            case FLOAT: {
                return "FloatVal";
            }
            case DOUBLE: {
                return "DoubleVal";
            }
            case DATE: {
                return "DateVal";
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case FIXED_UDA_INTERMEDIATE: 
            case BINARY: {
                return "StringVal";
            }
            case TIMESTAMP: {
                return "TimestampVal";
            }
            case DECIMAL: {
                return "DecimalVal";
            }
        }
        Preconditions.checkState((boolean)false, (Object)t.toString());
        return "";
    }

    public static boolean categoryMatch(Function fn, TFunctionCategory category) {
        Preconditions.checkNotNull((Object)((Object)category));
        return category == TFunctionCategory.SCALAR && fn instanceof ScalarFunction || category == TFunctionCategory.AGGREGATE && fn instanceof AggregateFunction && ((AggregateFunction)fn).isAggregateFn() || category == TFunctionCategory.ANALYTIC && fn instanceof AggregateFunction && ((AggregateFunction)fn).isAnalyticFn();
    }

    public static enum CompareMode {
        IS_IDENTICAL,
        IS_INDISTINGUISHABLE,
        IS_SUPERTYPE_OF,
        IS_NONSTRICT_SUPERTYPE_OF;

    }
}

