/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableStats;

public interface FeTable {
    public static final Comparator<FeTable> NAME_COMPARATOR = new Comparator<FeTable>(){

        @Override
        public int compare(FeTable t1, FeTable t2) {
            return t1.getFullName().compareTo(t2.getFullName());
        }
    };
    public static final String NUM_ROWS = "numRows";
    public static final String LAST_MODIFIED_BY = "last_modified_by";
    public static final String LAST_MODIFIED_TIME = "last_modified_time";
    public static final String CATALOG_SERVICE_ID = "impala.events.catalogServiceId";
    public static final String CATALOG_VERSION = "impala.events.catalogVersion";

    public boolean isLoaded();

    public Table getMetaStoreTable();

    public String getStorageHandlerClassName();

    public TCatalogObjectType getCatalogObjectType();

    public String getName();

    public String getFullName();

    public TableName getTableName();

    public TImpalaTableType getTableType();

    public String getTableComment();

    public List<Column> getColumns();

    default public List<VirtualColumn> getVirtualColumns() {
        return Collections.emptyList();
    }

    public List<Column> getColumnsInHiveOrder();

    public List<String> getColumnNames();

    public SqlConstraints getSqlConstraints();

    public List<Column> getClusteringColumns();

    public List<Column> getNonClusteringColumns();

    public int getNumClusteringCols();

    public boolean isClusteringColumn(Column var1);

    default public boolean isComputedPartitionColumn(Column c) {
        return false;
    }

    public Column getColumn(String var1);

    public ArrayType getType();

    public FeDb getDb();

    public long getNumRows();

    public TTableStats getTTableStats();

    public TTableDescriptor toThriftDescriptor(int var1, Set<Long> var2);

    public long getWriteId();

    public ValidWriteIdList getValidWriteIds();

    public String getOwnerUser();
}

