/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.PartitionSchema;

public interface FeKuduTable
extends FeTable {
    public String getKuduMasterHosts();

    public String getKuduTableName();

    public boolean isPrimaryKeyUnique();

    public boolean hasAutoIncrementingColumn();

    public List<String> getPrimaryKeyColumnNames();

    public List<KuduPartitionParam> getPartitionBy();

    public static abstract class Utils {
        private static KuduPartitionParam getRangePartitioning(FeKuduTable table) {
            for (KuduPartitionParam partitionParam : table.getPartitionBy()) {
                if (partitionParam.getType() != KuduPartitionParam.Type.RANGE) continue;
                return partitionParam;
            }
            return null;
        }

        public static List<String> getRangePartitioningColNames(FeKuduTable table) {
            KuduPartitionParam rangePartitioning = Utils.getRangePartitioning(table);
            if (rangePartitioning == null) {
                return Collections.emptyList();
            }
            return rangePartitioning.getColumnNames();
        }

        public static List<KuduPartitionParam> loadPartitionByParams(KuduTable kuduTable) {
            int colId;
            Iterator iterator;
            ArrayList<String> columnNames;
            ArrayList<KuduPartitionParam> ret = new ArrayList<KuduPartitionParam>();
            Preconditions.checkNotNull((Object)kuduTable);
            Schema tableSchema = kuduTable.getSchema();
            PartitionSchema partitionSchema = kuduTable.getPartitionSchema();
            for (PartitionSchema.HashBucketSchema hashBucketSchema : partitionSchema.getHashBucketSchemas()) {
                columnNames = new ArrayList<String>();
                iterator = hashBucketSchema.getColumnIds().iterator();
                while (iterator.hasNext()) {
                    colId = (Integer)iterator.next();
                    columnNames.add(Utils.getColumnNameById(tableSchema, colId));
                }
                ret.add(KuduPartitionParam.createHashParam(columnNames, hashBucketSchema.getNumBuckets()));
            }
            PartitionSchema.RangeSchema rangeSchema = partitionSchema.getRangeSchema();
            List columnIds = rangeSchema.getColumns();
            if (columnIds.isEmpty()) {
                return ret;
            }
            columnNames = new ArrayList();
            iterator = columnIds.iterator();
            while (iterator.hasNext()) {
                colId = (Integer)iterator.next();
                columnNames.add(Utils.getColumnNameById(tableSchema, colId));
            }
            ret.add(KuduPartitionParam.createRangeParam(columnNames, null));
            return ret;
        }

        public static TResultSet getTableStats(FeKuduTable table) throws ImpalaRuntimeException {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            result.setSchema(resultSchema);
            resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
            resultSchema.addToColumns(new TColumn("#Partitions", Type.BIGINT.toThrift()));
            resultSchema.addToColumns(new TColumn("Size", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Format", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Location", Type.STRING.toThrift()));
            KuduClient client = KuduUtil.getKuduClient(table.getKuduMasterHosts());
            try {
                KuduTable kuduTable = client.openTable(table.getKuduTableName());
                List tablets = kuduTable.getTabletsLocations((long)BackendConfig.INSTANCE.getKuduClientTimeoutMs());
                TResultRowBuilder tResultRowBuilder = new TResultRowBuilder();
                tResultRowBuilder.add(table.getNumRows());
                tResultRowBuilder.add(tablets.size());
                tResultRowBuilder.addBytes(kuduTable.getTableStatistics().getOnDiskSize());
                tResultRowBuilder.add("KUDU");
                tResultRowBuilder.add(table.getKuduMasterHosts());
                result.addToRows(tResultRowBuilder.get());
            }
            catch (Exception e) {
                throw new ImpalaRuntimeException("Error accessing Kudu for table stats.", e);
            }
            return result;
        }

        public static TResultSet getPartitions(FeKuduTable table) throws ImpalaRuntimeException {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            result.setSchema(resultSchema);
            resultSchema.addToColumns(new TColumn("Start Key", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Stop Key", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Leader Replica", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("#Replicas", Type.INT.toThrift()));
            KuduClient client = KuduUtil.getKuduClient(table.getKuduMasterHosts());
            try {
                KuduTable kuduTable = client.openTable(table.getKuduTableName());
                List tablets = kuduTable.getTabletsLocations((long)BackendConfig.INSTANCE.getKuduClientTimeoutMs());
                if (tablets.isEmpty()) {
                    TResultRowBuilder builder = new TResultRowBuilder();
                    result.addToRows(builder.add("N/A").add("N/A").add("N/A").add("-1").get());
                    return result;
                }
                for (LocatedTablet tab : tablets) {
                    TResultRowBuilder builder = new TResultRowBuilder();
                    builder.add(DatatypeConverter.printHexBinary((byte[])tab.getPartition().getPartitionKeyStart()));
                    builder.add(DatatypeConverter.printHexBinary((byte[])tab.getPartition().getPartitionKeyEnd()));
                    LocatedTablet.Replica leader = tab.getLeaderReplica();
                    if (leader == null) {
                        builder.add("Leader N/A");
                    } else {
                        builder.add(leader.getRpcHost() + ":" + leader.getRpcPort().toString());
                    }
                    builder.add(tab.getReplicas().size());
                    result.addToRows(builder.get());
                }
            }
            catch (Exception e) {
                throw new ImpalaRuntimeException("Error accessing Kudu for table partitions.", e);
            }
            return result;
        }

        public static TResultSet getRangePartitions(FeKuduTable table, boolean showHashSchema) throws ImpalaRuntimeException {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            result.setSchema(resultSchema);
            String header = "RANGE (" + Joiner.on((char)',').join(Utils.getRangePartitioningColNames(table)) + ")";
            if (showHashSchema) {
                header = header + " HASH SCHEMA";
            }
            resultSchema.addToColumns(new TColumn(header, Type.STRING.toThrift()));
            KuduClient client = KuduUtil.getKuduClient(table.getKuduMasterHosts());
            try {
                List partitions;
                KuduTable kuduTable = client.openTable(table.getKuduTableName());
                long timeout = BackendConfig.INSTANCE.getKuduClientTimeoutMs();
                List list = partitions = showHashSchema ? kuduTable.getFormattedRangePartitionsWithHashSchema(timeout) : kuduTable.getFormattedRangePartitions(timeout);
                if (partitions.isEmpty()) {
                    TResultRowBuilder builder = new TResultRowBuilder();
                    result.addToRows(builder.add("").get());
                    return result;
                }
                for (String partition : partitions) {
                    TResultRowBuilder builder = new TResultRowBuilder();
                    builder.add(partition);
                    result.addToRows(builder.get());
                }
            }
            catch (Exception e) {
                throw new ImpalaRuntimeException("Error accessing Kudu for table partitions.", e);
            }
            return result;
        }

        private static String getColumnNameById(Schema tableSchema, int colId) {
            Preconditions.checkNotNull((Object)tableSchema);
            ColumnSchema col = tableSchema.getColumnByIndex(tableSchema.getColumnIndex(colId));
            Preconditions.checkNotNull((Object)col);
            return col.getName();
        }
    }
}

