/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.PartitionKeyValue;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.TAccessLevelUtil;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FeFsTable
extends FeTable {
    public static final String DEFAULT_NULL_COLUMN_VALUE = "\\N";
    public static final Configuration CONF = new Configuration();
    public static final String NUM_FILES = "numFiles";
    public static final String TOTAL_SIZE = "totalSize";
    public static final String NUM_ERASURE_CODED_FILES = "numFilesErasureCoded";

    public boolean isCacheable();

    public boolean isLocationCacheable();

    public boolean isMarkedCached();

    public String getLocation();

    public String getNullPartitionKeyValue();

    public String getHdfsBaseDir();

    public FileSystemUtil.FsType getFsType();

    public long getTotalHdfsBytes();

    public boolean usesAvroSchemaOverride();

    public Set<HdfsFileFormat> getFileFormats();

    public boolean hasWriteAccessToBaseDir();

    public String getFirstLocationWithoutWriteAccess();

    public TResultSet getTableStats();

    public Collection<? extends PrunablePartition> getPartitions();

    public Set<Long> getPartitionIds();

    public Map<Long, ? extends PrunablePartition> getPartitionMap();

    public TreeMap<LiteralExpr, Set<Long>> getPartitionValueMap(int var1);

    public Set<Long> getNullPartitionIds(int var1);

    public List<? extends FeFsPartition> loadPartitions(Collection<Long> var1);

    @Override
    public SqlConstraints getSqlConstraints();

    default public FileSystem getFileSystem() throws CatalogException {
        FileSystem tableFs;
        try {
            tableFs = new Path(this.getLocation()).getFileSystem(CONF);
        }
        catch (IOException e) {
            throw new CatalogException("Invalid table path for table: " + this.getFullName(), e);
        }
        return tableFs;
    }

    public static FileSystem getFileSystem(Path filePath) throws CatalogException {
        FileSystem tableFs;
        try {
            tableFs = filePath.getFileSystem(CONF);
        }
        catch (IOException e) {
            throw new CatalogException("Invalid path: " + filePath.toString(), e);
        }
        return tableFs;
    }

    default public List<String> getPrimaryKeyColumnNames() throws TException {
        ArrayList<String> primaryKeyColNames = new ArrayList<String>();
        List<SQLPrimaryKey> primaryKeys = this.getSqlConstraints().getPrimaryKeys();
        if (!primaryKeys.isEmpty()) {
            primaryKeys.stream().forEach(p -> primaryKeyColNames.add(p.getColumn_name()));
        }
        return primaryKeyColNames;
    }

    default public boolean isPartitioned() {
        return this.getMetaStoreTable().getPartitionKeysSize() > 0;
    }

    default public List<String> getForeignKeysSql() throws TException {
        ArrayList<String> foreignKeysSql = new ArrayList<String>();
        List<SQLForeignKey> foreignKeys = this.getSqlConstraints().getForeignKeys();
        for (int i = 0; i < foreignKeys.size(); ++i) {
            String pkTableDb = foreignKeys.get(i).getPktable_db();
            String pkTableName = foreignKeys.get(i).getPktable_name();
            ArrayList<String> pkList = new ArrayList<String>();
            ArrayList<String> fkList = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            while (i < foreignKeys.size()) {
                fkList.add(foreignKeys.get(i).getFkcolumn_name());
                pkList.add(foreignKeys.get(i).getPkcolumn_name());
                if (i + 1 < foreignKeys.size() && foreignKeys.get(i + 1).getKey_seq() == 1) break;
                ++i;
            }
            Joiner.on((String)", ").appendTo(sb, fkList).append(") ");
            sb.append("REFERENCES ");
            if (pkTableDb != null) {
                sb.append(pkTableDb + ".");
            }
            sb.append(pkTableName + "(");
            Joiner.on((String)", ").appendTo(sb, pkList).append(")");
            foreignKeysSql.add(sb.toString());
        }
        return foreignKeysSql;
    }

    default public int parseSkipHeaderLineCount(StringBuilder error) {
        Table msTbl = this.getMetaStoreTable();
        if (msTbl == null || !msTbl.getParameters().containsKey("skip.header.line.count")) {
            return 0;
        }
        return Utils.parseSkipHeaderLineCount(msTbl.getParameters(), error);
    }

    public ListMap<TNetworkAddress> getHostIndex();

    default public int getSortByColumnIndex(String col_name) {
        Map parameters = this.getMetaStoreTable().getParameters();
        if (parameters == null) {
            return -1;
        }
        String sort_by_columns_string = (String)parameters.get("sort.columns");
        if (sort_by_columns_string == null) {
            return -1;
        }
        String[] sort_by_columns = sort_by_columns_string.split(",");
        if (sort_by_columns == null) {
            return -1;
        }
        for (int i = 0; i < sort_by_columns.length; ++i) {
            if (!sort_by_columns[i].equals(col_name)) continue;
            return i;
        }
        return -1;
    }

    default public boolean isLeadingSortByColumn(String col_name) {
        return this.getSortByColumnIndex(col_name) == 0;
    }

    default public boolean isSortByColumn(String col_name) {
        return this.getSortByColumnIndex(col_name) >= 0;
    }

    default public TSortingOrder getSortOrderForSortByColumn() {
        Map parameters = this.getMetaStoreTable().getParameters();
        if (parameters == null) {
            return null;
        }
        String sortOrder = (String)parameters.get("sort.order");
        if (sortOrder == null) {
            return null;
        }
        if (sortOrder.equals("LEXICAL")) {
            return TSortingOrder.LEXICAL;
        }
        if (sortOrder.equals("ZORDER")) {
            return TSortingOrder.ZORDER;
        }
        return null;
    }

    default public boolean IsLexicalSortByColumn() {
        TSortingOrder sortOrder = this.getSortOrderForSortByColumn();
        if (sortOrder == null) {
            return false;
        }
        return sortOrder == TSortingOrder.LEXICAL;
    }

    public static abstract class Utils {
        private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
        public static final String TBL_PROP_SKIP_HEADER_LINE_COUNT = "skip.header.line.count";

        public static boolean isStatsExtrapolationEnabled(FeFsTable table) {
            Table msTbl = table.getMetaStoreTable();
            String propVal = (String)msTbl.getParameters().get("impala.enable.stats.extrapolation");
            if (propVal == null) {
                return BackendConfig.INSTANCE.isStatsExtrapolationEnabled();
            }
            return Boolean.parseBoolean(propVal);
        }

        public static boolean shouldRecursivelyListPartitions(FeFsTable table) {
            Table msTbl = table.getMetaStoreTable();
            String propVal = (String)msTbl.getParameters().get("impala.disable.recursive.listing");
            if (propVal == null) {
                return BackendConfig.INSTANCE.recursivelyListPartitions();
            }
            return !Boolean.parseBoolean(propVal);
        }

        public static long getExtrapolatedNumRows(FeFsTable table, long fileBytes) {
            if (!Utils.isStatsExtrapolationEnabled(table)) {
                return -1L;
            }
            if (fileBytes == 0L) {
                return 0L;
            }
            if (fileBytes < 0L) {
                return -1L;
            }
            TTableStats tableStats = table.getTTableStats();
            if (tableStats.num_rows < 0L || tableStats.total_file_bytes <= 0L) {
                return -1L;
            }
            if (tableStats.num_rows == 0L && tableStats.total_file_bytes != 0L) {
                return -1L;
            }
            double rowsPerByte = (double)tableStats.num_rows / (double)tableStats.total_file_bytes;
            double extrapolatedNumRows = (double)fileBytes * rowsPerByte;
            return Math.max(1L, Math.round(extrapolatedNumRows));
        }

        public static TResultSet getFiles(FeFsTable table, List<List<TPartitionKeyValue>> partitionSet) {
            TResultSet result = new TResultSet();
            TResultSetMetadata resultSchema = new TResultSetMetadata();
            result.setSchema(resultSchema);
            resultSchema.addToColumns(new TColumn("Path", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Size", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Partition", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("EC Policy", Type.STRING.toThrift()));
            result.setRows(new ArrayList<TResultRow>());
            if (table instanceof FeIcebergTable) {
                return FeIcebergTable.Utils.getIcebergTableFiles((FeIcebergTable)table, result);
            }
            List<Object> orderedPartitions = partitionSet == null ? Lists.newArrayList(FeCatalogUtils.loadAllPartitions(table)) : Utils.getPartitionsFromPartitionSet(table, partitionSet);
            Collections.sort(orderedPartitions, HdfsPartition.KV_COMPARATOR);
            for (FeFsPartition feFsPartition : orderedPartitions) {
                ArrayList orderedFds = Lists.newArrayList(feFsPartition.getFileDescriptors());
                Collections.sort(orderedFds);
                for (HdfsPartition.FileDescriptor fd : orderedFds) {
                    TResultRowBuilder rowBuilder = new TResultRowBuilder();
                    String absPath = fd.getAbsolutePath(feFsPartition.getLocation());
                    rowBuilder.add(absPath);
                    rowBuilder.add(PrintUtils.printBytes(fd.getFileLength()));
                    rowBuilder.add(feFsPartition.getPartitionName());
                    rowBuilder.add(FileSystemUtil.getErasureCodingPolicy(new Path(absPath)));
                    result.addToRows(rowBuilder.get());
                }
            }
            return result;
        }

        public static Map<Long, List<HdfsPartition.FileDescriptor>> getFilesSample(FeFsTable table, Collection<? extends FeFsPartition> inputParts, long percentBytes, long minSampleBytes, long randomSeed) {
            HdfsPartition.FileDescriptor fd;
            Preconditions.checkState((percentBytes >= 0L && percentBytes <= 100L ? 1 : 0) != 0);
            Preconditions.checkState((minSampleBytes >= 0L ? 1 : 0) != 0);
            long totalNumFiles = 0L;
            for (FeFsPartition feFsPartition : inputParts) {
                totalNumFiles += (long)feFsPartition.getNumFileDescriptors();
            }
            long JVM_MAX_ARRAY_SIZE = 0x7FFFFFF5L;
            if (totalNumFiles > 0x7FFFFFF5L) {
                throw new IllegalStateException(String.format("Too many files to generate a table sample of table %s. Sample requested over %s files, but a maximum of %s files are supported.", table.getTableName().toString(), totalNumFiles, 0x7FFFFFF5L));
            }
            ArrayList orderedParts = Lists.newArrayList(inputParts);
            Collections.sort(orderedParts, HdfsPartition.KV_COMPARATOR);
            int[] fileIdxs = new int[(int)totalNumFiles];
            FeFsPartition[] parts = new FeFsPartition[(int)totalNumFiles];
            int idx = 0;
            long totalBytes = 0L;
            for (FeFsPartition part : orderedParts) {
                totalBytes += part.getSize();
                int numFds = part.getNumFileDescriptors();
                int fileIdx = 0;
                while (fileIdx < numFds) {
                    fileIdxs[idx] = fileIdx++;
                    parts[idx] = part;
                    ++idx;
                }
            }
            if ((long)idx != totalNumFiles) {
                throw new AssertionError((Object)"partition file counts changed during iteration");
            }
            int numFilesRemaining = idx;
            double fracPercentBytes = (double)percentBytes / 100.0;
            long targetBytes = Math.round((double)totalBytes * fracPercentBytes);
            targetBytes = Math.max(targetBytes, minSampleBytes);
            Random rnd = new Random(randomSeed);
            HashMap<Long, List<HdfsPartition.FileDescriptor>> result = new HashMap<Long, List<HdfsPartition.FileDescriptor>>();
            for (long selectedBytes = 0L; selectedBytes < targetBytes && numFilesRemaining > 0; selectedBytes += fd.getFileLength(), --numFilesRemaining) {
                int selectedIdx = Math.abs(rnd.nextInt()) % numFilesRemaining;
                FeFsPartition part = parts[selectedIdx];
                Long partId = part.getId();
                List sampleFileIdxs = result.computeIfAbsent(partId, id -> Lists.newArrayList());
                fd = part.getFileDescriptors().get(fileIdxs[selectedIdx]);
                sampleFileIdxs.add(fd);
                fileIdxs[selectedIdx] = fileIdxs[numFilesRemaining - 1];
                parts[selectedIdx] = parts[numFilesRemaining - 1];
            }
            return result;
        }

        public static List<? extends FeFsPartition> getPartitionsFromPartitionSet(FeFsTable table, List<List<TPartitionKeyValue>> partitionSet) {
            ArrayList<Long> partitionIds = new ArrayList<Long>();
            for (List<TPartitionKeyValue> kv : partitionSet) {
                PrunablePartition partition = Utils.getPartitionFromThriftPartitionSpec(table, kv);
                if (partition == null) continue;
                partitionIds.add(partition.getId());
            }
            return table.loadPartitions(partitionIds);
        }

        public static PrunablePartition getPartitionFromThriftPartitionSpec(FeFsTable table, List<TPartitionKeyValue> partitionSpec) {
            ArrayList<String> targetValues = new ArrayList<String>();
            HashSet<String> keys = new HashSet<String>();
            for (FieldSchema fieldSchema : table.getMetaStoreTable().getPartitionKeys()) {
                for (TPartitionKeyValue kv : partitionSpec) {
                    if (!fieldSchema.getName().equalsIgnoreCase(kv.getName())) continue;
                    targetValues.add(kv.getValue());
                    if (keys.add(kv.getName().toLowerCase())) continue;
                    return null;
                }
            }
            if (targetValues.size() == 0 || targetValues.size() != table.getMetaStoreTable().getPartitionKeysSize()) {
                return null;
            }
            for (PrunablePartition prunablePartition : table.getPartitions()) {
                List<LiteralExpr> partitionValues = prunablePartition.getPartitionValues();
                Preconditions.checkState((partitionValues.size() == targetValues.size() ? 1 : 0) != 0, (String)"Partition values not match in table %s: %s != %s", (Object)table.getFullName(), (Object)partitionValues.size(), (Object)targetValues.size());
                boolean matchFound = true;
                for (int i = 0; i < targetValues.size(); ++i) {
                    String value;
                    if (Expr.IS_NULL_LITERAL.apply((Object)partitionValues.get(i))) {
                        value = table.getNullPartitionKeyValue();
                    } else {
                        value = partitionValues.get(i).getStringValue();
                        Preconditions.checkNotNull((Object)value, (String)"Got null string from non-null partition value of table %s: i=%s", (Object)table.getFullName(), (int)i);
                        if (value.isEmpty()) {
                            value = table.getNullPartitionKeyValue();
                        }
                    }
                    if (((String)targetValues.get(i)).equals(value)) continue;
                    matchFound = false;
                    break;
                }
                if (!matchFound) continue;
                return prunablePartition;
            }
            return null;
        }

        public static void checkWriteAccess(FeFsTable table, List<PartitionKeyValue> partitionKeyValues, String operationType) throws AnalysisException {
            String noWriteAccessErrorMsg = String.format("Unable to %s into target table (%s) because Impala does not have WRITE access to HDFS location: ", operationType, table.getFullName());
            PrunablePartition existingTargetPartition = null;
            if (partitionKeyValues != null) {
                existingTargetPartition = HdfsTable.getPartition(table, partitionKeyValues);
            }
            if (existingTargetPartition != null) {
                FeFsPartition partition = FeCatalogUtils.loadPartition(table, existingTargetPartition.getId());
                String location = partition.getLocation();
                if (!TAccessLevelUtil.impliesWriteAccess(partition.getAccessLevel())) {
                    throw new AnalysisException(noWriteAccessErrorMsg + location);
                }
            } else if (partitionKeyValues != null) {
                if (!table.hasWriteAccessToBaseDir()) {
                    throw new AnalysisException(noWriteAccessErrorMsg + table.getHdfsBaseDir());
                }
            } else {
                String badPath = table.getFirstLocationWithoutWriteAccess();
                if (badPath != null) {
                    throw new AnalysisException(noWriteAccessErrorMsg + badPath);
                }
            }
        }

        public static int parseSkipHeaderLineCount(Map<String, String> tblProperties, StringBuilder error) {
            Preconditions.checkState((tblProperties != null ? 1 : 0) != 0);
            Preconditions.checkState((boolean)tblProperties.containsKey(TBL_PROP_SKIP_HEADER_LINE_COUNT));
            String string_value = tblProperties.get(TBL_PROP_SKIP_HEADER_LINE_COUNT);
            int skipHeaderLineCount = 0;
            String error_msg = String.format("Invalid value for table property %s: %s (value must be an integer >= 0)", TBL_PROP_SKIP_HEADER_LINE_COUNT, string_value);
            try {
                skipHeaderLineCount = Integer.parseInt(string_value);
            }
            catch (NumberFormatException exc) {
                error.append(error_msg);
            }
            if (skipHeaderLineCount < 0) {
                error.append(error_msg);
            }
            return skipHeaderLineCount;
        }
    }
}

