/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.THdfsPartitionLocation;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.util.ListMap;

public interface FeFsPartition {
    public String getPartitionName();

    public long getId();

    public FeFsTable getTable();

    public ListMap<TNetworkAddress> getHostIndex();

    public FileSystemUtil.FsType getFsType();

    public List<HdfsPartition.FileDescriptor> getFileDescriptors();

    public List<HdfsPartition.FileDescriptor> getInsertFileDescriptors();

    public List<HdfsPartition.FileDescriptor> getDeleteFileDescriptors();

    public boolean hasFileDescriptors();

    public int getNumFileDescriptors();

    public String getLocation();

    public THdfsPartitionLocation getLocationAsThrift();

    public Path getLocationPath();

    default public FileSystem getFileSystem(Configuration conf) throws IOException {
        return this.getLocationPath().getFileSystem(conf);
    }

    public TAccessLevel getAccessLevel();

    public boolean isCacheable();

    public boolean isMarkedCached();

    public HdfsStorageDescriptor getInputFormatDescriptor();

    public HdfsFileFormat getFileFormat();

    @Nullable
    public TPartitionStats getPartitionStats();

    public boolean hasIncrementalStats();

    public byte[] getPartitionStatsCompressed();

    public long getSize();

    public long getNumRows();

    public String getConjunctSql();

    public List<String> getPartitionValuesAsStrings(boolean var1);

    public List<LiteralExpr> getPartitionValues();

    public LiteralExpr getPartitionValue(int var1);

    public Map<String, String> getParameters();

    public long getWriteId();

    public FeFsPartition genInsertDeltaPartition();

    public FeFsPartition genDeleteDeltaPartition();
}

