/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.FeDataSource;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TGetPartitionStatsResponse;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.util.PatternMatcher;

public interface FeCatalog {
    public List<? extends FeDb> getDbs(PatternMatcher var1);

    public List<String> getTableNames(String var1, PatternMatcher var2) throws DatabaseNotFoundException;

    public List<String> getTableNames(String var1, PatternMatcher var2, Set<TImpalaTableType> var3) throws DatabaseNotFoundException;

    public FeTable getTable(String var1, String var2) throws DatabaseNotFoundException;

    public FeTable getTableNoThrow(String var1, String var2);

    public FeTable getTableIfCached(String var1, String var2) throws DatabaseNotFoundException;

    public FeTable getTableIfCachedNoThrow(String var1, String var2);

    public TCatalogObject getTCatalogObject(TCatalogObject var1) throws CatalogException;

    public FeDb getDb(String var1);

    public FeFsPartition getHdfsPartition(String var1, String var2, List<TPartitionKeyValue> var3) throws CatalogException;

    public List<? extends FeDataSource> getDataSources(PatternMatcher var1);

    public FeDataSource getDataSource(String var1);

    public Function getFunction(Function var1, Function.CompareMode var2);

    public HdfsCachePool getHdfsCachePool(String var1);

    public void prioritizeLoad(Set<TableName> var1, @Nullable TUniqueId var2) throws InternalException;

    public TGetPartitionStatsResponse getPartitionStats(TableName var1) throws InternalException;

    public void waitForCatalogUpdate(long var1);

    public TUniqueId getCatalogServiceId();

    public AuthorizationPolicy getAuthPolicy();

    public String getDefaultKuduMasterHosts();

    public boolean isReady();

    public void setIsReady(boolean var1);
}

