/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.MoreObjects;
import org.apache.impala.catalog.CatalogObjectImpl;
import org.apache.impala.catalog.FeDataSource;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TDataSource;

public class DataSource
extends CatalogObjectImpl
implements FeDataSource {
    private final String dataSrcName_;
    private final String className_;
    private final String apiVersionString_;
    private final String location_;

    public DataSource(String dataSrcName, String location, String className, String apiVersionString) {
        this.dataSrcName_ = dataSrcName;
        this.location_ = location;
        this.className_ = className;
        this.apiVersionString_ = apiVersionString;
    }

    public static DataSource fromThrift(TDataSource thrift) {
        return new DataSource(thrift.getName(), thrift.getHdfs_location(), thrift.getClass_name(), thrift.getApi_version());
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.DATA_SOURCE;
    }

    @Override
    public String getName() {
        return this.dataSrcName_;
    }

    @Override
    public String getLocation() {
        return this.location_;
    }

    @Override
    public String getClassName() {
        return this.className_;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersionString_;
    }

    public TDataSource toThrift() {
        return new TDataSource(this.getName(), this.location_, this.className_, this.apiVersionString_);
    }

    public String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.dataSrcName_).add("location", (Object)this.location_).add("className", (Object)this.className_).add("apiVersion", (Object)this.apiVersionString_).toString();
    }

    public static String debugString(TDataSource thrift) {
        return DataSource.fromThrift(thrift).debugString();
    }

    @Override
    protected void setTCatalogObject(TCatalogObject catalogObject) {
        catalogObject.setData_source(this.toThrift());
    }
}

