/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnStats;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.thrift.TBaseHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStats {
    private static final Set<PrimitiveType> SUPPORTED_COL_TYPES = Sets.newHashSet((Object[])new PrimitiveType[]{PrimitiveType.BIGINT, PrimitiveType.BINARY, PrimitiveType.BOOLEAN, PrimitiveType.DATE, PrimitiveType.DOUBLE, PrimitiveType.FLOAT, PrimitiveType.INT, PrimitiveType.SMALLINT, PrimitiveType.CHAR, PrimitiveType.VARCHAR, PrimitiveType.STRING, PrimitiveType.TIMESTAMP, PrimitiveType.TINYINT, PrimitiveType.DECIMAL});
    private static final Logger LOG = LoggerFactory.getLogger(ColumnStats.class);
    private double avgSize_;
    private double avgSerializedSize_;
    private long maxSize_;
    private long numDistinctValues_;
    private long numNulls_;
    private long numTrues_;
    private long numFalses_;
    private TColumnValue lowValue_;
    private TColumnValue highValue_;

    public ColumnStats(Type colType) {
        this.initColStats(colType);
        this.validate(colType);
    }

    private ColumnStats(ColumnStats other) {
        this.avgSize_ = other.avgSize_;
        this.avgSerializedSize_ = other.avgSerializedSize_;
        this.maxSize_ = other.maxSize_;
        this.numDistinctValues_ = other.numDistinctValues_;
        this.numNulls_ = other.numNulls_;
        this.numTrues_ = other.numTrues_;
        this.numFalses_ = other.numFalses_;
        this.lowValue_ = other.lowValue_;
        this.highValue_ = other.highValue_;
        this.validate(null);
    }

    private void initColStats(Type colType) {
        this.avgSize_ = -1.0;
        this.avgSerializedSize_ = -1.0;
        this.maxSize_ = -1L;
        this.numDistinctValues_ = -1L;
        this.numNulls_ = -1L;
        this.numTrues_ = -1L;
        this.numFalses_ = -1L;
        this.lowValue_ = null;
        this.highValue_ = null;
        if (colType.isFixedLengthType()) {
            this.avgSerializedSize_ = colType.getSlotSize();
            this.avgSize_ = colType.getSlotSize();
            this.maxSize_ = colType.getSlotSize();
        }
    }

    public static ColumnStats fromExpr(Expr expr) {
        return ColumnStats.fromExpr(expr, null);
    }

    public static ColumnStats fromExpr(Expr expr, @Nullable Set<Column> ignoreColumn) {
        ColumnStats slotStats;
        Preconditions.checkNotNull((Object)expr);
        Preconditions.checkState((boolean)expr.getType().isValid(), (Object)expr);
        Type colType = expr.getType();
        ColumnStats stats = new ColumnStats(colType);
        stats.setNumDistinctValues(expr.getNumDistinctValues());
        SlotRef slotRef = expr.unwrapSlotRef(false);
        if (slotRef == null) {
            return stats;
        }
        ColumnStats columnStats = slotStats = ignoreColumn != null ? slotRef.getDesc().getStats(ignoreColumn) : slotRef.getDesc().getStats();
        if (slotStats == null) {
            return stats;
        }
        if (ignoreColumn != null && slotStats.hasNumDistinctValues() && slotStats.getNumDistinctValues() < stats.getNumDistinctValues()) {
            stats.setNumDistinctValues(slotStats.getNumDistinctValues());
        }
        stats.numNulls_ = slotStats.getNumNulls();
        if (!colType.isFixedLengthType()) {
            stats.avgSerializedSize_ = slotStats.getAvgSerializedSize();
            stats.avgSize_ = slotStats.getAvgSize();
            stats.maxSize_ = slotStats.getMaxSize();
        }
        stats.numTrues_ = slotStats.getNumTrues();
        stats.numFalses_ = slotStats.getNumFalses();
        stats.lowValue_ = slotStats.getLowValue();
        stats.highValue_ = slotStats.getHighValue();
        stats.validate(colType);
        return stats;
    }

    public ColumnStats add(ColumnStats other) {
        this.numDistinctValues_ = this.numDistinctValues_ == -1L || other.numDistinctValues_ == -1L ? -1L : (this.numDistinctValues_ += other.numDistinctValues_);
        this.numNulls_ = this.numNulls_ == -1L || other.numNulls_ == -1L ? -1L : (this.numNulls_ += other.numNulls_);
        this.numTrues_ = this.numTrues_ == -1L || other.numTrues_ == -1L ? -1L : (this.numTrues_ += other.numTrues_);
        this.numFalses_ = this.numFalses_ == -1L || other.numFalses_ == -1L ? -1L : (this.numFalses_ += other.numFalses_);
        this.validate(null);
        return this;
    }

    public long getNumDistinctValues() {
        return this.numDistinctValues_;
    }

    public void setNumDistinctValues(long numDistinctValues) {
        this.numDistinctValues_ = numDistinctValues;
    }

    public void setNumNulls(long numNulls) {
        this.numNulls_ = numNulls;
    }

    public double getAvgSerializedSize() {
        return this.avgSerializedSize_;
    }

    public double getAvgSize() {
        return this.avgSize_;
    }

    public long getMaxSize() {
        return this.maxSize_;
    }

    public boolean hasNulls() {
        return this.numNulls_ > 0L;
    }

    public boolean hasNullsStats() {
        return this.numNulls_ != -1L;
    }

    public long getNumNulls() {
        return this.numNulls_;
    }

    public boolean hasAvgSize() {
        return this.avgSize_ >= 0.0;
    }

    public long getNumTrues() {
        return this.numTrues_;
    }

    public long getNumFalses() {
        return this.numFalses_;
    }

    public boolean hasNumDistinctValues() {
        return this.numDistinctValues_ >= 0L;
    }

    public boolean hasStats() {
        return this.numNulls_ != -1L || this.numDistinctValues_ != -1L;
    }

    public TColumnValue getLowValue() {
        return this.lowValue_;
    }

    public TColumnValue getHighValue() {
        return this.highValue_;
    }

    public String getTColumnValueAsString(TColumnValue value) {
        if (value == null) {
            return "-1";
        }
        StringBuilder sb = new StringBuilder();
        if (value.isSetBool_val()) {
            sb.append(value.bool_val);
        } else if (value.isSetByte_val()) {
            sb.append(value.byte_val);
        } else if (value.isSetShort_val()) {
            sb.append(value.short_val);
        } else if (value.isSetInt_val()) {
            sb.append(value.int_val);
        } else if (value.isSetLong_val()) {
            sb.append(value.long_val);
        } else if (value.isSetDouble_val()) {
            sb.append(value.double_val);
        } else if (value.isSetString_val()) {
            if (value.string_val == null) {
                sb.append("-1");
            } else {
                sb.append(value.string_val);
            }
        } else if (value.isSetBinary_val()) {
            if (value.binary_val == null) {
                sb.append("-1");
            } else {
                TBaseHelper.toString((ByteBuffer)value.binary_val, (StringBuilder)sb);
            }
        } else if (value.isSetTimestamp_val()) {
            if (value.timestamp_val == null) {
                sb.append("-1");
            } else {
                TBaseHelper.toString((ByteBuffer)value.timestamp_val, (StringBuilder)sb);
            }
        } else if (value.isSetDecimal_val()) {
            if (value.decimal_val == null) {
                sb.append("-1");
            } else {
                sb.append(new String(value.getDecimal_val()));
            }
        } else if (value.isSetDate_val()) {
            LocalDate d = LocalDate.ofEpochDay(value.date_val);
            sb.append(d.toString());
        } else {
            sb.append("-1");
        }
        return sb.toString();
    }

    public String getLowValueAsString() {
        return this.getTColumnValueAsString(this.lowValue_);
    }

    public String getHighValueAsString() {
        return this.getTColumnValueAsString(this.highValue_);
    }

    protected void updateLowValue(NumericLiteral literal) {
        if (this.lowValue_ == null) {
            this.lowValue_ = new TColumnValue();
        }
        if (literal.getType().isScalarType(PrimitiveType.TINYINT)) {
            int value = literal.getIntValue();
            if (!this.lowValue_.isSetByte_val() || value < this.lowValue_.getByte_val()) {
                this.lowValue_.setByte_val((byte)value);
            }
        } else if (literal.getType().isScalarType(PrimitiveType.SMALLINT)) {
            int value = literal.getIntValue();
            if (!this.lowValue_.isSetShort_val() || value < this.lowValue_.getShort_val()) {
                this.lowValue_.setShort_val((short)value);
            }
        } else if (literal.getType().isScalarType(PrimitiveType.INT)) {
            int value = literal.getIntValue();
            if (!this.lowValue_.isSetInt_val() || value < this.lowValue_.getInt_val()) {
                this.lowValue_.setInt_val(value);
            }
        } else if (literal.getType().isScalarType(PrimitiveType.BIGINT)) {
            long value = literal.getLongValue();
            if (!this.lowValue_.isSetLong_val() || value < this.lowValue_.getLong_val()) {
                this.lowValue_.setLong_val(value);
            }
        } else if (literal.getType().isFloatingPointType()) {
            double value = literal.getDoubleValue();
            if (!this.lowValue_.isSetDouble_val() || value < this.lowValue_.getDouble_val()) {
                this.lowValue_.setDouble_val(value);
            }
        } else if (literal.getType().isDecimal()) {
            if (!this.lowValue_.isSetDecimal_val()) {
                this.lowValue_.setDecimal_val(literal.getValue().toString().getBytes());
            } else {
                BigDecimal lValue;
                BigDecimal value = literal.getValue();
                if (value.compareTo(lValue = new BigDecimal(new String(this.lowValue_.getDecimal_val()))) < 0) {
                    this.lowValue_.setDecimal_val(value.toString().getBytes());
                }
            }
        }
    }

    protected void updateHighValue(NumericLiteral literal) {
        if (this.highValue_ == null) {
            this.highValue_ = new TColumnValue();
        }
        if (literal.getType().isScalarType(PrimitiveType.TINYINT)) {
            int value = literal.getIntValue();
            if (!this.highValue_.isSetByte_val() || value > this.highValue_.getByte_val()) {
                this.highValue_.setByte_val((byte)value);
            }
        } else if (literal.getType().isScalarType(PrimitiveType.SMALLINT)) {
            int value = literal.getIntValue();
            if (!this.highValue_.isSetShort_val() || value > this.highValue_.getShort_val()) {
                this.highValue_.setShort_val((short)value);
            }
        } else if (literal.getType().isScalarType(PrimitiveType.INT)) {
            int value = literal.getIntValue();
            if (!this.highValue_.isSetInt_val() || value > this.highValue_.getInt_val()) {
                this.highValue_.setInt_val(value);
            }
        } else if (literal.getType().isScalarType(PrimitiveType.BIGINT)) {
            long value = literal.getLongValue();
            if (!this.highValue_.isSetLong_val() || value > this.highValue_.getLong_val()) {
                this.highValue_.setLong_val(value);
            }
        } else if (literal.getType().isFloatingPointType()) {
            double value = literal.getDoubleValue();
            if (!this.highValue_.isSetDouble_val() || value > this.highValue_.getDouble_val()) {
                this.highValue_.setDouble_val(value);
            }
        } else if (literal.getType().isDecimal()) {
            if (!this.highValue_.isSetDecimal_val()) {
                this.highValue_.setDecimal_val(literal.getValue().toString().getBytes());
            } else {
                BigDecimal hValue;
                BigDecimal value = literal.getValue();
                if (value.compareTo(hValue = new BigDecimal(new String(this.highValue_.getDecimal_val()))) > 0) {
                    this.highValue_.setDecimal_val(value.toString().getBytes());
                }
            }
        }
    }

    protected void updateLowValue(DateLiteral literal) {
        if (this.lowValue_ == null) {
            this.lowValue_ = new TColumnValue();
        }
        int value = literal.getValue();
        if (!this.lowValue_.isSetDate_val() || value < this.lowValue_.getDate_val()) {
            this.lowValue_.setDate_val(value);
        }
    }

    protected void updateHighValue(DateLiteral literal) {
        if (this.highValue_ == null) {
            this.highValue_ = new TColumnValue();
        }
        int value = literal.getValue();
        if (!this.highValue_.isSetDate_val() || value > this.highValue_.getDate_val()) {
            this.highValue_.setDate_val(value);
        }
    }

    public void updateLowAndHighValue(LiteralExpr literal) {
        if (Expr.IS_NULL_LITERAL.apply((Object)literal)) {
            return;
        }
        if (!MetaStoreUtil.canStoreMinmaxInHMS(literal.getType())) {
            return;
        }
        if (literal instanceof NumericLiteral) {
            this.updateLowValue((NumericLiteral)literal);
            this.updateHighValue((NumericLiteral)literal);
        } else if (literal instanceof DateLiteral) {
            this.updateLowValue((DateLiteral)literal);
            this.updateHighValue((DateLiteral)literal);
        }
    }

    protected void setLowAndHighValue(PrimitiveType type, LongColumnStatsData longStats) {
        long value;
        if (!longStats.isSetLowValue()) {
            this.lowValue_ = null;
        } else {
            value = longStats.getLowValue();
            this.lowValue_ = new TColumnValue();
            switch (type) {
                case TINYINT: {
                    this.lowValue_.setByte_val((byte)value);
                    break;
                }
                case SMALLINT: {
                    this.lowValue_.setShort_val((short)value);
                    break;
                }
                case INT: {
                    this.lowValue_.setInt_val((int)value);
                    break;
                }
                case BIGINT: {
                    this.lowValue_.setLong_val(value);
                    break;
                }
                case TIMESTAMP: {
                    throw new IllegalStateException("TIMESTAMP columns are not supported by setLowAndHighValue()");
                }
                default: {
                    throw new IllegalStateException("Unsupported type encountered in setLowAndHighValue()");
                }
            }
        }
        if (!longStats.isSetHighValue()) {
            this.highValue_ = null;
        } else {
            value = longStats.getHighValue();
            this.highValue_ = new TColumnValue();
            switch (type) {
                case TINYINT: {
                    this.highValue_.setByte_val((byte)value);
                    break;
                }
                case SMALLINT: {
                    this.highValue_.setShort_val((short)value);
                    break;
                }
                case INT: {
                    this.highValue_.setInt_val((int)value);
                    break;
                }
                case BIGINT: {
                    this.highValue_.setLong_val(value);
                    break;
                }
                case TIMESTAMP: {
                    throw new IllegalStateException("TIMESTAMP columns are not supported by setLowAndHighValue()");
                }
                default: {
                    throw new IllegalStateException("Unsupported type encountered in setLowAndHighValue()");
                }
            }
        }
    }

    protected void setLowAndHighValue(DoubleColumnStatsData doubleStats) {
        if (!doubleStats.isSetLowValue()) {
            this.lowValue_ = null;
        } else {
            this.lowValue_ = new TColumnValue();
            this.lowValue_.setDouble_val(doubleStats.getLowValue());
        }
        if (!doubleStats.isSetHighValue()) {
            this.highValue_ = null;
        } else {
            this.highValue_ = new TColumnValue();
            this.highValue_.setDouble_val(doubleStats.getHighValue());
        }
    }

    protected void setLowAndHighValue(DateColumnStatsData dateStats) {
        if (!dateStats.isSetLowValue()) {
            this.lowValue_ = null;
        } else {
            this.lowValue_ = new TColumnValue();
            this.lowValue_.setDate_val((int)dateStats.getLowValue().getDaysSinceEpoch());
        }
        if (!dateStats.isSetHighValue()) {
            this.highValue_ = null;
        } else {
            this.highValue_ = new TColumnValue();
            this.highValue_.setDate_val((int)dateStats.getHighValue().getDaysSinceEpoch());
        }
    }

    protected void setLowAndHighValue(DecimalColumnStatsData decimalStats) {
        if (!decimalStats.isSetLowValue()) {
            this.lowValue_ = null;
        } else {
            this.lowValue_ = new TColumnValue();
            this.lowValue_.setDecimal_val(decimalStats.getLowValue().getUnscaled());
        }
        if (!decimalStats.isSetHighValue()) {
            this.highValue_ = null;
        } else {
            this.highValue_ = new TColumnValue();
            this.highValue_.setDecimal_val(decimalStats.getHighValue().getUnscaled());
        }
    }

    private long normalizeValue(String colName, StatsKey key, long value) {
        if (value < -1L) {
            LOG.warn("Invalid {} of column {}: {}. Normalized to -1.", new Object[]{key, colName, value});
            return -1L;
        }
        return value;
    }

    private float normalizeAvgSize(String colName, float value) {
        if (value < -1.0f) {
            LOG.warn("Invalid avgSize of column {}: {}. Normalized to -1.", (Object)colName, (Object)Float.valueOf(value));
            return -1.0f;
        }
        return value;
    }

    public boolean update(String colName, Type colType, ColumnStatisticsData statsData) {
        Preconditions.checkState((boolean)ColumnStats.isSupportedColType(colType));
        this.initColStats(colType);
        boolean isCompatible = false;
        this.lowValue_ = null;
        this.highValue_ = null;
        switch (colType.getPrimitiveType()) {
            case BOOLEAN: {
                isCompatible = statsData.isSetBooleanStats();
                if (!isCompatible) break;
                BooleanColumnStatsData boolStats = statsData.getBooleanStats();
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, boolStats.getNumNulls());
                this.numDistinctValues_ = this.numNulls_ > 0L ? 3L : (this.numNulls_ == 0L ? 2L : -1L);
                this.numTrues_ = this.normalizeValue(colName, StatsKey.NUM_TRUES, boolStats.getNumTrues());
                this.numFalses_ = this.normalizeValue(colName, StatsKey.NUM_FALSES, boolStats.getNumFalses());
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case TIMESTAMP: {
                isCompatible = statsData.isSetLongStats();
                if (!isCompatible) break;
                LongColumnStatsData longStats = statsData.getLongStats();
                this.numDistinctValues_ = this.normalizeValue(colName, StatsKey.NUM_DISTINCT_VALUES, longStats.getNumDVs());
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, longStats.getNumNulls());
                if (colType.getPrimitiveType() == PrimitiveType.TIMESTAMP) break;
                this.setLowAndHighValue(colType.getPrimitiveType(), longStats);
                break;
            }
            case DATE: {
                isCompatible = statsData.isSetDateStats();
                if (!isCompatible) break;
                DateColumnStatsData dateStats = statsData.getDateStats();
                this.numDistinctValues_ = this.normalizeValue(colName, StatsKey.NUM_DISTINCT_VALUES, dateStats.getNumDVs());
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, dateStats.getNumNulls());
                this.setLowAndHighValue(dateStats);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                isCompatible = statsData.isSetDoubleStats();
                if (!isCompatible) break;
                DoubleColumnStatsData doubleStats = statsData.getDoubleStats();
                this.numDistinctValues_ = this.normalizeValue(colName, StatsKey.NUM_DISTINCT_VALUES, doubleStats.getNumDVs());
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, doubleStats.getNumNulls());
                this.setLowAndHighValue(doubleStats);
                break;
            }
            case CHAR: {
                isCompatible = statsData.isSetStringStats();
                if (!isCompatible) break;
                StringColumnStatsData stringStats = statsData.getStringStats();
                this.numDistinctValues_ = this.normalizeValue(colName, StatsKey.NUM_DISTINCT_VALUES, stringStats.getNumDVs());
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, stringStats.getNumNulls());
                break;
            }
            case VARCHAR: 
            case STRING: {
                isCompatible = statsData.isSetStringStats();
                if (!isCompatible) break;
                StringColumnStatsData stringStats = statsData.getStringStats();
                this.numDistinctValues_ = this.normalizeValue(colName, StatsKey.NUM_DISTINCT_VALUES, stringStats.getNumDVs());
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, stringStats.getNumNulls());
                this.maxSize_ = this.normalizeValue(colName, StatsKey.MAX_SIZE, stringStats.getMaxColLen());
                this.avgSize_ = this.normalizeAvgSize(colName, Double.valueOf(stringStats.getAvgColLen()).floatValue());
                if (this.avgSize_ >= 0.0) {
                    this.avgSerializedSize_ = this.avgSize_ + (double)PrimitiveType.STRING.getSlotSize();
                    break;
                }
                this.avgSerializedSize_ = -1.0;
                break;
            }
            case BINARY: {
                isCompatible = statsData.isSetBinaryStats();
                if (!isCompatible) break;
                BinaryColumnStatsData binaryStats = statsData.getBinaryStats();
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, binaryStats.getNumNulls());
                this.maxSize_ = this.normalizeValue(colName, StatsKey.MAX_SIZE, binaryStats.getMaxColLen());
                this.avgSize_ = this.normalizeAvgSize(colName, Double.valueOf(binaryStats.getAvgColLen()).floatValue());
                if (this.avgSize_ >= 0.0) {
                    this.avgSerializedSize_ = this.avgSize_ + (double)PrimitiveType.BINARY.getSlotSize();
                    break;
                }
                this.avgSerializedSize_ = -1.0;
                break;
            }
            case DECIMAL: {
                isCompatible = statsData.isSetDecimalStats();
                if (!isCompatible) break;
                DecimalColumnStatsData decimalStats = statsData.getDecimalStats();
                this.numNulls_ = this.normalizeValue(colName, StatsKey.NUM_NULLS, decimalStats.getNumNulls());
                this.numDistinctValues_ = this.normalizeValue(colName, StatsKey.NUM_DISTINCT_VALUES, decimalStats.getNumDVs());
                this.setLowAndHighValue(decimalStats);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected column type: " + colType);
            }
        }
        this.validate(colType);
        return isCompatible;
    }

    public static void updateLowAndHighForHiveColumnStatsData(Long low_value, Long high_value, LongColumnStatsData longColStatsData) {
        if (low_value != null) {
            longColStatsData.setLowValue(low_value.longValue());
        } else {
            longColStatsData.unsetLowValue();
        }
        if (high_value != null) {
            longColStatsData.setHighValue(high_value.longValue());
        } else {
            longColStatsData.unsetHighValue();
        }
    }

    public static void updateLowAndHighForHiveColumnStatsData(Double low_value, Double high_value, DoubleColumnStatsData doubleColStatsData) {
        if (low_value != null) {
            doubleColStatsData.setLowValue(low_value.doubleValue());
        } else {
            doubleColStatsData.unsetLowValue();
        }
        if (high_value != null) {
            doubleColStatsData.setHighValue(high_value.doubleValue());
        } else {
            doubleColStatsData.unsetHighValue();
        }
    }

    public static void updateLowAndHighForHiveColumnStatsData(Date low_value, Date high_value, DateColumnStatsData dateColStatsData) {
        if (low_value != null) {
            dateColStatsData.setLowValue(low_value);
        } else {
            dateColStatsData.unsetLowValue();
        }
        if (high_value != null) {
            dateColStatsData.setHighValue(high_value);
        } else {
            dateColStatsData.unsetHighValue();
        }
    }

    public static void updateLowAndHighForHiveColumnStatsData(Decimal low_value, Decimal high_value, DecimalColumnStatsData decimalColStatsData) {
        if (low_value != null) {
            decimalColStatsData.setLowValue(low_value);
        } else {
            decimalColStatsData.unsetLowValue();
        }
        if (high_value != null) {
            decimalColStatsData.setHighValue(high_value);
        } else {
            decimalColStatsData.unsetHighValue();
        }
    }

    public static ColumnStatisticsData createHiveColStatsData(long capNdv, TColumnStats colStats, Type colType) {
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        long ndv = colStats.getNum_distinct_values();
        if (capNdv >= 0L) {
            ndv = Math.min(ndv, capNdv);
        }
        long numNulls = colStats.getNum_nulls();
        long numTrues = colStats.getNum_trues();
        long numFalses = colStats.getNum_falses();
        boolean isLowValueSet = colStats.isSetLow_value();
        boolean isHighValueSet = colStats.isSetHigh_value();
        long maxStrLen = colStats.getMax_size();
        double avgStrLen = colStats.getAvg_size();
        switch (colType.getPrimitiveType()) {
            case BOOLEAN: {
                colStatsData.setBooleanStats(new BooleanColumnStatsData(numTrues, numFalses, numNulls));
                break;
            }
            case TINYINT: {
                ndv = Math.min(ndv, LongMath.pow((long)2L, (int)8));
                LongColumnStatsData longColStatsData = new LongColumnStatsData(numNulls, ndv);
                Long lowValue = null;
                Long highValue = null;
                if (isLowValueSet && colStats.low_value.isSetByte_val()) {
                    lowValue = colStats.low_value.getByte_val();
                }
                if (isHighValueSet && colStats.high_value.isSetByte_val()) {
                    highValue = colStats.high_value.getByte_val();
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, longColStatsData);
                colStatsData.setLongStats(longColStatsData);
                break;
            }
            case SMALLINT: {
                ndv = Math.min(ndv, LongMath.pow((long)2L, (int)16));
                LongColumnStatsData longColStatsData = new LongColumnStatsData(numNulls, ndv);
                Long lowValue = null;
                Long highValue = null;
                if (isLowValueSet && colStats.low_value.isSetShort_val()) {
                    lowValue = colStats.low_value.getShort_val();
                }
                if (isHighValueSet && colStats.high_value.isSetShort_val()) {
                    highValue = colStats.high_value.getShort_val();
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, longColStatsData);
                colStatsData.setLongStats(longColStatsData);
                break;
            }
            case INT: {
                ndv = Math.min(ndv, LongMath.pow((long)2L, (int)32));
                LongColumnStatsData longColStatsData = new LongColumnStatsData(numNulls, ndv);
                Long lowValue = null;
                Long highValue = null;
                if (isLowValueSet && colStats.low_value.isSetInt_val()) {
                    lowValue = colStats.low_value.getInt_val();
                }
                if (isHighValueSet && colStats.high_value.isSetInt_val()) {
                    highValue = colStats.high_value.getInt_val();
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, longColStatsData);
                colStatsData.setLongStats(longColStatsData);
                break;
            }
            case DATE: {
                ndv = Math.min(ndv, 3652059L);
                DateColumnStatsData dateColStatsData = new DateColumnStatsData(numNulls, ndv);
                Date lowValue = null;
                Date highValue = null;
                if (isLowValueSet && colStats.low_value.isSetDate_val()) {
                    lowValue = new Date((long)colStats.low_value.getDate_val());
                }
                if (isHighValueSet && colStats.high_value.isSetDate_val()) {
                    highValue = new Date((long)colStats.high_value.getDate_val());
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, dateColStatsData);
                colStatsData.setDateStats(dateColStatsData);
                break;
            }
            case BIGINT: {
                LongColumnStatsData longColStatsData = new LongColumnStatsData(numNulls, ndv);
                Long lowValue = null;
                Long highValue = null;
                if (isLowValueSet && colStats.low_value.isSetLong_val()) {
                    lowValue = colStats.low_value.getLong_val();
                }
                if (isHighValueSet && colStats.high_value.isSetLong_val()) {
                    highValue = colStats.high_value.getLong_val();
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, longColStatsData);
                colStatsData.setLongStats(longColStatsData);
                break;
            }
            case TIMESTAMP: {
                colStatsData.setLongStats(new LongColumnStatsData(numNulls, ndv));
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                DoubleColumnStatsData doubleColStatsData = new DoubleColumnStatsData(numNulls, ndv);
                Double lowValue = null;
                Double highValue = null;
                if (isLowValueSet && colStats.low_value.isSetDouble_val()) {
                    lowValue = colStats.low_value.getDouble_val();
                }
                if (isHighValueSet && colStats.high_value.isSetDouble_val()) {
                    highValue = colStats.high_value.getDouble_val();
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, doubleColStatsData);
                colStatsData.setDoubleStats(doubleColStatsData);
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                colStatsData.setStringStats(new StringColumnStatsData(maxStrLen, avgStrLen, numNulls, ndv));
                break;
            }
            case BINARY: {
                colStatsData.setBinaryStats(new BinaryColumnStatsData(maxStrLen, avgStrLen, numNulls));
                break;
            }
            case DECIMAL: {
                double decMaxNdv = Math.pow(10.0, colType.getPrecision().intValue());
                ndv = (long)Math.min((double)ndv, decMaxNdv);
                DecimalColumnStatsData decimalStatsData = new DecimalColumnStatsData(numNulls, ndv);
                Decimal lowValue = null;
                Decimal highValue = null;
                ScalarType colTypeScalar = (ScalarType)colType;
                if (isLowValueSet && colStats.low_value.isSetDecimal_val()) {
                    lowValue = new Decimal((short)colTypeScalar.decimalScale(), colStats.low_value.bufferForDecimal_val());
                }
                if (isHighValueSet && colStats.high_value.isSetDecimal_val()) {
                    highValue = new Decimal((short)colTypeScalar.decimalScale(), colStats.high_value.bufferForDecimal_val());
                }
                ColumnStats.updateLowAndHighForHiveColumnStatsData(lowValue, highValue, decimalStatsData);
                colStatsData.setDecimalStats(decimalStatsData);
                break;
            }
            default: {
                return null;
            }
        }
        return colStatsData;
    }

    public ColumnStatisticsData toHmsCompatibleThrift(Type colType) {
        return ColumnStats.createHiveColStatsData(-1L, this.toThrift(), colType);
    }

    public void update(Type colType, StatsKey key, Number value) {
        Preconditions.checkNotNull((Object)((Object)key));
        Preconditions.checkNotNull((Object)value);
        if (key == StatsKey.AVG_SIZE) {
            Preconditions.checkArgument((boolean)(value instanceof Float));
            Float floatValue = (Float)value;
            Preconditions.checkArgument((floatValue.floatValue() >= 0.0f || floatValue.floatValue() == -1.0f ? 1 : 0) != 0, (Object)floatValue);
        } else {
            Preconditions.checkArgument((boolean)(value instanceof Long));
            Long longValue = (Long)value;
            Preconditions.checkArgument((longValue >= 0L || longValue == -1L ? 1 : 0) != 0, (Object)longValue);
        }
        switch (key) {
            case NUM_DISTINCT_VALUES: {
                this.numDistinctValues_ = (Long)value;
                break;
            }
            case NUM_NULLS: {
                this.numNulls_ = (Long)value;
                break;
            }
            case AVG_SIZE: {
                Preconditions.checkArgument((!colType.isFixedLengthType() ? 1 : 0) != 0, (Object)colType);
                this.avgSize_ = ((Float)value).floatValue();
                if (this.avgSize_ >= 0.0) {
                    this.avgSerializedSize_ = (double)colType.getSlotSize() + this.avgSize_;
                    break;
                }
                this.avgSerializedSize_ = -1.0;
                break;
            }
            case MAX_SIZE: {
                Preconditions.checkArgument((!colType.isFixedLengthType() ? 1 : 0) != 0, (Object)colType);
                this.maxSize_ = (Long)value;
                break;
            }
            case NUM_TRUES: {
                this.numTrues_ = (Long)value;
                break;
            }
            case NUM_FALSES: {
                this.numFalses_ = (Long)value;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown StatsKey " + (Object)((Object)key));
            }
        }
        this.validate(colType);
    }

    public static boolean isSupportedColType(Type colType) {
        if (!colType.isScalarType()) {
            return false;
        }
        ScalarType scalarType = (ScalarType)colType;
        return SUPPORTED_COL_TYPES.contains((Object)scalarType.getPrimitiveType());
    }

    public void update(Type colType, TColumnStats stats) {
        this.initColStats(colType);
        if (!colType.isFixedLengthType() && stats.getAvg_size() >= 0.0) {
            this.avgSize_ = Double.valueOf(stats.getAvg_size()).floatValue();
            this.avgSerializedSize_ = (double)colType.getSlotSize() + this.avgSize_;
        }
        if (colType.getPrimitiveType() == PrimitiveType.BOOLEAN) {
            this.numTrues_ = stats.getNum_trues();
            this.numFalses_ = stats.getNum_falses();
        }
        this.maxSize_ = stats.getMax_size();
        this.numDistinctValues_ = stats.getNum_distinct_values();
        this.numNulls_ = stats.getNum_nulls();
        this.lowValue_ = stats.getLow_value();
        this.highValue_ = stats.getHigh_value();
        this.validate(colType);
    }

    public TColumnStats toThrift() {
        TColumnStats colStats = new TColumnStats();
        colStats.setAvg_size(this.avgSize_);
        colStats.setMax_size(this.maxSize_);
        colStats.setNum_distinct_values(this.numDistinctValues_);
        colStats.setNum_nulls(this.numNulls_);
        colStats.setNum_trues(this.numTrues_);
        colStats.setNum_falses(this.numFalses_);
        colStats.setLow_value(this.lowValue_);
        colStats.setHigh_value(this.highValue_);
        return colStats;
    }

    public void validate(Type colType) {
        Preconditions.checkState((this.avgSize_ >= 0.0 == this.avgSerializedSize_ >= 0.0 ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.avgSize_ == -1.0 || this.avgSize_ >= 0.0 ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.avgSerializedSize_ == -1.0 || this.avgSerializedSize_ >= 0.0 ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.maxSize_ == -1L || this.maxSize_ >= 0L ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.numDistinctValues_ == -1L || this.numDistinctValues_ >= 0L ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.numNulls_ == -1L || this.numNulls_ >= 0L ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.numTrues_ == -1L || this.numTrues_ >= 0L ? 1 : 0) != 0, (Object)this);
        Preconditions.checkState((this.numFalses_ == -1L || this.numFalses_ >= 0L ? 1 : 0) != 0, (Object)this);
        if (colType != null && colType.isFixedLengthType()) {
            Preconditions.checkState((this.avgSize_ == (double)colType.getSlotSize() ? 1 : 0) != 0, (Object)this);
            Preconditions.checkState((this.avgSerializedSize_ == (double)colType.getSlotSize() ? 1 : 0) != 0, (Object)this);
            Preconditions.checkState((this.maxSize_ == (long)colType.getSlotSize() ? 1 : 0) != 0, (Object)this);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("avgSize_", this.avgSize_).add("avgSerializedSize_", this.avgSerializedSize_).add("maxSize_", this.maxSize_).add("numDistinct_", this.numDistinctValues_).add("numNulls_", this.numNulls_).add("numTrues", this.numTrues_).add("numFalses", this.numFalses_).add("lowValue", (Object)this.getLowValueAsString()).add("highValue", (Object)this.getHighValueAsString()).toString();
    }

    public ColumnStats clone() {
        return new ColumnStats(this);
    }

    public static enum StatsKey {
        NUM_DISTINCT_VALUES("numDVs"),
        NUM_NULLS("numNulls"),
        AVG_SIZE("avgSize"),
        MAX_SIZE("maxSize"),
        NUM_TRUES("numTrues"),
        NUM_FALSES("numFalses");

        private final String name_;

        private StatsKey(String name) {
            this.name_ = name;
        }

        public static StatsKey fromString(String key) {
            for (StatsKey k : StatsKey.values()) {
                if (!key.equalsIgnoreCase(k.name_)) continue;
                return k;
            }
            return null;
        }

        public String toString() {
            return this.name_;
        }
    }
}

