/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationDelta;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.AuthzCacheInvalidation;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogDeltaLog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.CatalogdTableInvalidator;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.ParallelFileMetadataLoader;
import org.apache.impala.catalog.PartitionMetaSummary;
import org.apache.impala.catalog.Principal;
import org.apache.impala.catalog.PrincipalPrivilege;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.Role;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.TableLoadingMgr;
import org.apache.impala.catalog.TableNotFoundException;
import org.apache.impala.catalog.TopicUpdateLog;
import org.apache.impala.catalog.User;
import org.apache.impala.catalog.events.ExternalEventsProcessor;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationFetchException;
import org.apache.impala.catalog.events.SelfEventContext;
import org.apache.impala.catalog.metastore.HmsApiNameEnum;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.catalog.monitor.CatalogMonitor;
import org.apache.impala.catalog.monitor.CatalogTableMetrics;
import org.apache.impala.catalog.monitor.TableLoadingTimeHistogram;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Pair;
import org.apache.impala.common.Reference;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hive.common.MutableValidWriteIdList;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveJavaFunctionFactoryImpl;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.service.JniCatalog;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TCatalog;
import org.apache.impala.thrift.TCatalogInfoSelector;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCatalogUpdateResult;
import org.apache.impala.thrift.TCatalogdHmsCacheMetrics;
import org.apache.impala.thrift.TDataSource;
import org.apache.impala.thrift.TDatabase;
import org.apache.impala.thrift.TEventProcessorMetrics;
import org.apache.impala.thrift.TEventProcessorMetricsSummaryResponse;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TGetCatalogUsageResponse;
import org.apache.impala.thrift.TGetOperationUsageResponse;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.TGetPartitionStatsRequest;
import org.apache.impala.thrift.THdfsFileDesc;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TPartialCatalogInfo;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TSystemTableName;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.thrift.TTableUsage;
import org.apache.impala.thrift.TTableUsageMetrics;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUpdateTableUsageRequest;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.CatalogBlacklistUtils;
import org.apache.impala.util.DebugUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.FunctionUtils;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.impala.util.PatternMatcher;
import org.apache.impala.util.TUniqueIdUtil;
import org.apache.impala.util.ThreadNameAnnotator;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogServiceCatalog
extends Catalog {
    public static final Logger LOG = LoggerFactory.getLogger(CatalogServiceCatalog.class);
    public static final String GOT_CATALOG_VERSION_READ_LOCK = "Got catalog version read lock";
    public static final String GOT_CATALOG_VERSION_WRITE_LOCK = "Got catalog version write lock";
    public static final int INITIAL_META_STORE_CLIENT_POOL_SIZE = 10;
    private static final int MAX_NUM_SKIPPED_TOPIC_UPDATES = 2;
    private final int maxSkippedUpdatesLockContention_;
    private final long topicUpdateTblLockMaxWaitTimeMs_;
    public static final long LOCK_RETRY_TIMEOUT_MS = 0x6DDD00L;
    private static final int LOCK_RETRY_DELAY_MS = 10;
    private static final long LOCK_ACQUIRING_DURATION_WARN_MS = 100L;
    public static final long TABLE_ID_UNAVAILABLE = -1L;
    private final ReentrantReadWriteLock versionLock_ = new ReentrantReadWriteLock(true);
    private long catalogVersion_ = 0L;
    private long lastResetStartVersion_ = 0L;
    private final TableLoadingMgr tableLoadingMgr_;
    private final boolean loadInBackground_;
    private final ScheduledExecutorService cachePoolReader_ = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("HDFSCachePoolReader").build());
    private final CatalogDeltaLog deleteLog_;
    private final AtomicLong lastSentTopicUpdate_ = new AtomicLong(-1L);
    private static final long TOPIC_UPDATE_WAIT_TIMEOUT_MS = 10000L;
    private final TopicUpdateLog topicUpdateLog_ = new TopicUpdateLog();
    private final String localLibraryPath_;
    private CatalogdTableInvalidator catalogdTableInvalidator_;
    private ExternalEventsProcessor metastoreEventProcessor_;
    private ICatalogMetastoreServer catalogMetastoreServer_;
    private MetastoreEvents.MetastoreEventFactory syncToLatestEventFactory_;
    final TopicMode topicMode_;
    private final long PARTIAL_FETCH_RPC_QUEUE_TIMEOUT_S = BackendConfig.INSTANCE.getCatalogPartialFetchRpcQueueTimeoutS();
    private final int MAX_PARALLEL_PARTIAL_FETCH_RPC_COUNT = BackendConfig.INSTANCE.getCatalogMaxParallelPartialFetchRpc();
    private final Semaphore partialObjectFetchAccess_ = new Semaphore(this.MAX_PARALLEL_PARTIAL_FETCH_RPC_COUNT, true);
    private AuthorizationManager authzManager_;
    private final Set<String> blacklistedDbs_ = CatalogBlacklistUtils.parseBlacklistedDbs(BackendConfig.INSTANCE.getBlacklistedDbs(), LOG);
    private final Set<TableName> blacklistedTables_ = CatalogBlacklistUtils.parseBlacklistedTables(BackendConfig.INSTANCE.getBlacklistedTables(), LOG);
    private final Set<String> whitelistedTblProperties_;
    private final Set<String> failureEventsForTesting_;
    private final List<String> defaultSkippedHmsEventTypes_;
    private final List<String> commonHmsEventTypes_;
    private int numDbs_ = 0;
    private int numTables_ = 0;
    private int numFunctions_ = 0;
    private final List<String> impalaSysTables;

    public CatalogServiceCatalog(boolean loadInBackground, int numLoadingThreads, String localLibraryPath, MetaStoreClientPool metaStoreClientPool) throws ImpalaException {
        super(metaStoreClientPool);
        this.maxSkippedUpdatesLockContention_ = BackendConfig.INSTANCE.getBackendCfg().catalog_max_lock_skipped_topic_updates;
        Preconditions.checkState((this.maxSkippedUpdatesLockContention_ > 0 ? 1 : 0) != 0, (Object)"catalog_max_lock_skipped_topic_updates must be positive");
        this.topicUpdateTblLockMaxWaitTimeMs_ = BackendConfig.INSTANCE.getBackendCfg().topic_update_tbl_max_wait_time_ms;
        Preconditions.checkState((this.topicUpdateTblLockMaxWaitTimeMs_ >= 0L ? 1 : 0) != 0, (Object)"topic_update_tbl_max_wait_time_ms must be positive");
        this.impalaSysTables = Arrays.asList(BackendConfig.INSTANCE.queryLogTableName(), TSystemTableName.IMPALA_QUERY_LIVE.toString().toLowerCase());
        this.tableLoadingMgr_ = new TableLoadingMgr(this, numLoadingThreads);
        this.loadInBackground_ = loadInBackground;
        try {
            if (FileSystemUtil.isDistributedFileSystem(FileSystemUtil.getDefaultFileSystem())) {
                this.cachePoolReader_.scheduleAtFixedRate(new CachePoolReader(false), 0L, 1L, TimeUnit.MINUTES);
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't identify the default FS. Cache Pool reader will be disabled.");
        }
        this.localLibraryPath_ = localLibraryPath;
        this.deleteLog_ = new CatalogDeltaLog();
        this.topicMode_ = TopicMode.valueOf(BackendConfig.INSTANCE.getBackendCfg().catalog_topic_mode.toUpperCase());
        this.catalogdTableInvalidator_ = CatalogdTableInvalidator.create(this, BackendConfig.INSTANCE);
        Preconditions.checkState((this.PARTIAL_FETCH_RPC_QUEUE_TIMEOUT_S > 0L ? 1 : 0) != 0);
        String whitelist = BackendConfig.INSTANCE.getFileMetadataReloadProperties();
        this.whitelistedTblProperties_ = Sets.newHashSet();
        for (Object tblProps : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)whitelist)) {
            this.whitelistedTblProperties_.add((String)tblProps);
        }
        this.failureEventsForTesting_ = Sets.newHashSet();
        String failureEvents = BackendConfig.INSTANCE.getProcessEventFailureEventTypes().toUpperCase();
        for (String tblProps : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)failureEvents)) {
            this.failureEventsForTesting_.add(tblProps);
        }
        this.defaultSkippedHmsEventTypes_ = Lists.newArrayList();
        Iterable eventTypes = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)BackendConfig.INSTANCE.getDefaultSkippedHmsEventTypes());
        for (String eventType : eventTypes) {
            this.defaultSkippedHmsEventTypes_.add(eventType);
        }
        LOG.info("Default skipped HMS event types: " + this.defaultSkippedHmsEventTypes_);
        this.commonHmsEventTypes_ = Lists.newArrayList();
        eventTypes = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)BackendConfig.INSTANCE.getCommonHmsEventTypes());
        for (String eventType : eventTypes) {
            this.commonHmsEventTypes_.add(eventType);
        }
        LOG.info("Common HMS event types: " + this.commonHmsEventTypes_);
    }

    public void startEventsProcessor() {
        Preconditions.checkNotNull((Object)this.metastoreEventProcessor_, (Object)"Start events processor called before initializing it");
        this.metastoreEventProcessor_.start();
    }

    public CatalogServiceCatalog(boolean loadInBackground, int numLoadingThreads, int initialHmsCnxnTimeoutSec, String localLibraryPath) throws ImpalaException {
        this(loadInBackground, numLoadingThreads, localLibraryPath, new MetaStoreClientPool(10, initialHmsCnxnTimeoutSec));
    }

    public boolean isBlacklistedDb(String dbName) {
        Preconditions.checkNotNull((Object)dbName);
        if (BackendConfig.INSTANCE.enableWorkloadMgmt() && dbName.equalsIgnoreCase("sys")) {
            return false;
        }
        return this.blacklistedDbs_.contains(dbName.toLowerCase());
    }

    public boolean isBlacklistedTable(TableName table) {
        Preconditions.checkNotNull((Object)table);
        if (table.getDb().equalsIgnoreCase("sys") && this.blacklistedDbs_.contains("sys")) {
            return !this.impalaSysTables.contains(table.getTbl());
        }
        return this.blacklistedTables_.contains(table);
    }

    public boolean isBlacklistedTable(String db, String table) {
        return this.isBlacklistedTable(new TableName(db, table));
    }

    public void setAuthzManager(AuthorizationManager authzManager) {
        this.authzManager_ = (AuthorizationManager)Preconditions.checkNotNull((Object)authzManager);
    }

    public ExternalEventsProcessor getMetastoreEventProcessor() {
        return this.metastoreEventProcessor_;
    }

    public boolean isEventProcessingActive() {
        return this.metastoreEventProcessor_ instanceof MetastoreEventsProcessor && MetastoreEventsProcessor.EventProcessorStatus.ACTIVE.equals((Object)((MetastoreEventsProcessor)this.metastoreEventProcessor_).getStatus());
    }

    public void readLock(Table tbl, EventSequence catalogTimeline) {
        tbl.readLock().lock();
        catalogTimeline.markEvent("Got table read lock");
    }

    public boolean tryWriteLock(Table tbl) {
        return this.tryLock(tbl, true, 0x6DDD00L);
    }

    public boolean tryWriteLock(Table tbl, EventSequence catalogTimeline) {
        boolean success = this.tryWriteLock(tbl);
        if (success) {
            catalogTimeline.markEvent("Got catalog version write lock and table write lock");
        } else {
            catalogTimeline.markEvent("Failed to acquire table write lock");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryWriteLock(Table[] tables) {
        block23: {
            block21: {
                block22: {
                    tableInfo = new StringBuilder();
                    numTables = tables.length;
                    if (CatalogServiceCatalog.LOG.isDebugEnabled()) {
                        for (i = 0; i < numTables; ++i) {
                            tableInfo.append(tables[i].getFullName());
                            if (i >= numTables - 1) continue;
                            tableInfo.append(", ");
                        }
                        CatalogServiceCatalog.LOG.debug("Trying to acquire write locks for tables: " + tableInfo);
                    }
                    tableIndex = -1;
                    versionLockCount = 0;
                    try {
                        tableIndex = 0;
lbl16:
                        // 2 sources

                        while (tableIndex < numTables) {
                            tbl = tables[tableIndex];
                            if (!this.tryWriteLock(tbl)) {
                                CatalogServiceCatalog.LOG.debug("Could not acquire write lock on table: " + tbl.getFullName());
                                var7_8 = false;
                                if (tableIndex == numTables) break block21;
                                tablesInfo = new StringBuilder();
                                break block22;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl62
                    }
                    catch (Throwable var10_13) {
                        if (tableIndex != numTables) {
                            tablesInfo = new StringBuilder();
                            for (i = 0; i < tableIndex; ++i) {
                                tables[i].releaseWriteLock();
                                tablesInfo.append(tables[i].getFullName() + (i < tableIndex - 1 ? ", " : ""));
                            }
                            if (CatalogServiceCatalog.LOG.isDebugEnabled()) {
                                CatalogServiceCatalog.LOG.debug("Released table write lock on tables: {}", (Object)tablesInfo);
                            }
                        }
                        CatalogServiceCatalog.LOG.debug("Unlocking versionLock_ write lock {} number of times", (Object)versionLockCount);
                        while (true) {
                            if (versionLockCount <= 0) {
                                throw var10_13;
                            }
                            this.versionLock_.writeLock().unlock();
                            --versionLockCount;
                        }
                    }
                }
                for (i = 0; i < tableIndex; ++i) {
                    tables[i].releaseWriteLock();
                    tablesInfo.append(tables[i].getFullName() + (i < tableIndex - 1 ? ", " : ""));
                }
                if (CatalogServiceCatalog.LOG.isDebugEnabled()) {
                    CatalogServiceCatalog.LOG.debug("Released table write lock on tables: {}", (Object)tablesInfo);
                }
            }
            CatalogServiceCatalog.LOG.debug("Unlocking versionLock_ write lock {} number of times", (Object)versionLockCount);
            while (true) {
                if (versionLockCount <= 0) {
                    return var7_8;
                }
                this.versionLock_.writeLock().unlock();
                --versionLockCount;
            }
lbl-1000:
            // 1 sources

            {
                ++versionLockCount;
                ++tableIndex;
                ** GOTO lbl16
lbl62:
                // 1 sources

                if (tableIndex == numTables) {
                    --versionLockCount;
                }
                var6_7 = true;
                if (tableIndex == numTables) break block23;
                tablesInfo = new StringBuilder();
            }
            for (i = 0; i < tableIndex; ++i) {
                tables[i].releaseWriteLock();
                tablesInfo.append(tables[i].getFullName() + (i < tableIndex - 1 ? ", " : ""));
            }
            if (CatalogServiceCatalog.LOG.isDebugEnabled()) {
                CatalogServiceCatalog.LOG.debug("Released table write lock on tables: {}", (Object)tablesInfo);
            }
        }
        CatalogServiceCatalog.LOG.debug("Unlocking versionLock_ write lock {} number of times", (Object)versionLockCount);
        while (true) {
            if (versionLockCount <= 0) {
                return var6_7;
            }
            this.versionLock_.writeLock().unlock();
            --versionLockCount;
        }
    }

    public boolean tryLock(Table tbl, boolean useWriteLock, long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0);
        try (ThreadNameAnnotator tna = new ThreadNameAnnotator(String.format("Attempting to %s lock table %s with a timeout of %s ms", useWriteLock ? "write" : "read", tbl.getFullName(), timeout));){
            long end;
            long begin = System.currentTimeMillis();
            do {
                block20: {
                    this.versionLock_.writeLock().lock();
                    Lock lock = useWriteLock ? tbl.writeLock() : tbl.readLock();
                    if (!lock.tryLock(0L, TimeUnit.SECONDS)) break block20;
                    long duration = System.currentTimeMillis() - begin;
                    if (duration > 100L) {
                        LOG.warn("{} lock for table {} was acquired in {} msec", new Object[]{useWriteLock ? "Write" : "Read", tbl.getFullName(), duration});
                    }
                    boolean bl = true;
                    return bl;
                }
                try {
                    this.versionLock_.writeLock().unlock();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((end = System.currentTimeMillis()) - begin < timeout);
            boolean bl = false;
            return bl;
        }
    }

    public boolean tryLockDb(Db db) {
        try (ThreadNameAnnotator tna = new ThreadNameAnnotator("Attempting to lock database " + db.getName());){
            long end;
            long begin = System.currentTimeMillis();
            do {
                this.versionLock_.writeLock().lock();
                if (db.getLock().tryLock()) {
                    long duration = System.currentTimeMillis() - begin;
                    if (duration > 100L) {
                        LOG.warn("Lock for db {} was acquired in {} msec", (Object)db.getName(), (Object)duration);
                    }
                    boolean bl = true;
                    return bl;
                }
                this.versionLock_.writeLock().unlock();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((end = System.currentTimeMillis()) - begin < 0x6DDD00L);
            boolean bl = false;
            return bl;
        }
    }

    public int getPartialFetchRpcQueueLength() {
        return this.partialObjectFetchAccess_.getQueueLength();
    }

    public int getNumAsyncWaitingTables() {
        return this.tableLoadingMgr_.numRemainingItems();
    }

    public int getNumAsyncLoadingTables() {
        return this.tableLoadingMgr_.numLoadsInProgress();
    }

    public int getNumDatabases() {
        return this.numDbs_;
    }

    public int getNumTables() {
        return this.numTables_;
    }

    public int getNumFunctions() {
        return this.numFunctions_;
    }

    public void watchCacheDirs(List<Long> dirIds, TTableName tblName, String reason) {
        this.tableLoadingMgr_.watchCacheDirs(dirIds, tblName, reason);
    }

    public void prioritizeLoad(List<TCatalogObject> objectDescs) {
        for (TCatalogObject catalogObject : objectDescs) {
            Preconditions.checkState((boolean)catalogObject.isSetTable());
            TTable table = catalogObject.getTable();
            this.tableLoadingMgr_.prioritizeLoad(new TTableName(table.getDb_name().toLowerCase(), table.getTbl_name().toLowerCase()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getPartitionStats(TGetPartitionStatsRequest request) throws CatalogException {
        long tableId;
        Table table;
        Preconditions.checkState((!RuntimeEnv.INSTANCE.isTestEnv() ? 1 : 0) != 0);
        TTableName tableName = request.table_name;
        LOG.info("Fetching partition statistics for: " + tableName.getDb_name() + "." + tableName.getTable_name());
        ValidWriteIdList writeIdList = null;
        if (request.valid_write_ids != null) {
            writeIdList = MetastoreShim.getValidWriteIdListFromThrift(new TableName(request.table_name.db_name, request.table_name.table_name).toString(), request.valid_write_ids);
        }
        if ((table = this.getOrLoadTable(tableName.db_name, tableName.table_name, "needed to fetch partition stats", writeIdList, tableId = request.getTable_id(), NoOpEventSequence.INSTANCE)) == null) {
            throw new CatalogException("Requested partition statistics for table that does not exist: " + request.table_name);
        }
        if (table instanceof IncompleteTable) {
            throw new CatalogException("No statistics available for incompletely loaded table: " + request.table_name, ((IncompleteTable)table).getCause());
        }
        Preconditions.checkArgument((boolean)(table instanceof HdfsTable), (String)"Partition statistics can only be requested for FS tables, type is: %s", (Object)table.getClass().getCanonicalName());
        Preconditions.checkState((boolean)table.isLoaded());
        HashMap<String, ByteBuffer> stats = new HashMap<String, ByteBuffer>();
        HdfsTable hdfsTable = (HdfsTable)table;
        hdfsTable.takeReadLock();
        try {
            Collection<? extends PrunablePartition> partitions = hdfsTable.getPartitions();
            for (PrunablePartition prunablePartition : partitions) {
                Preconditions.checkState((boolean)(prunablePartition instanceof FeFsPartition));
                FeFsPartition fsPartition = (FeFsPartition)((Object)prunablePartition);
                TPartitionStats partStats = fsPartition.getPartitionStats();
                if (partStats == null) continue;
                ByteBuffer compressedStats = ByteBuffer.wrap(fsPartition.getPartitionStatsCompressed());
                stats.put(FeCatalogUtils.getPartitionName(fsPartition), compressedStats);
            }
        }
        finally {
            hdfsTable.releaseReadLock();
        }
        LOG.info("Fetched partition statistics for " + stats.size() + " partitions on: " + hdfsTable.getFullName());
        return stats;
    }

    private PartitionMetaSummary createPartitionMetaSummary(String tableName) {
        return new PartitionMetaSummary(tableName, true, this.topicMode_ == TopicMode.FULL || this.topicMode_ == TopicMode.MIXED, this.topicMode_ == TopicMode.MINIMAL || this.topicMode_ == TopicMode.MIXED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCatalogDelta(long nativeCatalogServerPtr, long fromVersion) throws TException {
        GetCatalogDeltaContext ctx;
        this.versionLock_.readLock().lock();
        try {
            ctx = new GetCatalogDeltaContext(nativeCatalogServerPtr, fromVersion, this.catalogVersion_, this.lastResetStartVersion_);
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
        for (Db db : this.getAllDbs()) {
            ++ctx.numDbs;
            this.addDatabaseToCatalogDelta(db, ctx);
        }
        for (DataSource dataSource : this.getAllDataSources()) {
            this.addDataSourceToCatalogDelta(dataSource, ctx);
        }
        for (HdfsCachePool cachePool : this.getAllHdfsCachePools()) {
            this.addHdfsCachePoolToCatalogDelta(cachePool, ctx);
        }
        for (Role role : this.getAllRoles()) {
            this.addPrincipalToCatalogDelta(role, ctx);
        }
        for (User user : this.getAllUsers()) {
            this.addPrincipalToCatalogDelta(user, ctx);
        }
        for (AuthzCacheInvalidation authzCacheInvalidation : this.getAllAuthzCacheInvalidation()) {
            this.addAuthzCacheInvalidationToCatalogDelta(authzCacheInvalidation, ctx);
        }
        for (TCatalogObject removedObject : this.getDeletedObjects(ctx.fromVersion, ctx.toVersion)) {
            if (!ctx.updatedCatalogObjects.contains(Catalog.toCatalogObjectKey(removedObject))) {
                ctx.addCatalogObject(removedObject, true);
            }
            this.collectPartitionDeletion(ctx, removedObject);
        }
        TCatalogObject catalog = new TCatalogObject(TCatalogObjectType.CATALOG, ctx.toVersion);
        catalog.setCatalog(new TCatalog(JniCatalog.getServiceId(), ctx.lastResetStartVersion));
        ctx.addCatalogObject(catalog, false);
        this.deleteLog_.garbageCollect(ctx.toVersion);
        this.topicUpdateLog_.garbageCollectUpdateLogEntries(ctx.toVersion);
        this.lastSentTopicUpdate_.set(ctx.toVersion);
        TopicUpdateLog topicUpdateLog = this.topicUpdateLog_;
        synchronized (topicUpdateLog) {
            this.topicUpdateLog_.notifyAll();
        }
        this.numDbs_ = ctx.numDbs;
        this.numTables_ = ctx.numTables;
        this.numFunctions_ = ctx.numFunctions;
        return ctx.toVersion;
    }

    private void collectPartitionDeletion(GetCatalogDeltaContext ctx, TCatalogObject removedObject) throws TException {
        boolean collected;
        String partObjKey;
        TCatalogObject removedPart;
        if (!BackendConfig.INSTANCE.isIncrementalMetadataUpdatesEnabled() || removedObject.type != TCatalogObjectType.TABLE || removedObject.getTable().getTable_type() != TTableType.HDFS_TABLE) {
            return;
        }
        THdfsTable hdfsTable = removedObject.getTable().getHdfs_table();
        Preconditions.checkState((!hdfsTable.has_full_partitions && hdfsTable.has_partition_names ? 1 : 0) != 0, (Object)hdfsTable);
        String tblName = removedObject.getTable().db_name + "." + removedObject.getTable().tbl_name;
        PartitionMetaSummary deleteSummary = this.createPartitionMetaSummary(tblName);
        HashSet<String> collectedPartNames = new HashSet<String>();
        for (THdfsPartition part : hdfsTable.partitions.values()) {
            Preconditions.checkState((part.id >= 0L && part.db_name != null && part.tbl_name != null && part.partition_name != null ? 1 : 0) != 0, (Object)part);
            removedPart = new TCatalogObject(TCatalogObjectType.HDFS_PARTITION, removedObject.getCatalog_version());
            removedPart.setHdfs_partition(part);
            partObjKey = Catalog.toCatalogObjectKey(removedPart);
            collected = false;
            if (!ctx.updatedCatalogObjects.contains(partObjKey)) {
                ctx.addCatalogObject(removedPart, true, deleteSummary);
                collectedPartNames.add(part.partition_name);
                collected = true;
            }
            LOG.trace("{} deletion of {} id={} from the active partition set of a removed/invalidated table (version={})", new Object[]{collected ? "Collected" : "Skipped", partObjKey, part.id, removedObject.getCatalog_version()});
        }
        if (hdfsTable.isSetDropped_partitions()) {
            for (THdfsPartition part : hdfsTable.dropped_partitions) {
                if (collectedPartNames.contains(part.partition_name)) continue;
                removedPart = new TCatalogObject(TCatalogObjectType.HDFS_PARTITION, removedObject.getCatalog_version());
                removedPart.setHdfs_partition(part);
                partObjKey = Catalog.toCatalogObjectKey(removedPart);
                collected = false;
                if (!ctx.updatedCatalogObjects.contains(partObjKey)) {
                    ctx.addCatalogObject(removedPart, true, deleteSummary);
                    collected = true;
                }
                LOG.trace("{} deletion of {} id={} from the dropped partition set of a removed/invalidated table (version={})", new Object[]{collected ? "Collected" : "Skipped", partObjKey, part.id, removedObject.getCatalog_version()});
            }
        }
        if (deleteSummary.hasUpdates()) {
            LOG.info(deleteSummary.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluateSelfEvent(SelfEventContext ctx) throws CatalogException {
        Db db;
        Preconditions.checkState((boolean)this.isEventProcessingActive(), (Object)"Event processing should be enabled when calling this method");
        boolean isInsertEvent = ctx.isInsertEventContext();
        long versionNumber = isInsertEvent ? ctx.getInsertEventId(0) : ctx.getVersionNumberFromEvent();
        String serviceIdFromEvent = ctx.getServiceIdFromEvent();
        if (!isInsertEvent) {
            if (versionNumber == -1L || serviceIdFromEvent.isEmpty()) {
                LOG.debug("Not a self-event since the given version is {} and service id is {}", (Object)versionNumber, (Object)(serviceIdFromEvent.isEmpty() ? "empty" : serviceIdFromEvent));
                return false;
            }
            if (!this.getCatalogServiceId().equals(serviceIdFromEvent)) {
                LOG.debug("Not a self-event because service id of this catalog {} does not match with one in event {}.", (Object)this.getCatalogServiceId(), (Object)serviceIdFromEvent);
                return false;
            }
        } else if (versionNumber == -1L) {
            LOG.debug("Not a self-event because eventId is {}", (Object)versionNumber);
            return false;
        }
        if ((db = this.getDb(ctx.getDbName())) == null) {
            throw new DatabaseNotFoundException("Database " + ctx.getDbName() + " not found");
        }
        if (ctx.getTblName() == null) {
            return this.evaluateSelfEventForDb(db, versionNumber);
        }
        Table tbl = db.getTable(ctx.getTblName());
        if (tbl == null) {
            throw new TableNotFoundException(String.format("Table %s.%s not found", ctx.getDbName(), ctx.getTblName()));
        }
        if (ctx.getPartitionKeyValues() == null) {
            return this.evaluateSelfEventForTable(tbl, isInsertEvent, versionNumber);
        }
        if (!(tbl instanceof HdfsTable)) {
            return false;
        }
        if (!this.tryWriteLock(tbl)) {
            throw new CatalogException(String.format("Error during self-event evaluation for table %s due to lock contention", tbl.getFullName()));
        }
        this.versionLock_.writeLock().unlock();
        try {
            boolean bl = this.evaluateSelfEventForPartition(ctx, (HdfsTable)tbl, isInsertEvent, versionNumber);
            return bl;
        }
        finally {
            tbl.releaseWriteLock();
        }
    }

    private boolean evaluateSelfEventForDb(Db db, long versionNumber) throws CatalogException {
        boolean removed = db.removeFromVersionsForInflightEvents(versionNumber);
        if (!removed) {
            LOG.debug("Could not find version {} in the in-flight event list of database {}", (Object)versionNumber, (Object)db.getName());
        }
        return removed;
    }

    private boolean evaluateSelfEventForTable(Table tbl, boolean isInsertEvent, long versionNumber) throws CatalogException {
        boolean removed = tbl.removeFromVersionsForInflightEvents(isInsertEvent, versionNumber);
        if (!removed) {
            LOG.debug("Could not find {} {} in in-flight event list of table {}", new Object[]{isInsertEvent ? "eventId" : "version", versionNumber, tbl.getFullName()});
        }
        return removed;
    }

    private boolean evaluateSelfEventForPartition(SelfEventContext ctx, HdfsTable tbl, boolean isInsertEvent, long versionNumber) throws CatalogException {
        List<List<TPartitionKeyValue>> partitionKeyValues = ctx.getPartitionKeyValues();
        ArrayList<String> failingPartitions = new ArrayList<String>();
        int len = partitionKeyValues.size();
        for (int i = 0; i < len; ++i) {
            List<TPartitionKeyValue> partitionKeyValue = partitionKeyValues.get(i);
            versionNumber = isInsertEvent ? ctx.getInsertEventId(i) : versionNumber;
            HdfsPartition hdfsPartition = tbl.getPartitionFromThriftPartitionSpec(partitionKeyValue);
            if (hdfsPartition != null && hdfsPartition.removeFromVersionsForInflightEvents(isInsertEvent, versionNumber)) continue;
            String partName = HdfsTable.constructPartitionName(partitionKeyValue);
            if (hdfsPartition == null) {
                LOG.debug("Partition {} not found during self-event evaluation for the table {}", (Object)partName, (Object)tbl.getFullName());
            } else {
                LOG.trace("Could not find {} in in-flight event list of the partition {} of table {}", new Object[]{versionNumber, partName, tbl.getFullName()});
            }
            failingPartitions.add(partName);
        }
        return failingPartitions.isEmpty();
    }

    public boolean addVersionsForInflightEvents(boolean isInsertEvent, Table tbl, long versionNumber) {
        if (!this.isEventProcessingActive()) {
            return false;
        }
        boolean added = tbl.addToVersionsForInflightEvents(isInsertEvent, versionNumber);
        if (added) {
            LOG.info("Added {} {} in table's {} in-flight events", new Object[]{isInsertEvent ? "eventId" : "catalog version", versionNumber, tbl.getFullName()});
        }
        return added;
    }

    public boolean addVersionsForInflightEvents(Db db, long versionNumber) {
        if (!this.isEventProcessingActive()) {
            return false;
        }
        boolean added = db.addToVersionsForInflightEvents(versionNumber);
        if (added) {
            LOG.info("Added catalog version {} in database's {} in-flight events", (Object)versionNumber, (Object)db.getName());
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TCatalogObject> getDeletedObjects(long fromVersion, long toVersion) {
        this.versionLock_.readLock().lock();
        try {
            List<TCatalogObject> list = this.deleteLog_.retrieveObjects(fromVersion, toVersion);
            return list;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    List<Db> getAllDbs() {
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(((Map)this.dbCache_.get()).values());
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private List<DataSource> getAllDataSources() {
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.getDataSources());
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private List<HdfsCachePool> getAllHdfsCachePools() {
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)this.hdfsCachePools_);
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private List<Role> getAllRoles() {
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.authPolicy_.getAllRoles());
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private List<User> getAllUsers() {
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.authPolicy_.getAllUsers());
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private List<AuthzCacheInvalidation> getAllAuthzCacheInvalidation() {
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)this.authzCacheInvalidation_);
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private void addDatabaseToCatalogDelta(Db db, GetCatalogDeltaContext ctx) throws TException {
        long dbVersion = db.getCatalogVersion();
        if (dbVersion > ctx.fromVersion && dbVersion <= ctx.toVersion) {
            TCatalogObject catalogDb = new TCatalogObject(TCatalogObjectType.DATABASE, dbVersion);
            catalogDb.setDb(db.toThrift());
            ctx.addCatalogObject(catalogDb, false);
        }
        for (Table tbl : this.getAllTables(db)) {
            ++ctx.numTables;
            this.addTableToCatalogDelta(tbl, ctx);
        }
        for (Function fn : this.getAllFunctions(db)) {
            ++ctx.numFunctions;
            this.addFunctionToCatalogDelta(fn, ctx);
        }
    }

    List<Table> getAllTables(Db db) {
        Preconditions.checkNotNull((Object)db);
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(db.getTables());
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private List<Function> getAllFunctions(Db db) {
        Preconditions.checkNotNull((Object)db);
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(db.getFunctions(null, new PatternMatcher()));
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDbProperty(String dbName, String propertyKey) {
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)propertyKey);
        this.versionLock_.readLock().lock();
        try {
            Db db = this.getDb(dbName);
            if (db == null) {
                String string = null;
                return string;
            }
            if (!db.getMetaStoreDb().isSetParameters()) {
                String string = null;
                return string;
            }
            String string = (String)db.getMetaStoreDb().getParameters().get(propertyKey);
            return string;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableProperties(String dbName, String tblName, List<String> propertyKeys) {
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tblName);
        Preconditions.checkNotNull(propertyKeys);
        this.versionLock_.readLock().lock();
        try {
            Db db = this.getDb(dbName);
            if (db == null) {
                List<String> list = null;
                return list;
            }
            Table tbl = db.getTable(tblName);
            if (tbl == null || tbl instanceof IncompleteTable) {
                List<String> list = null;
                return list;
            }
            if (!tbl.getMetaStoreTable().isSetParameters()) {
                List<String> list = null;
                return list;
            }
            ArrayList propertyValues = new ArrayList(propertyKeys.size());
            for (String propertyKey : propertyKeys) {
                propertyValues.add(tbl.getMetaStoreTable().getParameters().get(propertyKey));
            }
            ArrayList arrayList = propertyValues;
            return arrayList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db updateDb(Database msDb) throws DatabaseNotFoundException {
        Preconditions.checkNotNull((Object)msDb);
        Preconditions.checkNotNull((Object)msDb.getName());
        this.versionLock_.writeLock().lock();
        try {
            Db db = this.getDb(msDb.getName());
            if (db == null) {
                throw new DatabaseNotFoundException("Database " + msDb.getName() + " not found");
            }
            db.setMetastoreDb(msDb.getName(), msDb);
            db.setCatalogVersion(this.incrementAndGetCatalogVersion());
            Db db2 = db;
            return db2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    private void addTableToCatalogDelta(Table tbl, GetCatalogDeltaContext ctx) throws TException {
        TopicUpdateLog.Entry topicUpdateEntry = this.topicUpdateLog_.getOrCreateLogEntry(tbl.getUniqueName());
        Preconditions.checkNotNull((Object)topicUpdateEntry);
        long tblVersion = tbl.getCatalogVersion();
        if (tblVersion <= ctx.toVersion) {
            boolean lockWithTimeout;
            boolean bl = lockWithTimeout = this.topicUpdateTblLockMaxWaitTimeMs_ > 0L && topicUpdateEntry.getNumSkippedUpdatesLockContention() < this.maxSkippedUpdatesLockContention_;
            if (this.topicUpdateTblLockMaxWaitTimeMs_ > 0L && !lockWithTimeout) {
                LOG.warn("Topic update thread blocking until lock is acquired for table {}", (Object)tbl.getFullName());
            }
            this.lockTableAndAddToCatalogDelta(tblVersion, tbl, ctx, lockWithTimeout);
        } else if (topicUpdateEntry.getNumSkippedTopicUpdates() == 2) {
            LOG.warn("Topic update thread blocking until lock is acquired for table {} since the table was already skipped {} number of times", (Object)tbl.getFullName(), (Object)2);
            this.lockTableAndAddToCatalogDelta(tblVersion, tbl, ctx, false);
        } else {
            LOG.info("Table {} (version={}) is skipping topic update ({}, {}]", new Object[]{tbl.getFullName(), tblVersion, ctx.fromVersion, ctx.toVersion});
            this.topicUpdateLog_.add(tbl.getUniqueName(), new TopicUpdateLog.Entry(topicUpdateEntry.getNumSkippedTopicUpdates() + 1, topicUpdateEntry.getLastSentVersion(), topicUpdateEntry.getLastSentCatalogUpdate(), topicUpdateEntry.getNumSkippedUpdatesLockContention()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockTableAndAddToCatalogDelta(long tblVersion, Table tbl, GetCatalogDeltaContext ctx, boolean lockWithTimeout) throws TException {
        long elapsedTime;
        Stopwatch sw = Stopwatch.createStarted();
        if (tbl instanceof HdfsTable && lockWithTimeout) {
            if (!this.lockHdfsTblWithTimeout(tblVersion, (HdfsTable)tbl, ctx)) {
                return;
            }
        } else {
            tbl.takeReadLock();
        }
        if ((elapsedTime = sw.stop().elapsed(TimeUnit.MILLISECONDS)) > 2000L) {
            LOG.debug("Time taken to acquire read lock on table {} for topic update {} ms", (Object)tbl.getFullName(), (Object)elapsedTime);
        }
        try {
            this.addTableToCatalogDeltaHelper(tbl, ctx);
        }
        finally {
            tbl.releaseReadLock();
        }
    }

    private boolean lockHdfsTblWithTimeout(long tblVersion, HdfsTable hdfsTable, GetCatalogDeltaContext ctx) {
        boolean pendingVersionUpdated;
        int maxAttempts = 2;
        int attemptCount = 0;
        do {
            ++attemptCount;
            long timeoutMs = this.topicUpdateTblLockMaxWaitTimeMs_ / 2L;
            boolean lockAcquired = this.tryLock(hdfsTable, false, timeoutMs);
            if (!lockAcquired) continue;
            this.versionLock_.writeLock().unlock();
            return true;
        } while (!(pendingVersionUpdated = hdfsTable.updatePendingVersion(tblVersion, this.incrementAndGetCatalogVersion())) && attemptCount != 2);
        TopicUpdateLog.Entry topicUpdateEntry = this.topicUpdateLog_.getOrCreateLogEntry(hdfsTable.getUniqueName());
        LOG.info("Table {} (version={}, lastSeen={}) is skipping topic update ({}, {}] due to lock contention", new Object[]{hdfsTable.getFullName(), tblVersion, hdfsTable.getLastVersionSeenByTopicUpdate(), ctx.fromVersion, ctx.toVersion});
        if (hdfsTable.getLastVersionSeenByTopicUpdate() != tblVersion) {
            this.topicUpdateLog_.add(hdfsTable.getUniqueName(), new TopicUpdateLog.Entry(topicUpdateEntry.getNumSkippedTopicUpdates(), topicUpdateEntry.getLastSentVersion(), topicUpdateEntry.getLastSentCatalogUpdate(), topicUpdateEntry.getNumSkippedUpdatesLockContention() + 1));
            hdfsTable.setLastVersionSeenByTopicUpdate(tblVersion);
        }
        return false;
    }

    private void addTableToCatalogDeltaHelper(Table tbl, GetCatalogDeltaContext ctx) throws TException {
        Preconditions.checkState((boolean)tbl.isReadLockedByCurrentThread(), (Object)("Topic update thread does not hold a lock on table " + tbl.getFullName() + " while generating catalog delta"));
        TCatalogObject catalogTbl = new TCatalogObject(TCatalogObjectType.TABLE, 0L);
        long tblVersion = tbl.getCatalogVersion();
        if (tblVersion <= ctx.fromVersion) {
            LOG.trace("Table {} version {} skipping the update ({}, {}]", new Object[]{tbl.getFullName(), tbl.getCatalogVersion(), ctx.fromVersion, ctx.toVersion});
            return;
        }
        String tableUniqueName = tbl.getUniqueName();
        TopicUpdateLog.Entry topicUpdateEntry = this.topicUpdateLog_.getOrCreateLogEntry(tableUniqueName);
        if (tblVersion > ctx.toVersion && topicUpdateEntry.getNumSkippedTopicUpdates() < 2) {
            LOG.info("Table " + tbl.getFullName() + " is skipping topic update " + ctx.toVersion);
            this.topicUpdateLog_.add(tableUniqueName, new TopicUpdateLog.Entry(topicUpdateEntry.getNumSkippedTopicUpdates() + 1, topicUpdateEntry.getLastSentVersion(), topicUpdateEntry.getLastSentCatalogUpdate(), topicUpdateEntry.getNumSkippedUpdatesLockContention()));
            return;
        }
        try {
            if (BackendConfig.INSTANCE.isIncrementalMetadataUpdatesEnabled() && tbl instanceof HdfsTable) {
                catalogTbl.setTable(((HdfsTable)tbl).toThriftWithMinimalPartitions());
                this.addHdfsPartitionsToCatalogDelta((HdfsTable)tbl, ctx);
            } else {
                catalogTbl.setTable(tbl.toThrift());
            }
            if (TImpalaTableType.VIEW == tbl.getTableType()) {
                catalogTbl.setType(TCatalogObjectType.VIEW);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Error calling toThrift() on table %s: %s", tbl.getFullName(), e.getMessage()), (Throwable)e);
            return;
        }
        catalogTbl.setCatalog_version(tbl.getCatalogVersion());
        ctx.addCatalogObject(catalogTbl, false);
    }

    private void addHdfsPartitionsToCatalogDelta(HdfsTable hdfsTable, GetCatalogDeltaContext ctx) throws TException {
        if (ctx.isFullUpdate()) {
            hdfsTable.resetMaxSentPartitionId();
        }
        PartitionMetaSummary updateSummary = this.createPartitionMetaSummary(hdfsTable.getFullName());
        long maxSentId = hdfsTable.getMaxSentPartitionId();
        for (TCatalogObject catalogPart : hdfsTable.getNewPartitionsSinceLastUpdate()) {
            maxSentId = Math.max(maxSentId, catalogPart.getHdfs_partition().getId());
            ctx.addCatalogObject(catalogPart, false, updateSummary);
        }
        hdfsTable.setMaxSentPartitionId(maxSentId);
        for (HdfsPartition part : hdfsTable.getDroppedPartitions()) {
            TCatalogObject removedPart = part.toMinimalTCatalogObject();
            if (ctx.updatedCatalogObjects.contains(Catalog.toCatalogObjectKey(removedPart))) continue;
            ctx.addCatalogObject(removedPart, true, updateSummary);
        }
        hdfsTable.resetDroppedPartitions();
        if (updateSummary.hasUpdates()) {
            LOG.info(updateSummary.toString());
        }
    }

    private void addFunctionToCatalogDelta(Function fn, GetCatalogDeltaContext ctx) throws TException {
        long fnVersion = fn.getCatalogVersion();
        if (ctx.versionNotInRange(fnVersion)) {
            return;
        }
        TCatalogObject function = new TCatalogObject(TCatalogObjectType.FUNCTION, fnVersion);
        function.setFn(fn.toThrift());
        ctx.addCatalogObject(function, false);
    }

    private void addDataSourceToCatalogDelta(DataSource dataSource, GetCatalogDeltaContext ctx) throws TException {
        long dsVersion = dataSource.getCatalogVersion();
        if (ctx.versionNotInRange(dsVersion)) {
            return;
        }
        TCatalogObject catalogObj = new TCatalogObject(TCatalogObjectType.DATA_SOURCE, dsVersion);
        catalogObj.setData_source(dataSource.toThrift());
        ctx.addCatalogObject(catalogObj, false);
    }

    private void addHdfsCachePoolToCatalogDelta(HdfsCachePool cachePool, GetCatalogDeltaContext ctx) throws TException {
        long cpVersion = cachePool.getCatalogVersion();
        if (ctx.versionNotInRange(cpVersion)) {
            return;
        }
        TCatalogObject pool = new TCatalogObject(TCatalogObjectType.HDFS_CACHE_POOL, cpVersion);
        pool.setCache_pool(cachePool.toThrift());
        ctx.addCatalogObject(pool, false);
    }

    private void addPrincipalToCatalogDelta(Principal principal, GetCatalogDeltaContext ctx) throws TException {
        long principalVersion = principal.getCatalogVersion();
        if (!ctx.versionNotInRange(principalVersion)) {
            TCatalogObject thriftPrincipal = new TCatalogObject(TCatalogObjectType.PRINCIPAL, principalVersion);
            thriftPrincipal.setPrincipal(principal.toThrift());
            ctx.addCatalogObject(thriftPrincipal, false);
        }
        for (PrincipalPrivilege p : this.getAllPrivileges(principal)) {
            this.addPrincipalPrivilegeToCatalogDelta(p, ctx);
        }
    }

    private List<PrincipalPrivilege> getAllPrivileges(Principal principal) {
        Preconditions.checkNotNull((Object)principal);
        this.versionLock_.readLock().lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(principal.getPrivileges());
            return immutableList;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private void addPrincipalPrivilegeToCatalogDelta(PrincipalPrivilege priv, GetCatalogDeltaContext ctx) throws TException {
        long privVersion = priv.getCatalogVersion();
        if (ctx.versionNotInRange(privVersion)) {
            return;
        }
        TCatalogObject privilege = new TCatalogObject(TCatalogObjectType.PRIVILEGE, privVersion);
        privilege.setPrivilege(priv.toThrift());
        ctx.addCatalogObject(privilege, false);
    }

    private void addAuthzCacheInvalidationToCatalogDelta(AuthzCacheInvalidation authzCacheInvalidation, GetCatalogDeltaContext ctx) throws TException {
        long authzCacheInvalidationVersion = authzCacheInvalidation.getCatalogVersion();
        if (ctx.versionNotInRange(authzCacheInvalidationVersion)) {
            return;
        }
        TCatalogObject catalogObj = new TCatalogObject(TCatalogObjectType.AUTHZ_CACHE_INVALIDATION, authzCacheInvalidationVersion);
        catalogObj.setAuthz_cache_invalidation(authzCacheInvalidation.toThrift());
        ctx.addCatalogObject(catalogObj, false);
    }

    public List<Function> getFunctions(String dbName) throws DatabaseNotFoundException {
        Db db = this.getDb(dbName);
        if (db == null) {
            throw new DatabaseNotFoundException("Database does not exist: " + dbName);
        }
        Map<String, List<Function>> dbFns = db.getAllFunctions();
        ArrayList<Function> fns = new ArrayList<Function>(dbFns.size());
        for (List<Function> fnOverloads : dbFns.values()) {
            for (Function fn : fnOverloads) {
                fns.add(fn);
            }
        }
        return fns;
    }

    private void loadFunctionsFromDbParams(Db db, Database msDb) {
        if (msDb == null || msDb.getParameters() == null) {
            return;
        }
        LOG.info("Loading native functions for database: " + db.getName());
        List<Function> funcs = FunctionUtils.deserializeNativeFunctionsFromDbParams(msDb.getParameters());
        for (Function f : funcs) {
            db.addFunction(f, false);
            f.setCatalogVersion(this.incrementAndGetCatalogVersion());
        }
        LOG.info("Loaded {} native functions for database: {}", (Object)funcs.size(), (Object)db.getName());
    }

    private void loadJavaFunctions(Db db, List<org.apache.hadoop.hive.metastore.api.Function> functions) {
        Preconditions.checkNotNull(functions);
        if (BackendConfig.INSTANCE.disableCatalogDataOpsDebugOnly()) {
            LOG.info("Skip loading Java functions: catalog data ops disabled.");
            return;
        }
        LOG.info("Loading Java functions for database: " + db.getName());
        int numFuncs = 0;
        for (org.apache.hadoop.hive.metastore.api.Function function : functions) {
            try {
                HiveJavaFunctionFactoryImpl factory = new HiveJavaFunctionFactoryImpl(this.localLibraryPath_);
                HiveJavaFunction javaFunction = factory.create(function);
                for (Function function2 : javaFunction.extract()) {
                    db.addFunction(function2);
                    function2.setCatalogVersion(this.incrementAndGetCatalogVersion());
                    ++numFuncs;
                }
            }
            catch (Exception | LinkageError e) {
                LOG.error("Skipping function load: " + function.getFunctionName(), e);
            }
        }
        LOG.info("Loaded {} Java functions for database: {}", (Object)numFuncs, (Object)db.getName());
    }

    public void refreshFunctions(MetaStoreClientPool.MetaStoreClient msClient, String dbName, List<TCatalogObject> addedFuncs, List<TCatalogObject> removedFuncs) throws CatalogException {
        try {
            ArrayList<org.apache.hadoop.hive.metastore.api.Function> javaFns = new ArrayList<org.apache.hadoop.hive.metastore.api.Function>();
            for (String javaFn : msClient.getHiveClient().getFunctions(dbName, "*")) {
                javaFns.add(msClient.getHiveClient().getFunction(dbName, javaFn));
            }
            Database msDb = msClient.getHiveClient().getDatabase(dbName);
            Db tmpDb = new Db(dbName, msDb);
            this.loadFunctionsFromDbParams(tmpDb, msDb);
            this.loadJavaFunctions(tmpDb, javaFns);
            Db db = this.getDb(dbName);
            if (db == null) {
                throw new DatabaseNotFoundException("Database does not exist: " + dbName);
            }
            for (Function function : db.getTransientFunctions()) {
                tmpDb.addFunction(function);
            }
            for (Map.Entry entry : db.getAllFunctions().entrySet()) {
                for (Function fn : (List)entry.getValue()) {
                    if (tmpDb.getFunction(fn, Function.CompareMode.IS_INDISTINGUISHABLE) != null) continue;
                    fn.setCatalogVersion(this.incrementAndGetCatalogVersion());
                    removedFuncs.add(fn.toTCatalogObject());
                }
            }
            db.removeAllFunctions();
            for (Map.Entry entry : tmpDb.getAllFunctions().entrySet()) {
                for (Function fn : (List)entry.getValue()) {
                    db.addFunction(fn);
                    addedFuncs.add(fn.toTCatalogObject());
                }
            }
        }
        catch (Exception e) {
            throw new CatalogException("Error refreshing functions in " + dbName + ": ", e);
        }
    }

    public void refreshDataSources() throws TException {
        Map<String, DataSource> newDataSrcs = null;
        try (MetaStoreClientPool.MetaStoreClient msClient = this.getMetaStoreClient();){
            newDataSrcs = MetastoreShim.loadAllDataSources(msClient.getHiveClient());
            if (newDataSrcs == null) {
                return;
            }
        }
        Set<String> oldDataSrcNames = this.dataSources_.keySet();
        Set<String> newDataSrcNames = newDataSrcs.keySet();
        oldDataSrcNames.removeAll(newDataSrcNames);
        int removedDataSrcNum = 0;
        for (String dataSrcName : oldDataSrcNames) {
            DataSource dataSrc = (DataSource)this.dataSources_.remove(dataSrcName);
            if (dataSrc == null) continue;
            dataSrc.setCatalogVersion(this.incrementAndGetCatalogVersion());
            this.deleteLog_.addRemovedObject(dataSrc.toTCatalogObject());
            ++removedDataSrcNum;
        }
        for (DataSource dataSrc : newDataSrcs.values()) {
            dataSrc.setCatalogVersion(this.incrementAndGetCatalogVersion());
            this.dataSources_.add(dataSrc);
        }
        LOG.info("Finished refreshing DataSources. Added {}. Removed {}.", (Object)newDataSrcs.size(), (Object)removedDataSrcNum);
    }

    private List<TableMeta> getTableMetaFromHive(MetaStoreClientPool.MetaStoreClient msClient, String dbName, @Nullable String tblName) throws TException {
        if (BackendConfig.INSTANCE.pullTableTypesAndComments()) {
            return msClient.getHiveClient().getTableMeta(dbName, tblName, null);
        }
        ArrayList res = Lists.newArrayList();
        if (tblName == null) {
            for (String tableName : msClient.getHiveClient().getAllTables(dbName)) {
                res.add(new TableMeta(dbName, tableName, null));
            }
        } else if (msClient.getHiveClient().tableExists(dbName, tblName)) {
            res.add(new TableMeta(dbName, tblName, null));
        }
        return res;
    }

    private Pair<Db, List<TTableName>> invalidateDb(MetaStoreClientPool.MetaStoreClient msClient, String dbName, Db existingDb, EventSequence catalogTimeline) {
        try {
            ArrayList<org.apache.hadoop.hive.metastore.api.Function> javaFns = new ArrayList<org.apache.hadoop.hive.metastore.api.Function>();
            for (String javaFn : msClient.getHiveClient().getFunctions(dbName, "*")) {
                javaFns.add(msClient.getHiveClient().getFunction(dbName, javaFn));
            }
            Database msDb = msClient.getHiveClient().getDatabase(dbName);
            Db newDb = new Db(dbName, msDb);
            if (existingDb != null) {
                for (Function fn : existingDb.getTransientFunctions()) {
                    newDb.addFunction(fn);
                    fn.setCatalogVersion(this.incrementAndGetCatalogVersion());
                }
            }
            this.loadFunctionsFromDbParams(newDb, msDb);
            this.loadJavaFunctions(newDb, javaFns);
            newDb.setCatalogVersion(this.incrementAndGetCatalogVersion());
            catalogTimeline.markEvent("Loaded functions of " + dbName);
            LOG.info("Loading table list for database: {}", (Object)dbName);
            int numTables = 0;
            ArrayList<TTableName> tblsToBackgroundLoad = new ArrayList<TTableName>();
            for (TableMeta tableMeta : this.getTableMetaFromHive(msClient, dbName, null)) {
                String tableName = tableMeta.getTableName().toLowerCase();
                if (this.isBlacklistedTable(dbName, tableName)) {
                    LOG.info("skip blacklisted table: " + dbName + "." + tableName);
                    continue;
                }
                LOG.trace("Get {}", (Object)tableMeta);
                IncompleteTable incompleteTbl = IncompleteTable.createUninitializedTable(newDb, tableName, MetastoreShim.mapToInternalTableType(tableMeta.getTableType()), tableMeta.getComments());
                incompleteTbl.setCatalogVersion(this.incrementAndGetCatalogVersion());
                newDb.addTable(incompleteTbl);
                ++numTables;
                if (!this.loadInBackground_) continue;
                tblsToBackgroundLoad.add(new TTableName(dbName, tableName));
            }
            catalogTimeline.markEvent(String.format("Loaded %d table names of database %s", numTables, dbName));
            LOG.info("Loaded table list for database: {}. Number of tables: {}", (Object)dbName, (Object)numTables);
            if (existingDb != null) {
                for (Map.Entry entry : existingDb.getAllFunctions().entrySet()) {
                    for (Function fn : (List)entry.getValue()) {
                        if (newDb.getFunction(fn, Function.CompareMode.IS_INDISTINGUISHABLE) != null) continue;
                        fn.setCatalogVersion(this.incrementAndGetCatalogVersion());
                        this.deleteLog_.addRemovedObject(fn.toTCatalogObject());
                    }
                }
                HashSet oldTableNames = Sets.newHashSet(existingDb.getAllTableNames());
                HashSet hashSet = Sets.newHashSet(newDb.getAllTableNames());
                oldTableNames.removeAll(hashSet);
                for (String removedTableName : oldTableNames) {
                    IncompleteTable removedTable = IncompleteTable.createUninitializedTableForRemove(existingDb, removedTableName);
                    removedTable.setCatalogVersion(this.incrementAndGetCatalogVersion());
                    this.deleteLog_.addRemovedObject(removedTable.toTCatalogObject());
                }
            }
            return Pair.create(newDb, tblsToBackgroundLoad);
        }
        catch (Exception e) {
            LOG.warn("Encountered an exception while invalidating database: " + dbName + ". Ignoring further load of this db.", (Throwable)e);
            return null;
        }
    }

    public AuthorizationDelta refreshAuthorization(boolean resetVersions) throws CatalogException {
        Preconditions.checkState((this.authzManager_ != null ? 1 : 0) != 0);
        try {
            return this.authzManager_.refreshAuthorization(resetVersions);
        }
        catch (Exception e) {
            throw new CatalogException("Error refreshing authorization policy: ", e);
        }
    }

    public long reset(EventSequence catalogTimeline) throws CatalogException {
        long currentEventId;
        long startVersion = this.getCatalogVersion();
        LOG.info("Invalidating all metadata. Version: " + startVersion);
        this.refreshAuthorization(true);
        try {
            currentEventId = this.metastoreEventProcessor_.getCurrentEventId();
        }
        catch (MetastoreNotificationFetchException e) {
            throw new CatalogException("Failed to fetch current event id", e);
        }
        this.metastoreEventProcessor_.pause();
        try {
            if (FileSystemUtil.isDistributedFileSystem(FileSystemUtil.getDefaultFileSystem())) {
                CachePoolReader reader = new CachePoolReader(true);
                reader.run();
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't identify the default FS. Cache Pool reader will be disabled.");
        }
        this.versionLock_.writeLock().lock();
        catalogTimeline.markEvent(GOT_CATALOG_VERSION_WRITE_LOCK);
        ++this.catalogVersion_;
        try {
            this.refreshDataSources();
            Map oldDbCache = (Map)this.dbCache_.get();
            ConcurrentHashMap newDbCache = new ConcurrentHashMap();
            ArrayList tblsToBackgroundLoad = new ArrayList();
            try (MetaStoreClientPool.MetaStoreClient msClient = this.getMetaStoreClient(catalogTimeline);){
                List allDbs = msClient.getHiveClient().getAllDatabases();
                catalogTimeline.markEvent("Got database list");
                int numComplete = 0;
                for (String dbName : allDbs) {
                    if (this.isBlacklistedDb(dbName)) {
                        LOG.info("skip blacklisted db: " + dbName);
                        continue;
                    }
                    String annotation = String.format("invalidating metadata - %s/%s dbs complete", numComplete++, allDbs.size());
                    ThreadNameAnnotator tna = new ThreadNameAnnotator(annotation);
                    Throwable throwable = null;
                    try {
                        dbName = dbName.toLowerCase();
                        Db oldDb = (Db)oldDbCache.get(dbName);
                        Pair<Db, List<TTableName>> invalidatedDb = this.invalidateDb(msClient, dbName, oldDb, catalogTimeline);
                        if (invalidatedDb == null) continue;
                        newDbCache.put(dbName, invalidatedDb.first);
                        tblsToBackgroundLoad.addAll((Collection)invalidatedDb.second);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tna == null) continue;
                        if (throwable != null) {
                            try {
                                tna.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tna.close();
                    }
                }
            }
            this.dbCache_.set(newDbCache);
            catalogTimeline.markEvent("Updated catalog cache");
            Set oldDbNames = oldDbCache.keySet();
            Set newDbNames = newDbCache.keySet();
            oldDbNames.removeAll(newDbNames);
            for (String dbName : oldDbNames) {
                Db removedDb = (Db)oldDbCache.get(dbName);
                this.updateDeleteLog(removedDb);
            }
            for (TTableName tblName : tblsToBackgroundLoad) {
                this.tableLoadingMgr_.backgroundLoad(tblName);
            }
        }
        catch (Exception e) {
            LOG.error("Error initializing Catalog", (Throwable)e);
            throw new CatalogException("Error initializing Catalog. Catalog may be empty.", e);
        }
        finally {
            if (this.lastResetStartVersion_ < startVersion) {
                this.lastResetStartVersion_ = startVersion;
            }
            this.versionLock_.writeLock().unlock();
            this.clearWriteIds();
            this.metastoreEventProcessor_.start(currentEventId);
        }
        LOG.info("Invalidated all metadata.");
        return startVersion;
    }

    public Db addDb(String dbName, Database msDb) {
        return this.addDb(dbName, msDb, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db addDb(String dbName, Database msDb, long eventId) {
        Db newDb = new Db(dbName, msDb);
        this.versionLock_.writeLock().lock();
        try {
            newDb.setCatalogVersion(this.incrementAndGetCatalogVersion());
            newDb.setCreateEventId(eventId);
            this.addDb(newDb);
            Db db = newDb;
            return db;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Db removeDb(String dbName) {
        this.versionLock_.writeLock().lock();
        try {
            Db removedDb = super.removeDb(dbName);
            if (removedDb != null) {
                this.updateDeleteLog(removedDb);
            }
            Db db = removedDb;
            return db;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    private void updateDeleteLog(Db db) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkState((boolean)this.versionLock_.isWriteLockedByCurrentThread());
        if (!db.isSystemDb()) {
            for (Table tbl : db.getTables()) {
                tbl.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(tbl.toMinimalTCatalogObject());
            }
            for (Function fn : db.getFunctions(null, new PatternMatcher())) {
                fn.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(fn.toTCatalogObject());
            }
        }
        db.setCatalogVersion(this.incrementAndGetCatalogVersion());
        this.deleteLog_.addRemovedObject(db.toTCatalogObject());
    }

    public Table addIncompleteTable(String dbName, String tblName, TImpalaTableType tblType, String tblComment) {
        return this.addIncompleteTable(dbName, tblName, tblType, tblComment, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table addIncompleteTable(String dbName, String tblName, TImpalaTableType tblType, String tblComment, long createEventId) {
        this.versionLock_.writeLock().lock();
        try {
            Db db = this.getDb(dbName);
            if (db == null) {
                Table table = null;
                return table;
            }
            Table existingTbl = db.getTable(tblName);
            if (existingTbl instanceof HdfsTable) {
                existingTbl.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(existingTbl.toMinimalTCatalogObject());
            }
            IncompleteTable incompleteTable = IncompleteTable.createUninitializedTable(db, tblName, tblType, tblComment);
            incompleteTable.setCatalogVersion(this.incrementAndGetCatalogVersion());
            incompleteTable.setCreateEventId(createEventId);
            db.addTable(incompleteTable);
            Table table = db.getTable(tblName);
            return table;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public Table addTable(Db db, Table table) {
        this.versionLock_.writeLock().lock();
        try {
            ((Db)Preconditions.checkNotNull((Object)db)).addTable((Table)Preconditions.checkNotNull((Object)table));
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
        return table;
    }

    public Table getOrLoadTable(String dbName, String tblName, String reason, ValidWriteIdList validWriteIdList) throws CatalogException {
        return this.getOrLoadTable(dbName, tblName, reason, validWriteIdList, -1L, NoOpEventSequence.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getOrLoadTable(String dbName, String tblName, String reason, ValidWriteIdList validWriteIdList, long tableId, EventSequence catalogTimeline) throws CatalogException {
        Table tbl;
        long previousCatalogVersion;
        List<Object> partsToBeRefreshed;
        TableLoadingMgr.LoadRequest loadReq;
        block20: {
            TTableName tableName = new TTableName(dbName.toLowerCase(), tblName.toLowerCase());
            loadReq = null;
            partsToBeRefreshed = Collections.emptyList();
            previousCatalogVersion = -1L;
            this.acquireVersionReadLock(catalogTimeline);
            try {
                tbl = this.getTable(dbName, tblName);
                if (tbl == null) {
                    Table table = null;
                    return table;
                }
                LOG.trace("table {} exits in cache, last synced id {}", (Object)tbl.getFullName(), (Object)tbl.getLastSyncedEventId());
                boolean isLoaded = tbl.isLoaded();
                if (isLoaded && tbl instanceof IncompleteTable && ((IncompleteTable)tbl).isLoadFailedByRecoverableError()) {
                    isLoaded = false;
                }
                if (isLoaded && (validWriteIdList == null || !AcidUtils.isTransactionalTable(tbl.getMetaStoreTable().getParameters()))) {
                    this.incrementCatalogDCacheHitMetric(reason);
                    LOG.trace("returning already loaded table {}", (Object)tbl.getFullName());
                    Table table = tbl;
                    return table;
                }
                if (tbl instanceof HdfsTable && AcidUtils.compare((HdfsTable)tbl, validWriteIdList, tableId) >= 0) {
                    this.incrementCatalogDCacheHitMetric(reason);
                    Preconditions.checkState((boolean)AcidUtils.isTransactionalTable(tbl.getMetaStoreTable().getParameters()), (Object)("Compaction id check cannot be done for non-transactional table " + tbl.getFullName()));
                    this.readLock(tbl, catalogTimeline);
                    try {
                        partsToBeRefreshed = AcidUtils.getPartitionsForRefreshingFileMetadata(this, (HdfsTable)tbl);
                    }
                    finally {
                        tbl.readLock().unlock();
                    }
                    if (partsToBeRefreshed.isEmpty()) {
                        Table table = tbl;
                        return table;
                    }
                    break block20;
                }
                CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter("catalogd-hms-cache.miss").inc();
                if (HmsApiNameEnum.contains(reason)) {
                    CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(String.format("catalogd-hms-cache.cache-miss.api.%s", reason)).inc();
                }
                previousCatalogVersion = tbl.getCatalogVersion();
                LOG.trace("Loading full table {}", (Object)tbl.getFullName());
                loadReq = this.tableLoadingMgr_.loadAsync(tableName, tbl.getCreateEventId(), reason, catalogTimeline);
            }
            finally {
                this.versionLock_.readLock().unlock();
            }
        }
        if (!partsToBeRefreshed.isEmpty()) {
            return this.refreshFileMetadata((HdfsTable)tbl, partsToBeRefreshed, catalogTimeline);
        }
        Preconditions.checkNotNull((Object)loadReq);
        try {
            Table t = loadReq.get();
            catalogTimeline.markEvent("Async loaded table");
            Table table = this.replaceTableIfUnchanged(t, previousCatalogVersion, tableId);
            return table;
        }
        finally {
            loadReq.close();
        }
    }

    private void incrementCatalogDCacheHitMetric(String reason) {
        CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter("catalogd-hms-cache.hit").inc();
        if (HmsApiNameEnum.contains(reason)) {
            CatalogMonitor.INSTANCE.getCatalogdHmsCacheMetrics().getCounter(String.format("catalogd-hms-cache.cache-hit.api.%s", reason)).inc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table replaceTableIfUnchanged(Table updatedTbl, long expectedCatalogVersion, long tableId) throws DatabaseNotFoundException {
        this.versionLock_.writeLock().lock();
        try {
            Db db = this.getDb(updatedTbl.getDb().getName());
            if (db == null) {
                throw new DatabaseNotFoundException("Database does not exist: " + updatedTbl.getDb().getName());
            }
            Table existingTbl = db.getTable(updatedTbl.getName());
            if (existingTbl == null || existingTbl.getCatalogVersion() != expectedCatalogVersion && (!(existingTbl instanceof HdfsTable) || AcidUtils.compare((HdfsTable)existingTbl, updatedTbl.getValidWriteIds(), tableId) >= 0)) {
                LOG.trace("returning existing table {} with last synced id: ", (Object)existingTbl.getFullName(), (Object)existingTbl.getLastSyncedEventId());
                Table table = existingTbl;
                return table;
            }
            if (existingTbl instanceof HdfsTable) {
                existingTbl.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(existingTbl.toMinimalTCatalogObject());
            }
            updatedTbl.setCatalogVersion(this.incrementAndGetCatalogVersion());
            db.addTable(updatedTbl);
            Table table = updatedTbl;
            return table;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table removeTable(String dbName, String tblName) {
        Db parentDb = this.getDb(dbName);
        if (parentDb == null) {
            return null;
        }
        this.versionLock_.writeLock().lock();
        try {
            Table removedTable = parentDb.removeTable(tblName);
            if (removedTable != null && !removedTable.isStoredInImpaladCatalogCache()) {
                CatalogMonitor.INSTANCE.getCatalogTableMetrics().removeTable(removedTable);
            }
            if (removedTable != null) {
                removedTable.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(removedTable.toMinimalTCatalogObject());
            }
            Table table = removedTable;
            return table;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function removeFunction(Function desc) {
        this.versionLock_.writeLock().lock();
        try {
            Function removedFn = super.removeFunction(desc);
            if (removedFn != null) {
                removedFn.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(removedFn.toTCatalogObject());
            }
            Function function = removedFn;
            return function;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFunction(Function fn) {
        Db db = this.getDb(fn.getFunctionName().getDb());
        if (db == null) {
            return false;
        }
        this.versionLock_.writeLock().lock();
        try {
            if (db.addFunction(fn)) {
                fn.setCatalogVersion(this.incrementAndGetCatalogVersion());
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
        return false;
    }

    @Override
    public boolean addDataSource(DataSource dataSource) {
        this.versionLock_.writeLock().lock();
        try {
            if (this.dataSources_.add(dataSource)) {
                dataSource.setCatalogVersion(this.incrementAndGetCatalogVersion());
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource removeDataSource(String dataSourceName) {
        this.versionLock_.writeLock().lock();
        try {
            DataSource dataSource = (DataSource)this.dataSources_.remove(dataSourceName);
            if (dataSource != null) {
                dataSource.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(dataSource.toTCatalogObject());
            }
            DataSource dataSource2 = dataSource;
            return dataSource2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Table, Table> renameTable(TTableName oldTableName, TTableName newTableName) {
        Db db = this.getDb(oldTableName.getDb_name());
        if (db == null) {
            return null;
        }
        this.versionLock_.writeLock().lock();
        try {
            Table oldTable = this.removeTable(oldTableName.getDb_name(), oldTableName.getTable_name());
            if (oldTable == null) {
                Pair<Object, Object> pair = Pair.create(null, null);
                return pair;
            }
            Pair<Table, Table> pair = Pair.create(oldTable, this.addIncompleteTable(newTableName.getDb_name(), newTableName.getTable_name(), oldTable.getTableType(), oldTable.getTableComment(), oldTable.getCreateEventId()));
            return pair;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public void reloadTable(Table tbl, String reason, EventSequence catalogTimeline) throws CatalogException {
        this.reloadTable(tbl, reason, -1L, false, catalogTimeline);
    }

    public void reloadTable(Table tbl, String reason, long eventId, boolean isSkipFileMetadataReload, EventSequence catalogTimeline) throws CatalogException {
        this.reloadTable(tbl, new TResetMetadataRequest(), CatalogObject.ThriftObjectType.NONE, reason, eventId, isSkipFileMetadataReload, catalogTimeline);
    }

    public TCatalogObject reloadTable(Table tbl, TResetMetadataRequest request, CatalogObject.ThriftObjectType resultType, String reason, long eventId, EventSequence catalogTimeline) throws CatalogException {
        return this.reloadTable(tbl, request, resultType, reason, eventId, false, catalogTimeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCatalogObject reloadTable(Table tbl, TResetMetadataRequest request, CatalogObject.ThriftObjectType resultType, String reason, long eventId, boolean isSkipFileMetadataReload, EventSequence catalogTimeline) throws CatalogException {
        LOG.info(String.format("Refreshing table metadata: %s", tbl.getFullName()));
        Preconditions.checkState((!(tbl instanceof IncompleteTable) ? 1 : 0) != 0);
        String dbName = tbl.getDb().getName();
        String tblName = tbl.getName();
        if (!this.tryWriteLock(tbl, catalogTimeline)) {
            throw new CatalogException(String.format("Error refreshing metadata for table %s due to lock contention", tbl.getFullName()));
        }
        long newCatalogVersion = this.incrementAndGetCatalogVersion();
        this.versionLock_.writeLock().unlock();
        boolean syncToLatestEventId = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
        Timer.Context context = tbl.getMetrics().getTimer("refresh-duration").time();
        try {
            boolean isFullReloadOnTable;
            if (eventId != -1L && tbl.getLastSyncedEventId() != -1L && tbl.getLastSyncedEventId() >= eventId) {
                LOG.info("Not reloading table for event id: {} since table is already synced till event id: {}", (Object)eventId, (Object)tbl.getLastSyncedEventId());
                TCatalogObject tCatalogObject = tbl.toTCatalogObject(resultType);
                return tCatalogObject;
            }
            long currentHmsEventId = -1L;
            Serializable serializable = null;
            try (MetaStoreClientPool.MetaStoreClient msClient = this.getMetaStoreClient(catalogTimeline);){
                if (syncToLatestEventId) {
                    try {
                        currentHmsEventId = msClient.getHiveClient().getCurrentNotificationEventId().getEventId();
                        catalogTimeline.markEvent("Got current Metastore event id " + currentHmsEventId);
                    }
                    catch (TException e) {
                        throw new CatalogException("Failed to reload table: " + tbl.getFullName() + " as there was an error in fetching current event id from HMS", e);
                    }
                }
                org.apache.hadoop.hive.metastore.api.Table msTbl = null;
                try {
                    msTbl = msClient.getHiveClient().getTable(dbName, tblName);
                    catalogTimeline.markEvent("Fetched table from Metastore");
                }
                catch (Exception e) {
                    throw new TableLoadingException("Error loading metadata for table: " + dbName + "." + tblName, e);
                }
                if (tbl instanceof HdfsTable) {
                    ((HdfsTable)tbl).load(true, msClient.getHiveClient(), msTbl, !isSkipFileMetadataReload, true, request.refresh_updated_hms_partitions, null, request.debug_action, null, reason, catalogTimeline);
                } else {
                    tbl.load(true, msClient.getHiveClient(), msTbl, reason, catalogTimeline);
                }
                catalogTimeline.markEvent("Loaded table");
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            boolean bl = isFullReloadOnTable = !isSkipFileMetadataReload;
            if (currentHmsEventId != -1L && syncToLatestEventId) {
                if (isFullReloadOnTable) {
                    tbl.setLastSyncedEventId(currentHmsEventId);
                } else {
                    tbl.setLastSyncedEventId(eventId);
                }
            }
            tbl.setCatalogVersion(newCatalogVersion);
            LOG.info(String.format("Refreshed table metadata: %s", tbl.getFullName()));
            if (currentHmsEventId > eventId && isFullReloadOnTable) {
                tbl.setLastRefreshEventId(currentHmsEventId, isFullReloadOnTable);
            } else {
                tbl.setLastRefreshEventId(eventId, isFullReloadOnTable);
            }
            serializable = tbl.toTCatalogObject(resultType);
            return serializable;
        }
        finally {
            context.stop();
            this.UnlockWriteLockIfErroneouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    public Table dropPartitions(Table tbl, List<List<TPartitionKeyValue>> partitionSet) throws CatalogException {
        Preconditions.checkNotNull((Object)tbl);
        Preconditions.checkNotNull(partitionSet);
        Preconditions.checkState((boolean)tbl.isWriteLockedByCurrentThread());
        if (!(tbl instanceof HdfsTable)) {
            throw new CatalogException("Table " + tbl.getFullName() + " is not an Hdfs table");
        }
        HdfsTable hdfsTable = (HdfsTable)tbl;
        List<HdfsPartition> partitions = hdfsTable.getPartitionsFromPartitionSet(partitionSet);
        hdfsTable.dropPartitions(partitions);
        return hdfsTable;
    }

    public Table addPartition(HdfsPartition partition) throws CatalogException {
        Preconditions.checkNotNull((Object)partition);
        HdfsTable hdfsTable = partition.getTable();
        hdfsTable.addPartition(partition);
        return hdfsTable;
    }

    public TCatalogObject invalidateTable(TTableName tableName, Reference<Boolean> tblWasRemoved, Reference<Boolean> dbWasAdded, EventSequence catalogTimeline) {
        return this.invalidateTable(tableName, tblWasRemoved, dbWasAdded, catalogTimeline, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCatalogObject invalidateTable(TTableName tableName, Reference<Boolean> tblWasRemoved, Reference<Boolean> dbWasAdded, EventSequence catalogTimeline, long eventId) {
        List<Object> metaRes;
        String tblName;
        String dbName;
        block40: {
            tblWasRemoved.setRef(false);
            dbWasAdded.setRef(false);
            dbName = tableName.getDb_name();
            tblName = tableName.getTable_name();
            if (this.isBlacklistedTable(dbName, tblName)) {
                LOG.info("Skip invalidating blacklisted table: " + tableName);
                return null;
            }
            LOG.info(String.format("Invalidating table metadata: %s.%s", dbName, tblName));
            metaRes = null;
            Db db = null;
            try (MetaStoreClientPool.MetaStoreClient msClient = this.getMetaStoreClient(catalogTimeline);){
                Table result;
                Database msDb = null;
                try {
                    metaRes = this.getTableMetaFromHive(msClient, dbName, tblName);
                    catalogTimeline.markEvent("Fetched table from Metastore");
                }
                catch (NoSuchObjectException | UnknownDBException e) {
                    metaRes = Collections.emptyList();
                }
                catch (TException e) {
                    LOG.error("Error executing tableExists() metastore call: " + tblName, (Throwable)e);
                }
                if (metaRes != null && metaRes.isEmpty()) {
                    result = this.removeTable(dbName, tblName);
                    catalogTimeline.markEvent("Removed table in catalog cache");
                    if (result == null) {
                        TCatalogObject tCatalogObject = null;
                        return tCatalogObject;
                    }
                    tblWasRemoved.setRef(true);
                    result.takeReadLock();
                    try {
                        TCatalogObject tCatalogObject = result.toTCatalogObject();
                        return tCatalogObject;
                    }
                    finally {
                        result.releaseReadLock();
                    }
                }
                db = this.getDb(dbName);
                if (!(db != null && db.containsTable(tblName) || metaRes != null)) {
                    result = null;
                    return result;
                }
                if (db != null || metaRes.isEmpty()) break block40;
                try {
                    msDb = msClient.getHiveClient().getDatabase(dbName);
                    catalogTimeline.markEvent("Fetched database from Metastore");
                    Preconditions.checkNotNull((Object)msDb);
                    this.addDb(dbName, msDb);
                    catalogTimeline.markEvent("Added database in catalog cache");
                    dbWasAdded.setRef(true);
                }
                catch (TException e) {
                    LOG.error("Error executing getDatabase() metastore call: " + dbName, (Throwable)e);
                    TCatalogObject tCatalogObject = null;
                    if (msClient != null) {
                        if (var12_11 != null) {
                            try {
                                msClient.close();
                            }
                            catch (Throwable throwable) {
                                var12_11.addSuppressed(throwable);
                            }
                        } else {
                            msClient.close();
                        }
                    }
                    return tCatalogObject;
                }
            }
        }
        Preconditions.checkState((metaRes != null ? 1 : 0) != 0);
        Preconditions.checkState((metaRes.size() == 1 ? 1 : 0) != 0);
        TableMeta tblMeta = (TableMeta)metaRes.get(0);
        Table newTable = this.addIncompleteTable(dbName, tblName, MetastoreShim.mapToInternalTableType(tblMeta.getTableType()), tblMeta.getComments(), eventId);
        Preconditions.checkNotNull((Object)newTable);
        if (this.loadInBackground_) {
            this.tableLoadingMgr_.backgroundLoad(new TTableName(dbName.toLowerCase(), tblName.toLowerCase()));
        }
        if (dbWasAdded.getRef().booleanValue()) {
            Db addedDb = newTable.getDb();
            Preconditions.checkNotNull((Object)addedDb);
            Preconditions.checkState((addedDb.getCatalogVersion() < newTable.getCatalogVersion() ? 1 : 0) != 0);
        }
        return newTable.toTCatalogObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table invalidateTableIfExists(String dbName, String tblName) {
        IncompleteTable incompleteTable;
        this.versionLock_.writeLock().lock();
        try {
            Db db = this.getDb(dbName);
            if (db == null) {
                Table table = null;
                return table;
            }
            Table existingTbl = db.getTable(tblName);
            if (existingTbl == null) {
                Table table = null;
                return table;
            }
            incompleteTable = IncompleteTable.createUninitializedTable(db, tblName, existingTbl.getTableType(), existingTbl.getTableComment());
            incompleteTable.setCatalogVersion(this.incrementAndGetCatalogVersion());
            incompleteTable.setCreateEventId(existingTbl.getCreateEventId());
            db.addTable(incompleteTable);
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
        if (this.loadInBackground_) {
            this.tableLoadingMgr_.backgroundLoad(new TTableName(dbName.toLowerCase(), tblName.toLowerCase()));
        }
        return incompleteTable;
    }

    public boolean reloadTableIfExists(String dbName, String tblName, String reason, long eventId, boolean isSkipFileMetadataReload) throws CatalogException {
        try {
            Table table = this.getTable(dbName, tblName);
            if (table == null || table instanceof IncompleteTable) {
                return false;
            }
            if (eventId > 0L && eventId <= table.getCreateEventId()) {
                LOG.debug("Not reloading the table {}.{} for event {} since it is recreated at event {}.", new Object[]{dbName, tblName, eventId, table.getCreateEventId()});
                return false;
            }
            this.reloadTable(table, reason, eventId, isSkipFileMetadataReload, NoOpEventSequence.INSTANCE);
        }
        catch (DatabaseNotFoundException | TableLoadingException e) {
            LOG.info(String.format("Reload table if exists failed with: %s", e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean updateDbIfExists(Database msdb) {
        try {
            this.updateDb(msdb);
        }
        catch (DatabaseNotFoundException e) {
            return false;
        }
        return true;
    }

    public Role addRole(String roleName, Set<String> grantGroups) {
        Principal role = this.addPrincipal(roleName, grantGroups, TPrincipalType.ROLE);
        Preconditions.checkState((boolean)(role instanceof Role));
        return (Role)role;
    }

    public User addUser(String userName) {
        Principal user = this.addPrincipal(userName, new HashSet<String>(), TPrincipalType.USER);
        Preconditions.checkState((boolean)(user instanceof User));
        return (User)user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User addUserIfNotExists(String owner, Reference<Boolean> existingUser) {
        this.versionLock_.writeLock().lock();
        try {
            User user = this.getAuthPolicy().getUser(owner);
            existingUser.setRef(Boolean.TRUE);
            if (user == null) {
                user = this.addUser(owner);
                existingUser.setRef(Boolean.FALSE);
            }
            User user2 = user;
            return user2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal addPrincipal(String principalName, Set<String> grantGroups, TPrincipalType type) {
        this.versionLock_.writeLock().lock();
        try {
            Principal principal = Principal.newInstance(principalName, type, grantGroups);
            principal.setCatalogVersion(this.incrementAndGetCatalogVersion());
            this.authPolicy_.addPrincipal(principal);
            Principal principal2 = principal;
            return principal2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public Role removeRole(String roleName) {
        Principal role = this.removePrincipal(roleName, TPrincipalType.ROLE);
        if (role == null) {
            return null;
        }
        Preconditions.checkState((boolean)(role instanceof Role));
        return (Role)role;
    }

    public User removeUser(String userName) {
        Principal user = this.removePrincipal(userName, TPrincipalType.USER);
        if (user == null) {
            return null;
        }
        Preconditions.checkState((boolean)(user instanceof User));
        return (User)user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Principal removePrincipal(String principalName, TPrincipalType type) {
        this.versionLock_.writeLock().lock();
        try {
            Principal principal = this.authPolicy_.removePrincipal(principalName, type);
            if (principal == null) {
                Principal principal2 = null;
                return principal2;
            }
            for (PrincipalPrivilege priv : principal.getPrivileges()) {
                priv.setCatalogVersion(this.incrementAndGetCatalogVersion());
                this.deleteLog_.addRemovedObject(priv.toTCatalogObject());
            }
            principal.setCatalogVersion(this.incrementAndGetCatalogVersion());
            this.deleteLog_.addRemovedObject(principal.toTCatalogObject());
            Principal principal3 = principal;
            return principal3;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role addRoleGrantGroup(String roleName, String groupName) throws CatalogException {
        this.versionLock_.writeLock().lock();
        try {
            Role role = this.authPolicy_.addRoleGrantGroup(roleName, groupName);
            Preconditions.checkNotNull((Object)role);
            role.setCatalogVersion(this.incrementAndGetCatalogVersion());
            Role role2 = role;
            return role2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Role removeRoleGrantGroup(String roleName, String groupName) throws CatalogException {
        this.versionLock_.writeLock().lock();
        try {
            Role role = this.authPolicy_.removeRoleGrantGroup(roleName, groupName);
            Preconditions.checkNotNull((Object)role);
            role.setCatalogVersion(this.incrementAndGetCatalogVersion());
            Role role2 = role;
            return role2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public PrincipalPrivilege addRolePrivilege(String roleName, TPrivilege thriftPriv) throws CatalogException {
        Preconditions.checkArgument((thriftPriv.getPrincipal_type() == TPrincipalType.ROLE ? 1 : 0) != 0);
        return this.addPrincipalPrivilege(roleName, thriftPriv, TPrincipalType.ROLE);
    }

    public PrincipalPrivilege addUserPrivilege(String userName, TPrivilege thriftPriv) throws CatalogException {
        Preconditions.checkArgument((thriftPriv.getPrincipal_type() == TPrincipalType.USER ? 1 : 0) != 0);
        return this.addPrincipalPrivilege(userName, thriftPriv, TPrincipalType.USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalPrivilege addPrincipalPrivilege(String principalName, TPrivilege thriftPriv, TPrincipalType type) throws CatalogException {
        this.versionLock_.writeLock().lock();
        try {
            Principal principal = this.authPolicy_.getPrincipal(principalName, type);
            if (principal == null) {
                throw new CatalogException(String.format("%s does not exist: %s", Principal.toString(type), principalName));
            }
            PrincipalPrivilege priv = PrincipalPrivilege.fromThrift(thriftPriv);
            priv.setCatalogVersion(this.incrementAndGetCatalogVersion());
            this.authPolicy_.addPrivilege(priv);
            PrincipalPrivilege principalPrivilege = priv;
            return principalPrivilege;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public PrincipalPrivilege removeRolePrivilege(String roleName, String privilegeName) throws CatalogException {
        return this.removePrincipalPrivilege(roleName, privilegeName, TPrincipalType.ROLE);
    }

    public PrincipalPrivilege removeUserPrivilege(String userName, String privilegeName) throws CatalogException {
        return this.removePrincipalPrivilege(userName, privilegeName, TPrincipalType.USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalPrivilege removePrincipalPrivilege(String principalName, String privilegeName, TPrincipalType type) throws CatalogException {
        this.versionLock_.writeLock().lock();
        try {
            Principal principal = this.authPolicy_.getPrincipal(principalName, type);
            if (principal == null) {
                throw new CatalogException(String.format("%s does not exist: %s", Principal.toString(type), principalName));
            }
            PrincipalPrivilege principalPrivilege = principal.removePrivilege(privilegeName);
            if (principalPrivilege == null) {
                PrincipalPrivilege principalPrivilege2 = null;
                return principalPrivilege2;
            }
            principalPrivilege.setCatalogVersion(this.incrementAndGetCatalogVersion());
            this.deleteLog_.addRemovedObject(principalPrivilege.toTCatalogObject());
            PrincipalPrivilege principalPrivilege3 = principalPrivilege;
            return principalPrivilege3;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalPrivilege getPrincipalPrivilege(String principalName, TPrivilege privSpec) throws CatalogException {
        String privilegeName = PrincipalPrivilege.buildPrivilegeName(privSpec);
        this.versionLock_.readLock().lock();
        try {
            Principal principal = this.authPolicy_.getPrincipal(principalName, privSpec.getPrincipal_type());
            if (principal == null) {
                throw new CatalogException(Principal.toString(privSpec.getPrincipal_type()) + " does not exist: " + principalName);
            }
            PrincipalPrivilege principalPrivilege = principal.getPrivilege(privilegeName);
            return principalPrivilege;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    @Override
    public AuthzCacheInvalidation getAuthzCacheInvalidation(String markerName) {
        this.versionLock_.readLock().lock();
        try {
            AuthzCacheInvalidation authzCacheInvalidation = (AuthzCacheInvalidation)this.authzCacheInvalidation_.get(markerName);
            return authzCacheInvalidation;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthzCacheInvalidation incrementAuthzCacheInvalidationVersion(String markerName) {
        this.versionLock_.writeLock().lock();
        try {
            AuthzCacheInvalidation authzCacheInvalidation = this.getAuthzCacheInvalidation(markerName);
            if (authzCacheInvalidation == null) {
                authzCacheInvalidation = new AuthzCacheInvalidation(markerName);
                this.authzCacheInvalidation_.add(authzCacheInvalidation);
            }
            authzCacheInvalidation.setCatalogVersion(this.incrementAndGetCatalogVersion());
            AuthzCacheInvalidation authzCacheInvalidation2 = authzCacheInvalidation;
            return authzCacheInvalidation2;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public long incrementAndGetCatalogVersion() {
        this.versionLock_.writeLock().lock();
        try {
            long l = ++this.catalogVersion_;
            return l;
        }
        finally {
            this.versionLock_.writeLock().unlock();
        }
    }

    public long getCatalogVersion() {
        this.versionLock_.readLock().lock();
        try {
            long l = this.catalogVersion_;
            return l;
        }
        finally {
            this.versionLock_.readLock().unlock();
        }
    }

    private void acquireVersionReadLock(EventSequence catalogTimeline) {
        this.versionLock_.readLock().lock();
        catalogTimeline.markEvent(GOT_CATALOG_VERSION_READ_LOCK);
    }

    public ReentrantReadWriteLock getLock() {
        return this.versionLock_;
    }

    public AuthorizationPolicy getAuthPolicy() {
        return this.authPolicy_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCatalogObject reloadPartition(Table tbl, List<TPartitionKeyValue> partitionSpec, Reference<Boolean> wasPartitionReloaded, CatalogObject.ThriftObjectType resultType, String reason, EventSequence catalogTimeline) throws CatalogException {
        if (!this.tryWriteLock(tbl, catalogTimeline)) {
            throw new CatalogException(String.format("Error reloading partition of table %s due to lock contention", tbl.getFullName()));
        }
        try {
            long newCatalogVersion = this.incrementAndGetCatalogVersion();
            this.versionLock_.writeLock().unlock();
            HdfsTable hdfsTable = (HdfsTable)tbl;
            wasPartitionReloaded.setRef(false);
            HdfsPartition hdfsPartition = hdfsTable.getPartitionFromThriftPartitionSpec(partitionSpec);
            String partitionName = hdfsPartition == null ? HdfsTable.constructPartitionName(partitionSpec) : hdfsPartition.getPartitionName();
            TCatalogObject tCatalogObject = this.reloadHdfsPartition(hdfsTable, partitionName, wasPartitionReloaded, resultType, reason, newCatalogVersion, hdfsPartition, catalogTimeline);
            return tCatalogObject;
        }
        finally {
            this.UnlockWriteLockIfErroneouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    public TCatalogObject reloadHdfsPartition(HdfsTable hdfsTable, String partitionName, Reference<Boolean> wasPartitionReloaded, CatalogObject.ThriftObjectType resultType, String reason, long newCatalogVersion, @Nullable HdfsPartition hdfsPartition, EventSequence catalogTimeline) throws CatalogException {
        HashMap<Partition, HdfsPartition> hmsPartToHdfsPart;
        Preconditions.checkState((boolean)hdfsTable.isWriteLockedByCurrentThread());
        LOG.info(String.format("Refreshing partition metadata: %s %s (%s)", hdfsTable.getFullName(), partitionName, reason));
        try (MetaStoreClientPool.MetaStoreClient msClient = this.getMetaStoreClient(catalogTimeline);){
            Partition hmsPartition = null;
            try {
                hmsPartition = msClient.getHiveClient().getPartition(hdfsTable.getDb().getName(), hdfsTable.getName(), partitionName);
                catalogTimeline.markEvent("Fetched partition from Metastore");
            }
            catch (NoSuchObjectException e) {
                if (hdfsPartition != null) {
                    hdfsTable.dropPartition(hdfsPartition);
                    hdfsTable.setCatalogVersion(newCatalogVersion);
                    wasPartitionReloaded.setRef(true);
                } else {
                    LOG.info(String.format("Partition metadata for %s was not refreshed since it does not exist in metastore anymore", hdfsTable.getFullName() + " " + partitionName));
                }
                TCatalogObject tCatalogObject = hdfsTable.toTCatalogObject(resultType);
                if (msClient != null) {
                    if (var11_10 != null) {
                        try {
                            msClient.close();
                        }
                        catch (Throwable throwable) {
                            var11_10.addSuppressed(throwable);
                        }
                    } else {
                        msClient.close();
                    }
                }
                return tCatalogObject;
            }
            catch (Exception e) {
                throw new CatalogException("Error loading metadata for partition: " + hdfsTable.getFullName() + " " + partitionName, e);
            }
            hmsPartToHdfsPart = new HashMap<Partition, HdfsPartition>();
            hmsPartToHdfsPart.put(hmsPartition, hdfsPartition);
        }
        hdfsTable.reloadPartitions(msClient.getHiveClient(), hmsPartToHdfsPart, true, catalogTimeline);
        hdfsTable.setCatalogVersion(newCatalogVersion);
        wasPartitionReloaded.setRef(true);
        LOG.info(String.format("Refreshed partition metadata: %s %s", hdfsTable.getFullName(), partitionName));
        return hdfsTable.toTCatalogObject(resultType);
    }

    public CatalogDeltaLog getDeleteLog() {
        return this.deleteLog_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForSyncDdlVersion(TCatalogUpdateResult result) throws CatalogException {
        if (result.getVersion() <= this.topicUpdateLog_.getOldestTopicUpdateToGc() || !result.isSetUpdated_catalog_objects() && !result.isSetRemoved_catalog_objects()) {
            return result.getVersion();
        }
        long lastSentTopicUpdate = this.lastSentTopicUpdate_.get();
        long maxNumAttempts = 5L;
        if (result.isSetUpdated_catalog_objects()) {
            maxNumAttempts = Math.max(maxNumAttempts, (long)(result.getUpdated_catalog_objects().size() * 3));
        }
        long numAttempts = 0L;
        long begin = System.currentTimeMillis();
        long versionToWaitFor = -1L;
        TUniqueId serviceId = JniCatalog.getServiceId();
        while (versionToWaitFor == -1L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("waitForSyncDdlVersion() attempt: " + numAttempts);
            }
            if (BackendConfig.INSTANCE.isCatalogdHAEnabled()) {
                if (!Strings.isNullOrEmpty((String)BackendConfig.INSTANCE.debugActions())) {
                    DebugUtils.executeDebugAction(BackendConfig.INSTANCE.debugActions(), "catalogd_wait_sync_ddl_version_delay");
                }
                if (!serviceId.equals(JniCatalog.getServiceId())) {
                    String errorMsg = "Couldn't retrieve the catalog topic update for the SYNC_DDL operation since HA role of this catalog instance has been changed. The operation has been successfully executed but its effects may have not been broadcast to all the coordinators.";
                    LOG.error(errorMsg);
                    throw new CatalogException(errorMsg);
                }
            }
            long topicVersionForUpdates = this.getCoveringTopicUpdateVersion(result.getUpdated_catalog_objects());
            long topicVersionForDeletes = this.getCoveringTopicUpdateVersion(result.getRemoved_catalog_objects());
            if (topicVersionForUpdates == -1L || topicVersionForDeletes == -1L) {
                LOG.info("Topic update for {} not found yet. Last sent catalog version: {}. Updated objects: {}, deleted objects: {}", new Object[]{topicVersionForUpdates == -1L ? "updates" : "deletes", this.lastSentTopicUpdate_.get(), FeCatalogUtils.debugString(result.updated_catalog_objects), FeCatalogUtils.debugString(result.removed_catalog_objects)});
                TopicUpdateLog topicUpdateLog = this.topicUpdateLog_;
                synchronized (topicUpdateLog) {
                    try {
                        this.topicUpdateLog_.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                long currentTopicUpdate = this.lastSentTopicUpdate_.get();
                if (lastSentTopicUpdate == currentTopicUpdate) continue;
                if (this.shouldTimeOut(++numAttempts, maxNumAttempts, begin)) {
                    LOG.error(String.format("Couldn't retrieve the covering topic update for catalog objects. Updated objects: %s, deleted objects: %s", FeCatalogUtils.debugString(result.updated_catalog_objects), FeCatalogUtils.debugString(result.removed_catalog_objects)));
                    throw new CatalogException("Couldn't retrieve the catalog topic update for the SYNC_DDL operation after " + numAttempts + " attempts and elapsed time of " + (System.currentTimeMillis() - begin) + " msec. The operation has been successfully executed but its effects may have not been broadcast to all the coordinators.");
                }
                lastSentTopicUpdate = currentTopicUpdate;
                continue;
            }
            versionToWaitFor = Math.max(topicVersionForDeletes, topicVersionForUpdates);
        }
        Preconditions.checkState((versionToWaitFor >= 0L ? 1 : 0) != 0);
        LOG.info("Operation using SYNC_DDL is waiting for catalog version {} to be sent. Time to identify topic update (msec): {}.", (Object)versionToWaitFor, (Object)(System.currentTimeMillis() - begin));
        return versionToWaitFor;
    }

    private boolean shouldTimeOut(long numAttempts, long maxNumAttempts, long startTime) {
        int timeoutSecs = BackendConfig.INSTANCE.getMaxWaitTimeForSyncDdlSecs();
        if (this.topicUpdateTblLockMaxWaitTimeMs_ > 0L) {
            if (timeoutSecs <= 0) {
                return false;
            }
            return System.currentTimeMillis() - startTime > (long)timeoutSecs * 1000L;
        }
        return numAttempts > maxNumAttempts;
    }

    private long getCoveringTopicUpdateVersion(List<TCatalogObject> tCatalogObjects) {
        if (tCatalogObjects == null || tCatalogObjects.isEmpty()) {
            return this.lastSentTopicUpdate_.get();
        }
        long versionToWaitFor = -1L;
        for (TCatalogObject tCatalogObject : tCatalogObjects) {
            String key = Catalog.toCatalogObjectKey(tCatalogObject);
            TopicUpdateLog.Entry topicUpdateEntry = this.topicUpdateLog_.get(key);
            if (topicUpdateEntry == null) {
                return -1L;
            }
            if (topicUpdateEntry.getLastSentVersion() < tCatalogObject.getCatalog_version()) {
                LOG.info("Should wait for next update for {}: older version {} is sent. Expects a version >= {}.", new Object[]{key, topicUpdateEntry.getLastSentVersion(), tCatalogObject.getCatalog_version()});
                return -1L;
            }
            versionToWaitFor = Math.max(versionToWaitFor, topicUpdateEntry.getLastSentCatalogUpdate());
        }
        return versionToWaitFor;
    }

    public TGetCatalogUsageResponse getCatalogUsage() {
        TTableUsageMetrics tableUsageMetrics;
        TGetCatalogUsageResponse usage = new TGetCatalogUsageResponse();
        CatalogTableMetrics catalogTableMetrics = CatalogMonitor.INSTANCE.getCatalogTableMetrics();
        usage.setLarge_tables(new ArrayList<TTableUsageMetrics>());
        usage.setFrequently_accessed_tables(new ArrayList<TTableUsageMetrics>());
        usage.setHigh_file_count_tables(new ArrayList<TTableUsageMetrics>());
        usage.setLong_metadata_loading_tables(new ArrayList<TTableUsageMetrics>());
        for (Pair<TTableName, Long> pair : catalogTableMetrics.getLargestTables()) {
            tableUsageMetrics = new TTableUsageMetrics(pair.getFirst());
            tableUsageMetrics.setMemory_estimate_bytes(pair.getSecond());
            usage.addToLarge_tables(tableUsageMetrics);
        }
        for (Pair<TTableName, Long> pair : catalogTableMetrics.getFrequentlyAccessedTables()) {
            tableUsageMetrics = new TTableUsageMetrics(pair.getFirst());
            tableUsageMetrics.setNum_metadata_operations(pair.getSecond());
            usage.addToFrequently_accessed_tables(tableUsageMetrics);
        }
        for (Pair<TTableName, Long> pair : catalogTableMetrics.getHighFileCountTables()) {
            tableUsageMetrics = new TTableUsageMetrics(pair.getFirst());
            tableUsageMetrics.setNum_files(pair.getSecond());
            usage.addToHigh_file_count_tables(tableUsageMetrics);
        }
        for (Pair<TTableName, Object> pair : catalogTableMetrics.getLongMetadataLoadingTables()) {
            tableUsageMetrics = new TTableUsageMetrics(pair.getFirst());
            tableUsageMetrics.setMedian_table_loading_ns(((TableLoadingTimeHistogram)pair.getSecond()).getQuantile(TableLoadingTimeHistogram.Quantile.P50));
            tableUsageMetrics.setMax_table_loading_ns(((TableLoadingTimeHistogram)pair.getSecond()).getQuantile(TableLoadingTimeHistogram.Quantile.P100));
            tableUsageMetrics.setP75_loading_time_ns(((TableLoadingTimeHistogram)pair.getSecond()).getQuantile(TableLoadingTimeHistogram.Quantile.P75));
            tableUsageMetrics.setP95_loading_time_ns(((TableLoadingTimeHistogram)pair.getSecond()).getQuantile(TableLoadingTimeHistogram.Quantile.P95));
            tableUsageMetrics.setP99_loading_time_ns(((TableLoadingTimeHistogram)pair.getSecond()).getQuantile(TableLoadingTimeHistogram.Quantile.P99));
            tableUsageMetrics.setNum_table_loading(((TableLoadingTimeHistogram)pair.getSecond()).getCount());
            usage.addToLong_metadata_loading_tables(tableUsageMetrics);
        }
        return usage;
    }

    public TGetOperationUsageResponse getOperationUsage() {
        return CatalogMonitor.INSTANCE.getCatalogOperationTracker().getOperationMetrics();
    }

    public TEventProcessorMetrics getEventProcessorMetrics() {
        return this.metastoreEventProcessor_.getEventProcessorMetrics();
    }

    public TCatalogdHmsCacheMetrics getCatalogdHmsCacheMetrics() {
        return this.catalogMetastoreServer_.getCatalogdHmsCacheMetrics();
    }

    public TEventProcessorMetricsSummaryResponse getEventProcessorSummary() {
        return this.metastoreEventProcessor_.getEventProcessorSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableMetrics(TTableName tTableName) throws CatalogException {
        String dbName = tTableName.db_name;
        String tblName = tTableName.table_name;
        Table tbl = this.getTable(dbName, tblName);
        if (tbl == null) {
            throw new CatalogException("Table " + dbName + "." + tblName + " was not found.");
        }
        if (tbl instanceof IncompleteTable) {
            String result = "No metrics available for table " + dbName + "." + tblName + ". Table not yet loaded.";
            return result;
        }
        if (!tbl.tryReadLock()) {
            String result = "Metrics for table " + dbName + "." + tblName + "are not available because the table is currently modified by another operation.";
            return result;
        }
        try {
            String string = tbl.getMetrics().toString();
            return string;
        }
        finally {
            tbl.releaseReadLock();
        }
    }

    public TGetPartialCatalogObjectResponse getPartialCatalogObject(TGetPartialCatalogObjectRequest req) throws CatalogException {
        return this.getPartialCatalogObject(req, "needed by coordinator");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public TGetPartialCatalogObjectResponse getPartialCatalogObject(TGetPartialCatalogObjectRequest req, String reason) throws CatalogException {
        Preconditions.checkNotNull((Object)reason);
        try {
            if (!this.partialObjectFetchAccess_.tryAcquire(1, this.PARTIAL_FETCH_RPC_QUEUE_TIMEOUT_S, TimeUnit.SECONDS)) {
                throw new CatalogException("Timed out while fetching partial object metadata. Please check the metric 'catalog.partial-fetch-rpc.queue-len' for the current queue length and consider increasing 'catalog_partial_fetch_rpc_queue_timeout_s' and/or 'catalog_max_parallel_partial_fetch_rpc'");
            }
            try {
                try (ThreadNameAnnotator tna = new ThreadNameAnnotator("Get Partial Catalog Object - " + Catalog.toCatalogObjectKey(req.object_desc));){
                    TGetPartialCatalogObjectResponse tGetPartialCatalogObjectResponse = this.doGetPartialCatalogObject(req, reason);
                    return tGetPartialCatalogObjectResponse;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.partialObjectFetchAccess_.release();
            }
        }
        catch (InterruptedException e) {
            throw new CatalogException("Error running getPartialCatalogObject(): ", e);
        }
    }

    @Override
    public String getAcidUserId() {
        return String.format("CatalogD %s", this.getCatalogServiceId());
    }

    public String getCatalogServiceId() {
        return TUniqueIdUtil.PrintId(JniCatalog.getServiceId()).intern();
    }

    @VisibleForTesting
    public int getConcurrentPartialRpcReqCount() {
        return this.MAX_PARALLEL_PARTIAL_FETCH_RPC_COUNT - this.partialObjectFetchAccess_.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TGetPartialCatalogObjectResponse doGetPartialCatalogObject(TGetPartialCatalogObjectRequest req, String tableLoadReason) throws CatalogException {
        TCatalogObject objectDesc = (TCatalogObject)Preconditions.checkNotNull((Object)req.object_desc, (Object)"missing object_desc");
        switch (objectDesc.type) {
            case CATALOG: {
                return this.getPartialCatalogInfo(req);
            }
            case DATABASE: {
                TDatabase dbDesc = (TDatabase)Preconditions.checkNotNull((Object)req.object_desc.db);
                this.versionLock_.readLock().lock();
                try {
                    Db db = this.getDb(dbDesc.getDb_name());
                    if (db == null) {
                        TGetPartialCatalogObjectResponse tGetPartialCatalogObjectResponse = CatalogServiceCatalog.createGetPartialCatalogObjectError(req, CatalogLookupStatus.DB_NOT_FOUND);
                        return tGetPartialCatalogObjectResponse;
                    }
                    TGetPartialCatalogObjectResponse tGetPartialCatalogObjectResponse = db.getPartialInfo(req);
                    return tGetPartialCatalogObjectResponse;
                }
                finally {
                    this.versionLock_.readLock().unlock();
                }
            }
            case TABLE: 
            case VIEW: {
                Table table;
                Object tblName;
                ValidWriteIdList writeIdList = null;
                try {
                    long tableId = -1L;
                    if (req.table_info_selector.valid_write_ids != null) {
                        Preconditions.checkState((boolean)objectDesc.type.equals((Object)TCatalogObjectType.TABLE));
                        String dbName = objectDesc.getTable().db_name == null ? "default" : objectDesc.getTable().db_name;
                        tblName = objectDesc.getTable().tbl_name;
                        writeIdList = MetastoreShim.getValidWriteIdListFromThrift(dbName + "." + (String)tblName, req.table_info_selector.valid_write_ids);
                        tableId = req.table_info_selector.getTable_id();
                    }
                    table = this.getOrLoadTable(objectDesc.getTable().getDb_name(), objectDesc.getTable().getTbl_name(), tableLoadReason, writeIdList, tableId, NoOpEventSequence.INSTANCE);
                }
                catch (DatabaseNotFoundException e) {
                    return CatalogServiceCatalog.createGetPartialCatalogObjectError(req, CatalogLookupStatus.DB_NOT_FOUND);
                }
                if (table == null) {
                    return CatalogServiceCatalog.createGetPartialCatalogObjectError(req, CatalogLookupStatus.TABLE_NOT_FOUND);
                }
                if (!table.isLoaded()) {
                    return CatalogServiceCatalog.createGetPartialCatalogObjectError(req, CatalogLookupStatus.TABLE_NOT_LOADED);
                }
                table.takeReadLock();
                try {
                    if (table instanceof HdfsTable) {
                        HdfsTable hdfsTable = (HdfsTable)table;
                        HashMap missingPartialInfos = Maps.newHashMap();
                        TGetPartialCatalogObjectResponse resp = hdfsTable.getPartialInfo(req, missingPartialInfos);
                        if (missingPartialInfos.isEmpty()) {
                            tblName = resp;
                            return tblName;
                        }
                        this.setFileMetadataFromFS(hdfsTable, writeIdList, missingPartialInfos);
                        tblName = resp;
                        return tblName;
                    }
                    TGetPartialCatalogObjectResponse tGetPartialCatalogObjectResponse = table.getPartialInfo(req);
                    return tGetPartialCatalogObjectResponse;
                }
                finally {
                    table.releaseReadLock();
                }
            }
            case FUNCTION: {
                this.versionLock_.readLock().lock();
                try {
                    Db db = this.getDb(objectDesc.fn.name.db_name);
                    if (db == null) {
                        TGetPartialCatalogObjectResponse writeIdList = CatalogServiceCatalog.createGetPartialCatalogObjectError(req, CatalogLookupStatus.DB_NOT_FOUND);
                        return writeIdList;
                    }
                    List<Function> funcs = db.getFunctions(objectDesc.fn.name.function_name);
                    if (funcs.isEmpty()) {
                        TGetPartialCatalogObjectResponse missingPartialInfos = CatalogServiceCatalog.createGetPartialCatalogObjectError(req, CatalogLookupStatus.FUNCTION_NOT_FOUND);
                        return missingPartialInfos;
                    }
                    TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
                    ArrayList thriftFuncs = Lists.newArrayListWithCapacity((int)funcs.size());
                    for (Function f : funcs) {
                        thriftFuncs.add(f.toThrift());
                    }
                    resp.setFunctions(thriftFuncs);
                    TGetPartialCatalogObjectResponse tGetPartialCatalogObjectResponse = resp;
                    return tGetPartialCatalogObjectResponse;
                }
                finally {
                    this.versionLock_.readLock().unlock();
                }
            }
            case DATA_SOURCE: {
                TDataSource dsDesc = (TDataSource)Preconditions.checkNotNull((Object)req.object_desc.data_source);
                this.versionLock_.readLock().lock();
                try {
                    TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
                    if (dsDesc.getName() == null || dsDesc.getName().isEmpty()) {
                        List<DataSource> data_srcs = this.getDataSources();
                        if (data_srcs == null || data_srcs.isEmpty()) {
                            resp.setData_srcs(Collections.emptyList());
                        } else {
                            ArrayList thriftDataSrcs = Lists.newArrayListWithCapacity((int)data_srcs.size());
                            for (DataSource ds : data_srcs) {
                                thriftDataSrcs.add(ds.toThrift());
                            }
                            resp.setData_srcs(thriftDataSrcs);
                        }
                    } else {
                        DataSource ds = this.getDataSource(dsDesc.getName());
                        if (ds == null) {
                            resp.setData_srcs(Collections.emptyList());
                        } else {
                            ArrayList thriftDataSrcs = Lists.newArrayListWithCapacity((int)1);
                            thriftDataSrcs.add(ds.toThrift());
                            resp.setData_srcs(thriftDataSrcs);
                        }
                    }
                    TGetPartialCatalogObjectResponse tGetPartialCatalogObjectResponse = resp;
                    return tGetPartialCatalogObjectResponse;
                }
                finally {
                    this.versionLock_.readLock().unlock();
                }
            }
        }
        throw new CatalogException("Unable to fetch partial info for type: " + (Object)((Object)req.object_desc.type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileMetadataFromFS(HdfsTable table, ValidWriteIdList reqWriteIdList, Map<HdfsPartition, TPartialPartitionInfo> partToPartialInfoMap) throws CatalogException {
        Preconditions.checkNotNull((Object)reqWriteIdList);
        Preconditions.checkState((boolean)MapUtils.isNotEmpty(partToPartialInfoMap));
        Stopwatch timer = Stopwatch.createStarted();
        try {
            ValidTxnList validTxnList;
            String logPrefix = String.format("Fetching file and block metadata for %s paths for table %s for validWriteIdList %s", partToPartialInfoMap.size(), table.getFullName(), reqWriteIdList);
            try {
                MetaStoreClientPool.MetaStoreClient client = this.getMetaStoreClient();
                Object object = null;
                try {
                    validTxnList = MetastoreShim.getValidTxns(client.getHiveClient());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (client != null) {
                        if (object != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            client.close();
                        }
                    }
                }
            }
            catch (TException ex) {
                throw new CatalogException("Unable to fetch valid transaction ids while loading file metadata for table " + table.getFullName(), ex);
            }
            List<HdfsPartition.Builder> partBuilders = partToPartialInfoMap.keySet().stream().map(HdfsPartition.Builder::new).collect(Collectors.toList());
            new ParallelFileMetadataLoader(table.getFileSystem(), partBuilders, reqWriteIdList, validTxnList, FeFsTable.Utils.shouldRecursivelyListPartitions(table), table.getHostIndex(), null, logPrefix).load();
            for (HdfsPartition.Builder builder : partBuilders) {
                HdfsPartition part = builder.getOldInstance();
                TPartialPartitionInfo partitionInfo = partToPartialInfoMap.get(part);
                partitionInfo.setFile_descriptors(CatalogServiceCatalog.transformFds(builder.getFileDescriptors()));
                partitionInfo.setInsert_file_descriptors(CatalogServiceCatalog.transformFds(builder.getInsertFileDescriptors()));
                partitionInfo.setDelete_file_descriptors(CatalogServiceCatalog.transformFds(builder.getDeleteFileDescriptors()));
            }
        }
        catch (Throwable throwable) {
            LOG.info("Time taken to load file metadata for table {} from filesystem for writeIdList {}: {} msec.", new Object[]{table.getFullName(), reqWriteIdList, timer.stop().elapsed(TimeUnit.MILLISECONDS)});
            throw throwable;
        }
        LOG.info("Time taken to load file metadata for table {} from filesystem for writeIdList {}: {} msec.", new Object[]{table.getFullName(), reqWriteIdList, timer.stop().elapsed(TimeUnit.MILLISECONDS)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table refreshFileMetadata(HdfsTable hdfsTable, List<HdfsPartition.Builder> partBuilders, EventSequence catalogTimeline) throws CatalogException {
        Preconditions.checkState((!partBuilders.isEmpty() ? 1 : 0) != 0);
        if (!this.tryWriteLock(hdfsTable, catalogTimeline)) {
            throw new CatalogException(String.format("Error during refreshing file metadata for table %s due to lock contention", hdfsTable.getFullName()));
        }
        long newVersion = this.incrementAndGetCatalogVersion();
        this.versionLock_.writeLock().unlock();
        try {
            try (MetaStoreClientPool.MetaStoreClient client = this.getMetaStoreClient(catalogTimeline);){
                hdfsTable.loadFileMetadataForPartitions(client.getHiveClient(), partBuilders, true, catalogTimeline);
            }
            hdfsTable.updatePartitions(partBuilders);
            hdfsTable.setCatalogVersion(newVersion);
        }
        finally {
            hdfsTable.writeLock().unlock();
        }
        LOG.debug("Refreshed file metadata for table {}", (Object)hdfsTable.getFullName());
        return hdfsTable;
    }

    private static List<THdfsFileDesc> transformFds(List<HdfsPartition.FileDescriptor> fds) {
        ArrayList ret = Lists.newArrayListWithCapacity((int)fds.size());
        for (HdfsPartition.FileDescriptor fd : fds) {
            ret.add(fd.toThrift());
        }
        return ret;
    }

    private static TGetPartialCatalogObjectResponse createGetPartialCatalogObjectError(TGetPartialCatalogObjectRequest req, CatalogLookupStatus status) {
        TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
        resp.setLookup_status(status);
        LOG.warn("Fetching {} failed: {}. Could not find {}", new Object[]{req.object_desc.type, status, req.object_desc});
        return resp;
    }

    private TGetPartialCatalogObjectResponse getPartialCatalogInfo(TGetPartialCatalogObjectRequest req) {
        TGetPartialCatalogObjectResponse resp = new TGetPartialCatalogObjectResponse();
        resp.catalog_info = new TPartialCatalogInfo();
        TCatalogInfoSelector sel = (TCatalogInfoSelector)Preconditions.checkNotNull((Object)req.catalog_info_selector, (Object)"no catalog_info_selector in request");
        if (sel.want_db_names) {
            resp.catalog_info.db_names = ImmutableList.copyOf(((Map)this.dbCache_.get()).keySet());
        }
        return resp;
    }

    public void updateTableUsage(TUpdateTableUsageRequest req) {
        for (TTableUsage usage : req.usages) {
            Table table = null;
            try {
                table = this.getTable(usage.table_name.db_name, usage.table_name.table_name);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                // empty catch block
            }
            if (table == null) continue;
            table.refreshLastUsedTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriteIdsToTable(String dbName, String tblName, long eventId, List<Long> writeIds, MutableValidWriteIdList.WriteIdStatus status) throws CatalogException {
        Table tbl;
        try {
            tbl = this.getTable(dbName, tblName);
        }
        catch (DatabaseNotFoundException e) {
            LOG.debug("Not adding write ids to table {}.{} for event {} since database was not found", new Object[]{dbName, tblName, eventId});
            return;
        }
        if (tbl == null) {
            LOG.debug("Not adding write ids to table {}.{} for event {} since it was not found", new Object[]{dbName, tblName, eventId});
            return;
        }
        if (!tbl.isLoaded()) {
            LOG.debug("Not adding write ids to table {}.{} for event {} since it was not loaded", new Object[]{dbName, tblName, eventId});
            return;
        }
        if (!(tbl instanceof HdfsTable)) {
            LOG.debug("Not adding write ids to table {}.{} for event {} since it is not HdfsTable", new Object[]{dbName, tblName, eventId});
            return;
        }
        if (eventId > 0L && eventId <= tbl.getCreateEventId()) {
            LOG.debug("Not adding write ids to table {}.{} for event {} since it is recreated.", new Object[]{dbName, tblName, eventId});
            return;
        }
        if (tbl.getNumClusteringCols() == 0) {
            LOG.debug("Not adding write ids to table {}.{} for event {} since it is a non-partitioned table", new Object[]{dbName, tblName, eventId});
            return;
        }
        if (!this.tryWriteLock(tbl)) {
            throw new CatalogException(String.format("Error locking table %s for event %d", tbl.getFullName(), eventId));
        }
        try {
            boolean syncToLatestEvent = BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls();
            long newCatalogVersion = this.incrementAndGetCatalogVersion();
            this.versionLock_.writeLock().unlock();
            HdfsTable hdfsTable = (HdfsTable)tbl;
            if (hdfsTable.getLastSyncedEventId() > eventId) {
                LOG.info("EventId: {}, skipping adding writeIds {} with status {} to table {} since it is already synced till event id: {}", new Object[]{eventId, writeIds, status, hdfsTable.getFullName(), hdfsTable.getLastSyncedEventId()});
                return;
            }
            if (hdfsTable.getValidWriteIds() == null) {
                LOG.info("Not adding write ids to table {}.{} for event {} since it was just upgraded to an acid table and it's valid write id list is not loaded", new Object[]{dbName, tblName, eventId});
            }
            if (hdfsTable.getValidWriteIds() != null && hdfsTable.addWriteIds(writeIds, status)) {
                tbl.setCatalogVersion(newCatalogVersion);
                LOG.info("Added {} writeId to table {}: {} for event {}", new Object[]{status, tbl.getFullName(), writeIds, eventId});
            }
            if (syncToLatestEvent) {
                hdfsTable.setLastSyncedEventId(eventId);
            }
        }
        finally {
            this.UnlockWriteLockIfErroneouslyLocked();
            tbl.releaseWriteLock();
        }
    }

    private void UnlockWriteLockIfErroneouslyLocked() {
        if (this.versionLock_.isWriteLockedByCurrentThread()) {
            LOG.error("Write lock should have been released.");
            this.versionLock_.writeLock().unlock();
        }
    }

    CatalogdTableInvalidator getCatalogdTableInvalidator() {
        return this.catalogdTableInvalidator_;
    }

    @VisibleForTesting
    void setCatalogdTableInvalidator(CatalogdTableInvalidator cleaner) {
        this.catalogdTableInvalidator_ = cleaner;
    }

    @VisibleForTesting
    public void setMetastoreEventProcessor(ExternalEventsProcessor metastoreEventProcessor) {
        this.metastoreEventProcessor_ = metastoreEventProcessor;
    }

    public void setCatalogMetastoreServer(ICatalogMetastoreServer catalogMetastoreServer) {
        this.catalogMetastoreServer_ = catalogMetastoreServer;
    }

    public void setEventFactoryForSyncToLatestEvent(MetastoreEvents.MetastoreEventFactory factory) {
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)"factory is null");
        Preconditions.checkArgument((boolean)(factory instanceof MetastoreEvents.EventFactoryForSyncToLatestEvent), (Object)"factory is not an instance of EventFactorySyncToLatestEvent");
        this.syncToLatestEventFactory_ = factory;
    }

    public MetastoreEvents.MetastoreEventFactory getEventFactoryForSyncToLatestEvent() {
        return this.syncToLatestEventFactory_;
    }

    public boolean isPartitionLoadedAfterEvent(String dbName, String tableName, Partition msPartition, long eventId) {
        try {
            HdfsPartition hdfsPartition = this.getHdfsPartition(dbName, tableName, msPartition);
            LOG.info("Partition {} of table {}.{} has last refresh id as {}. Comparing it with {}.", new Object[]{hdfsPartition.getPartitionName(), dbName, tableName, hdfsPartition.getLastRefreshEventId(), eventId});
            if (hdfsPartition.getLastRefreshEventId() >= eventId) {
                return true;
            }
        }
        catch (CatalogException ex) {
            LOG.warn("Encountered an exception while the partition's last refresh event id: " + dbName + "." + tableName + ". Ignoring further processing and try to reload the partition.", (Throwable)ex);
        }
        return false;
    }

    public Set<String> getWhitelistedTblProperties() {
        return this.whitelistedTblProperties_;
    }

    public Set<String> getFailureEventsForTesting() {
        return this.failureEventsForTesting_;
    }

    public List<String> getDefaultSkippedHmsEventTypes() {
        return this.defaultSkippedHmsEventTypes_;
    }

    public List<String> getCommonHmsEventTypes() {
        return this.commonHmsEventTypes_;
    }

    class GetCatalogDeltaContext {
        long nativeCatalogServerPtr;
        long fromVersion;
        long toVersion;
        long lastResetStartVersion;
        int numDbs = 0;
        int numTables = 0;
        int numFunctions = 0;
        Set<String> updatedCatalogObjects;
        TSerializer serializer;

        GetCatalogDeltaContext(long nativeCatalogServerPtr, long fromVersion, long toVersion, long lastResetStartVersion) throws TTransportException {
            this.nativeCatalogServerPtr = nativeCatalogServerPtr;
            this.fromVersion = fromVersion;
            this.toVersion = toVersion;
            this.lastResetStartVersion = lastResetStartVersion;
            this.updatedCatalogObjects = new HashSet<String>();
            this.serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        }

        void addCatalogObject(TCatalogObject obj, boolean delete) throws TException {
            this.addCatalogObject(obj, delete, null);
        }

        void addCatalogObject(TCatalogObject obj, boolean delete, PartitionMetaSummary summary) throws TException {
            TCatalogObject minimalObject;
            byte[] data;
            String key = Catalog.toCatalogObjectKey(obj);
            if (obj.type != TCatalogObjectType.CATALOG) {
                CatalogServiceCatalog.this.topicUpdateLog_.add(key, new TopicUpdateLog.Entry(0, obj.getCatalog_version(), this.toVersion, 0));
                if (!delete) {
                    this.updatedCatalogObjects.add(key);
                }
            }
            if (CatalogServiceCatalog.this.topicMode_ == TopicMode.FULL || CatalogServiceCatalog.this.topicMode_ == TopicMode.MIXED) {
                String v1Key = "1:" + key;
                int actualSize = FeSupport.NativeAddPendingTopicItem(this.nativeCatalogServerPtr, v1Key, obj.catalog_version, data = this.serializer.serialize((TBase)obj), delete);
                if (actualSize < 0) {
                    LOG.error("NativeAddPendingTopicItem failed in BE. key=" + v1Key + ", delete=" + delete + ", data_size=" + data.length);
                } else if (summary != null && obj.type == TCatalogObjectType.HDFS_PARTITION) {
                    summary.update(true, delete, obj.hdfs_partition.partition_name, obj.catalog_version, data.length, actualSize);
                }
            }
            if ((CatalogServiceCatalog.this.topicMode_ == TopicMode.MINIMAL || CatalogServiceCatalog.this.topicMode_ == TopicMode.MIXED) && (minimalObject = this.getMinimalObjectForV2(obj)) != null) {
                data = this.serializer.serialize((TBase)minimalObject);
                String v2Key = "2:" + key;
                int actualSize = FeSupport.NativeAddPendingTopicItem(this.nativeCatalogServerPtr, v2Key, obj.catalog_version, data, delete);
                if (actualSize < 0) {
                    LOG.error("NativeAddPendingTopicItem failed in BE. key=" + v2Key + ", delete=" + delete + ", data_size=" + data.length);
                } else if (summary != null && obj.type == TCatalogObjectType.HDFS_PARTITION) {
                    summary.update(false, delete, obj.hdfs_partition.partition_name, obj.catalog_version, data.length, actualSize);
                }
            }
        }

        private TCatalogObject getMinimalObjectForV2(TCatalogObject obj) {
            Preconditions.checkState((CatalogServiceCatalog.this.topicMode_ == TopicMode.MINIMAL || CatalogServiceCatalog.this.topicMode_ == TopicMode.MIXED ? 1 : 0) != 0);
            TCatalogObject min = new TCatalogObject(obj.type, obj.catalog_version);
            switch (obj.type) {
                case DATABASE: {
                    min.setDb(new TDatabase(obj.db.db_name));
                    break;
                }
                case TABLE: 
                case VIEW: {
                    min.setTable(new TTable(obj.table.db_name, obj.table.tbl_name));
                    break;
                }
                case HDFS_PARTITION: {
                    THdfsPartition partObject = new THdfsPartition();
                    partObject.setDb_name(obj.hdfs_partition.db_name);
                    partObject.setTbl_name(obj.hdfs_partition.tbl_name);
                    partObject.setPartition_name(obj.hdfs_partition.partition_name);
                    partObject.setId(obj.hdfs_partition.id);
                    if (obj.hdfs_partition.isSetPrev_id()) {
                        Preconditions.checkState((obj.hdfs_partition.prev_id != -1L ? 1 : 0) != 0, (Object)"Invalid partition id");
                        partObject.setPrev_id(obj.hdfs_partition.prev_id);
                    }
                    min.setHdfs_partition(partObject);
                    break;
                }
                case CATALOG: {
                    return obj;
                }
                case PRIVILEGE: 
                case PRINCIPAL: 
                case AUTHZ_CACHE_INVALIDATION: {
                    return obj;
                }
                case FUNCTION: {
                    TFunction fnObject = new TFunction(obj.fn.getName());
                    if (obj.fn.hdfs_location != null) {
                        fnObject.setHdfs_location(obj.fn.hdfs_location);
                    }
                    min.setFn(fnObject);
                    break;
                }
                case DATA_SOURCE: {
                    min.setData_source(new TDataSource(obj.data_source));
                    break;
                }
                case HDFS_CACHE_POOL: {
                    return obj;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected catalog object type: " + (Object)((Object)obj.type)));
                }
            }
            return min;
        }

        boolean versionNotInRange(long version) {
            return version <= this.fromVersion || version > this.toVersion;
        }

        boolean isFullUpdate() {
            return this.fromVersion == 0L;
        }
    }

    protected class CachePoolReader
    implements Runnable {
        private final boolean incrementVersions_;

        public CachePoolReader(boolean incrementVersions) {
            this.incrementVersions_ = incrementVersions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reloading cache pool names from HDFS");
            }
            HashMap<String, CachePoolInfo> currentCachePools = new HashMap<String, CachePoolInfo>();
            try {
                DistributedFileSystem dfs = FileSystemUtil.getDistributedFileSystem();
                RemoteIterator itr = dfs.listCachePools();
                while (itr.hasNext()) {
                    CachePoolInfo cachePoolInfo = ((CachePoolEntry)itr.next()).getInfo();
                    currentCachePools.put(cachePoolInfo.getPoolName(), cachePoolInfo);
                }
            }
            catch (Exception e) {
                LOG.error("Error loading cache pools: ", (Throwable)e);
                return;
            }
            CatalogServiceCatalog.this.versionLock_.writeLock().lock();
            try {
                HdfsCachePool cachePool;
                Sets.SetView droppedCachePoolNames = Sets.difference(CatalogServiceCatalog.this.hdfsCachePools_.keySet(), currentCachePools.keySet());
                Sets.SetView createdCachePoolNames = Sets.difference(currentCachePools.keySet(), CatalogServiceCatalog.this.hdfsCachePools_.keySet());
                Sets.SetView survivingCachePoolNames = Sets.difference(CatalogServiceCatalog.this.hdfsCachePools_.keySet(), (Set)droppedCachePoolNames);
                for (String createdCachePool : createdCachePoolNames) {
                    cachePool = new HdfsCachePool((CachePoolInfo)currentCachePools.get(createdCachePool));
                    cachePool.setCatalogVersion(CatalogServiceCatalog.this.incrementAndGetCatalogVersion());
                    CatalogServiceCatalog.this.hdfsCachePools_.add(cachePool);
                }
                for (String cachePoolName : droppedCachePoolNames) {
                    cachePool = (HdfsCachePool)CatalogServiceCatalog.this.hdfsCachePools_.remove(cachePoolName);
                    if (cachePool == null) continue;
                    cachePool.setCatalogVersion(CatalogServiceCatalog.this.incrementAndGetCatalogVersion());
                    TCatalogObject removedObject = new TCatalogObject(TCatalogObjectType.HDFS_CACHE_POOL, cachePool.getCatalogVersion());
                    removedObject.setCache_pool(cachePool.toThrift());
                    CatalogServiceCatalog.this.deleteLog_.addRemovedObject(removedObject);
                }
                if (this.incrementVersions_) {
                    for (String survivingCachePoolName : survivingCachePoolNames) {
                        cachePool = (HdfsCachePool)CatalogServiceCatalog.this.hdfsCachePools_.get(survivingCachePoolName);
                        Preconditions.checkNotNull((Object)cachePool);
                        cachePool.setCatalogVersion(CatalogServiceCatalog.this.incrementAndGetCatalogVersion());
                    }
                }
            }
            finally {
                CatalogServiceCatalog.this.versionLock_.writeLock().unlock();
            }
        }
    }

    private static enum TopicMode {
        FULL,
        MIXED,
        MINIMAL;

    }
}

