/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.List;
import org.apache.impala.catalog.CatalogObject;

public class CatalogObjectVersionSet {
    private final TreeMultiset<Long> objectVersions_ = TreeMultiset.create();
    private long minVersion_ = 0L;
    public static final CatalogObjectVersionSet INSTANCE = new CatalogObjectVersionSet();

    @VisibleForTesting
    CatalogObjectVersionSet() {
    }

    public synchronized void updateVersions(long oldVersion, long newVersion) {
        this.removeVersion(oldVersion);
        this.addVersion(newVersion);
    }

    public synchronized void removeVersion(long oldVersion) {
        int oldCount = this.objectVersions_.remove((Object)oldVersion, 1);
        if (oldCount == 1 && oldVersion == this.minVersion_) {
            Multiset.Entry entry = this.objectVersions_.firstEntry();
            this.minVersion_ = entry != null ? (Long)entry.getElement() : 0L;
        }
    }

    public synchronized void addVersion(long newVersion) {
        if (this.objectVersions_.isEmpty() || newVersion < this.minVersion_) {
            this.minVersion_ = newVersion;
        }
        this.objectVersions_.add((Object)newVersion);
    }

    public synchronized long getMinimumVersion() {
        return this.minVersion_;
    }

    public void addAll(List<? extends CatalogObject> catalogObjects) {
        for (CatalogObject catalogObject : catalogObjects) {
            this.addVersion(catalogObject.getCatalogVersion());
        }
    }

    public void removeAll(List<? extends CatalogObject> catalogObjects) {
        for (CatalogObject catalogObject : catalogObjects) {
            this.removeVersion(catalogObject.getCatalogVersion());
        }
    }

    public synchronized void clear() {
        this.minVersion_ = 0L;
        this.objectVersions_.clear();
    }
}

