/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TTable;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public abstract class CatalogInterners {
    private static Interner<TNetworkAddress> NETWORK_ADDRESS_INTERNER = Interners.newWeakInterner();
    private static Interner<String> STRING_INTERNER = Interners.newWeakInterner();

    private CatalogInterners() {
    }

    public static void internFieldsInPlace(Table msTable) {
        if (msTable == null) {
            return;
        }
        if (msTable.isSetDbName()) {
            msTable.setDbName((String)STRING_INTERNER.intern((Object)msTable.getDbName()));
        }
        if (msTable.isSetOwner()) {
            msTable.setOwner((String)STRING_INTERNER.intern((Object)msTable.getOwner()));
        }
        if (msTable.isSetParameters()) {
            msTable.setParameters(CatalogInterners.internParameters(msTable.getParameters()));
        }
        if (msTable.isSetTableType()) {
            msTable.setTableType((String)STRING_INTERNER.intern((Object)msTable.getTableType()));
        }
        if (msTable.isSetSd()) {
            CatalogInterners.internFieldsInPlace(msTable.getSd());
        }
        if (msTable.isSetPartitionKeys()) {
            for (FieldSchema fs : msTable.getPartitionKeys()) {
                CatalogInterners.internFieldsInPlace(fs);
            }
        }
    }

    public static void internFieldsInPlace(TTable table) {
        if (table == null) {
            return;
        }
        CatalogInterners.internFieldsInPlace(table.getClustering_columns());
        CatalogInterners.internFieldsInPlace(table.getColumns());
        if (table.isSetHdfs_table()) {
            table.hdfs_table.setNullPartitionKeyValue(table.hdfs_table.getNullPartitionKeyValue().intern());
            table.hdfs_table.setNullColumnValue(table.hdfs_table.getNullColumnValue().intern());
            table.hdfs_table.setNetwork_addresses(CatalogInterners.internAddresses(table.hdfs_table.getNetwork_addresses()));
        }
    }

    private static void internFieldsInPlace(List<TColumn> cols) {
        if (cols == null) {
            return;
        }
        for (TColumn col : cols) {
            if (!col.isSetColumnName()) continue;
            col.setColumnName((String)STRING_INTERNER.intern((Object)col.getColumnName()));
        }
    }

    public static void internFieldsInPlace(StorageDescriptor sd) {
        if (sd == null) {
            return;
        }
        if (sd.isSetCols()) {
            for (FieldSchema fs : sd.getCols()) {
                CatalogInterners.internFieldsInPlace(fs);
            }
        }
        if (sd.isSetInputFormat()) {
            sd.setInputFormat((String)STRING_INTERNER.intern((Object)sd.getInputFormat()));
        }
        if (sd.isSetOutputFormat()) {
            sd.setOutputFormat((String)STRING_INTERNER.intern((Object)sd.getOutputFormat()));
        }
        if (sd.isSetParameters()) {
            sd.setParameters(CatalogInterners.internParameters(sd.getParameters()));
        }
    }

    private static void internFieldsInPlace(FieldSchema fs) {
        if (fs == null) {
            return;
        }
        if (fs.isSetName()) {
            fs.setName((String)STRING_INTERNER.intern((Object)fs.getName()));
        }
        if (fs.isSetType()) {
            fs.setType((String)STRING_INTERNER.intern((Object)fs.getType()));
        }
    }

    public static Map<String, String> internParameters(Map<String, String> parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap ret = Maps.newHashMapWithExpectedSize((int)parameters.size());
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            String val = e.getValue();
            if (val.isEmpty() || "-1".equals(val) || "0".equals(val) || "true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val) || "TASK".equals(val) || val.startsWith("impala_")) {
                val = val.intern();
            } else if (val.length() <= 2) {
                val = (String)STRING_INTERNER.intern((Object)val);
            }
            ret.put(STRING_INTERNER.intern((Object)e.getKey()), val);
        }
        Preconditions.checkState((ret.size() == parameters.size() ? 1 : 0) != 0);
        return ret;
    }

    private static List<TNetworkAddress> internAddresses(List<TNetworkAddress> addrs) {
        if (addrs == null) {
            return null;
        }
        ArrayList ret = Lists.newArrayListWithCapacity((int)addrs.size());
        for (TNetworkAddress addr : addrs) {
            ret.add(CatalogInterners.internNetworkAddress(addr));
        }
        return ret;
    }

    public static String internString(String value) {
        if (value == null) {
            return null;
        }
        return (String)STRING_INTERNER.intern((Object)value);
    }

    public static TNetworkAddress internNetworkAddress(TNetworkAddress addr) {
        if (addr == null) {
            return null;
        }
        return (TNetworkAddress)NETWORK_ADDRESS_INTERNER.intern((Object)new TNetworkAddress(addr){
            private static final long serialVersionUID = 1L;

            @Override
            public void clear() {
                throw new UnsupportedOperationException("immutable");
            }

            @Override
            public TNetworkAddress setHostname(String hostname) {
                throw new UnsupportedOperationException("immutable");
            }

            @Override
            public TNetworkAddress setPort(int port) {
                throw new UnsupportedOperationException("immutable");
            }

            @Override
            public void read(TProtocol iprot) throws TException {
                throw new UnsupportedOperationException("immutable");
            }
        });
    }
}

