/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.thrift.TCatalogObject;

public class CatalogDeltaLog {
    private SortedMap<Long, TCatalogObject> removedCatalogObjects_ = new TreeMap<Long, TCatalogObject>();

    public synchronized void addRemovedObject(TCatalogObject catalogObject) {
        Preconditions.checkNotNull((Object)catalogObject);
        this.removedCatalogObjects_.put(catalogObject.getCatalog_version(), catalogObject);
    }

    public synchronized List<TCatalogObject> retrieveObjects(long fromVersion, long toVersion) {
        SortedMap<Long, TCatalogObject> objects = this.removedCatalogObjects_.subMap(fromVersion + 1L, toVersion + 1L);
        return ImmutableList.copyOf(objects.values());
    }

    public synchronized void garbageCollect(long currentCatalogVersion) {
        if (!this.removedCatalogObjects_.isEmpty() && this.removedCatalogObjects_.firstKey() < currentCatalogVersion) {
            this.removedCatalogObjects_ = new TreeMap<Long, TCatalogObject>(this.removedCatalogObjects_.tailMap(currentCatalogVersion));
        }
    }

    public synchronized boolean wasObjectRemovedAfter(TCatalogObject catalogObject) {
        Preconditions.checkNotNull((Object)catalogObject);
        if (this.removedCatalogObjects_.isEmpty()) {
            return false;
        }
        SortedMap<Long, TCatalogObject> candidateObjects = this.removedCatalogObjects_.tailMap(catalogObject.getCatalog_version());
        for (Map.Entry<Long, TCatalogObject> entry : candidateObjects.entrySet()) {
            if (!Catalog.keyEquals(catalogObject, entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

