/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;

public class ArrayType
extends Type {
    private final Type itemType_;

    public ArrayType(Type itemType) {
        this.itemType_ = itemType;
    }

    public Type getItemType() {
        return this.itemType_;
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "ARRAY<...>";
        }
        return String.format("ARRAY<%s>", this.itemType_.toSql(depth + 1));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ArrayType)) {
            return false;
        }
        ArrayType otherArrayType = (ArrayType)other;
        return otherArrayType.itemType_.equals(this.itemType_);
    }

    @Override
    public int hashCode() {
        return 1 + this.itemType_.hashCode();
    }

    @Override
    public void toThrift(TColumnType container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull((Object)this.itemType_);
        node.setType(TTypeNodeType.ARRAY);
        this.itemType_.toThrift(container);
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = StringUtils.repeat((char)' ', (int)lpad);
        if (this.itemType_.isScalarType()) {
            return leftPadding + this.toSql();
        }
        String structStr = this.itemType_.prettyPrint(lpad);
        structStr = structStr.substring(lpad);
        return String.format("%sARRAY<%s>", leftPadding, structStr);
    }
}

