/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TAggregateFunction;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TSymbolLookupParams;
import org.apache.impala.thrift.TSymbolType;

public class AggregateFunction
extends Function {
    private Type intermediateType_;
    private String updateFnSymbol_;
    private String initFnSymbol_;
    private String serializeFnSymbol_;
    private String mergeFnSymbol_;
    private String getValueFnSymbol_;
    private String removeFnSymbol_;
    private String finalizeFnSymbol_;
    private boolean ignoresDistinct_;
    private boolean isAnalyticFn_;
    private boolean isAggregateFn_;
    private boolean returnsNonNullOnEmpty_;

    public AggregateFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs) {
        super(fnName, argTypes, retType, hasVarArgs);
    }

    public AggregateFunction(FunctionName fnName, List<Type> argTypes, Type retType, Type intermediateType, HdfsUri location, String updateFnSymbol, String initFnSymbol, String serializeFnSymbol, String mergeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol) {
        super(fnName, argTypes, retType, false);
        this.setLocation(location);
        this.intermediateType_ = intermediateType.equals(retType) ? null : intermediateType;
        this.updateFnSymbol_ = updateFnSymbol;
        this.initFnSymbol_ = initFnSymbol;
        this.serializeFnSymbol_ = serializeFnSymbol;
        this.mergeFnSymbol_ = mergeFnSymbol;
        this.getValueFnSymbol_ = getValueFnSymbol;
        this.removeFnSymbol_ = removeFnSymbol;
        this.finalizeFnSymbol_ = finalizeFnSymbol;
        this.ignoresDistinct_ = false;
        this.isAnalyticFn_ = false;
        this.isAggregateFn_ = true;
        this.returnsNonNullOnEmpty_ = false;
    }

    public static AggregateFunction createForTesting(FunctionName fnName, List<Type> argTypes, Type retType, Type intermediateType, HdfsUri location, String updateFnSymbol, String initFnSymbol, String serializeFnSymbol, String mergeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, TFunctionBinaryType fnType) {
        AggregateFunction fn = new AggregateFunction(fnName, argTypes, retType, intermediateType, location, updateFnSymbol, initFnSymbol, serializeFnSymbol, mergeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol);
        fn.setBinaryType(fnType);
        return fn;
    }

    public static AggregateFunction createBuiltin(Db db, String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        return AggregateFunction.createBuiltin(db, name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, mergeFnSymbol, serializeFnSymbol, null, null, finalizeFnSymbol, ignoresDistinct, isAnalyticFn, returnsNonNullOnEmpty);
    }

    public static AggregateFunction createBuiltin(Db db, String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String mergeFnSymbol, String serializeFnSymbol, String getValueFnSymbol, String removeFnSymbol, String finalizeFnSymbol, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        Preconditions.checkState((initFnSymbol != null ? 1 : 0) != 0);
        Preconditions.checkState((updateFnSymbol != null ? 1 : 0) != 0);
        Preconditions.checkState((mergeFnSymbol != null ? 1 : 0) != 0);
        AggregateFunction fn = new AggregateFunction(new FunctionName(db.getName(), name), argTypes, retType, intermediateType, null, updateFnSymbol, initFnSymbol, serializeFnSymbol, mergeFnSymbol, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.ignoresDistinct_ = ignoresDistinct;
        fn.isAnalyticFn_ = isAnalyticFn;
        fn.isAggregateFn_ = true;
        fn.returnsNonNullOnEmpty_ = returnsNonNullOnEmpty;
        fn.setIsPersistent(true);
        return fn;
    }

    public static AggregateFunction createUnsupportedBuiltin(Db db, String name, List<Type> argTypes, Type retType, Type intermediateType) {
        AggregateFunction fn = new AggregateFunction(new FunctionName(db.getName(), name), argTypes, retType, intermediateType, null, null, null, null, null, null, null, null);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.isAggregateFn_ = true;
        fn.setUnsupported();
        return fn;
    }

    public static AggregateFunction createRewrittenBuiltin(Db db, String name, List<Type> argTypes, Type retType, boolean ignoresDistinct, boolean isAnalyticFn, boolean returnsNonNullOnEmpty) {
        AggregateFunction fn = new AggregateFunction(new FunctionName(db.getName(), name), argTypes, retType, false);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.ignoresDistinct_ = ignoresDistinct;
        fn.isAnalyticFn_ = isAnalyticFn;
        fn.isAggregateFn_ = true;
        fn.returnsNonNullOnEmpty_ = returnsNonNullOnEmpty;
        fn.setIsPersistent(true);
        return fn;
    }

    public static AggregateFunction createAnalyticBuiltin(Db db, String name, List<Type> argTypes, Type retType, Type intermediateType) {
        return AggregateFunction.createAnalyticBuiltin(db, name, argTypes, retType, intermediateType, null, null, null, null, null, true);
    }

    public static AggregateFunction createAnalyticBuiltin(Db db, String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String removeFnSymbol, String getValueFnSymbol, String finalizeFnSymbol) {
        return AggregateFunction.createAnalyticBuiltin(db, name, argTypes, retType, intermediateType, initFnSymbol, updateFnSymbol, removeFnSymbol, getValueFnSymbol, finalizeFnSymbol, true);
    }

    public static AggregateFunction createAnalyticBuiltin(Db db, String name, List<Type> argTypes, Type retType, Type intermediateType, String initFnSymbol, String updateFnSymbol, String removeFnSymbol, String getValueFnSymbol, String finalizeFnSymbol, boolean isUserVisible) {
        AggregateFunction fn = new AggregateFunction(new FunctionName(db.getName(), name), argTypes, retType, intermediateType, null, updateFnSymbol, initFnSymbol, null, null, getValueFnSymbol, removeFnSymbol, finalizeFnSymbol);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.ignoresDistinct_ = false;
        fn.isAnalyticFn_ = true;
        fn.isAggregateFn_ = false;
        fn.returnsNonNullOnEmpty_ = false;
        fn.setUserVisible(isUserVisible);
        fn.setIsPersistent(true);
        return fn;
    }

    public String getUpdateFnSymbol() {
        return this.updateFnSymbol_;
    }

    public String getInitFnSymbol() {
        return this.initFnSymbol_;
    }

    public String getSerializeFnSymbol() {
        return this.serializeFnSymbol_;
    }

    public String getMergeFnSymbol() {
        return this.mergeFnSymbol_;
    }

    public String getFinalizeFnSymbol() {
        return this.finalizeFnSymbol_;
    }

    public String getRemoveFnSymbol() {
        return this.removeFnSymbol_;
    }

    public String getValueFnSymbol() {
        return this.getValueFnSymbol_;
    }

    public boolean ignoresDistinct() {
        return this.ignoresDistinct_;
    }

    public boolean isAnalyticFn() {
        return this.isAnalyticFn_;
    }

    public boolean isAggregateFn() {
        return this.isAggregateFn_;
    }

    public boolean returnsNonNullOnEmpty() {
        return this.returnsNonNullOnEmpty_;
    }

    public Type getIntermediateType() {
        return this.intermediateType_;
    }

    public void setUpdateFnSymbol(String fn) {
        this.updateFnSymbol_ = fn;
    }

    public void setInitFnSymbol(String fn) {
        this.initFnSymbol_ = fn;
    }

    public void setSerializeFnSymbol(String fn) {
        this.serializeFnSymbol_ = fn;
    }

    public void setMergeFnSymbol(String fn) {
        this.mergeFnSymbol_ = fn;
    }

    public void setFinalizeFnSymbol(String fn) {
        this.finalizeFnSymbol_ = fn;
    }

    public void setIntermediateType(Type t) {
        this.intermediateType_ = t;
    }

    public static List<Expr> getCanonicalDistinctAggChildren(FunctionCallExpr aggFn) {
        Preconditions.checkState((boolean)aggFn.isDistinct());
        ArrayList<Expr> result = new ArrayList<Expr>();
        if (aggFn.getFnName().getFunction().equalsIgnoreCase("group_concat")) {
            result.add(((Expr)aggFn.getChild(0)).ignoreImplicitCast());
        } else {
            for (Expr c : aggFn.getChildren()) {
                result.add(c.ignoreImplicitCast());
            }
        }
        return result;
    }

    @Override
    protected TSymbolLookupParams getLookupParams() {
        return this.buildLookupParams(this.getUpdateFnSymbol(), TSymbolType.UDF_EVALUATE, this.intermediateType_, this.hasVarArgs(), false, this.getArgs());
    }

    @Override
    public String toSql(boolean ifNotExists) {
        StringBuilder sb = new StringBuilder("CREATE AGGREGATE FUNCTION ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.dbName()).append(".").append(this.signatureString()).append("\n RETURNS ").append(this.getReturnType());
        if (this.intermediateType_ != null) {
            sb.append("\n INTERMEDIATE ").append(this.intermediateType_);
        }
        sb.append("\n LOCATION '").append(this.location_).append("'\n UPDATE_FN='").append(this.updateFnSymbol_).append("'\n INIT_FN='").append(this.initFnSymbol_).append("'\n MERGE_FN='").append(this.mergeFnSymbol_).append("'");
        if (this.serializeFnSymbol_ != null) {
            sb.append("\n SERIALIZE_FN='").append(this.serializeFnSymbol_).append("'");
        }
        if (this.finalizeFnSymbol_ != null) {
            sb.append("\n FINALIZE_FN='").append(this.finalizeFnSymbol_).append("'");
        }
        return sb.toString();
    }

    @Override
    public TFunction toThrift() {
        TFunction fn = super.toThrift();
        TAggregateFunction agg_fn = new TAggregateFunction();
        agg_fn.setIs_analytic_only_fn(this.isAnalyticFn_ && !this.isAggregateFn_);
        agg_fn.setUpdate_fn_symbol(this.updateFnSymbol_);
        agg_fn.setInit_fn_symbol(this.initFnSymbol_);
        if (this.serializeFnSymbol_ != null) {
            agg_fn.setSerialize_fn_symbol(this.serializeFnSymbol_);
        }
        agg_fn.setMerge_fn_symbol(this.mergeFnSymbol_);
        if (this.getValueFnSymbol_ != null) {
            agg_fn.setGet_value_fn_symbol(this.getValueFnSymbol_);
        }
        if (this.removeFnSymbol_ != null) {
            agg_fn.setRemove_fn_symbol(this.removeFnSymbol_);
        }
        if (this.finalizeFnSymbol_ != null) {
            agg_fn.setFinalize_fn_symbol(this.finalizeFnSymbol_);
        }
        if (this.intermediateType_ != null) {
            agg_fn.setIntermediate_type(this.intermediateType_.toThrift());
        } else {
            agg_fn.setIntermediate_type(this.getReturnType().toThrift());
        }
        agg_fn.setIgnores_distinct(this.ignoresDistinct_);
        fn.setAggregate_fn(agg_fn);
        return fn;
    }
}

