/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TPrivilege;

public class RangerUtil {
    private RangerUtil() {
    }

    public static Map<String, String> createColumnResource(TPrivilege privilege) {
        HashMap<String, String> resource = new HashMap<String, String>();
        resource.put("database", RangerUtil.getOrAll(privilege.getDb_name()));
        resource.put("table", RangerUtil.getOrAll(privilege.getTable_name()));
        resource.put("column", RangerUtil.getOrAll(privilege.getColumn_name()));
        return resource;
    }

    public static Map<String, String> createUriResource(TPrivilege privilege) {
        HashMap<String, String> resource = new HashMap<String, String>();
        String uri = privilege.getUri();
        resource.put("url", uri == null ? "*" : uri);
        return resource;
    }

    public static Map<String, String> createFunctionResource(TPrivilege privilege) {
        HashMap<String, String> resource = new HashMap<String, String>();
        resource.put("database", RangerUtil.getOrAll(privilege.getDb_name()));
        resource.put("udf", RangerUtil.getOrAll(privilege.getFn_name()));
        return resource;
    }

    public static Map<String, String> createStorageHandlerUriResource(TPrivilege privilege) {
        HashMap<String, String> resource = new HashMap<String, String>();
        resource.put("storage-type", RangerUtil.getOrAll(privilege.getStorage_type()));
        resource.put("storage-url", RangerUtil.getOrAll(privilege.getStorage_url()));
        return resource;
    }

    private static String getOrAll(String resource) {
        return resource == null ? "*" : resource;
    }

    public static Set<String> getGroups(String user) {
        UserGroupInformation ugi = RuntimeEnv.INSTANCE.isTestEnv() || BackendConfig.INSTANCE.useCustomizedUserGroupsMapperForRanger() ? UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{user}) : UserGroupInformation.createRemoteUser((String)user);
        return Sets.newHashSet((Object[])ugi.getGroupNames());
    }

    public static void validateRangerAdmin(RangerImpalaPlugin plugin, String user) throws Exception {
        plugin.getAllRoles(user, null);
    }

    public static boolean roleExists(RangerImpalaPlugin plugin, String roleName) {
        Set roleSet = plugin.getRoles().getRangerRoles();
        if (roleSet == null) {
            return false;
        }
        return roleSet.stream().anyMatch(r -> r.getName().equals(roleName));
    }
}

