/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.impala.authorization.AuthorizationDelta;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.User;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.authorization.ranger.RangerUtil;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TCreateDropRoleParams;
import org.apache.impala.thrift.TDdlExecResponse;
import org.apache.impala.thrift.TGrantRevokePrivParams;
import org.apache.impala.thrift.TGrantRevokeRoleParams;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TShowGrantPrincipalParams;
import org.apache.impala.thrift.TShowRolesParams;
import org.apache.impala.thrift.TShowRolesResult;
import org.apache.impala.util.ClassUtil;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerImpaladAuthorizationManager
implements AuthorizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(RangerImpaladAuthorizationManager.class);
    private static final String ANY = "*";
    private final Supplier<RangerImpalaPlugin> plugin_;

    public RangerImpaladAuthorizationManager(Supplier<RangerImpalaPlugin> pluginSupplier) {
        this.plugin_ = pluginSupplier;
    }

    @Override
    public void createRole(User requestingUser, TCreateDropRoleParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void dropRole(User requestingUser, TCreateDropRoleParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public TShowRolesResult getRoles(TShowRolesParams params) throws ImpalaException {
        try {
            Set roleNames;
            boolean adminOp;
            TShowRolesResult result = new TShowRolesResult();
            HashSet groups = RangerUtil.getGroups(params.getRequesting_user());
            boolean bl = adminOp = !groups.contains(params.getGrant_group()) && !params.is_show_current_roles;
            if (adminOp) {
                RangerUtil.validateRangerAdmin(this.plugin_.get(), params.getRequesting_user());
            }
            if (params.isIs_show_current_roles() || params.isSetGrant_group()) {
                HashSet groupNames;
                if (params.isIs_show_current_roles()) {
                    groupNames = groups;
                } else {
                    Preconditions.checkState((boolean)params.isSetGrant_group());
                    groupNames = Sets.newHashSet((Object[])new String[]{params.getGrant_group()});
                }
                roleNames = this.plugin_.get().getRolesFromUserAndGroups(null, groupNames);
            } else {
                Preconditions.checkState((!params.isIs_show_current_roles() ? 1 : 0) != 0);
                Set roles = this.plugin_.get().getRoles().getRangerRoles();
                if (null == roles) {
                    roles = Collections.emptySet();
                }
                roleNames = roles.stream().map(RangerRole::getName).collect(Collectors.toSet());
            }
            result.setRole_names(Lists.newArrayList((Iterable)roleNames));
            Collections.sort(result.getRole_names());
            return result;
        }
        catch (Exception e) {
            if (params.is_show_current_roles) {
                LOG.error("Error executing SHOW CURRENT ROLES.", (Throwable)e);
                throw new InternalException("Error executing SHOW CURRENT ROLES. Ranger error message: " + e.getMessage());
            }
            if (params.isSetGrant_group()) {
                LOG.error("Error executing SHOW ROLE GRANT GROUP " + params.getGrant_group() + ".");
                throw new InternalException("Error executing SHOW ROLE GRANT GROUP " + params.getGrant_group() + ". Ranger error message: " + e.getMessage());
            }
            LOG.error("Error executing SHOW ROLES.");
            throw new InternalException("Error executing SHOW ROLES. Ranger error message: " + e.getMessage());
        }
    }

    @Override
    public void grantRoleToGroup(User requestingUser, TGrantRevokeRoleParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void revokeRoleFromGroup(User requestingUser, TGrantRevokeRoleParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void grantPrivilegeToRole(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void revokePrivilegeFromRole(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void grantPrivilegeToUser(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void revokePrivilegeFromUser(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void grantPrivilegeToGroup(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    @Override
    public void revokePrivilegeFromGroup(TCatalogServiceRequestHeader header, TGrantRevokePrivParams params, TDdlExecResponse response) throws ImpalaException {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    private static Optional<String> getResourceName(String resourceType, String resourceName, RangerResourceACLs.AccessResult accessResult) {
        RangerPolicy.RangerPolicyResource rangerPolicyResource = (RangerPolicy.RangerPolicyResource)accessResult.getPolicy().getResources().get(resourceType);
        if (rangerPolicyResource == null) {
            return Optional.empty();
        }
        boolean nameIsPresent = rangerPolicyResource.getValues().contains(resourceName);
        return nameIsPresent ? Optional.of(resourceName) : Optional.of(ANY);
    }

    private static boolean isDelegateAdmin(RangerResourceACLs.AccessResult accessResult, String privilegeLevel, String principal, TPrincipalType type) {
        block5: for (RangerPolicy.RangerPolicyItem item : accessResult.getPolicy().getPolicyItems()) {
            switch (type) {
                case USER: {
                    if (!item.getUsers().contains(principal) || !item.getAccesses().stream().anyMatch(rpia -> rpia.getType().equals(privilegeLevel))) continue block5;
                    return item.getDelegateAdmin();
                }
                case GROUP: {
                    if (!item.getGroups().contains(principal)) continue block5;
                    return item.getDelegateAdmin();
                }
                case ROLE: {
                    if (!item.getRoles().contains(principal)) continue block5;
                    return item.getDelegateAdmin();
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported principal type %s", new Object[]{type}));
        }
        return false;
    }

    private static RangerResultRow toResultRow(String rangerPrivilegeLevel, String principal, TPrincipalType type, RangerResourceACLs.AccessResult accessResult, TPrivilege privilege) {
        TPrivilegeLevel level;
        TPrivilege rangerPrivilege = new TPrivilege();
        rangerPrivilege.setScope(privilege.getScope());
        boolean grantOption = RangerImpaladAuthorizationManager.isDelegateAdmin(accessResult, rangerPrivilegeLevel, principal, type);
        try {
            level = TPrivilegeLevel.valueOf(rangerPrivilegeLevel.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            if (rangerPrivilegeLevel.equals("update")) {
                level = TPrivilegeLevel.INSERT;
            }
            return null;
        }
        Date createTime = accessResult.getPolicy().getCreateTime();
        Long longTime = createTime == null ? null : Long.valueOf(createTime.getTime());
        Optional<String> database = RangerImpaladAuthorizationManager.getResourceName("database", privilege.getDb_name(), accessResult);
        Optional<String> table = RangerImpaladAuthorizationManager.getResourceName("table", privilege.getTable_name(), accessResult);
        Optional<String> column = RangerImpaladAuthorizationManager.getResourceName("column", privilege.getColumn_name(), accessResult);
        Optional<String> uri = RangerImpaladAuthorizationManager.getResourceName("url", privilege.getUri(), accessResult);
        Optional<String> storageType = RangerImpaladAuthorizationManager.getResourceName("storage-type", privilege.getStorage_type(), accessResult);
        Optional<String> storageUri = RangerImpaladAuthorizationManager.getResourceName("storage-url", privilege.getStorage_url(), accessResult);
        Optional<String> udf = RangerImpaladAuthorizationManager.getResourceName("udf", privilege.getFn_name(), accessResult);
        return new RangerResultRow(type, principal, database.orElse(""), table.orElse(""), column.orElse(""), uri.orElse(""), storageType.orElse(""), storageUri.orElse(""), udf.orElse(""), level, grantOption, longTime);
    }

    private static List<RangerAccessRequest> buildAccessRequests(TPrivilege privilege) {
        ArrayList<Map<String, String>> resources = new ArrayList<Map<String, String>>();
        if (privilege == null) {
            throw new UnsupportedOperationException("SHOW GRANT is not supported without a defined resource in Ranger.");
        }
        if (privilege.getColumn_name() != null || privilege.getTable_name() != null) {
            resources.add(RangerUtil.createColumnResource(privilege));
        } else if (privilege.getUri() != null) {
            resources.add(RangerUtil.createUriResource(privilege));
        } else if (privilege.getFn_name() != null) {
            resources.add(RangerUtil.createFunctionResource(privilege));
        } else if (privilege.getDb_name() != null) {
            resources.add(RangerUtil.createColumnResource(privilege));
            resources.add(RangerUtil.createFunctionResource(privilege));
        } else if (privilege.getStorage_url() != null || privilege.getStorage_type() != null) {
            resources.add(RangerUtil.createStorageHandlerUriResource(privilege));
        } else {
            resources.add(RangerUtil.createColumnResource(privilege));
            resources.add(RangerUtil.createUriResource(privilege));
            resources.add(RangerUtil.createStorageHandlerUriResource(privilege));
            resources.add(RangerUtil.createFunctionResource(privilege));
        }
        ArrayList<RangerAccessRequest> requests = new ArrayList<RangerAccessRequest>();
        for (Map map : resources) {
            RangerAccessRequestImpl request = new RangerAccessRequestImpl();
            request.setResource((RangerAccessResource)new RangerAccessResourceImpl(Collections.unmodifiableMap(map)));
            request.setAccessType("_any");
            requests.add((RangerAccessRequest)request);
        }
        return requests;
    }

    private static List<RangerResultRow> aclToPrivilege(Map<String, RangerResourceACLs.AccessResult> acls, String principal, TPrivilege privilege, TPrincipalType type) {
        return acls.entrySet().stream().map(en -> RangerImpaladAuthorizationManager.toResultRow((String)en.getKey(), principal, type, (RangerResourceACLs.AccessResult)en.getValue(), privilege)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public TResultSet getPrivileges(TShowGrantPrincipalParams params) throws ImpalaException {
        List<RangerAccessRequest> requests = RangerImpaladAuthorizationManager.buildAccessRequests(params.privilege);
        TreeSet resultSet = new TreeSet();
        TResultSet result = new TResultSet();
        result.setSchema(RangerResultRow.getSchema());
        result.setRows(new ArrayList<TResultRow>());
        for (RangerAccessRequest request : requests) {
            ArrayList<RangerResultRow> resultRows;
            RangerResourceACLs acls = this.plugin_.get().getResourceACLs(request);
            switch (params.principal_type) {
                case USER: {
                    resultRows = new ArrayList<RangerResultRow>(RangerImpaladAuthorizationManager.aclToPrivilege(acls.getUserACLs().getOrDefault(params.name, Collections.emptyMap()), params.name, params.privilege, TPrincipalType.USER));
                    for (String group : RangerUtil.getGroups(params.name)) {
                        resultRows.addAll(RangerImpaladAuthorizationManager.aclToPrivilege(acls.getGroupACLs().getOrDefault(group, Collections.emptyMap()), params.name, params.privilege, TPrincipalType.GROUP));
                    }
                    break;
                }
                case GROUP: {
                    resultRows = new ArrayList<RangerResultRow>(RangerImpaladAuthorizationManager.aclToPrivilege(acls.getGroupACLs().getOrDefault(params.name, Collections.emptyMap()), params.name, params.privilege, TPrincipalType.GROUP));
                    break;
                }
                case ROLE: {
                    resultRows = new ArrayList<RangerResultRow>(RangerImpaladAuthorizationManager.aclToPrivilege(acls.getRoleACLs().getOrDefault(params.name, Collections.emptyMap()), params.name, params.privilege, TPrincipalType.ROLE));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported principal type %s.", new Object[]{params.principal_type}));
                }
            }
            RangerResourceResult resourceResult = new RangerResourceResult();
            for (RangerResultRow row : resultRows) {
                if (!row.column_.equals(ANY) && !row.column_.isEmpty()) {
                    resourceResult.addColumnResult(row);
                    continue;
                }
                if (!row.table_.equals(ANY) && !row.table_.isEmpty()) {
                    resourceResult.addTableResult(row);
                    continue;
                }
                if (!row.udf_.equals(ANY) && !row.udf_.isEmpty()) {
                    resourceResult.addUdfResult(row);
                    continue;
                }
                if (!row.database_.equals(ANY) && !row.database_.isEmpty()) {
                    resourceResult.addDatabaseResult(row);
                    continue;
                }
                resourceResult.addServerResult(row);
            }
            resourceResult.getResultRows().forEach(principal -> resultSet.add(principal.toResultRow()));
        }
        resultSet.forEach(result::addToRows);
        return result;
    }

    @Override
    public void updateDatabaseOwnerPrivilege(String serverName, String databaseName, String oldOwner, PrincipalType oldOwnerType, String newOwner, PrincipalType newOwnerType, TDdlExecResponse response) throws ImpalaException {
    }

    @Override
    public void updateTableOwnerPrivilege(String serverName, String databaseName, String tableName, String oldOwner, PrincipalType oldOwnerType, String newOwner, PrincipalType newOwnerType, TDdlExecResponse response) throws ImpalaException {
    }

    @Override
    public AuthorizationDelta refreshAuthorization(boolean resetVersions) {
        throw new UnsupportedOperationException(String.format("%s is not supported in Impalad", ClassUtil.getMethodName()));
    }

    private static class RangerResultRow {
        private final TPrincipalType principalType_;
        private final String principalName_;
        private final String database_;
        private final String table_;
        private final String column_;
        private final String uri_;
        private final String storageType_;
        private final String storageUri_;
        private final String udf_;
        private final TPrivilegeLevel privilege_;
        private final boolean grantOption_;
        private final Long createTime_;

        public RangerResultRow(TPrincipalType principalType, String principalName, String database, String table, String column, String uri, String storageType, String storageUri, String udf, TPrivilegeLevel privilege, boolean grantOption, Long createTime) {
            this.principalType_ = principalType;
            this.principalName_ = principalName;
            this.database_ = database;
            this.table_ = table;
            this.column_ = column;
            this.uri_ = uri;
            this.storageType_ = storageType;
            this.storageUri_ = storageUri;
            this.udf_ = udf;
            this.privilege_ = privilege;
            this.grantOption_ = grantOption;
            this.createTime_ = createTime;
        }

        public static TResultSetMetadata getSchema() {
            TResultSetMetadata schema = new TResultSetMetadata();
            schema.addToColumns(new TColumn("principal_type", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("principal_name", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("database", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("table", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("column", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("uri", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("storage_type", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("storage_uri", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("udf", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("privilege", Type.STRING.toThrift()));
            schema.addToColumns(new TColumn("grant_option", Type.BOOLEAN.toThrift()));
            schema.addToColumns(new TColumn("create_time", Type.STRING.toThrift()));
            return schema;
        }

        public TResultRow toResultRow() {
            TResultRowBuilder rowBuilder = new TResultRowBuilder();
            rowBuilder.add(this.principalType_.name().toUpperCase());
            rowBuilder.add(this.principalName_);
            rowBuilder.add(this.database_);
            rowBuilder.add(this.table_);
            rowBuilder.add(this.column_);
            rowBuilder.add(this.uri_);
            rowBuilder.add(this.storageType_);
            rowBuilder.add(this.storageUri_);
            rowBuilder.add(this.udf_);
            rowBuilder.add(this.privilege_.name().toLowerCase());
            rowBuilder.add(this.grantOption_);
            if (this.createTime_ == null) {
                rowBuilder.add(null);
            } else {
                rowBuilder.add(this.createTime_);
            }
            return rowBuilder.get();
        }
    }

    private static class RangerResourceResult {
        private List<RangerResultRow> server = new ArrayList<RangerResultRow>();
        private List<RangerResultRow> database = new ArrayList<RangerResultRow>();
        private List<RangerResultRow> table = new ArrayList<RangerResultRow>();
        private List<RangerResultRow> column = new ArrayList<RangerResultRow>();
        private List<RangerResultRow> udf = new ArrayList<RangerResultRow>();

        public RangerResourceResult addServerResult(RangerResultRow result) {
            this.server.add(result);
            return this;
        }

        public RangerResourceResult addDatabaseResult(RangerResultRow result) {
            this.database.add(result);
            return this;
        }

        public RangerResourceResult addTableResult(RangerResultRow result) {
            this.table.add(result);
            return this;
        }

        public RangerResourceResult addColumnResult(RangerResultRow result) {
            this.column.add(result);
            return this;
        }

        public RangerResourceResult addUdfResult(RangerResultRow result) {
            this.udf.add(result);
            return this;
        }

        public List<RangerResultRow> getResultRows() {
            ArrayList<RangerResultRow> results = new ArrayList<RangerResultRow>();
            results.addAll(RangerResourceResult.filterIfAll(this.server));
            results.addAll(RangerResourceResult.filterIfAll(this.database));
            results.addAll(RangerResourceResult.filterIfAll(this.table));
            results.addAll(RangerResourceResult.filterIfAll(this.column));
            results.addAll(RangerResourceResult.filterIfAll(this.udf));
            return results;
        }

        private static List<RangerResultRow> filterIfAll(List<RangerResultRow> resultRows) {
            boolean all = resultRows.stream().anyMatch(row -> ((RangerResultRow)row).privilege_ == TPrivilegeLevel.ALL);
            List<RangerResultRow> rows = all ? resultRows.stream().filter(row -> ((RangerResultRow)row).privilege_ == TPrivilegeLevel.ALL).collect(Collectors.toList()) : resultRows;
            return rows;
        }
    }
}

