/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;

public class RangerImpalaResourceBuilder {
    public static final String DATABASE = "database";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String UDF = "udf";
    public static final String URL = "url";
    public static final String STORAGE_TYPE = "storage-type";
    public static final String STORAGE_URL = "storage-url";
    private final RangerAccessResourceImpl rangerAccessResource = new RangerAccessResourceImpl();

    public RangerImpalaResourceBuilder database(String dbName) {
        this.rangerAccessResource.setValue(DATABASE, Preconditions.checkNotNull((Object)dbName));
        return this;
    }

    public RangerImpalaResourceBuilder table(String tableName) {
        this.rangerAccessResource.setValue(TABLE, Preconditions.checkNotNull((Object)tableName));
        return this;
    }

    public RangerImpalaResourceBuilder column(String columnName) {
        this.rangerAccessResource.setValue(COLUMN, Preconditions.checkNotNull((Object)columnName));
        return this;
    }

    public RangerImpalaResourceBuilder function(String fnName) {
        this.rangerAccessResource.setValue(UDF, Preconditions.checkNotNull((Object)fnName));
        return this;
    }

    public RangerImpalaResourceBuilder uri(String uri) {
        this.rangerAccessResource.setValue(URL, Preconditions.checkNotNull((Object)uri));
        return this;
    }

    public RangerImpalaResourceBuilder storageType(String storageType) {
        this.rangerAccessResource.setValue(STORAGE_TYPE, Preconditions.checkNotNull((Object)storageType));
        return this;
    }

    public RangerImpalaResourceBuilder storageUri(String storageUri) {
        this.rangerAccessResource.setValue(STORAGE_URL, Preconditions.checkNotNull((Object)storageUri));
        return this;
    }

    public RangerImpalaResourceBuilder owner(String ownerUser) {
        this.rangerAccessResource.setOwnerUser(ownerUser);
        return this;
    }

    public RangerAccessResourceImpl build() {
        return this.rangerAccessResource;
    }
}

