/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class RangerImpalaPlugin
extends RangerBasePlugin {
    private static volatile RangerImpalaPlugin INSTANCE = null;
    private static String SERVICE_TYPE = null;
    private static String APP_ID = null;
    private static boolean BLOCK_UPDATE_IF_TABLE_MASK_SPECIFIED = true;

    private RangerImpalaPlugin(String serviceType, String appId) {
        super(serviceType, appId);
    }

    public void init() {
        super.init();
        BLOCK_UPDATE_IF_TABLE_MASK_SPECIFIED = this.getConfig().getBoolean("xasecure.hive.block.update.if.rowfilter.columnmask.specified", true);
    }

    public boolean blockUpdateIfTableMaskSpecified() {
        return BLOCK_UPDATE_IF_TABLE_MASK_SPECIFIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static RangerImpalaPlugin getInstance(String serviceType, String appId) {
        if (INSTANCE == null) {
            Class<RangerImpalaPlugin> clazz = RangerImpalaPlugin.class;
            // MONITORENTER : org.apache.impala.authorization.ranger.RangerImpalaPlugin.class
            if (INSTANCE == null) {
                SERVICE_TYPE = serviceType;
                APP_ID = appId;
                INSTANCE = new RangerImpalaPlugin(serviceType, appId);
                INSTANCE.init();
            }
            // MONITOREXIT : clazz
        }
        Preconditions.checkState((boolean)StringUtils.equals((CharSequence)SERVICE_TYPE, (CharSequence)serviceType), (Object)String.format("%s != %s", SERVICE_TYPE, serviceType));
        Preconditions.checkState((boolean)StringUtils.equals((CharSequence)APP_ID, (CharSequence)appId), (Object)String.format("%s != %s", APP_ID, appId));
        return INSTANCE;
    }

    public Set<String> getUnfilteredMaskNames(Collection<String> maskNamesToFilter) {
        HashSet<String> maskNames = new HashSet<String>();
        List maskTypes = this.getServiceDef().getDataMaskDef().getMaskTypes();
        for (RangerServiceDef.RangerDataMaskTypeDef maskType : maskTypes) {
            maskNames.add(maskType.getName().toUpperCase());
        }
        maskNames.removeAll(maskNamesToFilter);
        return maskNames;
    }
}

