/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.function.Supplier;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.authorization.ranger.RangerAuthorizationChecker;
import org.apache.impala.authorization.ranger.RangerAuthorizationConfig;
import org.apache.impala.authorization.ranger.RangerCatalogdAuthorizationManager;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.authorization.ranger.RangerImpaladAuthorizationManager;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeCatalogManager;

public class RangerAuthorizationFactory
implements AuthorizationFactory {
    private final AuthorizationConfig authzConfig_;
    private final RangerAuthorizationChecker authzChecker_;

    public RangerAuthorizationFactory(BackendConfig backendConfig) {
        Preconditions.checkNotNull((Object)backendConfig);
        this.authzConfig_ = RangerAuthorizationFactory.newAuthorizationConfig(backendConfig);
        this.authzChecker_ = new RangerAuthorizationChecker(this.authzConfig_);
    }

    @VisibleForTesting
    public RangerAuthorizationFactory(AuthorizationConfig authzConfig) {
        Preconditions.checkNotNull((Object)authzConfig);
        this.authzConfig_ = authzConfig;
        this.authzChecker_ = new RangerAuthorizationChecker(this.authzConfig_);
    }

    private static AuthorizationConfig newAuthorizationConfig(BackendConfig backendConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)backendConfig.getBackendCfg().getServer_name()) ? 1 : 0) != 0, (Object)"Authorization is enabled but the server name is empty. Set the server name using impalad and catalogd --server_name flag.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)backendConfig.getRangerServiceType()) ? 1 : 0) != 0, (Object)"Ranger service type is empty. Set the Ranger service type using impalad and catalogd --ranger_service_type flag.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)backendConfig.getRangerAppId()) ? 1 : 0) != 0, (Object)"Ranger application ID is empty. Set the Ranger application ID using impalad and catalogd --ranger_app_id flag.");
        return new RangerAuthorizationConfig(backendConfig.getRangerServiceType(), backendConfig.getRangerAppId(), backendConfig.getBackendCfg().getServer_name(), null, null, null);
    }

    @Override
    public AuthorizationConfig getAuthorizationConfig() {
        return this.authzConfig_;
    }

    @Override
    public AuthorizationChecker newAuthorizationChecker(AuthorizationPolicy authzPolicy) {
        return this.authzChecker_;
    }

    @Override
    public AuthorizationManager newAuthorizationManager(FeCatalogManager catalog, Supplier<? extends AuthorizationChecker> authzChecker) {
        Preconditions.checkArgument((boolean)(authzChecker.get() instanceof RangerAuthorizationChecker));
        return new RangerImpaladAuthorizationManager(() -> ((RangerAuthorizationChecker)authzChecker.get()).getRangerImpalaPlugin());
    }

    @Override
    public AuthorizationManager newAuthorizationManager(CatalogServiceCatalog catalog) {
        RangerAuthorizationConfig config = (RangerAuthorizationConfig)this.authzConfig_;
        RangerImpalaPlugin plugin = RangerImpalaPlugin.getInstance(config.getServiceType(), config.getAppId());
        return new RangerCatalogdAuthorizationManager(() -> plugin, catalog);
    }

    @Override
    public boolean supportsTableMasking() {
        return BackendConfig.INSTANCE.isColumnMaskingEnabled() || BackendConfig.INSTANCE.isRowFilteringEnabled();
    }
}

