/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;

public class RangerAuthorizationConfig
implements AuthorizationConfig {
    private final String serviceType_;
    private final String appId_;
    private final String serverName_;
    private final String clusterName_;
    private final String clusterType_;
    private final RangerPolicyEngineOptions policyEngineOptions_;
    private final RangerPluginConfig rangerConfig_;

    public RangerAuthorizationConfig(String serviceType, String appId, String serverName, String clusterName, String clusterType, RangerPolicyEngineOptions policyEngineOptions) {
        this.serviceType_ = (String)Preconditions.checkNotNull((Object)serviceType);
        this.appId_ = (String)Preconditions.checkNotNull((Object)appId);
        this.serverName_ = (String)Preconditions.checkNotNull((Object)serverName);
        this.clusterName_ = clusterName;
        this.clusterType_ = clusterType;
        this.policyEngineOptions_ = policyEngineOptions;
        this.rangerConfig_ = new RangerPluginConfig(this.serviceType_, this.serverName_, this.appId_, this.clusterName_, this.clusterType_, this.policyEngineOptions_);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getProviderName() {
        return "ranger";
    }

    @Override
    public String getServerName() {
        return this.serverName_;
    }

    public String getServiceType() {
        return this.serviceType_;
    }

    public String getAppId() {
        return this.appId_;
    }

    public String getClusterName() {
        return this.clusterName_;
    }

    public String getClusterType() {
        return this.clusterType_;
    }

    public RangerPolicyEngineOptions getPolicyEngineOptions() {
        return this.policyEngineOptions_;
    }

    public RangerPluginConfig getRangerConfig() {
        return this.rangerConfig_;
    }
}

