/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.authorization.Authorizable;
import org.apache.impala.authorization.AuthorizableTable;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.authorization.BaseAuthorizationChecker;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.authorization.User;
import org.apache.impala.authorization.ranger.RangerAuthorizationConfig;
import org.apache.impala.authorization.ranger.RangerAuthorizationContext;
import org.apache.impala.authorization.ranger.RangerBufferAuditHandler;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.authorization.ranger.RangerImpalaResourceBuilder;
import org.apache.impala.authorization.ranger.RangerUtil;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TSessionState;
import org.apache.impala.util.EventSequence;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationChecker
extends BaseAuthorizationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationChecker.class);
    public static final String UPDATE_ACCESS_TYPE = "update";
    public static final String SELECT_ACCESS_TYPE = "select";
    private final RangerImpalaPlugin plugin_;

    public RangerAuthorizationChecker(AuthorizationConfig authzConfig) {
        super(authzConfig);
        Preconditions.checkArgument((boolean)(authzConfig instanceof RangerAuthorizationConfig));
        RangerAuthorizationConfig rangerConfig = (RangerAuthorizationConfig)authzConfig;
        this.plugin_ = RangerImpalaPlugin.getInstance(rangerConfig.getServiceType(), rangerConfig.getAppId());
    }

    @Override
    protected boolean authorizeResource(AuthorizationContext authzCtx, User user, PrivilegeRequest request) throws InternalException {
        Preconditions.checkArgument((boolean)(authzCtx instanceof RangerAuthorizationContext));
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)request);
        RangerAuthorizationContext rangerAuthzCtx = (RangerAuthorizationContext)authzCtx;
        ArrayList<RangerAccessResourceImpl> resources = new ArrayList<RangerAccessResourceImpl>();
        Authorizable authorizable = request.getAuthorizable();
        Privilege privilege = request.getPrivilege();
        switch (authorizable.getType()) {
            case SERVER: {
                resources.add(new RangerImpalaResourceBuilder().database("*").table("*").column("*").build());
                resources.add(new RangerImpalaResourceBuilder().database("*").function("*").build());
                resources.add(new RangerImpalaResourceBuilder().uri("*").build());
                if (privilege != Privilege.ALL && privilege != Privilege.OWNER && privilege != Privilege.RWSTORAGE) break;
                resources.add(new RangerImpalaResourceBuilder().storageType("*").storageUri("*").build());
                break;
            }
            case DB: {
                resources.add(new RangerImpalaResourceBuilder().database(authorizable.getDbName()).owner(authorizable.getOwnerUser()).build());
                break;
            }
            case TABLE: {
                resources.add(new RangerImpalaResourceBuilder().database(authorizable.getDbName()).table(authorizable.getTableName()).owner(authorizable.getOwnerUser()).build());
                break;
            }
            case COLUMN: {
                RangerImpalaResourceBuilder builder = new RangerImpalaResourceBuilder();
                builder.database(authorizable.getDbName());
                if (privilege != Privilege.ANY || !"*".equals(authorizable.getTableName())) {
                    builder.table(authorizable.getTableName());
                }
                if (privilege != Privilege.ANY || !"*".equals(authorizable.getColumnName())) {
                    builder.column(authorizable.getColumnName());
                }
                builder.owner(authorizable.getOwnerUser());
                resources.add(builder.build());
                break;
            }
            case FUNCTION: {
                resources.add(new RangerImpalaResourceBuilder().database(authorizable.getDbName()).function(authorizable.getFnName()).build());
                break;
            }
            case URI: {
                resources.add(new RangerImpalaResourceBuilder().uri(authorizable.getName()).build());
                break;
            }
            case STORAGEHANDLER_URI: {
                resources.add(new RangerImpalaResourceBuilder().storageType(authorizable.getStorageType()).storageUri(authorizable.getStorageUri()).build());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid authorizable type: %s", new Object[]{authorizable.getType()}));
            }
        }
        for (RangerAccessResourceImpl resource : resources) {
            boolean authorized;
            if (!(privilege == Privilege.ANY ? !this.authorizeResource(rangerAuthzCtx, user, resource, authorizable, privilege, rangerAuthzCtx.getAuditHandler()) : !(authorized = privilege.hasAnyOf() ? this.authorizeAny(rangerAuthzCtx, resource, authorizable, user, privilege) : this.authorizeAll(rangerAuthzCtx, resource, authorizable, user, privilege)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void postAuthorize(AuthorizationContext authzCtx, boolean authzOk, boolean analysisOk) {
        Preconditions.checkArgument((boolean)(authzCtx instanceof RangerAuthorizationContext));
        super.postAuthorize(authzCtx, authzOk, analysisOk);
        if (authzOk) {
            ((RangerAuthorizationContext)authzCtx).consolidateAuthzEvents();
            ((RangerAuthorizationContext)authzCtx).applyDeduplicatedAuthzEvents();
        }
        RangerBufferAuditHandler auditHandler = ((RangerAuthorizationContext)authzCtx).getAuditHandler();
        if (authzOk && !analysisOk) {
            auditHandler.getAuthzEvents().clear();
        } else {
            auditHandler.flush();
        }
    }

    @Override
    protected void authorizeRowFilterAndColumnMask(User user, List<PrivilegeRequest> privilegeRequests) throws AuthorizationException, InternalException {
        boolean isColumnMaskingEnabled = BackendConfig.INSTANCE.isColumnMaskingEnabled();
        boolean isRowFilteringEnabled = BackendConfig.INSTANCE.isRowFilteringEnabled();
        if (isColumnMaskingEnabled && isRowFilteringEnabled) {
            return;
        }
        for (PrivilegeRequest request : privilegeRequests) {
            if (!isColumnMaskingEnabled && request.getAuthorizable().getType() == Authorizable.Type.COLUMN) {
                this.throwIfColumnMaskingRequired(user, request.getAuthorizable().getDbName(), request.getAuthorizable().getTableName(), request.getAuthorizable().getColumnName());
                continue;
            }
            if (isRowFilteringEnabled || request.getAuthorizable().getType() != Authorizable.Type.TABLE) continue;
            this.throwIfRowFilteringRequired(user, request.getAuthorizable().getDbName(), request.getAuthorizable().getTableName());
        }
    }

    @Override
    public void invalidateAuthorizationCache() {
        long startTime = System.currentTimeMillis();
        try {
            this.plugin_.refreshPoliciesAndTags();
        }
        finally {
            LOG.debug("Refreshing Ranger policies took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    @Override
    public AuthorizationContext createAuthorizationContext(boolean doAudits, String sqlStmt, TSessionState sessionState, Optional<EventSequence> timeline) {
        RangerAuthorizationContext authzCtx = new RangerAuthorizationContext(sessionState, timeline);
        if (doAudits) {
            if (sqlStmt != null) {
                authzCtx.setAuditHandler(new RangerBufferAuditHandler(sqlStmt, this.plugin_.getClusterName(), sessionState.getNetwork_address().getHostname()));
            } else {
                authzCtx.setAuditHandler(new RangerBufferAuditHandler());
            }
        }
        return authzCtx;
    }

    @Override
    protected void authorizeTableAccess(AuthorizationContext authzCtx, AnalysisContext.AnalysisResult analysisResult, FeCatalog catalog, List<PrivilegeRequest> requests) throws AuthorizationException, InternalException {
        RangerAuthorizationContext originalCtx = (RangerAuthorizationContext)authzCtx;
        RangerBufferAuditHandler originalAuditHandler = originalCtx.getAuditHandler();
        RangerAuthorizationContext tmpCtx = new RangerAuthorizationContext(originalCtx.getSessionState(), originalCtx.getTimeline());
        tmpCtx.setAuditHandler(new RangerBufferAuditHandler(originalAuditHandler));
        AuthorizationException authorizationException = null;
        try {
            super.authorizeTableAccess(tmpCtx, analysisResult, catalog, requests);
        }
        catch (AuthorizationException e) {
            authorizationException = e;
            tmpCtx.getAuditHandler().getAuthzEvents().stream().filter(evt -> !SELECT_ACCESS_TYPE.equalsIgnoreCase(evt.getAccessType()) && "@table".equals(evt.getResourceType()) || ("@table".equals(evt.getResourceType()) || "@column".equals(evt.getResourceType())) && evt.getAccessResult() == 0).findFirst().ifPresent(evt -> originalCtx.getAuditHandler().getAuthzEvents().add((AuthzAuditEvent)evt));
            throw e;
        }
        finally {
            if (authorizationException == null) {
                List events = tmpCtx.getAuditHandler().getAuthzEvents().stream().filter(evt -> evt.getAccessResult() != 0).collect(Collectors.toList());
                originalCtx.getAuditHandler().getAuthzEvents().addAll(events);
            }
        }
    }

    private void throwIfColumnMaskingRequired(User user, String dbName, String tableName, String columnName) throws InternalException, AuthorizationException {
        if (this.evalColumnMask(user, dbName, tableName, columnName, null).isMaskEnabled()) {
            throw new AuthorizationException(String.format("Column masking is disabled by --enable_column_masking flag. Can't access column %s.%s.%s that has column masking policy.", dbName, tableName, columnName));
        }
    }

    @Override
    public boolean needsMaskingOrFiltering(User user, String dbName, String tableName, List<String> requiredColumns) throws InternalException {
        for (String column : requiredColumns) {
            if (!this.evalColumnMask(user, dbName, tableName, column, null).isMaskEnabled()) continue;
            return true;
        }
        return this.needsRowFiltering(user, dbName, tableName);
    }

    @Override
    public boolean needsRowFiltering(User user, String dbName, String tableName) throws InternalException {
        return this.evalRowFilter(user, dbName, tableName, null).isRowFilterEnabled();
    }

    private void removeStaleAudits(RangerBufferAuditHandler auditHandler, int numAuthzAuditEventsBefore) {
        List<AuthzAuditEvent> auditEvents = auditHandler.getAuthzEvents();
        Preconditions.checkState((auditEvents.size() - numAuthzAuditEventsBefore <= 1 ? 1 : 0) != 0);
        if (auditEvents.size() > numAuthzAuditEventsBefore) {
            auditHandler.getAuthzEvents().remove(auditEvents.size() - 1);
        }
    }

    @Override
    public String createColumnMask(User user, String dbName, String tableName, String columnName, AuthorizationContext rangerCtx) throws InternalException {
        RangerBufferAuditHandler auditHandler = rangerCtx == null ? null : ((RangerAuthorizationContext)rangerCtx).getAuditHandler();
        int numAuthzAuditEventsBefore = auditHandler == null ? 0 : auditHandler.getAuthzEvents().size();
        RangerAccessResult accessResult = this.evalColumnMask(user, dbName, tableName, columnName, auditHandler);
        if (!accessResult.isMaskEnabled() && auditHandler != null) {
            this.removeStaleAudits(auditHandler, numAuthzAuditEventsBefore);
            return columnName;
        }
        String maskType = accessResult.getMaskType();
        RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = accessResult.getMaskTypeDef();
        String maskedColumn = columnName;
        String transformer = null;
        if (maskTypeDef != null) {
            transformer = maskTypeDef.getTransformer();
        }
        if (StringUtils.equalsIgnoreCase((String)maskType, (String)"MASK_NULL")) {
            maskedColumn = "NULL";
        } else if (StringUtils.equalsIgnoreCase((String)maskType, (String)"CUSTOM")) {
            String maskedValue = accessResult.getMaskedValue();
            maskedColumn = maskedValue == null ? "NULL" : maskedValue.replace("{col}", columnName);
        } else if (StringUtils.isNotEmpty((String)transformer)) {
            maskedColumn = transformer.replace("{col}", columnName);
        }
        LOG.trace("dbName: {}, tableName: {}, column: {}, maskType: {}, columnTransformer: {}", new Object[]{dbName, tableName, columnName, maskType, maskedColumn});
        return maskedColumn;
    }

    @Override
    public String createRowFilter(User user, String dbName, String tableName, AuthorizationContext rangerCtx) throws InternalException {
        RangerBufferAuditHandler auditHandler = rangerCtx == null ? null : ((RangerAuthorizationContext)rangerCtx).getAuditHandler();
        int numAuthzAuditEventsBefore = auditHandler == null ? 0 : auditHandler.getAuthzEvents().size();
        RangerAccessResult accessResult = this.evalRowFilter(user, dbName, tableName, auditHandler);
        if (!accessResult.isRowFilterEnabled() && auditHandler != null) {
            this.removeStaleAudits(auditHandler, numAuthzAuditEventsBefore);
            return null;
        }
        String filter = accessResult.getFilterExpr();
        LOG.trace("dbName: {}, tableName: {}, rowFilter: {}", new Object[]{dbName, tableName, filter});
        return filter;
    }

    @Override
    public void postAnalyze(AuthorizationContext authzCtx) {
        Preconditions.checkArgument((boolean)(authzCtx instanceof RangerAuthorizationContext));
        ((RangerAuthorizationContext)authzCtx).stashTableMaskingAuditEvents(this.plugin_);
    }

    private RangerAccessResult evalColumnMask(User user, String dbName, String tableName, String columnName, RangerBufferAuditHandler auditHandler) throws InternalException {
        Preconditions.checkNotNull((Object)user);
        RangerAccessResourceImpl resource = new RangerImpalaResourceBuilder().database(dbName).table(tableName).column(columnName).build();
        RangerAccessRequestImpl req = new RangerAccessRequestImpl();
        req.setResource((RangerAccessResource)resource);
        req.setAccessType(SELECT_ACCESS_TYPE);
        req.setUser(user.getShortName());
        req.setUserGroups(this.getUserGroups(user));
        return this.plugin_.evalDataMaskPolicies((RangerAccessRequest)req, auditHandler);
    }

    private RangerAccessResult evalRowFilter(User user, String dbName, String tableName, RangerBufferAuditHandler auditHandler) throws InternalException {
        Preconditions.checkNotNull((Object)user);
        RangerAccessResourceImpl resource = new RangerImpalaResourceBuilder().database(dbName).table(tableName).build();
        RangerAccessRequestImpl req = new RangerAccessRequestImpl();
        req.setResource((RangerAccessResource)resource);
        req.setAccessType(SELECT_ACCESS_TYPE);
        req.setUser(user.getShortName());
        req.setUserGroups(this.getUserGroups(user));
        return this.plugin_.evalRowFilterPolicies((RangerAccessRequest)req, auditHandler);
    }

    private void throwIfRowFilteringRequired(User user, String dbName, String tableName) throws InternalException, AuthorizationException {
        if (this.evalRowFilter(user, dbName, tableName, null).isRowFilterEnabled()) {
            throw new AuthorizationException(String.format("Row filtering is disabled by --enable_row_filtering flag. Can't access table %s.%s that has row filtering policy.", dbName, tableName));
        }
    }

    @Override
    public Set<String> getUserGroups(User user) throws InternalException {
        Preconditions.checkNotNull((Object)user);
        UserGroupInformation ugi = RuntimeEnv.INSTANCE.isTestEnv() || BackendConfig.INSTANCE.useCustomizedUserGroupsMapperForRanger() ? UserGroupInformation.createUserForTesting((String)user.getShortName(), (String[])new String[]{user.getShortName()}) : UserGroupInformation.createRemoteUser((String)user.getShortName());
        return new HashSet<String>(ugi.getGroups());
    }

    private boolean authorizeAny(RangerAuthorizationContext authzCtx, RangerAccessResourceImpl resource, Authorizable authorizable, User user, Privilege privilege) throws InternalException {
        boolean authorized = false;
        RangerBufferAuditHandler originalAuditHandler = authzCtx.getAuditHandler();
        RangerBufferAuditHandler tmpAuditHandler = originalAuditHandler == null || !authzCtx.getRetainAudits() ? null : new RangerBufferAuditHandler(originalAuditHandler);
        for (Privilege impliedPrivilege : privilege.getImpliedPrivileges()) {
            if (!this.authorizeResource(authzCtx, user, resource, authorizable, impliedPrivilege, tmpAuditHandler)) continue;
            authorized = true;
            break;
        }
        if (originalAuditHandler != null && tmpAuditHandler != null) {
            RangerAuthorizationChecker.updateAuditEvents(tmpAuditHandler, originalAuditHandler, true, privilege);
        }
        return authorized;
    }

    private boolean authorizeAll(RangerAuthorizationContext authzCtx, RangerAccessResourceImpl resource, Authorizable authorizable, User user, Privilege privilege) throws InternalException {
        boolean authorized = true;
        RangerBufferAuditHandler originalAuditHandler = authzCtx.getAuditHandler();
        RangerBufferAuditHandler tmpAuditHandler = originalAuditHandler == null || !authzCtx.getRetainAudits() ? null : new RangerBufferAuditHandler(originalAuditHandler);
        for (Privilege impliedPrivilege : privilege.getImpliedPrivileges()) {
            if (this.authorizeResource(authzCtx, user, resource, authorizable, impliedPrivilege, tmpAuditHandler)) continue;
            authorized = false;
            break;
        }
        if (originalAuditHandler != null && tmpAuditHandler != null) {
            RangerAuthorizationChecker.updateAuditEvents(tmpAuditHandler, originalAuditHandler, false, resource.getKeys().contains("storage-type") ? Privilege.RWSTORAGE : privilege);
        }
        return authorized;
    }

    private static void updateAuditEvents(RangerBufferAuditHandler source, RangerBufferAuditHandler dest, boolean isAny, Privilege privilege) {
        AuthzAuditEvent newAuditEvent = null;
        for (AuthzAuditEvent auditEvent : source.getAuthzEvents()) {
            if (auditEvent.getAccessResult() == (isAny ? (short)1 : 0)) {
                newAuditEvent = auditEvent;
                break;
            }
            newAuditEvent = auditEvent;
        }
        if (newAuditEvent != null) {
            newAuditEvent.setAccessType(privilege.name().toLowerCase());
            dest.getAuthzEvents().add(newAuditEvent);
        }
    }

    private boolean authorizeResource(RangerAuthorizationContext authzCtx, User user, RangerAccessResourceImpl resource, Authorizable authorizable, Privilege privilege, RangerBufferAuditHandler auditHandler) throws InternalException {
        RangerAccessResult authorized;
        String accessType = resource.getKeys().contains("storage-type") ? Privilege.RWSTORAGE.name().toLowerCase() : (privilege == Privilege.ANY ? "_any" : (privilege == Privilege.INSERT ? UPDATE_ACCESS_TYPE : privilege.name().toLowerCase()));
        RangerAccessRequestImpl request = new RangerAccessRequestImpl();
        request.setResource((RangerAccessResource)resource);
        request.setAccessType(accessType);
        request.setUser(user.getShortName());
        request.setUserGroups(this.getUserGroups(user));
        request.setClusterName(this.plugin_.getClusterName());
        if (authzCtx.getSessionState() != null) {
            request.setClientIPAddress(authzCtx.getSessionState().getNetwork_address().getHostname());
        }
        if ((authorized = this.plugin_.isAccessAllowed((RangerAccessRequest)request, auditHandler)) == null || !authorized.getIsAllowed()) {
            return false;
        }
        if (!this.plugin_.blockUpdateIfTableMaskSpecified() || !privilege.impliesUpdate() || authorizable.getType() != Authorizable.Type.TABLE && authorizable.getType() != Authorizable.Type.COLUMN) {
            return true;
        }
        return this.authorizeByTableMasking(request, user, authorizable, authorized, privilege, auditHandler);
    }

    private boolean authorizeByTableMasking(RangerAccessRequestImpl request, User user, Authorizable authorizable, RangerAccessResult accessResult, Privilege privilege, RangerBufferAuditHandler auditHandler) throws InternalException {
        Preconditions.checkNotNull((Object)accessResult, (Object)"accessResult is null!");
        Preconditions.checkState((boolean)accessResult.getIsAllowed(), (Object)"update should be allowed before checking this");
        String originalAccessType = request.getAccessType();
        request.setAccessType(SELECT_ACCESS_TYPE);
        if (authorizable.getType() == Authorizable.Type.TABLE) {
            RangerAccessResult rowFilterResult = this.plugin_.evalRowFilterPolicies((RangerAccessRequest)request, null);
            if (rowFilterResult != null && rowFilterResult.isRowFilterEnabled()) {
                LOG.trace("Deny {} on {} due to row filtering policy {}", new Object[]{privilege, authorizable.getName(), rowFilterResult.getPolicyId()});
                accessResult.setIsAllowed(false);
                accessResult.setPolicyId(rowFilterResult.getPolicyId());
                accessResult.setReason("User does not have access to all rows of the table");
            } else {
                LOG.trace("No row filtering policy found on {}.", (Object)authorizable.getName());
            }
        }
        if (accessResult.getIsAllowed()) {
            ArrayList columns;
            if (authorizable.getType() == Authorizable.Type.TABLE) {
                columns = ((AuthorizableTable)authorizable).getColumns();
                LOG.trace("Checking mask policies on {} columns of table {}", (Object)columns.size(), (Object)authorizable.getFullTableName());
            } else {
                columns = Lists.newArrayList((Object[])new String[]{authorizable.getColumnName()});
            }
            for (String column : columns) {
                RangerAccessResult columnMaskResult = this.evalColumnMask(user, authorizable.getDbName(), authorizable.getTableName(), column, null);
                if (columnMaskResult != null && columnMaskResult.isMaskEnabled()) {
                    LOG.trace("Deny {} on {} due to column masking policy {}", new Object[]{privilege, authorizable.getName(), columnMaskResult.getPolicyId()});
                    accessResult.setIsAllowed(false);
                    accessResult.setPolicyId(columnMaskResult.getPolicyId());
                    accessResult.setReason("User does not have access to unmasked column values");
                    break;
                }
                LOG.trace("No column masking policy found on column {} of {}.", (Object)column, (Object)authorizable.getFullTableName());
            }
        }
        request.setAccessType(originalAccessType);
        if (!accessResult.getIsAllowed() && auditHandler != null) {
            auditHandler.processResult(accessResult);
        }
        return accessResult.getIsAllowed();
    }

    @VisibleForTesting
    public RangerImpalaPlugin getRangerImpalaPlugin() {
        return this.plugin_;
    }

    @Override
    public boolean roleExists(String roleName) {
        return RangerUtil.roleExists(this.plugin_, roleName);
    }
}

