/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.RuntimeEnv;

public class User {
    private final String name_;
    private final KerberosName kerberosName_;

    public User(String name) {
        Preconditions.checkNotNull((Object)name);
        this.name_ = name;
        this.kerberosName_ = new KerberosName(name);
    }

    public String getName() {
        return this.name_;
    }

    public String getShortName() throws InternalException {
        try {
            return this.kerberosName_.getShortName();
        }
        catch (IOException e) {
            throw new InternalException("Error calling getShortName() for user: " + this.getName(), e);
        }
    }

    @VisibleForTesting
    public String getShortNameForTesting(String rules) {
        Preconditions.checkNotNull((Object)rules);
        Preconditions.checkState((boolean)RuntimeEnv.INSTANCE.isTestEnv());
        String currentRules = KerberosName.getRules();
        KerberosName.setRules((String)rules);
        String shortName = null;
        try {
            shortName = this.getShortName();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        KerberosName.setRules((String)currentRules);
        return shortName;
    }

    @VisibleForTesting
    public static void setRulesForTesting(String rules) {
        Preconditions.checkState((boolean)RuntimeEnv.INSTANCE.isTestEnv());
        KerberosName.setRules((String)rules);
    }
}

