/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMask {
    private static final Logger LOG = LoggerFactory.getLogger(TableMask.class);
    private final AuthorizationChecker authChecker_;
    private final String dbName_;
    private final String tableName_;
    private final List<Column> requiredColumns_;
    private final List<String> requiredColumnNames_;
    private final User user_;
    private boolean hasComplexColumnMask_;

    public TableMask(AuthorizationChecker authzChecker, String dbName, String tableName, List<Column> requiredColumns, User user) {
        this.authChecker_ = (AuthorizationChecker)Preconditions.checkNotNull((Object)authzChecker);
        this.user_ = (User)Preconditions.checkNotNull((Object)user);
        this.dbName_ = (String)Preconditions.checkNotNull((Object)dbName);
        this.tableName_ = (String)Preconditions.checkNotNull((Object)tableName);
        this.requiredColumns_ = (List)Preconditions.checkNotNull(requiredColumns);
        this.requiredColumnNames_ = requiredColumns.stream().map(Column::getName).collect(Collectors.toList());
    }

    public List<Column> getRequiredColumns() {
        return this.requiredColumns_;
    }

    public boolean hasComplexColumnMask() {
        return this.hasComplexColumnMask_;
    }

    public boolean needsMaskingOrFiltering() throws InternalException {
        return this.authChecker_.needsMaskingOrFiltering(this.user_, this.dbName_, this.tableName_, this.requiredColumnNames_);
    }

    public boolean needsRowFiltering() throws InternalException {
        return this.authChecker_.needsRowFiltering(this.user_, this.dbName_, this.tableName_);
    }

    public SelectStmt createColumnMaskStmt(String colName, Type colType, AuthorizationContext authzCtx) throws InternalException, AnalysisException {
        String maskedValue = this.authChecker_.createColumnMask(this.user_, this.dbName_, this.tableName_, colName, authzCtx);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Performing column masking on table {}.{}: {} => {}", new Object[]{this.dbName_, this.tableName_, colName, maskedValue});
        }
        if (maskedValue == null || maskedValue.equals(colName)) {
            return null;
        }
        if (colType.isComplexType() || colName.contains(".")) {
            LOG.warn("Ignoring column mask on complex type {}.{}: {} => {}", new Object[]{this.dbName_, this.tableName_, colName, maskedValue});
            return null;
        }
        SelectStmt maskStmt = (SelectStmt)Parser.parse(String.format("SELECT CAST(%s AS %s)", maskedValue, colType));
        if (maskStmt.getSelectList().getItems().size() != 1 || maskStmt.hasGroupByClause() || maskStmt.hasHavingClause() || maskStmt.hasWhereClause()) {
            throw new AnalysisException("Illegal column masked value: " + maskedValue);
        }
        return maskStmt;
    }

    public Expr createColumnMask(String colName, Type colType, AuthorizationContext authzCtx) throws InternalException, AnalysisException {
        SelectStmt maskStmt = this.createColumnMaskStmt(colName, colType, authzCtx);
        if (maskStmt == null) {
            return new SlotRef(Arrays.asList(colName.split("\\.")));
        }
        Expr res = maskStmt.getSelectList().getItems().get(0).getExpr();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returned Expr: " + res.toSql());
        }
        return res;
    }

    public SelectStmt createRowFilterStmt(AuthorizationContext authzCtx) throws InternalException, AnalysisException {
        String rowFilter = this.authChecker_.createRowFilter(this.user_, this.dbName_, this.tableName_, authzCtx);
        if (rowFilter == null) {
            return null;
        }
        String stmtSql = String.format("SELECT 1 FROM foo WHERE %s", rowFilter);
        return (SelectStmt)Parser.parse(stmtSql);
    }

    public Expr createRowFilter(AuthorizationContext authzCtx) throws InternalException, AnalysisException {
        SelectStmt selectStmt = this.createRowFilterStmt(authzCtx);
        if (selectStmt == null) {
            return null;
        }
        return selectStmt.getWhereClause();
    }
}

