/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.authorization.Authorizable;
import org.apache.impala.authorization.AuthorizableTable;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.authorization.ImpalaInternalAdminUser;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeIncompleteTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.util.EventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthorizationChecker
implements AuthorizationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAuthorizationChecker.class);
    protected final AuthorizationConfig config_;

    protected BaseAuthorizationChecker(AuthorizationConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config_ = config;
    }

    @Override
    public boolean hasAccess(User user, PrivilegeRequest request) throws InternalException {
        return this.hasAccess(this.createAuthorizationContext(false, null, null, Optional.empty()), user, request);
    }

    private boolean hasAccess(AuthorizationContext authzCtx, User user, PrivilegeRequest request) throws InternalException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)request);
        if (!this.config_.isEnabled() || user instanceof ImpalaInternalAdminUser) {
            return true;
        }
        return this.authorizeResource(authzCtx, user, request);
    }

    @Override
    public boolean hasAnyAccess(User user, Set<PrivilegeRequest> requests) throws InternalException {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull(requests);
        for (PrivilegeRequest request : requests) {
            if (!this.hasAccess(user, request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postAuthorize(AuthorizationContext authzCtx, boolean authzOk, boolean analysisOk) {
        if (authzCtx.getTimeline().isPresent()) {
            EventSequence timeline = authzCtx.getTimeline().get();
            long durationMs = timeline.markEvent(String.format("Authorization finished (%s)", this.config_.getProviderName())) / 1000000L;
            LOG.debug("Authorization check took {} ms", (Object)durationMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authorize(AuthorizationContext authzCtx, AnalysisContext.AnalysisResult analysisResult, FeCatalog catalog) throws AuthorizationException, InternalException {
        Preconditions.checkNotNull((Object)analysisResult);
        Analyzer analyzer = analysisResult.getAnalyzer();
        if (analysisResult.isHierarchicalAuthStmt()) {
            LinkedHashMap tablePrivReqs = new LinkedHashMap();
            ArrayList<PrivilegeRequest> otherPrivReqs = new ArrayList<PrivilegeRequest>();
            for (PrivilegeRequest privReq : analyzer.getPrivilegeReqs()) {
                String tableName = privReq.getAuthorizable().getFullTableName();
                if (tableName == null) {
                    otherPrivReqs.add(privReq);
                    continue;
                }
                ArrayList<PrivilegeRequest> requests = (ArrayList<PrivilegeRequest>)tablePrivReqs.get(tableName);
                if (requests == null) {
                    requests = new ArrayList<PrivilegeRequest>();
                    tablePrivReqs.put(tableName, requests);
                }
                Preconditions.checkState((requests.isEmpty() || privReq.getAuthorizable().getType() != Authorizable.Type.COLUMN || ((PrivilegeRequest)requests.get(0)).getAuthorizable().getType() == Authorizable.Type.TABLE && ((PrivilegeRequest)requests.get(0)).getPrivilege() == Privilege.SELECT ? 1 : 0) != 0);
                requests.add(privReq);
            }
            for (PrivilegeRequest request : otherPrivReqs) {
                this.authorizePrivilegeRequest(authzCtx, analysisResult, catalog, request);
            }
            for (Map.Entry entry : tablePrivReqs.entrySet()) {
                this.authorizeTableAccess(authzCtx, analysisResult, catalog, (List)entry.getValue());
            }
        } else {
            for (PrivilegeRequest privReq : analyzer.getPrivilegeReqs()) {
                Preconditions.checkState((privReq.getAuthorizable().getType() != Authorizable.Type.COLUMN || analysisResult.isSingleColumnPrivStmt() ? 1 : 0) != 0);
                this.authorizePrivilegeRequest(authzCtx, analysisResult, catalog, privReq);
            }
        }
        for (Pair maskedReq : analyzer.getMaskedPrivilegeReqs()) {
            try {
                authzCtx.setRetainAudits(false);
                this.authorizePrivilegeRequest(authzCtx, analysisResult, catalog, (PrivilegeRequest)maskedReq.first);
            }
            catch (AuthorizationException e) {
                analysisResult.setUserHasProfileAccess(false);
                if (Strings.isNullOrEmpty((String)((String)maskedReq.second))) break;
                throw new AuthorizationException((String)maskedReq.second);
            }
            finally {
                authzCtx.setRetainAudits(true);
            }
        }
    }

    private void authorizePrivilegeRequest(AuthorizationContext authzCtx, AnalysisContext.AnalysisResult analysisResult, FeCatalog catalog, PrivilegeRequest request) throws AuthorizationException, InternalException {
        Preconditions.checkNotNull((Object)request);
        String dbName = null;
        if (request.getAuthorizable() != null) {
            dbName = request.getAuthorizable().getDbName();
        }
        if (dbName != null && this.checkSystemDbAccess(catalog, dbName, request.getPrivilege())) {
            return;
        }
        if (this.config_.isEnabled() && request.getAuthorizable() != null && request.getAuthorizable().getType() == Authorizable.Type.TABLE && (request.getPrivilege() != Privilege.REFRESH || !BackendConfig.INSTANCE.allowCatalogCacheOpFromMaskedUsers())) {
            FeTable table;
            Preconditions.checkNotNull((Object)dbName);
            AuthorizableTable authorizableTable = (AuthorizableTable)request.getAuthorizable();
            FeDb db = catalog.getDb(dbName);
            if (db != null && (table = db.getTable(authorizableTable.getTableName())) != null && !(table instanceof FeIncompleteTable)) {
                authorizableTable.setColumns(table.getColumnNames());
            }
        }
        this.checkAccess(authzCtx, analysisResult.getAnalyzer().getUser(), request);
    }

    protected void authorizeTableAccess(AuthorizationContext authzCtx, AnalysisContext.AnalysisResult analysisResult, FeCatalog catalog, List<PrivilegeRequest> requests) throws AuthorizationException, InternalException {
        Preconditions.checkArgument((!requests.isEmpty() ? 1 : 0) != 0);
        Analyzer analyzer = analysisResult.getAnalyzer();
        this.authorizeRowFilterAndColumnMask(analyzer.getUser(), requests);
        boolean hasTableSelectPriv = true;
        boolean hasColumnSelectPriv = false;
        for (PrivilegeRequest request : requests) {
            if (request.getAuthorizable().getType() == Authorizable.Type.TABLE) {
                try {
                    this.authorizePrivilegeRequest(authzCtx, analysisResult, catalog, request);
                }
                catch (AuthorizationException e) {
                    if (request.getPrivilege() != Privilege.SELECT) {
                        throw e;
                    }
                    hasTableSelectPriv = false;
                }
                continue;
            }
            Preconditions.checkState((request.getAuthorizable().getType() == Authorizable.Type.COLUMN ? 1 : 0) != 0);
            if (hasTableSelectPriv && request.getPrivilege() != Privilege.SELECT && request.getPrivilege() != Privilege.INSERT) continue;
            if (this.hasAccess(authzCtx, analyzer.getUser(), request)) {
                hasColumnSelectPriv = true;
                continue;
            }
            throw new AuthorizationException(String.format("User '%s' does not have privileges to execute '%s' on: %s", analyzer.getUser().getName(), request.getPrivilege().toString(), request.getAuthorizable().getFullTableName()));
        }
        if (!hasTableSelectPriv && !hasColumnSelectPriv) {
            throw new AuthorizationException(String.format("User '%s' does not have privileges to execute 'SELECT' on: %s", analyzer.getUser().getName(), requests.get(0).getAuthorizable().getFullTableName()));
        }
    }

    private boolean checkSystemDbAccess(FeCatalog catalog, String dbName, Privilege privilege) throws AuthorizationException {
        FeDb db = catalog.getDb(dbName);
        if (db != null && db.isSystemDb()) {
            switch (privilege) {
                case VIEW_METADATA: 
                case ANY: {
                    return true;
                }
                case SELECT: {
                    return false;
                }
            }
            throw new AuthorizationException("Cannot modify system database.");
        }
        return false;
    }

    private void checkAccess(AuthorizationContext authzCtx, User user, PrivilegeRequest privilegeRequest) throws AuthorizationException, InternalException {
        Preconditions.checkNotNull((Object)privilegeRequest);
        if (this.hasAccess(authzCtx, user, privilegeRequest)) {
            return;
        }
        Privilege privilege = privilegeRequest.getPrivilege();
        if (privilegeRequest.getAuthorizable().getType() == Authorizable.Type.FUNCTION) {
            throw new AuthorizationException(String.format("User '%s' does not have privileges%s to %s functions in: %s", new Object[]{user.getName(), BaseAuthorizationChecker.grantOption(privilegeRequest.hasGrantOption()), privilege, privilegeRequest.getName()}));
        }
        if (EnumSet.of(Privilege.ANY, Privilege.ALL, Privilege.VIEW_METADATA).contains((Object)privilege)) {
            throw new AuthorizationException(String.format("User '%s' does not have privileges%s to access: %s", user.getName(), BaseAuthorizationChecker.grantOption(privilegeRequest.hasGrantOption()), privilegeRequest.getName()));
        }
        if (privilege == Privilege.REFRESH) {
            throw new AuthorizationException(String.format("User '%s' does not have privileges%s to execute 'INVALIDATE METADATA/REFRESH' on: %s", user.getName(), BaseAuthorizationChecker.grantOption(privilegeRequest.hasGrantOption()), privilegeRequest.getName()));
        }
        if (privilege == Privilege.CREATE && privilegeRequest.getAuthorizable().getType() == Authorizable.Type.TABLE) {
            throw new AuthorizationException(String.format("User '%s' does not have privileges%s to execute '%s' on: %s", new Object[]{user.getName(), BaseAuthorizationChecker.grantOption(privilegeRequest.hasGrantOption()), privilege, privilegeRequest.getAuthorizable().getDbName()}));
        }
        throw new AuthorizationException(String.format("User '%s' does not have privileges%s to execute '%s' on: %s", new Object[]{user.getName(), BaseAuthorizationChecker.grantOption(privilegeRequest.hasGrantOption()), privilege, privilegeRequest.getName()}));
    }

    private static String grantOption(boolean hasGrantOption) {
        return hasGrantOption ? " with 'GRANT OPTION'" : "";
    }

    protected abstract boolean authorizeResource(AuthorizationContext var1, User var2, PrivilegeRequest var3) throws InternalException;

    @Override
    public abstract Set<String> getUserGroups(User var1) throws InternalException;

    protected abstract void authorizeRowFilterAndColumnMask(User var1, List<PrivilegeRequest> var2) throws AuthorizationException, InternalException;

    @Override
    public abstract void invalidateAuthorizationCache();
}

