/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.impala.thrift.TCatalogObject;

public class AuthorizationDelta {
    private final List<TCatalogObject> added_;
    private final List<TCatalogObject> removed_;

    public AuthorizationDelta() {
        this(new ArrayList<TCatalogObject>(), new ArrayList<TCatalogObject>());
    }

    public AuthorizationDelta(List<TCatalogObject> added, List<TCatalogObject> removed) {
        this.added_ = (List)Preconditions.checkNotNull(added);
        this.removed_ = (List)Preconditions.checkNotNull(removed);
    }

    public AuthorizationDelta addCatalogObjectAdded(TCatalogObject catalogObject) {
        this.added_.add(catalogObject);
        return this;
    }

    public AuthorizationDelta addCatalogObjectRemoved(TCatalogObject catalogObject) {
        this.removed_.add(catalogObject);
        return this;
    }

    public List<TCatalogObject> getCatalogObjectsAdded() {
        return Collections.unmodifiableList(this.added_);
    }

    public List<TCatalogObject> getCatalogObjectsRemoved() {
        return Collections.unmodifiableList(this.removed_);
    }
}

