/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.impala.authorization.Authorizable;

public class AuthorizableStorageHandlerUri
extends Authorizable {
    private final String storageType_;
    private final String storageUri_;

    public AuthorizableStorageHandlerUri(String storageType, String storageUri) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)storageType) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)storageUri) ? 1 : 0) != 0);
        this.storageType_ = storageType;
        this.storageUri_ = storageUri;
    }

    @Override
    public String getName() {
        return this.storageType_ + "://" + this.storageUri_;
    }

    @Override
    public String getStorageType() {
        return this.storageType_;
    }

    @Override
    public String getStorageUri() {
        return this.storageUri_;
    }

    @Override
    public Authorizable.Type getType() {
        return Authorizable.Type.STORAGEHANDLER_URI;
    }
}

