/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.impala.authorization.Authorizable;

public class AuthorizableFn
extends Authorizable {
    private final String dbName_;
    private final String fnName_;

    public AuthorizableFn(String dbName, String fnName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fnName) ? 1 : 0) != 0);
        this.dbName_ = dbName;
        this.fnName_ = fnName;
    }

    @Override
    public String getName() {
        return this.dbName_ + "." + this.fnName_;
    }

    @Override
    public Authorizable.Type getType() {
        return Authorizable.Type.FUNCTION;
    }

    @Override
    public String getDbName() {
        return this.dbName_;
    }

    @Override
    public String getFnName() {
        return this.fnName_;
    }
}

