/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.apache.impala.authorization.Authorizable;

public class AuthorizableColumn
extends Authorizable {
    private final String dbName_;
    private final String tableName_;
    private final String columnName_;
    @Nullable
    private final String ownerUser_;

    public AuthorizableColumn(String dbName, String tableName, String columnName, @Nullable String ownerUser) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dbName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)columnName) ? 1 : 0) != 0);
        this.dbName_ = dbName;
        this.tableName_ = tableName;
        this.columnName_ = columnName;
        this.ownerUser_ = ownerUser;
    }

    @Override
    public String getName() {
        return this.dbName_ + "." + this.tableName_ + "." + this.columnName_;
    }

    @Override
    public Authorizable.Type getType() {
        return Authorizable.Type.COLUMN;
    }

    @Override
    public String getFullTableName() {
        return this.dbName_ + "." + this.tableName_;
    }

    @Override
    public String getDbName() {
        return this.dbName_;
    }

    @Override
    public String getTableName() {
        return this.tableName_;
    }

    @Override
    public String getColumnName() {
        return this.columnName_;
    }

    @Override
    public String getOwnerUser() {
        return this.ownerUser_;
    }
}

