/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authentication.saml;

import java.util.HashMap;
import java.util.Optional;
import org.apache.impala.authentication.saml.HiveSamlAuthTokenGenerator;
import org.apache.impala.authentication.saml.HiveSamlGroupNameFilter;
import org.apache.impala.authentication.saml.HiveSamlHttpServlet;
import org.apache.impala.authentication.saml.HiveSamlRelayStateStore;
import org.apache.impala.authentication.saml.HttpSamlAuthenticationException;
import org.apache.impala.authentication.saml.HttpSamlNoGroupsMatchedException;
import org.apache.impala.authentication.saml.WrappedWebContext;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.BackendConfig;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.BearerAuthExtractor;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.credentials.extractor.SAML2CredentialsExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpalaSamlClient
extends SAML2Client {
    private static final Logger LOG = LoggerFactory.getLogger(ImpalaSamlClient.class);
    private static ImpalaSamlClient INSTANCE;
    private final HiveSamlGroupNameFilter groupNameFilter;
    private final HiveSamlHttpServlet samlHttpServlet;

    private ImpalaSamlClient() throws Exception {
        super(ImpalaSamlClient.getSamlConfig());
        RedirectionActionHelper.setUseModernHttpCodes((boolean)false);
        this.setCallbackUrl(ImpalaSamlClient.getCallBackUrl());
        this.setName(ImpalaSamlClient.class.getSimpleName());
        this.setStateGenerator(HiveSamlRelayStateStore.get());
        this.groupNameFilter = new HiveSamlGroupNameFilter();
        this.samlHttpServlet = new HiveSamlHttpServlet(this);
        this.init();
    }

    private static String getCallBackUrl() throws Exception {
        BackendConfig conf = BackendConfig.INSTANCE;
        return conf.getSaml2SpCallbackUrl();
    }

    public static synchronized ImpalaSamlClient get() throws InternalException {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        try {
            INSTANCE = new ImpalaSamlClient();
        }
        catch (Exception e) {
            throw new InternalException("Could not instantiate SAML2.0 client", e);
        }
        return INSTANCE;
    }

    private static SAML2Configuration getSamlConfig() throws Exception {
        BackendConfig conf = BackendConfig.INSTANCE;
        LOG.info("keystore path: " + conf.getSaml2KeystorePath());
        SAML2Configuration saml2Configuration = new SAML2Configuration(conf.getSaml2KeystorePath(), conf.getSaml2KeystorePassword(), conf.getSaml2PrivateKeyPassword(), conf.getSaml2IdpMetadata());
        saml2Configuration.setAuthnRequestBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        saml2Configuration.setResponseBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        saml2Configuration.setServiceProviderEntityId(conf.getSaml2SpEntityId());
        saml2Configuration.setWantsAssertionsSigned(conf.getSaml2WantAsserationsSigned());
        saml2Configuration.setAuthnRequestSigned(conf.getSaml2SignRequest());
        saml2Configuration.setAllSignatureValidationDisabled(conf.getSaml2EETestMode());
        return saml2Configuration;
    }

    public void setRedirect(WrappedWebContext webContext) throws InternalException {
        Optional<String> responsePort = webContext.getRequestHeader("X-Hive-Token-Response-Port");
        if (responsePort == null || !responsePort.isPresent()) {
            throw new InternalException("No response port specified");
        }
        LOG.debug("Request has response port set as {}", responsePort);
        Optional redirect = this.getRedirectionAction(webContext);
        if (redirect == null || !redirect.isPresent()) {
            throw new InternalException("Could not get the redirect response");
        }
        webContext.setResponseStatusCode(((RedirectionAction)redirect.get()).getCode());
        WithLocationAction locationAction = (WithLocationAction)redirect.get();
        webContext.setResponseHeader("Location", locationAction.getLocation());
    }

    public void validateAuthnResponse(WrappedWebContext webContext) throws InternalException {
        this.samlHttpServlet.doPost(webContext);
        webContext.setResponseStatusCode(200);
    }

    public String validateAuthnResponseInner(WrappedWebContext webContext) throws HttpSamlAuthenticationException {
        Optional credentials;
        try {
            SAML2CredentialsExtractor credentialsExtractor = new SAML2CredentialsExtractor((SAML2Client)this);
            credentials = credentialsExtractor.extract((WebContext)webContext);
        }
        catch (Exception ex) {
            throw new HttpSamlAuthenticationException("Could not validate the SAML response", ex);
        }
        if (!credentials.isPresent()) {
            throw new HttpSamlAuthenticationException("Credentials could not be extracted");
        }
        String nameId = ((SAML2Credentials)credentials.get()).getNameId().getValue();
        if (!this.groupNameFilter.apply(((SAML2Credentials)credentials.get()).getAttributes())) {
            LOG.warn("Could not match any groups for the nameid {}", (Object)nameId);
            throw new HttpSamlNoGroupsMatchedException("None of the configured groups match for the user");
        }
        return nameId;
    }

    public String validateBearer(WrappedWebContext webContext) throws InternalException {
        LOG.info(webContext.getRequestAsJsonString());
        try {
            return this.doSamlAuth(webContext);
        }
        catch (HttpSamlAuthenticationException ex) {
            throw new InternalException("SAML2 bearer validation failed", ex);
        }
    }

    private String doSamlAuth(WrappedWebContext webContext) throws HttpSamlAuthenticationException {
        BearerAuthExtractor extractor = new BearerAuthExtractor();
        Optional tokenCredentials = extractor.extract((WebContext)webContext);
        String token = tokenCredentials.map(TokenCredentials::getToken).orElse(null);
        if (token == null) {
            throw new HttpSamlAuthenticationException("No token found");
        }
        Optional<String> clientIdentifier = webContext.getRequestHeader("X-Hive-Client-Identifier");
        if (clientIdentifier == null || !clientIdentifier.isPresent()) {
            throw new HttpSamlAuthenticationException("Client identifier not found.");
        }
        String user = HiveSamlAuthTokenGenerator.get().validate(token);
        HashMap<String, String> keyValues = new HashMap<String, String>();
        if (HiveSamlAuthTokenGenerator.parse(token, keyValues)) {
            String relayStateKey = (String)keyValues.get("rs");
            if (!HiveSamlRelayStateStore.get().validateClientIdentifier(relayStateKey, clientIdentifier.get())) {
                throw new HttpSamlAuthenticationException("Code verifier could not be validated");
            }
        }
        return user;
    }
}

