/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authentication.saml;

import com.google.common.base.Preconditions;
import org.apache.impala.authentication.saml.AuthTokenGenerator;
import org.apache.impala.authentication.saml.HiveSamlAuthTokenGenerator;
import org.apache.impala.authentication.saml.HiveSamlRelayStateStore;
import org.apache.impala.authentication.saml.HttpSamlAuthenticationException;
import org.apache.impala.authentication.saml.HttpSamlNoGroupsMatchedException;
import org.apache.impala.authentication.saml.ImpalaSamlClient;
import org.apache.impala.authentication.saml.WrappedWebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSamlHttpServlet.class);
    private final AuthTokenGenerator tokenGenerator;
    ImpalaSamlClient samlClient;

    public HiveSamlHttpServlet(ImpalaSamlClient samlClient) {
        this.samlClient = samlClient;
        this.tokenGenerator = HiveSamlAuthTokenGenerator.get();
    }

    public void doPost(WrappedWebContext webContext) {
        String nameId;
        int port;
        String relayState;
        try {
            relayState = HiveSamlRelayStateStore.get().getRelayStateInfo(webContext);
            port = HiveSamlRelayStateStore.get().getRelayStateInfo(relayState).getPort();
        }
        catch (HttpSamlAuthenticationException e) {
            LOG.error("Invalid relay state", (Throwable)e);
            webContext.setResponseStatusCode(401);
            return;
        }
        try {
            LOG.debug("RelayState port is " + port);
            nameId = this.samlClient.validateAuthnResponseInner(webContext);
        }
        catch (HttpSamlAuthenticationException e) {
            if (e instanceof HttpSamlNoGroupsMatchedException) {
                LOG.error("Could not authenticate user since the groups didn't match", (Throwable)e);
            } else {
                LOG.error("SAML response could not be validated", (Throwable)e);
            }
            this.generateFormData(webContext, "http://127.0.0.1:" + port, null, false, "SAML assertion could not be validated. Check server logs for more details.");
            return;
        }
        Preconditions.checkState((nameId != null ? 1 : 0) != 0);
        LOG.debug("Successfully validated saml response. Forwarding the token to port " + port);
        this.generateFormData(webContext, "http://127.0.0.1:" + port, this.tokenGenerator.get(nameId, relayState), true, "");
    }

    private void generateFormData(WrappedWebContext webContext, String url, String token, boolean sucess, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<body onload='document.forms[\"form\"].submit()'>");
        sb.append(String.format("<form name='form' action='%s' method='POST'>", url));
        sb.append(String.format("<input type='hidden' name='%s' value='%s'/>", "token", token));
        sb.append(String.format("<input type='hidden' name='%s' value='%s'/>", "status", sucess));
        sb.append(String.format("<input type='hidden' name='%s' value='%s'/>", "message", msg));
        sb.append("</form>");
        sb.append("</body>");
        sb.append("</html>");
        webContext.setResponseContent("text/html;charset=utf-8", sb.toString());
    }
}

