/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authentication.saml;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.impala.authentication.saml.AuthTokenGenerator;
import org.apache.impala.authentication.saml.HttpSamlAuthenticationException;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlAuthTokenGenerator
implements AuthTokenGenerator {
    private final long ttlMs;
    private final SecureRandom rand = new SecureRandom();
    private final byte[] signatureSecret = Long.toString(this.rand.nextLong()).getBytes();
    private static final String USER = "u";
    private static final String SEPARATOR = "=";
    private static final String ATTR_SEPARATOR = ";";
    private static final String ID = "id";
    private static final String CREATE_TIME = "time";
    public static final String RELAY_STATE = "rs";
    private static final String SIGN = "sg";
    private static HiveSamlAuthTokenGenerator INSTANCE;
    private static final Logger LOG;

    public static synchronized AuthTokenGenerator get() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new HiveSamlAuthTokenGenerator();
        return INSTANCE;
    }

    private HiveSamlAuthTokenGenerator() {
        BackendConfig conf = BackendConfig.INSTANCE;
        this.ttlMs = conf.getSaml2CallbackTokenTtl();
    }

    @Override
    public String get(String username, String relayStateKey) {
        String id = String.valueOf(this.rand.nextLong());
        String time = String.valueOf(System.currentTimeMillis());
        LOG.debug("Generating token for user {} with id {} and time {}", new Object[]{username, id, time});
        String tokenStr = this.getTokenStr(username, id, time, relayStateKey);
        return this.sign(tokenStr);
    }

    private String getTokenStr(String username, String id, String timestamp, String relayStateKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(USER).append(SEPARATOR).append(username).append(ATTR_SEPARATOR);
        sb.append(ID).append(SEPARATOR).append(id).append(ATTR_SEPARATOR);
        sb.append(CREATE_TIME).append(SEPARATOR).append(timestamp).append(ATTR_SEPARATOR);
        sb.append(RELAY_STATE).append(SEPARATOR).append(relayStateKey);
        return sb.toString();
    }

    private String getSign(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input.getBytes());
            md.update(this.signatureSecret);
            byte[] digest = md.digest();
            return Base64.getEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String sign(String input) {
        return input + ATTR_SEPARATOR + SIGN + SEPARATOR + this.getSign(input);
    }

    @Override
    public String validate(String token) throws HttpSamlAuthenticationException {
        HashMap<String, String> keyValue = new HashMap<String, String>();
        if (!HiveSamlAuthTokenGenerator.parse(token, keyValue)) {
            throw new HttpSamlAuthenticationException("Invalid token");
        }
        String tokenStr = this.getTokenStr((String)keyValue.get(USER), (String)keyValue.get(ID), (String)keyValue.get(CREATE_TIME), (String)keyValue.get(RELAY_STATE));
        String signature = this.getSign(tokenStr);
        if (!this.signatureMatches((String)keyValue.get(SIGN), signature)) {
            throw new HttpSamlAuthenticationException("Token could not be verified");
        }
        if (this.isExpired(System.currentTimeMillis(), Long.parseLong((String)keyValue.get(CREATE_TIME)))) {
            throw new HttpSamlAuthenticationException("Token is expired");
        }
        return (String)keyValue.get(USER);
    }

    private boolean isExpired(long currentTime, long tokenTime) {
        if (currentTime >= tokenTime) {
            return currentTime - tokenTime > this.ttlMs;
        }
        return false;
    }

    private boolean signatureMatches(String origSign, String derivedSign) {
        return !MessageDigest.isEqual(origSign.getBytes(), derivedSign.getBytes());
    }

    public static boolean parse(String token, Map<String, String> kv) {
        String[] splits = token.split(ATTR_SEPARATOR);
        if (splits.length != 5) {
            return false;
        }
        for (String split : splits) {
            String[] pair = split.split(SEPARATOR);
            if (pair.length != 2) {
                return false;
            }
            kv.put(pair[0], pair[1]);
        }
        return kv.containsKey(USER) && kv.containsKey(CREATE_TIME) && kv.containsKey(ID) && kv.containsKey(SIGN) && kv.containsKey(RELAY_STATE);
    }

    static {
        LOG = LoggerFactory.getLogger(HiveSamlAuthTokenGenerator.class);
    }
}

