/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.View;
import org.apache.impala.common.AnalysisException;

public class WithClause
extends StmtNode {
    private final List<View> views_;

    public WithClause(List<View> views) {
        Preconditions.checkNotNull(views);
        Preconditions.checkState((!views.isEmpty() ? 1 : 0) != 0);
        this.views_ = views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        Analyzer withClauseAnalyzer = Analyzer.createWithNewGlobalState(analyzer);
        withClauseAnalyzer.setHasWithClause();
        if (analyzer.isExplain()) {
            withClauseAnalyzer.setIsExplain();
        }
        try {
            for (View view : this.views_) {
                Analyzer viewAnalyzer = new Analyzer(withClauseAnalyzer);
                view.getQueryStmt().analyze(viewAnalyzer);
                withClauseAnalyzer.registerLocalView(view);
            }
            for (FeView localView : withClauseAnalyzer.getLocalViews().values()) {
                analyzer.registerLocalView(localView);
            }
            analyzer.getAccessEvents().addAll(withClauseAnalyzer.getAccessEvents());
        }
        finally {
            for (PrivilegeRequest req : withClauseAnalyzer.getPrivilegeReqs()) {
                analyzer.registerPrivReq(req);
            }
        }
    }

    private WithClause(WithClause other) {
        Preconditions.checkNotNull((Object)other);
        this.views_ = new ArrayList<View>();
        for (View view : other.views_) {
            this.views_.add(new View(view.getName(), view.getQueryStmt().clone(), view.getOriginalColLabels()));
        }
    }

    public void reset() {
        for (View view : this.views_) {
            view.getQueryStmt().reset();
        }
    }

    public WithClause clone() {
        return new WithClause(this);
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        ArrayList<String> viewStrings = new ArrayList<String>();
        for (View view : this.views_) {
            String aliasSql = ToSqlUtils.getIdentSql(view.getName());
            if (view.getColLabels() != null) {
                aliasSql = aliasSql + "(" + Joiner.on((String)", ").join(ToSqlUtils.getIdentSqlList(view.getOriginalColLabels())) + ")";
            }
            viewStrings.add(aliasSql + " AS (" + view.getQueryStmt().toSql(options) + ")");
        }
        return "WITH " + Joiner.on((String)",").join(viewStrings);
    }

    public List<View> getViews() {
        return this.views_;
    }

    @Override
    public boolean resolveTableMask(Analyzer analyzer) throws AnalysisException {
        boolean hasChanges = false;
        for (View v : this.views_) {
            hasChanges |= v.getQueryStmt().resolveTableMask(analyzer);
        }
        return hasChanges;
    }
}

