/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;

public class ValidTupleIdExpr
extends Expr {
    private final Set<TupleId> tupleIds_;
    private Analyzer analyzer_;

    public ValidTupleIdExpr(List<TupleId> tupleIds) {
        Preconditions.checkState((tupleIds != null && !tupleIds.isEmpty() ? 1 : 0) != 0);
        this.tupleIds_ = Sets.newHashSet(tupleIds);
    }

    protected ValidTupleIdExpr(ValidTupleIdExpr other) {
        super(other);
        this.tupleIds_ = Sets.newHashSet(other.tupleIds_);
        this.analyzer_ = other.analyzer_;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.analyzer_ = analyzer;
        this.type_ = Type.INT;
    }

    @Override
    protected float computeEvalCost() {
        return (float)this.tupleIds_.size() * 1.0f;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.VALID_TUPLE_ID_EXPR;
        Preconditions.checkNotNull((Object)this.analyzer_);
        for (TupleId tid : this.tupleIds_) {
            TupleDescriptor tupleDesc = this.analyzer_.getTupleDesc(tid);
            Preconditions.checkNotNull((Object)tupleDesc, (Object)("Unknown tuple id: " + tid.toString()));
            Preconditions.checkState((boolean)tupleDesc.isMaterialized(), (Object)String.format("Illegal reference to non-materialized tuple: tid=%s", tid));
        }
    }

    @Override
    protected boolean localEquals(Expr that) {
        if (!super.localEquals(that)) {
            return false;
        }
        ValidTupleIdExpr other = (ValidTupleIdExpr)that;
        return other.tupleIds_.containsAll(this.tupleIds_) && this.tupleIds_.containsAll(other.tupleIds_);
    }

    @Override
    protected int localHash() {
        return Objects.hash(super.localHash(), this.tupleIds_);
    }

    @Override
    protected String toSqlImpl(ToSqlOptions options) {
        return "valid_tid(" + Joiner.on((String)",").join(this.tupleIds_) + ")";
    }

    @Override
    public boolean isBoundByTupleIds(List<TupleId> tids) {
        return tids.containsAll(this.tupleIds_);
    }

    @Override
    protected boolean isConstantImpl() {
        return false;
    }

    @Override
    public Expr clone() {
        return new ValidTupleIdExpr(this);
    }
}

