/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TUseDbParams;

public class UseStmt
extends StatementBase {
    private final String database_;

    public UseStmt(String db) {
        this.database_ = db;
    }

    public String getDatabase() {
        return this.database_;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return "USE " + this.database_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (!this.database_.equalsIgnoreCase("default")) {
            analyzer.getDb(this.database_, Privilege.ANY, true);
        }
    }

    public TUseDbParams toThrift() {
        TUseDbParams params = new TUseDbParams();
        params.setDb(this.getDatabase());
        return params;
    }
}

