/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.ExprSubstitutionMap;
import org.apache.impala.analysis.FromClause;
import org.apache.impala.analysis.IcebergUpdateImpl;
import org.apache.impala.analysis.KuduUpdateImpl;
import org.apache.impala.analysis.ModifyStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.common.Pair;
import org.apache.impala.planner.DataSink;

public class UpdateStmt
extends ModifyStmt {
    public UpdateStmt(List<String> targetTablePath, FromClause tableRefs, List<Pair<SlotRef, Expr>> assignmentExprs, Expr wherePredicate) {
        super(targetTablePath, tableRefs, assignmentExprs, wherePredicate);
    }

    public UpdateStmt(UpdateStmt other) {
        super(other.targetTablePath_, other.fromClause_.clone(), new ArrayList<Pair<SlotRef, Expr>>(), other.wherePredicate_);
    }

    @Override
    protected void createModifyImpl() {
        if (this.table_ instanceof FeKuduTable) {
            this.modifyImpl_ = new KuduUpdateImpl(this);
        } else if (this.table_ instanceof FeIcebergTable) {
            this.modifyImpl_ = new IcebergUpdateImpl(this);
        }
    }

    @Override
    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.modifyImpl_.substituteResultExprs(smap, analyzer);
    }

    @Override
    public DataSink createDataSink() {
        return this.modifyImpl_.createDataSink();
    }

    @Override
    public UpdateStmt clone() {
        return new UpdateStmt(this);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (!options.showRewritten() && this.sqlString_ != null) {
            return this.sqlString_;
        }
        StringBuilder b = new StringBuilder();
        b.append("UPDATE ");
        if (this.fromClause_ == null) {
            b.append(this.targetTableRef_.toSql(options));
        } else if (this.targetTableRef_.hasExplicitAlias()) {
            b.append(this.targetTableRef_.getExplicitAlias());
        } else {
            b.append(this.targetTableRef_.toSql(options));
        }
        b.append(" SET");
        boolean first = true;
        for (Pair i : this.assignments_) {
            if (!first) {
                b.append(",");
            } else {
                first = false;
            }
            b.append(String.format(" %s = %s", ((SlotRef)i.first).toSql(options), ((Expr)i.second).toSql(options)));
        }
        b.append(this.fromClause_.toSql(options));
        if (this.wherePredicate_ != null) {
            b.append(" WHERE ");
            b.append(this.wherePredicate_.toSql(options));
        }
        return b.toString();
    }
}

