/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;

public class TypesUtil {
    static final int DECIMAL_DIVISION_SCALE_INCREMENT = 4;

    public static int getDecimalSlotSize(ScalarType type) {
        Preconditions.checkState((type.isDecimal() && !type.isWildcardDecimal() ? 1 : 0) != 0);
        if (type.decimalPrecision() <= 9) {
            return 4;
        }
        if (type.decimalPrecision() <= 18) {
            return 8;
        }
        return 16;
    }

    public static ScalarType getDecimalAssignmentCompatibleType(ScalarType t1, ScalarType t2, boolean strictDecimal) {
        Preconditions.checkState((boolean)t1.isDecimal());
        Preconditions.checkState((boolean)t2.isDecimal());
        Preconditions.checkState((!t1.isWildcardDecimal() || !t2.isWildcardDecimal() ? 1 : 0) != 0);
        if (t1.isWildcardDecimal()) {
            return t2;
        }
        if (t2.isWildcardDecimal()) {
            return t1;
        }
        Preconditions.checkState((boolean)t1.isFullySpecifiedDecimal());
        Preconditions.checkState((boolean)t2.isFullySpecifiedDecimal());
        if (t1.equals(t2)) {
            return t1;
        }
        int s1 = t1.decimalScale();
        int s2 = t2.decimalScale();
        int p1 = t1.decimalPrecision();
        int p2 = t2.decimalPrecision();
        int digitsBefore = Math.max(p1 - s1, p2 - s2);
        int digitsAfter = Math.max(s1, s2);
        if (strictDecimal) {
            if (digitsBefore + digitsAfter > 38) {
                return Type.INVALID;
            }
            return ScalarType.createDecimalType(digitsBefore + digitsAfter, digitsAfter);
        }
        return ScalarType.createClippedDecimalType(digitsBefore + digitsAfter, digitsAfter);
    }

    public static Type getArithmeticResultType(Type t1, Type t2, ArithmeticExpr.Operator op, boolean decimalV2) throws AnalysisException {
        Preconditions.checkState((t1.isNumericType() || t1.isNull() ? 1 : 0) != 0);
        Preconditions.checkState((t2.isNumericType() || t2.isNull() ? 1 : 0) != 0);
        if (t1.isNull() && t2.isNull()) {
            return Type.NULL;
        }
        if (t1.isDecimal() || t2.isDecimal()) {
            if (t1.isNull()) {
                return t2;
            }
            if (t2.isNull()) {
                return t1;
            }
            if (op == ArithmeticExpr.Operator.MULTIPLY && (t1.isFloatingPointType() || t2.isFloatingPointType())) {
                return Type.DOUBLE;
            }
            t1 = ((ScalarType)t1).getMinResolutionDecimal();
            t2 = ((ScalarType)t2).getMinResolutionDecimal();
            Preconditions.checkState((boolean)t1.isDecimal());
            Preconditions.checkState((boolean)t2.isDecimal());
            return TypesUtil.getDecimalArithmeticResultType(t1, t2, op, decimalV2);
        }
        Type type = null;
        switch (op) {
            case MULTIPLY: 
            case ADD: 
            case SUBTRACT: {
                Type compatibleType = ScalarType.getAssignmentCompatibleType(t1, t2, TypeCompatibility.DEFAULT);
                Preconditions.checkState((boolean)compatibleType.isScalarType());
                type = ((ScalarType)compatibleType).getNextResolutionType();
                break;
            }
            case MOD: {
                type = ScalarType.getAssignmentCompatibleType(t1, t2, TypeCompatibility.DEFAULT);
                break;
            }
            case DIVIDE: {
                type = Type.DOUBLE;
                break;
            }
            default: {
                throw new AnalysisException("Invalid op: " + (Object)((Object)op));
            }
        }
        Preconditions.checkState((boolean)type.isValid());
        return type;
    }

    private static ScalarType getDecimalArithmeticResultType(Type t1, Type t2, ArithmeticExpr.Operator op, boolean decimalV2) throws AnalysisException {
        if (decimalV2) {
            return TypesUtil.getDecimalArithmeticResultTypeV2(t1, t2, op);
        }
        return TypesUtil.getDecimalArithmeticResultTypeV1(t1, t2, op);
    }

    private static ScalarType getDecimalArithmeticResultTypeV1(Type t1, Type t2, ArithmeticExpr.Operator op) throws AnalysisException {
        Preconditions.checkState((boolean)t1.isFullySpecifiedDecimal());
        Preconditions.checkState((boolean)t2.isFullySpecifiedDecimal());
        ScalarType st1 = (ScalarType)t1;
        ScalarType st2 = (ScalarType)t2;
        int s1 = st1.decimalScale();
        int s2 = st2.decimalScale();
        int p1 = st1.decimalPrecision();
        int p2 = st2.decimalPrecision();
        int sMax = Math.max(s1, s2);
        switch (op) {
            case ADD: 
            case SUBTRACT: {
                return ScalarType.createClippedDecimalType(sMax + Math.max(p1 - s1, p2 - s2) + 1, sMax);
            }
            case MULTIPLY: {
                return ScalarType.createClippedDecimalType(p1 + p2, s1 + s2);
            }
            case DIVIDE: {
                int resultScale = Math.max(4, s1 + p2 + 1);
                int resultPrecision = p1 - s1 + s2 + resultScale;
                if (resultPrecision > 38) {
                    resultScale = Math.max(s1, s2);
                    resultPrecision = 38;
                }
                return ScalarType.createClippedDecimalType(resultPrecision, resultScale);
            }
            case MOD: {
                return ScalarType.createClippedDecimalType(Math.min(p1 - s1, p2 - s2) + sMax, sMax);
            }
        }
        throw new AnalysisException("Operation '" + (Object)((Object)op) + "' is not allowed for decimal types.");
    }

    private static ScalarType getDecimalArithmeticResultTypeV2(Type t1, Type t2, ArithmeticExpr.Operator op) throws AnalysisException {
        int resultPrecision;
        int resultScale;
        Preconditions.checkState((boolean)t1.isFullySpecifiedDecimal());
        Preconditions.checkState((boolean)t2.isFullySpecifiedDecimal());
        ScalarType st1 = (ScalarType)t1;
        ScalarType st2 = (ScalarType)t2;
        int s1 = st1.decimalScale();
        int s2 = st2.decimalScale();
        int p1 = st1.decimalPrecision();
        int p2 = st2.decimalPrecision();
        switch (op) {
            case DIVIDE: {
                resultScale = Math.max(6, s1 + p2 + 1);
                resultPrecision = p1 - s1 + s2 + resultScale;
                break;
            }
            case MOD: {
                resultScale = Math.max(s1, s2);
                resultPrecision = Math.min(p1 - s1, p2 - s2) + resultScale;
                break;
            }
            case MULTIPLY: {
                resultScale = s1 + s2;
                resultPrecision = p1 + p2 + 1;
                break;
            }
            case ADD: 
            case SUBTRACT: {
                resultScale = Math.max(s1, s2);
                resultPrecision = Math.max(p1 - s1, p2 - s2) + resultScale + 1;
                break;
            }
            default: {
                Preconditions.checkState((boolean)false);
                return null;
            }
        }
        return ScalarType.createAdjustedDecimalType(resultPrecision, resultScale);
    }

    public static Type computeDecimalType(BigDecimal v) {
        String str = v.toPlainString();
        int digitsBefore = 0;
        int digitsAfter = 0;
        boolean decimalFound = false;
        boolean leadingZeros = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '-') continue;
            if (c == '.') {
                decimalFound = true;
                continue;
            }
            if (decimalFound) {
                ++digitsAfter;
                continue;
            }
            if (c == '0' && leadingZeros) continue;
            leadingZeros = false;
            ++digitsBefore;
        }
        if (digitsAfter > 38) {
            return null;
        }
        if (digitsBefore + digitsAfter > 38) {
            return null;
        }
        if (digitsBefore == 0 && digitsAfter == 0) {
            digitsBefore = 1;
        }
        return ScalarType.createDecimalType(digitsBefore + digitsAfter, digitsAfter);
    }
}

