/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TTruncateParams;

public class TruncateStmt
extends StatementBase {
    private TableName tableName_;
    private final boolean ifExists_;
    private FeTable table_;

    public TruncateStmt(TableName tableName, boolean ifExists) {
        Preconditions.checkNotNull((Object)tableName);
        this.tableName_ = tableName;
        this.table_ = null;
        this.ifExists_ = ifExists;
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        tblRefs.add(new TableRef(this.tableName_.toPath(), null));
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.tableName_ = analyzer.getFqTableName(this.tableName_);
        try {
            this.table_ = analyzer.getTable(this.tableName_, Privilege.INSERT);
        }
        catch (AnalysisException e) {
            if (this.ifExists_) {
                return;
            }
            throw e;
        }
        if (!(this.table_ instanceof FeFsTable)) {
            throw new AnalysisException(String.format("TRUNCATE TABLE not supported on non-HDFS table: %s", this.table_.getFullName()));
        }
        Analyzer.ensureTableNotFullAcid(this.table_, "TRUNCATE");
        Analyzer.checkTableCapability(this.table_, Analyzer.OperationType.WRITE);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return "TRUNCATE TABLE " + (this.ifExists_ ? " IF EXISTS " : "") + this.tableName_;
    }

    public TTruncateParams toThrift() {
        TTruncateParams params = new TTruncateParams();
        params.setTable_name(this.tableName_.toThrift());
        params.setIf_exists(this.ifExists_);
        return params;
    }
}

