/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.TTimestampLiteral;

public class TimestampLiteral
extends LiteralExpr {
    private final byte[] value_;
    private final String strValue_;

    public TimestampLiteral(byte[] value, String strValue) {
        Preconditions.checkState((value.length == Type.TIMESTAMP.getSlotSize() ? 1 : 0) != 0);
        this.value_ = value;
        this.strValue_ = strValue;
        this.type_ = Type.TIMESTAMP;
    }

    protected TimestampLiteral(TimestampLiteral other) {
        super(other);
        this.value_ = Arrays.copyOf(other.value_, other.value_.length);
        this.strValue_ = other.strValue_;
    }

    @Override
    protected boolean localEquals(Expr that) {
        return super.localEquals(that) && Arrays.equals(this.value_, ((TimestampLiteral)that).value_);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value_);
    }

    @Override
    public String toSqlImpl(ToSqlOptions options) {
        return "TIMESTAMP '" + this.getStringValue() + "'";
    }

    @Override
    public String getStringValue() {
        return this.strValue_;
    }

    public byte[] getValue() {
        return this.value_;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.TIMESTAMP_LITERAL;
        msg.timestamp_literal = new TTimestampLiteral();
        msg.timestamp_literal.setValue(this.value_);
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType, TypeCompatibility compatibility) throws AnalysisException {
        if (targetType.equals(this.type_)) {
            return this;
        }
        return new CastExpr(targetType, (Expr)this, compatibility);
    }

    @Override
    public int compareTo(LiteralExpr o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        TimestampLiteral other = (TimestampLiteral)o;
        return this.strValue_.compareTo(other.strValue_);
    }

    @Override
    public Expr clone() {
        return new TimestampLiteral(this);
    }
}

