/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.util.ExprUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTravelSpec
extends StmtNode {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTravelSpec.class);
    private Kind kind_;
    private Expr asOfExpr_;
    private long asOfVersion_ = -1L;
    private long asOfMicros_ = -1L;
    private String timeString_;
    private boolean analyzed_;

    public Kind getKind() {
        return this.kind_;
    }

    public long getAsOfVersion() {
        return this.asOfVersion_;
    }

    public long getAsOfMillis() {
        return this.asOfMicros_ == -1L ? -1L : this.asOfMicros_ / 1000L;
    }

    public long getAsOfMicros() {
        return this.asOfMicros_;
    }

    public TimeTravelSpec(Kind kind, Expr asOfExpr) {
        Preconditions.checkNotNull((Object)asOfExpr);
        this.kind_ = kind;
        this.asOfExpr_ = asOfExpr;
    }

    protected TimeTravelSpec(TimeTravelSpec other) {
        this.kind_ = other.kind_;
        this.asOfExpr_ = other.asOfExpr_.clone();
        this.asOfVersion_ = other.asOfVersion_;
        this.asOfMicros_ = other.asOfMicros_;
        this.timeString_ = other.timeString_;
    }

    public TimeTravelSpec clone() {
        return new TimeTravelSpec(this);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.analyzed_) {
            return;
        }
        switch (this.kind_) {
            case TIME_AS_OF: {
                this.analyzeTimeBased(analyzer);
                break;
            }
            case VERSION_AS_OF: {
                this.analyzeVersionBased(analyzer);
            }
        }
        this.analyzed_ = true;
    }

    private void analyzeTimeBased(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.asOfExpr_);
        try {
            this.asOfExpr_.analyze(analyzer);
        }
        catch (AnalysisException e) {
            if (e.getMessage().contains("Could not resolve column/field reference")) {
                throw new AnalysisException("FOR SYSTEM_TIME AS OF <expression> must be a constant expression: " + this.toSql());
            }
            throw e;
        }
        if (!this.asOfExpr_.isConstant()) {
            throw new AnalysisException("FOR SYSTEM_TIME AS OF <expression> must be a constant expression: " + this.toSql());
        }
        if (this.asOfExpr_.getType().isStringType()) {
            this.asOfExpr_ = new CastExpr(Type.TIMESTAMP, this.asOfExpr_);
        }
        if (!this.asOfExpr_.getType().isTimestamp()) {
            throw new AnalysisException("FOR SYSTEM_TIME AS OF <expression> must be a timestamp type but is '" + this.asOfExpr_.getType() + "': " + this.asOfExpr_.toSql());
        }
        try {
            this.asOfMicros_ = ExprUtil.localTimestampToUnixTimeMicros(analyzer, this.asOfExpr_);
            LOG.debug("FOR SYSTEM_TIME AS OF micros: " + String.valueOf(this.asOfMicros_));
        }
        catch (InternalException ie) {
            throw new AnalysisException("Invalid TIMESTAMP expression: " + ie.getMessage(), ie);
        }
        try {
            this.timeString_ = ExprUtil.localTimestampToString(analyzer, this.asOfExpr_);
            LOG.debug("FOR SYSTEM_TIME AS OF time: {}, {}", (Object)this.timeString_, (Object)analyzer.getQueryCtx().getLocal_time_zone());
        }
        catch (InternalException ie) {
            throw new AnalysisException("Invalid TIMESTAMP expression: " + ie.getMessage(), ie);
        }
    }

    private void analyzeVersionBased(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.asOfExpr_);
        this.asOfExpr_.analyze(analyzer);
        if (!(this.asOfExpr_ instanceof LiteralExpr)) {
            throw new AnalysisException("FOR SYSTEM_VERSION AS OF <expression> must be an integer literal: " + this.toSql());
        }
        if (!this.asOfExpr_.getType().isIntegerType()) {
            throw new AnalysisException("FOR SYSTEM_VERSION AS OF <expression> must be an integer type but is '" + this.asOfExpr_.getType() + "': " + this.asOfExpr_.toSql());
        }
        this.asOfVersion_ = this.asOfExpr_.evalToInteger(analyzer, "SYSTEM_VERSION AS OF");
        if (this.asOfVersion_ < 0L) {
            throw new AnalysisException("Invalid version number has been given to SYSTEM_VERSION AS OF: " + String.valueOf(this.asOfVersion_));
        }
        LOG.debug("FOR SYSTEM_VERSION AS OF version: " + String.valueOf(this.asOfVersion_));
    }

    public void reset() {
        this.asOfVersion_ = -1L;
        this.asOfMicros_ = -1L;
    }

    @Override
    public String toSql(ToSqlOptions options) {
        return String.format("FOR %s AS OF %s", this.kind_ == Kind.TIME_AS_OF ? "SYSTEM_TIME" : "SYSTEM_VERSION", this.asOfExpr_.toSql());
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    public String toTimeString() {
        Preconditions.checkState((boolean)Kind.TIME_AS_OF.equals((Object)this.kind_));
        return this.timeString_;
    }

    public static enum Kind {
        TIME_AS_OF,
        VERSION_AS_OF;

    }
}

