/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.AnalyticExpr;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BaseTableRef;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.JoinOperator;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.StmtNode;
import org.apache.impala.analysis.Subquery;
import org.apache.impala.analysis.TableSampleClause;
import org.apache.impala.analysis.TimeTravelSpec;
import org.apache.impala.analysis.ToSqlOptions;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.analysis.TupleDescriptor;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.planner.JoinNode;
import org.apache.impala.rewrite.ExprRewriter;
import org.apache.impala.thrift.TReplicaPreference;

public class TableRef
extends StmtNode {
    protected List<String> rawPath_;
    protected String[] aliases_;
    protected boolean hasExplicitAlias_;
    protected final Privilege priv_;
    protected final boolean requireGrantOption_;
    protected TableSampleClause sampleParams_;
    protected JoinOperator joinOp_;
    protected List<PlanHint> joinHints_ = new ArrayList<PlanHint>();
    protected List<String> usingColNames_;
    protected boolean allowEmptyOn_ = false;
    protected List<PlanHint> tableHints_ = new ArrayList<PlanHint>();
    protected TReplicaPreference replicaPreference_;
    protected boolean randomReplica_;
    protected int convertLimitToSampleHintPercent_;
    private JoinNode.DistributionMode distrMode_ = JoinNode.DistributionMode.NONE;
    protected ZippingUnnestType zippingUnnestType_ = ZippingUnnestType.NONE;
    protected Path resolvedPath_;
    protected Expr onClause_;
    protected TableRef leftTblRef_;
    protected boolean isAnalyzed_;
    protected List<TupleId> allTableRefIds_ = new ArrayList<TupleId>();
    protected List<TupleId> allMaterializedTupleIds_ = new ArrayList<TupleId>();
    protected List<TupleId> correlatedTupleIds_ = new ArrayList<TupleId>();
    protected TupleDescriptor desc_;
    protected boolean exposeNestedColumnsByTableMaskView_ = false;
    protected Map<String, Column> columns_ = new HashMap<String, Column>();
    protected TimeTravelSpec timeTravelSpec_;
    private boolean isHidden_ = false;
    private long tableNumRowsHint_ = -1L;
    private static final String TABLE_ROW_HINT = "TABLE_NUM_ROWS";

    public static TableRef newTableRef(Analyzer analyzer, List<String> rawPath, String alias) throws AnalysisException {
        TableRef ret = new TableRef(rawPath, alias);
        ret = analyzer.resolveTableRef(ret);
        ret.analyze(analyzer);
        return ret;
    }

    public TableRef(List<String> path, String alias) {
        this(path, alias, Privilege.SELECT);
    }

    public TableRef(List<String> path, String alias, TableSampleClause tableSample) {
        this(path, alias, tableSample, null);
    }

    public TableRef(List<String> path, String alias, TableSampleClause tableSample, TimeTravelSpec timeTravel) {
        this(path, alias, tableSample, timeTravel, Privilege.SELECT, false);
    }

    public TableRef(List<String> path, String alias, Privilege priv) {
        this(path, alias, null, null, priv, false);
    }

    public TableRef(List<String> path, String alias, Privilege priv, boolean requireGrantOption) {
        this(path, alias, null, null, priv, requireGrantOption);
    }

    public TableRef(List<String> path, String alias, TableSampleClause sampleParams, TimeTravelSpec timeTravel, Privilege priv, boolean requireGrantOption) {
        this.rawPath_ = path;
        if (alias != null) {
            this.aliases_ = new String[]{alias.toLowerCase()};
            this.hasExplicitAlias_ = true;
        } else {
            this.hasExplicitAlias_ = false;
        }
        this.sampleParams_ = sampleParams;
        this.priv_ = priv;
        this.requireGrantOption_ = requireGrantOption;
        this.isAnalyzed_ = false;
        this.replicaPreference_ = null;
        this.randomReplica_ = false;
        this.convertLimitToSampleHintPercent_ = -1;
        this.timeTravelSpec_ = timeTravel;
    }

    protected TableRef(TableRef other) {
        this.rawPath_ = other.rawPath_;
        this.resolvedPath_ = other.resolvedPath_;
        this.aliases_ = other.aliases_;
        this.hasExplicitAlias_ = other.hasExplicitAlias_;
        this.sampleParams_ = other.sampleParams_;
        this.timeTravelSpec_ = other.timeTravelSpec_ != null ? other.timeTravelSpec_.clone() : null;
        this.priv_ = other.priv_;
        this.requireGrantOption_ = other.requireGrantOption_;
        this.joinOp_ = other.joinOp_;
        this.joinHints_ = Lists.newArrayList(other.joinHints_);
        this.onClause_ = other.onClause_ != null ? other.onClause_.clone() : null;
        this.usingColNames_ = other.usingColNames_ != null ? Lists.newArrayList(other.usingColNames_) : null;
        this.allowEmptyOn_ = other.allowEmptyOn_;
        this.tableHints_ = Lists.newArrayList(other.tableHints_);
        this.replicaPreference_ = other.replicaPreference_;
        this.convertLimitToSampleHintPercent_ = other.convertLimitToSampleHintPercent_;
        this.randomReplica_ = other.randomReplica_;
        this.distrMode_ = other.distrMode_;
        this.leftTblRef_ = null;
        this.isAnalyzed_ = other.isAnalyzed_;
        this.allTableRefIds_ = Lists.newArrayList(other.allTableRefIds_);
        this.allMaterializedTupleIds_ = Lists.newArrayList(other.allMaterializedTupleIds_);
        this.correlatedTupleIds_ = Lists.newArrayList(other.correlatedTupleIds_);
        this.desc_ = other.desc_;
        this.exposeNestedColumnsByTableMaskView_ = other.exposeNestedColumnsByTableMaskView_;
        this.columns_ = new LinkedHashMap<String, Column>(other.columns_);
        this.isHidden_ = other.isHidden_;
        this.zippingUnnestType_ = other.zippingUnnestType_;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        throw new IllegalStateException("Should not call analyze() on an unresolved TableRef.");
    }

    public TupleDescriptor createTupleDescriptor(Analyzer analyzer) throws AnalysisException {
        TupleDescriptor result = analyzer.getDescTbl().createTupleDescriptor(this.getClass().getSimpleName() + " " + this.getUniqueAlias());
        result.setPath(this.resolvedPath_);
        return result;
    }

    protected void setJoinAttrs(TableRef other) {
        this.joinOp_ = other.joinOp_;
        this.joinHints_ = other.joinHints_;
        this.tableHints_ = other.tableHints_;
        this.onClause_ = other.onClause_;
        this.usingColNames_ = other.usingColNames_;
        this.allowEmptyOn_ = other.allowEmptyOn_;
    }

    public JoinOperator getJoinOp() {
        return this.joinOp_ == null ? JoinOperator.INNER_JOIN : this.joinOp_;
    }

    public boolean allowEmptyOn() {
        return this.allowEmptyOn_;
    }

    public void setAllowEmptyOn(boolean v) {
        this.allowEmptyOn_ = v;
    }

    public TReplicaPreference getReplicaPreference() {
        return this.replicaPreference_;
    }

    public boolean getRandomReplica() {
        return this.randomReplica_;
    }

    public boolean hasConvertLimitToSampleHint() {
        return this.convertLimitToSampleHintPercent_ != -1;
    }

    public int getConvertLimitToSampleHintPercent() {
        return this.convertLimitToSampleHintPercent_;
    }

    public long getTableNumRowsHint() {
        return this.tableNumRowsHint_;
    }

    public boolean isRelative() {
        return false;
    }

    public boolean isCollectionInSelectList() {
        return false;
    }

    public boolean isCorrelated() {
        return !this.correlatedTupleIds_.isEmpty();
    }

    public List<String> getPath() {
        return this.rawPath_;
    }

    public Path getResolvedPath() {
        return this.resolvedPath_;
    }

    public String[] getAliases() {
        return this.aliases_;
    }

    public String getUniqueAlias() {
        return this.aliases_[0];
    }

    public boolean hasExplicitAlias() {
        return this.hasExplicitAlias_;
    }

    public String getExplicitAlias() {
        if (this.hasExplicitAlias()) {
            return this.getUniqueAlias();
        }
        return null;
    }

    public FeTable getTable() {
        Preconditions.checkNotNull((Object)this.resolvedPath_);
        return this.resolvedPath_.getRootTable();
    }

    public TableSampleClause getSampleParams() {
        return this.sampleParams_;
    }

    public TimeTravelSpec getTimeTravelSpec() {
        return this.timeTravelSpec_;
    }

    public Privilege getPrivilege() {
        return this.priv_;
    }

    public boolean requireGrantOption() {
        return this.requireGrantOption_;
    }

    public List<PlanHint> getJoinHints() {
        return this.joinHints_;
    }

    public List<PlanHint> getTableHints() {
        return this.tableHints_;
    }

    public Expr getOnClause() {
        return this.onClause_;
    }

    public void setJoinOp(JoinOperator op) {
        this.joinOp_ = op;
    }

    public void setOnClause(Expr e) {
        this.onClause_ = e;
    }

    public void setUsingClause(List<String> colNames) {
        this.usingColNames_ = colNames;
    }

    public TableRef getLeftTblRef() {
        return this.leftTblRef_;
    }

    public void setLeftTblRef(TableRef leftTblRef) {
        this.leftTblRef_ = leftTblRef;
    }

    public void setExposeNestedColumnsByTableMaskView() {
        this.exposeNestedColumnsByTableMaskView_ = true;
    }

    public boolean exposeNestedColumnsByTableMaskView() {
        return this.exposeNestedColumnsByTableMaskView_;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden_ = isHidden;
    }

    public boolean isHidden() {
        return this.isHidden_;
    }

    public void setJoinHints(List<PlanHint> hints) {
        Preconditions.checkNotNull(hints);
        this.joinHints_ = hints;
    }

    public void setTableHints(List<PlanHint> hints) {
        Preconditions.checkNotNull(hints);
        this.tableHints_ = hints;
    }

    public void setTableSampleClause(TableSampleClause sampleParams) {
        this.sampleParams_ = sampleParams;
    }

    public boolean isBroadcastJoin() {
        return this.distrMode_ == JoinNode.DistributionMode.BROADCAST;
    }

    public boolean isPartitionedJoin() {
        return this.distrMode_ == JoinNode.DistributionMode.PARTITIONED;
    }

    public JoinNode.DistributionMode getDistributionMode() {
        return this.distrMode_;
    }

    public List<TupleId> getCorrelatedTupleIds() {
        return this.correlatedTupleIds_;
    }

    public boolean isAnalyzed() {
        return this.isAnalyzed_;
    }

    public boolean isResolved() {
        return !this.getClass().equals(TableRef.class);
    }

    public boolean isFromClauseZippingUnnest() {
        return this.zippingUnnestType_ == ZippingUnnestType.FROM_CLAUSE_ZIPPING_UNNEST;
    }

    public boolean isZippingUnnest() {
        return this.zippingUnnestType_ != ZippingUnnestType.NONE;
    }

    public ZippingUnnestType getZippingUnnestType() {
        return this.zippingUnnestType_;
    }

    public void setZippingUnnestType(ZippingUnnestType t) {
        this.zippingUnnestType_ = t;
    }

    public TupleDescriptor getDesc() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        Preconditions.checkState((this.desc_ != null ? 1 : 0) != 0);
        return this.desc_;
    }

    public TupleId getId() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        Preconditions.checkNotNull((Object)this.desc_);
        return this.desc_.getId();
    }

    public List<TupleId> getMaterializedTupleIds() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        Preconditions.checkNotNull((Object)this.desc_);
        return this.desc_.getId().asList();
    }

    public List<TupleId> getAllMaterializedTupleIds() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.allMaterializedTupleIds_;
    }

    public List<TupleId> getAllTableRefIds() {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        return this.allTableRefIds_;
    }

    protected void analyzeTableSample(Analyzer analyzer) throws AnalysisException {
        if (this.sampleParams_ == null) {
            return;
        }
        this.sampleParams_.analyze(analyzer);
        if (!(this instanceof BaseTableRef) || !(this.resolvedPath_.destTable() instanceof FeFsTable)) {
            throw new AnalysisException("TABLESAMPLE is only supported on HDFS tables: " + this.getUniqueAlias());
        }
    }

    protected void analyzeTimeTravel(Analyzer analyzer) throws AnalysisException {
        if (this.timeTravelSpec_ != null) {
            this.timeTravelSpec_.analyze(analyzer);
        }
    }

    protected void analyzeHints(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)this.isResolved());
        this.analyzeTableHints(analyzer);
        this.analyzeJoinHints(analyzer);
    }

    private void analyzeTableHints(Analyzer analyzer) {
        if (this.tableHints_.isEmpty()) {
            return;
        }
        if (!(this instanceof BaseTableRef)) {
            analyzer.addWarning("Table hints not supported for inline view and collections");
            return;
        }
        Preconditions.checkState((this.getResolvedPath() != null ? 1 : 0) != 0);
        boolean isTableHintSupported = true;
        if (this.getResolvedPath().destTable() != null && !this.supportTableHint(this.getResolvedPath().destTable(), analyzer)) {
            isTableHintSupported = false;
        }
        for (PlanHint hint : this.tableHints_) {
            List<String> args;
            if (hint.is("SCHEDULE_CACHE_LOCAL")) {
                analyzer.setHasPlanHints();
                this.replicaPreference_ = TReplicaPreference.CACHE_LOCAL;
                continue;
            }
            if (hint.is("SCHEDULE_DISK_LOCAL")) {
                analyzer.setHasPlanHints();
                this.replicaPreference_ = TReplicaPreference.DISK_LOCAL;
                continue;
            }
            if (hint.is("SCHEDULE_REMOTE")) {
                analyzer.setHasPlanHints();
                this.replicaPreference_ = TReplicaPreference.REMOTE;
                continue;
            }
            if (hint.is("SCHEDULE_RANDOM_REPLICA")) {
                analyzer.setHasPlanHints();
                this.randomReplica_ = true;
                continue;
            }
            if (hint.is("CONVERT_LIMIT_TO_SAMPLE")) {
                args = hint.getArgs();
                if (args == null || args.size() != 1) {
                    this.addHintWarning(hint, analyzer);
                    return;
                }
                try {
                    int samplePercent = Integer.parseInt(args.get(0));
                    if (samplePercent < 1 || samplePercent > 100) {
                        this.addHintWarning(hint, analyzer);
                        return;
                    }
                    analyzer.setHasPlanHints();
                    this.convertLimitToSampleHintPercent_ = samplePercent;
                }
                catch (NumberFormatException e) {
                    this.addHintWarning(hint, analyzer);
                }
                continue;
            }
            if (hint.is(TABLE_ROW_HINT)) {
                args = hint.getArgs();
                if (args == null || args.size() != 1 || !isTableHintSupported) {
                    this.addHintWarning(hint, analyzer);
                    return;
                }
                analyzer.setHasPlanHints();
                this.tableNumRowsHint_ = Long.parseLong(args.get(0));
                continue;
            }
            this.addHintWarning(hint, analyzer);
        }
    }

    private boolean supportTableHint(FeTable table, Analyzer analyzer) {
        if (table instanceof FeKuduTable) {
            if (this.tableHints_.size() != 1 || !this.tableHints_.get(0).is(TABLE_ROW_HINT)) {
                analyzer.addWarning(String.format("Kudu table only support '%s' hint.", TABLE_ROW_HINT));
                return false;
            }
        } else if (!(table instanceof FeFsTable)) {
            analyzer.addWarning("Table hints only supported for Hdfs/Kudu tables.");
            return false;
        }
        return true;
    }

    private void addHintWarning(PlanHint hint, Analyzer analyzer) {
        Preconditions.checkState((this.getAliases() != null && this.getAliases().length > 0 ? 1 : 0) != 0);
        analyzer.addWarning("Table hint not recognized for table " + this.getUniqueAlias() + ": " + hint);
    }

    private void analyzeJoinHints(Analyzer analyzer) throws AnalysisException {
        if (this.joinHints_.isEmpty()) {
            return;
        }
        for (PlanHint hint : this.joinHints_) {
            if (hint.is("BROADCAST")) {
                if (this.joinOp_ == JoinOperator.RIGHT_OUTER_JOIN || this.joinOp_ == JoinOperator.FULL_OUTER_JOIN || this.joinOp_ == JoinOperator.RIGHT_SEMI_JOIN || this.joinOp_ == JoinOperator.RIGHT_ANTI_JOIN) {
                    throw new AnalysisException(this.joinOp_.toString() + " does not support BROADCAST.");
                }
                if (this.isPartitionedJoin()) {
                    throw new AnalysisException("Conflicting JOIN hint: " + hint);
                }
                this.distrMode_ = JoinNode.DistributionMode.BROADCAST;
                analyzer.setHasPlanHints();
                continue;
            }
            if (hint.is("SHUFFLE")) {
                if (this.joinOp_ == JoinOperator.CROSS_JOIN) {
                    throw new AnalysisException("CROSS JOIN does not support SHUFFLE.");
                }
                if (this.isBroadcastJoin()) {
                    throw new AnalysisException("Conflicting JOIN hint: " + hint);
                }
                this.distrMode_ = JoinNode.DistributionMode.PARTITIONED;
                analyzer.setHasPlanHints();
                continue;
            }
            analyzer.addWarning("JOIN hint not recognized: " + hint);
        }
    }

    public void analyzeJoin(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((this.leftTblRef_ == null || this.leftTblRef_.isAnalyzed_ ? 1 : 0) != 0);
        Preconditions.checkState((this.desc_ != null ? 1 : 0) != 0);
        this.allTableRefIds_.clear();
        this.allMaterializedTupleIds_.clear();
        if (this.leftTblRef_ != null) {
            this.allTableRefIds_.addAll(this.leftTblRef_.getAllTableRefIds());
            this.allMaterializedTupleIds_.addAll(this.leftTblRef_.getAllMaterializedTupleIds());
        }
        this.allTableRefIds_.add(this.getId());
        this.allMaterializedTupleIds_.addAll(this.getMaterializedTupleIds());
        if (this.joinOp_ == JoinOperator.CROSS_JOIN) {
            this.distrMode_ = JoinNode.DistributionMode.BROADCAST;
        }
        if (this.usingColNames_ != null) {
            Preconditions.checkState((this.joinOp_ != JoinOperator.CROSS_JOIN ? 1 : 0) != 0);
            this.onClause_ = null;
            for (String colName : this.usingColNames_) {
                Path leftColPath = new Path(this.leftTblRef_.getDesc(), (List<String>)Lists.newArrayList((Object[])new String[]{colName.toLowerCase()}));
                if (!leftColPath.resolve()) {
                    throw new AnalysisException("unknown column " + colName + " for alias " + this.leftTblRef_.getUniqueAlias() + " (in \"" + this.toSql() + "\")");
                }
                Path rightColPath = new Path(this.desc_, (List<String>)Lists.newArrayList((Object[])new String[]{colName.toLowerCase()}));
                if (!rightColPath.resolve()) {
                    throw new AnalysisException("unknown column " + colName + " for alias " + this.getUniqueAlias() + " (in \"" + this.toSql() + "\")");
                }
                BinaryPredicate eqPred = new BinaryPredicate(BinaryPredicate.Operator.EQ, new SlotRef(Path.createRawPath(this.leftTblRef_.getUniqueAlias(), colName)), new SlotRef(Path.createRawPath(this.getUniqueAlias(), colName)));
                this.onClause_ = CompoundPredicate.createConjunction(eqPred, this.onClause_);
            }
        }
        if (this.joinOp_ == JoinOperator.LEFT_OUTER_JOIN || this.joinOp_ == JoinOperator.FULL_OUTER_JOIN) {
            analyzer.registerOuterJoinedTids(this.getId().asList(), this);
        }
        if (this.joinOp_ == JoinOperator.RIGHT_OUTER_JOIN || this.joinOp_ == JoinOperator.FULL_OUTER_JOIN) {
            analyzer.registerOuterJoinedTids(this.leftTblRef_.getAllTableRefIds(), this);
        }
        if (this.joinOp_ == JoinOperator.FULL_OUTER_JOIN) {
            analyzer.registerFullOuterJoinedTids(this.leftTblRef_.getAllTableRefIds(), this);
            analyzer.registerFullOuterJoinedTids(this.getId().asList(), this);
        }
        TupleId semiJoinedTupleId = null;
        if (this.joinOp_ == JoinOperator.LEFT_SEMI_JOIN || this.joinOp_ == JoinOperator.LEFT_ANTI_JOIN || this.joinOp_ == JoinOperator.NULL_AWARE_LEFT_ANTI_JOIN) {
            analyzer.registerSemiJoinedTid(this.getId(), this);
            semiJoinedTupleId = this.getId();
        }
        if (this.joinOp_ == JoinOperator.RIGHT_SEMI_JOIN || this.joinOp_ == JoinOperator.RIGHT_ANTI_JOIN) {
            analyzer.registerSemiJoinedTid(this.leftTblRef_.getId(), this);
            semiJoinedTupleId = this.leftTblRef_.getId();
        }
        if (this.onClause_ != null) {
            Preconditions.checkState((this.joinOp_ != JoinOperator.CROSS_JOIN ? 1 : 0) != 0);
            analyzer.setVisibleSemiJoinedTuple(semiJoinedTupleId);
            this.onClause_.analyze(analyzer);
            analyzer.setVisibleSemiJoinedTuple(null);
            this.onClause_.checkReturnsBool("ON clause", true);
            if (this.onClause_.contains(Expr.IS_AGGREGATE)) {
                throw new AnalysisException("aggregate function not allowed in ON clause: " + this.toSql());
            }
            if (this.onClause_.contains(AnalyticExpr.class)) {
                throw new AnalysisException("analytic expression not allowed in ON clause: " + this.toSql());
            }
            if (this.onClause_.contains(Subquery.class)) {
                throw new AnalysisException("Subquery is not allowed in ON clause: " + this.toSql());
            }
            HashSet<TupleId> onClauseTupleIds = new HashSet<TupleId>();
            List<Expr> conjuncts = this.onClause_.getConjuncts();
            analyzer.registerOnClauseConjuncts(conjuncts, this);
            for (Expr e : conjuncts) {
                ArrayList<TupleId> tupleIds = new ArrayList<TupleId>();
                e.getIds(tupleIds, null);
                onClauseTupleIds.addAll(tupleIds);
            }
        } else {
            if (!(this.allowEmptyOn() || this.isRelative() || this.isCorrelated() || !this.getJoinOp().isOuterJoin() && !this.getJoinOp().isSemiJoin())) {
                throw new AnalysisException(this.joinOp_.toString() + " requires an ON or USING clause.");
            }
            analyzer.registerOnClauseConjuncts(Collections.emptyList(), this);
        }
    }

    public void rewriteExprs(ExprRewriter rewriter, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed_);
        if (this.onClause_ != null) {
            this.onClause_ = rewriter.rewrite(this.onClause_, analyzer);
        }
    }

    public String debugString() {
        return this.tableRefToSql();
    }

    protected String tableRefToSql() {
        return this.tableRefToSql(ToSqlOptions.DEFAULT);
    }

    protected String tableRefToSql(ToSqlOptions options) {
        String aliasSql = null;
        String alias = this.getExplicitAlias();
        if (alias != null) {
            aliasSql = ToSqlUtils.getIdentSql(alias);
        }
        List<String> path = this.rawPath_;
        if (this.resolvedPath_ != null) {
            path = this.resolvedPath_.getFullyQualifiedRawPath();
        }
        return ToSqlUtils.getPathSql(path) + (aliasSql != null ? " " + aliasSql : "");
    }

    @Override
    public final String toSql() {
        return this.toSql(ToSqlOptions.DEFAULT);
    }

    @Override
    public String toSql(ToSqlOptions options) {
        if (this.isZippingUnnest()) {
            return "";
        }
        if (this.joinOp_ == null) {
            return (this.leftTblRef_ != null ? ", " : "") + this.tableRefToSql(options);
        }
        StringBuilder output = new StringBuilder(" " + this.joinOp_.toString() + " ");
        if (!this.joinHints_.isEmpty()) {
            output.append(ToSqlUtils.getPlanHintsSql(options, this.joinHints_)).append(" ");
        }
        output.append(this.tableRefToSql(options));
        if (this.usingColNames_ != null) {
            output.append(" USING (").append(Joiner.on((String)", ").join(this.usingColNames_)).append(")");
        } else if (this.onClause_ != null) {
            output.append(" ON ").append(this.onClause_.toSql(options));
        }
        return output.toString();
    }

    protected TableRef clone() {
        return new TableRef(this);
    }

    public void reset() {
        this.isAnalyzed_ = false;
        this.resolvedPath_ = null;
        if (this.usingColNames_ != null) {
            this.onClause_ = null;
        } else if (this.onClause_ != null) {
            this.onClause_.reset();
        }
        this.leftTblRef_ = null;
        this.allTableRefIds_.clear();
        this.allMaterializedTupleIds_.clear();
        this.correlatedTupleIds_.clear();
        this.desc_ = null;
        if (this.timeTravelSpec_ != null) {
            this.timeTravelSpec_.reset();
        }
    }

    public boolean isTableMaskingView() {
        return false;
    }

    public void registerColumn(Column column) {
        this.columns_.put(column.getName(), column);
    }

    public List<Column> getColumnsInHiveOrder() {
        return this.getTable().getColumnsInHiveOrder();
    }

    public List<Column> getSelectedColumnsInHiveOrder() {
        LinkedHashMap<String, Column> colSelection = new LinkedHashMap<String, Column>();
        for (Column c : this.getColumnsInHiveOrder()) {
            colSelection.put(c.getName(), null);
        }
        for (String colName : this.columns_.keySet()) {
            colSelection.put(colName, this.columns_.get(colName));
        }
        ArrayList<Column> res = new ArrayList<Column>();
        for (Column c : colSelection.values()) {
            if (c == null) continue;
            res.add(c);
        }
        Preconditions.checkState((res.size() == this.columns_.size() ? 1 : 0) != 0, (Object)("missing columns: " + res.size() + " != " + this.columns_.size()));
        return res;
    }

    void migratePropertiesTo(TableRef other) {
        other.aliases_ = this.aliases_;
        other.onClause_ = this.onClause_;
        other.usingColNames_ = this.usingColNames_;
        other.joinOp_ = this.joinOp_;
        other.joinHints_ = this.joinHints_;
        other.tableHints_ = this.tableHints_;
        other.timeTravelSpec_ = this.timeTravelSpec_;
        this.onClause_ = null;
        this.usingColNames_ = null;
        this.joinOp_ = null;
        this.joinHints_ = new ArrayList<PlanHint>();
        this.tableHints_ = new ArrayList<PlanHint>();
    }

    public static enum ZippingUnnestType {
        NONE,
        FROM_CLAUSE_ZIPPING_UNNEST,
        SELECT_LIST_ZIPPING_UNNEST;

    }
}

