/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.CatalogBlacklistUtils;

public class TableName {
    private final String db_;
    private final String tbl_;
    private final String vTbl_;

    public TableName(String db, String tbl) {
        this(db, tbl, null);
    }

    public TableName(String db, String tbl, String vTbl) {
        Preconditions.checkArgument((db == null || !db.isEmpty() ? 1 : 0) != 0);
        this.db_ = db;
        Preconditions.checkNotNull((Object)tbl);
        this.tbl_ = tbl;
        Preconditions.checkArgument((vTbl == null || !vTbl.isEmpty() ? 1 : 0) != 0);
        this.vTbl_ = vTbl;
    }

    public static TableName parse(String fullName) {
        if (fullName == null || fullName.trim().endsWith(".")) {
            return null;
        }
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((char)'.').trimResults().omitEmptyStrings().splitToList((CharSequence)fullName.toLowerCase()));
        if (parts.size() == 1) {
            return new TableName("default", (String)parts.get(0));
        }
        if (parts.size() == 2) {
            return new TableName((String)parts.get(0), (String)parts.get(1));
        }
        if (parts.size() == 3) {
            return new TableName((String)parts.get(0), (String)parts.get(1), (String)parts.get(2));
        }
        return null;
    }

    public String getDb() {
        return this.db_;
    }

    public String getTbl() {
        return this.tbl_;
    }

    public String getVTbl() {
        return this.vTbl_;
    }

    public boolean isEmpty() {
        return this.tbl_.isEmpty();
    }

    public void analyze() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.isFullyQualified());
        if (!MetastoreShim.validateName(this.db_)) {
            throw new AnalysisException("Invalid database name: " + this.db_);
        }
        if (!MetastoreShim.validateName(this.tbl_)) {
            throw new AnalysisException("Invalid table/view name: " + this.tbl_);
        }
        CatalogBlacklistUtils.verifyTableName(this);
    }

    public boolean isFullyQualified() {
        return this.db_ != null && !this.db_.isEmpty() && !this.tbl_.isEmpty();
    }

    public String toSql() {
        StringBuilder result = new StringBuilder();
        if (this.db_ == null) {
            result.append(ToSqlUtils.getIdentSql(this.tbl_));
        } else {
            result.append(ToSqlUtils.getIdentSql(this.db_) + "." + ToSqlUtils.getIdentSql(this.tbl_));
            if (this.vTbl_ != null && !this.vTbl_.isEmpty()) {
                result.append("." + ToSqlUtils.getIdentSql(this.vTbl_));
            }
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.db_ == null) {
            result.append(this.tbl_);
        } else {
            result.append(this.db_ + "." + this.tbl_);
            if (this.vTbl_ != null && !this.vTbl_.isEmpty()) {
                result.append("." + this.vTbl_);
            }
        }
        return result.toString();
    }

    public List<String> toPath() {
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        if (this.db_ != null) {
            result.add(this.db_);
        }
        result.add(this.tbl_);
        if (this.vTbl_ != null && !this.vTbl_.isEmpty()) {
            result.add(this.vTbl_);
        }
        return result;
    }

    public static TableName fromThrift(TTableName tableName) {
        return new TableName(tableName.getDb_name(), tableName.getTable_name());
    }

    public static String thriftToString(TTableName tableName) {
        return TableName.fromThrift(tableName).toString();
    }

    public TTableName toThrift() {
        return new TTableName(this.db_, this.tbl_);
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof TableName) {
            return this.toString().toLowerCase().equals(anObject.toString().toLowerCase());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }
}

