/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.impala.analysis.AlterTableSetTblProperties;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.HdfsCachingOp;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.KuduPartitionParam;
import org.apache.impala.analysis.TableDataLayout;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TAccessEvent;
import org.apache.impala.thrift.TBucketInfo;
import org.apache.impala.thrift.TBucketType;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.THdfsFileFormat;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TSortingOrder;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.thrift.TException;

class TableDef {
    private final TableName tableName_;
    private final List<ColumnDef> columnDefs_ = new ArrayList<ColumnDef>();
    private final List<String> primaryKeyColNames_ = new ArrayList<String>();
    private boolean isPrimaryKeyUnique_;
    private final boolean isExternal_;
    private final boolean ifNotExists_;
    private final TableDataLayout dataLayout_;
    private final List<ColumnDef> primaryKeyColDefs_ = new ArrayList<ColumnDef>();
    List<SQLPrimaryKey> sqlPrimaryKeys_ = new ArrayList<SQLPrimaryKey>();
    List<SQLForeignKey> sqlForeignKeys_ = new ArrayList<SQLForeignKey>();
    private boolean isAnalyzed_ = false;
    private Map<String, String> generatedProperties_ = new HashMap<String, String>();
    private Options options_;
    private PrimaryKey primaryKey_;
    private List<ForeignKey> foreignKeysList_ = new ArrayList<ForeignKey>();
    private TableName fqTableName_;

    public List<SQLPrimaryKey> getSqlPrimaryKeys() {
        return this.sqlPrimaryKeys_;
    }

    public List<SQLForeignKey> getSqlForeignKeys() {
        return this.sqlForeignKeys_;
    }

    TableDef(TableName tableName, boolean isExternal, boolean ifNotExists) {
        this.tableName_ = tableName;
        this.isExternal_ = isExternal;
        this.ifNotExists_ = ifNotExists;
        this.dataLayout_ = TableDataLayout.createEmptyLayout();
    }

    public void reset() {
        this.primaryKeyColDefs_.clear();
        this.columnDefs_.clear();
        this.isAnalyzed_ = false;
        this.generatedProperties_.clear();
    }

    public TableName getTblName() {
        return this.fqTableName_ != null ? this.fqTableName_ : this.tableName_;
    }

    public String getTbl() {
        return this.tableName_.getTbl();
    }

    public boolean isAnalyzed() {
        return this.isAnalyzed_;
    }

    List<ColumnDef> getColumnDefs() {
        return this.columnDefs_;
    }

    List<String> getColumnNames() {
        return ColumnDef.toColumnNames(this.columnDefs_);
    }

    List<Type> getColumnTypes() {
        return this.columnDefs_.stream().map(col -> col.getType()).collect(Collectors.toList());
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey_ = primaryKey;
    }

    public void setPrimaryKeyUnique(boolean isKeyUnique) {
        this.isPrimaryKeyUnique_ = isKeyUnique;
    }

    List<String> getPartitionColumnNames() {
        return ColumnDef.toColumnNames(this.getPartitionColumnDefs());
    }

    List<ColumnDef> getPartitionColumnDefs() {
        return this.dataLayout_.getPartitionColumnDefs();
    }

    boolean isKuduTable() {
        return this.options_.fileFormat == THdfsFileFormat.KUDU;
    }

    boolean isIcebergTable() {
        return this.options_.fileFormat == THdfsFileFormat.ICEBERG;
    }

    List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColNames_;
    }

    List<ColumnDef> getPrimaryKeyColumnDefs() {
        return this.primaryKeyColDefs_;
    }

    boolean isPrimaryKeyUnique() {
        return this.isPrimaryKeyUnique_;
    }

    boolean isExternal() {
        return this.isExternal_;
    }

    boolean getIfNotExists() {
        return this.ifNotExists_;
    }

    Map<String, String> getGeneratedProperties() {
        return this.generatedProperties_;
    }

    void putGeneratedProperty(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        this.generatedProperties_.put(key, value);
    }

    List<KuduPartitionParam> getKuduPartitionParams() {
        return this.dataLayout_.getKuduPartitionParams();
    }

    List<IcebergPartitionSpec> getIcebergPartitionSpecs() {
        return this.dataLayout_.getIcebergPartitionSpecs();
    }

    void setOptions(Options options) {
        Preconditions.checkNotNull((Object)options);
        this.options_ = options;
    }

    List<String> getSortColumns() {
        return this.options_.sortCols;
    }

    String getComment() {
        return this.options_.comment;
    }

    Map<String, String> getTblProperties() {
        return this.options_.tblProperties;
    }

    HdfsCachingOp getCachingOp() {
        return this.options_.cachingOp;
    }

    HdfsUri getLocation() {
        return this.options_.location;
    }

    Map<String, String> getSerdeProperties() {
        return this.options_.serdeProperties;
    }

    THdfsFileFormat getFileFormat() {
        return this.options_.fileFormat;
    }

    RowFormat getRowFormat() {
        return this.options_.rowFormat;
    }

    TSortingOrder getSortingOrder() {
        return this.options_.sortingOrder;
    }

    List<ForeignKey> getForeignKeysList() {
        return this.foreignKeysList_;
    }

    TBucketInfo geTBucketInfo() {
        return this.options_.bucketInfo;
    }

    boolean isBucketableFormat() {
        return this.options_.fileFormat != THdfsFileFormat.KUDU && this.options_.fileFormat != THdfsFileFormat.ICEBERG && this.options_.fileFormat != THdfsFileFormat.HUDI_PARQUET && this.options_.fileFormat != THdfsFileFormat.JDBC;
    }

    void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.isAnalyzed_) {
            return;
        }
        Preconditions.checkState((this.tableName_ != null && !this.tableName_.isEmpty() ? 1 : 0) != 0);
        this.fqTableName_ = analyzer.getFqTableName(this.getTblName());
        this.fqTableName_.analyze();
        this.analyzeAcidProperties(analyzer);
        this.analyzeColumnDefs(analyzer);
        this.analyzePrimaryKeys(analyzer);
        this.analyzeForeignKeys(analyzer);
        if (analyzer.dbContainsTable(this.getTblName().getDb(), this.getTbl(), Privilege.CREATE) && !this.getIfNotExists()) {
            throw new AnalysisException("Table already exists: " + this.getTblName());
        }
        analyzer.addAccessEvent(new TAccessEvent(this.fqTableName_.toString(), TCatalogObjectType.TABLE, Privilege.CREATE.toString()));
        Preconditions.checkNotNull((Object)this.options_);
        this.analyzeOptions(analyzer);
        this.isAnalyzed_ = true;
    }

    private void analyzeColumnDefs(Analyzer analyzer) throws AnalysisException {
        HashSet<String> colNames = new HashSet<String>();
        for (ColumnDef colDef : this.columnDefs_) {
            colDef.analyze(analyzer);
            if (!colNames.add(colDef.getColName().toLowerCase())) {
                throw new AnalysisException("Duplicate column name: " + colDef.getColName());
            }
            if (this.analyzeColumnOption(colDef)) continue;
            throw new AnalysisException(String.format("Unsupported column options for file format '%s': '%s'", this.getFileFormat().name(), colDef.toString()));
        }
        for (ColumnDef colDef : this.getPartitionColumnDefs()) {
            colDef.analyze(analyzer);
            if (!colDef.getType().supportsTablePartitioning()) {
                throw new AnalysisException(String.format("Type '%s' is not supported as partition-column type in column: %s", colDef.getType().toSql(), colDef.getColName()));
            }
            if (colNames.add(colDef.getColName().toLowerCase())) continue;
            throw new AnalysisException("Duplicate column name: " + colDef.getColName());
        }
    }

    private boolean analyzeColumnOption(ColumnDef columnDef) {
        return !(this.isKuduTable() ? columnDef.hasIncompatibleKuduOptions() : (this.isIcebergTable() ? columnDef.hasIncompatibleIcebergOptions() : columnDef.hasKuduOptions() || columnDef.hasIcebergOptions()));
    }

    private void analyzePrimaryKeys(Analyzer analyzer) throws AnalysisException {
        String primaryKeyString;
        for (ColumnDef colDef : this.columnDefs_) {
            if (!colDef.isPrimaryKey()) continue;
            this.primaryKeyColDefs_.add(colDef);
            if (colDef.isPrimaryKeyUnique() || this.isKuduTable()) continue;
            throw new AnalysisException("Non unique primary key is only supported for Kudu.");
        }
        if (this.primaryKeyColDefs_.size() > 1) {
            primaryKeyString = KuduUtil.getPrimaryKeyString(this.primaryKeyColDefs_.get(0).isPrimaryKeyUnique());
            throw new AnalysisException(String.format("Multiple %sS specified. Composite %s can be specified using the %s (col1, col2, ...) syntax at the end of the column definition.", primaryKeyString, primaryKeyString, primaryKeyString));
        }
        if (this.primaryKeyColNames_.isEmpty()) {
            if (this.primaryKey_ == null || this.primaryKey_.getPrimaryKeyColNames().isEmpty()) {
                if (!this.isKuduTable()) {
                    return;
                }
                if (!this.primaryKeyColDefs_.isEmpty()) {
                    this.setPrimaryKeyUnique(this.primaryKeyColDefs_.get(0).isPrimaryKeyUnique());
                    return;
                }
                if (!this.getKuduPartitionParams().isEmpty()) {
                    List<String> colNames = this.getColumnNames();
                    TreeMap<Integer, String> partitionCols = new TreeMap<Integer, String>();
                    for (KuduPartitionParam partitionParam : this.getKuduPartitionParams()) {
                        for (String colName : partitionParam.getColumnNames()) {
                            int index = colNames.indexOf(colName);
                            Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
                            partitionCols.put(index, colName);
                        }
                    }
                    if (partitionCols.size() > 0 && (Integer)partitionCols.lastKey() == partitionCols.size() - 1) {
                        this.primaryKeyColNames_.addAll(partitionCols.values());
                        this.setPrimaryKeyUnique(false);
                        analyzer.addWarning(String.format("Partition columns (%s) are promoted as non unique primary key.", String.join((CharSequence)", ", partitionCols.values())));
                    } else {
                        throw new AnalysisException("Specify primary key or non unique primary key for the Kudu table, or create partitions with the beginning columns of the table.");
                    }
                }
                if (this.primaryKeyColNames_.isEmpty()) {
                    return;
                }
            } else {
                this.primaryKeyColNames_.addAll(this.primaryKey_.getPrimaryKeyColNames());
            }
        }
        primaryKeyString = KuduUtil.getPrimaryKeyString(this.isPrimaryKeyUnique_);
        if (!this.primaryKeyColDefs_.isEmpty()) {
            throw new AnalysisException(String.format("Multiple %sS specified. Composite %s can be specified using the %s (col1, col2, ...) syntax at the end of the column definition.", primaryKeyString, primaryKeyString, primaryKeyString));
        }
        if (!(this.primaryKeyColNames_.isEmpty() || this.isPrimaryKeyUnique() || this.isKuduTable() || this.isIcebergTable())) {
            throw new AnalysisException(primaryKeyString + " is only supported for Kudu and Iceberg.");
        }
        if (this.isIcebergTable() && this.isPrimaryKeyUnique_) {
            throw new AnalysisException("Iceberg tables only support NOT ENFORCED primary keys.");
        }
        HashSet hashedPKColNames = Sets.newHashSet(this.primaryKeyColNames_);
        List<IcebergPartitionSpec> icebergPartitionSpecs = this.getIcebergPartitionSpecs();
        if (!icebergPartitionSpecs.isEmpty()) {
            Preconditions.checkState((icebergPartitionSpecs.size() == 1 ? 1 : 0) != 0);
            IcebergPartitionSpec partSpec = icebergPartitionSpecs.get(0);
            for (IcebergPartitionField partField : partSpec.getIcebergPartitionFields()) {
                if (hashedPKColNames.contains(partField.getFieldName())) continue;
                throw new AnalysisException("Partition columns have to be part of the primary key for Iceberg tables.");
            }
        }
        Map<String, ColumnDef> colDefsByColName = ColumnDef.mapByColumnNames(this.columnDefs_);
        int keySeq = 1;
        String constraintName = null;
        for (String colName : this.primaryKeyColNames_) {
            ColumnDef colDef = colDefsByColName.remove(colName = colName.toLowerCase());
            if (colDef == null) {
                if (ColumnDef.toColumnNames(this.primaryKeyColDefs_).contains(colName)) {
                    throw new AnalysisException(String.format("Column '%s' is listed multiple times as a %s.", colName, primaryKeyString));
                }
                throw new AnalysisException(String.format("%s column '%s' does not exist in the table", primaryKeyString, colName));
            }
            if (colDef.isExplicitNullable()) {
                throw new AnalysisException(primaryKeyString + " columns cannot be nullable: " + colDef.toString());
            }
            if (this.primaryKey_ != null) {
                if (this.primaryKey_.isEnableCstr()) {
                    throw new AnalysisException("ENABLE feature is not supported yet.");
                }
                if (this.primaryKey_.isValidateCstr()) {
                    throw new AnalysisException("VALIDATE feature is not supported yet.");
                }
                if (constraintName == null) {
                    constraintName = this.generateConstraintName();
                }
                this.sqlPrimaryKeys_.add(new SQLPrimaryKey(this.getTblName().getDb(), this.getTbl(), colDef.getColName(), keySeq++, constraintName, this.primaryKey_.enableCstr, this.primaryKey_.validateCstr, this.primaryKey_.relyCstr));
            }
            this.primaryKeyColDefs_.add(colDef);
        }
    }

    private void analyzeForeignKeys(Analyzer analyzer) throws AnalysisException {
        if (this.foreignKeysList_ == null || this.foreignKeysList_.size() == 0) {
            return;
        }
        for (ForeignKey fk : this.foreignKeysList_) {
            if (fk.getForeignKeyColNames().size() != fk.getPrimaryKeyColNames().size()) {
                throw new AnalysisException("The number of foreign key columns should be same as the number of parent key columns.");
            }
            String parentDb = fk.getPkTableName().getDb();
            if (parentDb == null) {
                parentDb = analyzer.getDefaultDb();
            }
            fk.fullyQualifiedPkTableName = new TableName(parentDb, fk.pkTableName.getTbl());
            if (!analyzer.dbContainsTable(parentDb, fk.getPkTableName().getTbl(), Privilege.VIEW_METADATA)) {
                throw new AnalysisException("Parent table not found: " + analyzer.getFqTableName(fk.getPkTableName()));
            }
            FeTable parentTable = analyzer.getTable(fk.getPkTableName(), Privilege.VIEW_METADATA);
            if (!(parentTable instanceof FeFsTable)) {
                throw new AnalysisException("Foreign keys on non-HDFS parent tables are not supported.");
            }
            for (String pkCol : fk.getPrimaryKeyColNames()) {
                if (!parentTable.getColumnNames().contains(pkCol.toLowerCase())) {
                    throw new AnalysisException("Parent column not found: " + pkCol.toLowerCase());
                }
                try {
                    if (((FeFsTable)parentTable).getPrimaryKeyColumnNames().contains(pkCol)) continue;
                    throw new AnalysisException(String.format("Parent column %s is not part of primary key.", pkCol));
                }
                catch (TException e) {
                    throw new AnalysisException("Failed to get primary key columns for " + fk.pkTableName);
                }
            }
            if (fk.isEnableCstr()) {
                throw new AnalysisException("ENABLE feature is not supported yet.");
            }
            if (fk.isValidateCstr()) {
                throw new AnalysisException("VALIDATE feature is not supported yet.");
            }
            if (fk.getFkConstraintName() == null) {
                fk.setConstraintName(this.generateConstraintName());
            }
            for (int i = 0; i < fk.getForeignKeyColNames().size(); ++i) {
                SQLForeignKey sqlForeignKey = new SQLForeignKey();
                sqlForeignKey.setPktable_db(parentDb);
                sqlForeignKey.setPktable_name(fk.getPkTableName().getTbl());
                sqlForeignKey.setFktable_db(this.getTblName().getDb());
                sqlForeignKey.setFktable_name(this.getTbl());
                sqlForeignKey.setPkcolumn_name(fk.getPrimaryKeyColNames().get(i).toLowerCase());
                sqlForeignKey.setFk_name(fk.getFkConstraintName());
                sqlForeignKey.setKey_seq(i + 1);
                sqlForeignKey.setFkcolumn_name(fk.getForeignKeyColNames().get(i).toLowerCase());
                sqlForeignKey.setRely_cstr(fk.isRelyCstr());
                this.getSqlForeignKeys().add(sqlForeignKey);
            }
        }
    }

    private String generateConstraintName() {
        return UUID.randomUUID().toString();
    }

    public static List<Integer> analyzeSortColumns(List<String> sortCols, FeTable table, TSortingOrder sortingOrder) throws AnalysisException {
        Preconditions.checkState((boolean)(table instanceof FeFsTable));
        List<Type> columnTypes = table.getNonClusteringColumns().stream().map(col -> col.getType()).collect(Collectors.toList());
        return TableDef.analyzeSortColumns(sortCols, Column.toColumnNames(table.getNonClusteringColumns()), Column.toColumnNames(table.getClusteringColumns()), columnTypes, sortingOrder);
    }

    public static List<Integer> analyzeSortColumns(List<String> sortCols, List<String> tableCols, List<String> partitionCols, List<Type> columnTypes, TSortingOrder sortingOrder) throws AnalysisException {
        LinkedHashSet<Integer> colIdxs = new LinkedHashSet<Integer>();
        int numColumns = 0;
        for (String sortColName : sortCols) {
            ++numColumns;
            if (partitionCols.contains(sortColName)) {
                throw new AnalysisException(String.format("SORT BY column list must not contain partition column: '%s'", sortColName));
            }
            boolean foundColumn = false;
            for (int j = 0; j < tableCols.size(); ++j) {
                if (!tableCols.get(j).equalsIgnoreCase(sortColName)) continue;
                if (colIdxs.contains(j)) {
                    throw new AnalysisException(String.format("Duplicate column in SORT BY list: %s", sortColName));
                }
                colIdxs.add(j);
                foundColumn = true;
                break;
            }
            if (foundColumn) continue;
            throw new AnalysisException(String.format("Could not find SORT BY column '%s' in table.", sortColName));
        }
        if (sortingOrder == TSortingOrder.ZORDER && numColumns == 1) {
            throw new AnalysisException(String.format("SORT BY ZORDER with 1 column is equivalent to SORT BY. Please, use the latter, if that was your intention.", new Object[0]));
        }
        Preconditions.checkState((numColumns == colIdxs.size() ? 1 : 0) != 0);
        return Lists.newArrayList(colIdxs);
    }

    private void analyzeOptions(Analyzer analyzer) throws AnalysisException {
        MetaStoreUtil.checkShortPropertyMap("Property", this.options_.tblProperties);
        MetaStoreUtil.checkShortPropertyMap("Serde property", this.options_.serdeProperties);
        if (this.options_.location != null) {
            this.options_.location.analyze(analyzer, Privilege.ALL, FsAction.READ_WRITE);
        }
        if (this.options_.cachingOp != null) {
            this.options_.cachingOp.analyze(analyzer);
            if (this.options_.cachingOp.shouldCache() && this.options_.location != null && !FileSystemUtil.isPathCacheable(this.options_.location.getPath())) {
                throw new AnalysisException(String.format("Location '%s' cannot be cached. Please retry without caching: CREATE TABLE ... UNCACHED", this.options_.location));
            }
        }
        AlterTableSetTblProperties.analyzeSkipHeaderLineCount(this.options_.tblProperties);
        this.analyzeRowFormat(analyzer);
        String sortByKey = "sort.columns";
        String sortOrderKey = "sort.order";
        if (this.options_.tblProperties.containsKey(sortByKey)) {
            throw new AnalysisException(String.format("Table definition must not contain the %s table property. Use SORT BY (...) instead.", sortByKey));
        }
        if (this.options_.tblProperties.containsKey(sortOrderKey)) {
            throw new AnalysisException(String.format("Table definition must not contain the %s table property. Use SORT BY %s (...) instead.", sortOrderKey, this.options_.sortingOrder.toString()));
        }
        this.analyzeBucketColumns(this.options_.bucketInfo, this.getColumnNames(), this.getPartitionColumnNames());
        if (this.options_.sortCols == null) {
            return;
        }
        if (this.isKuduTable()) {
            throw new AnalysisException(String.format("SORT BY is not supported for Kudu tables.", new Object[0]));
        }
        TableDef.analyzeSortColumns(this.options_.sortCols, this.getColumnNames(), this.getPartitionColumnNames(), this.getColumnTypes(), this.options_.sortingOrder);
    }

    private void analyzeBucketColumns(TBucketInfo bucketInfo, List<String> tableCols, List<String> partitionCols) throws AnalysisException {
        if (bucketInfo == null || bucketInfo.getBucket_type() == TBucketType.NONE) {
            return;
        }
        if (!this.isBucketableFormat()) {
            throw new AnalysisException(String.format("CLUSTERED BY not support fileformat: '%s'", new Object[]{this.options_.fileFormat}));
        }
        if (bucketInfo.getNum_bucket() <= 0) {
            throw new AnalysisException(String.format("Bucket's number must be greater than 0.", new Object[0]));
        }
        if (bucketInfo.getBucket_columns() == null || bucketInfo.getBucket_columns().size() == 0) {
            throw new AnalysisException(String.format("Bucket columns must be not null.", new Object[0]));
        }
        LinkedHashSet<Integer> colIdxs = new LinkedHashSet<Integer>();
        for (String bucketCol : bucketInfo.getBucket_columns()) {
            if (partitionCols.contains(bucketCol)) {
                throw new AnalysisException(String.format("CLUSTERED BY column list must not contain partition column: '%s'", bucketCol));
            }
            boolean foundColumn = false;
            for (int j = 0; j < tableCols.size(); ++j) {
                if (!tableCols.get(j).equalsIgnoreCase(bucketCol)) continue;
                if (colIdxs.contains(j)) {
                    throw new AnalysisException(String.format("Duplicate column in CLUSTERED BY list: %s", bucketCol));
                }
                colIdxs.add(j);
                foundColumn = true;
                break;
            }
            if (foundColumn) continue;
            throw new AnalysisException(String.format("Could not find CLUSTERED BY column '%s' in table.", bucketCol));
        }
    }

    private void analyzeRowFormat(Analyzer analyzer) throws AnalysisException {
        if (this.options_.rowFormat == null) {
            return;
        }
        if (this.isKuduTable()) {
            throw new AnalysisException(String.format("ROW FORMAT cannot be specified for file format %s.", new Object[]{this.options_.fileFormat}));
        }
        Byte fieldDelim = this.analyzeRowFormatValue(this.options_.rowFormat.getFieldDelimiter());
        Byte lineDelim = this.analyzeRowFormatValue(this.options_.rowFormat.getLineDelimiter());
        Byte escapeChar = this.analyzeRowFormatValue(this.options_.rowFormat.getEscapeChar());
        if (this.options_.fileFormat == THdfsFileFormat.TEXT) {
            if (fieldDelim == null) {
                fieldDelim = 1;
            }
            if (lineDelim == null) {
                lineDelim = 10;
            }
            if (escapeChar == null) {
                escapeChar = 0;
            }
            if (fieldDelim.equals(lineDelim)) {
                throw new AnalysisException("Field delimiter and line delimiter have same value: byte " + fieldDelim);
            }
            if (fieldDelim.equals(escapeChar)) {
                analyzer.addWarning("Field delimiter and escape character have same value: byte " + fieldDelim + ". Escape character will be ignored");
            }
            if (lineDelim.equals(escapeChar)) {
                analyzer.addWarning("Line delimiter and escape character have same value: byte " + lineDelim + ". Escape character will be ignored");
            }
        }
    }

    private Byte analyzeRowFormatValue(String value) throws AnalysisException {
        if (value == null) {
            return null;
        }
        Byte byteVal = HdfsStorageDescriptor.parseDelim(value);
        if (byteVal == null) {
            throw new AnalysisException("ESCAPED BY values and LINE/FIELD terminators must be specified as a single character or as a decimal value in the range [-128:127]: " + value);
        }
        return byteVal;
    }

    private void analyzeAcidProperties(Analyzer analyzer) throws AnalysisException {
        if (this.isExternal_) {
            if (AcidUtils.isTransactionalTable(this.options_.tblProperties)) {
                throw new AnalysisException("EXTERNAL tables cannot be transactional");
            }
            return;
        }
        if (this.options_.fileFormat == THdfsFileFormat.KUDU) {
            if (AcidUtils.isTransactionalTable(this.options_.tblProperties)) {
                throw new AnalysisException("Kudu tables cannot be transactional");
            }
            return;
        }
        if (this.options_.fileFormat == THdfsFileFormat.ICEBERG) {
            if (AcidUtils.isTransactionalTable(this.options_.tblProperties)) {
                throw new AnalysisException("Iceberg tables cannot have Hive ACID table properties.");
            }
            return;
        }
        AcidUtils.setTransactionalProperties(this.options_.tblProperties, analyzer.getQueryOptions().getDefault_transactional_type());
    }

    static class ForeignKey {
        final TableName pkTableName;
        final List<String> primaryKeyColNames;
        final List<String> foreignKeyColNames;
        String fkConstraintName;
        TableName fullyQualifiedPkTableName;
        final boolean relyCstr;
        final boolean validateCstr;
        final boolean enableCstr;

        ForeignKey(TableName pkTableName, List<String> primaryKeyColNames, List<String> foreignKeyColNames, String fkName, boolean relyCstr, boolean validateCstr, boolean enableCstr) {
            this.pkTableName = pkTableName;
            this.primaryKeyColNames = primaryKeyColNames;
            this.foreignKeyColNames = foreignKeyColNames;
            this.relyCstr = relyCstr;
            this.validateCstr = validateCstr;
            this.enableCstr = enableCstr;
            this.fkConstraintName = fkName;
        }

        public TableName getPkTableName() {
            return this.pkTableName;
        }

        public List<String> getPrimaryKeyColNames() {
            return this.primaryKeyColNames;
        }

        public List<String> getForeignKeyColNames() {
            return this.foreignKeyColNames;
        }

        public String getFkConstraintName() {
            return this.fkConstraintName;
        }

        public void setConstraintName(String constraintName) {
            this.fkConstraintName = constraintName;
        }

        public TableName getFullyQualifiedPkTableName() {
            return this.fullyQualifiedPkTableName;
        }

        public boolean isRelyCstr() {
            return this.relyCstr;
        }

        public boolean isValidateCstr() {
            return this.validateCstr;
        }

        public boolean isEnableCstr() {
            return this.enableCstr;
        }
    }

    static class PrimaryKey {
        final TableName pkTableName;
        final List<String> primaryKeyColNames;
        final String pkConstraintName;
        final boolean relyCstr;
        final boolean validateCstr;
        final boolean enableCstr;

        public PrimaryKey(TableName pkTableName, List<String> primaryKeyColNames, String pkConstraintName, boolean relyCstr, boolean validateCstr, boolean enableCstr) {
            this.pkTableName = pkTableName;
            this.primaryKeyColNames = primaryKeyColNames;
            this.pkConstraintName = pkConstraintName;
            this.relyCstr = relyCstr;
            this.validateCstr = validateCstr;
            this.enableCstr = enableCstr;
        }

        public TableName getPkTableName() {
            return this.pkTableName;
        }

        public List<String> getPrimaryKeyColNames() {
            return this.primaryKeyColNames;
        }

        public String getPkConstraintName() {
            return this.pkConstraintName;
        }

        public boolean isRelyCstr() {
            return this.relyCstr;
        }

        public boolean isValidateCstr() {
            return this.validateCstr;
        }

        public boolean isEnableCstr() {
            return this.enableCstr;
        }
    }

    static class Options {
        final List<String> sortCols;
        final String comment;
        final RowFormat rowFormat;
        final Map<String, String> serdeProperties;
        final THdfsFileFormat fileFormat;
        final HdfsUri location;
        final HdfsCachingOp cachingOp;
        final Map<String, String> tblProperties;
        final TSortingOrder sortingOrder;
        final TBucketInfo bucketInfo;

        Options(TBucketInfo bucketInfo, Pair<List<String>, TSortingOrder> sortProperties, String comment, RowFormat rowFormat, Map<String, String> serdeProperties, THdfsFileFormat fileFormat, HdfsUri location, HdfsCachingOp cachingOp, Map<String, String> tblProperties, TQueryOptions queryOptions) {
            this.sortCols = (List)sortProperties.first;
            this.sortingOrder = (TSortingOrder)((Object)sortProperties.second);
            this.comment = comment;
            this.rowFormat = rowFormat;
            Preconditions.checkNotNull(serdeProperties);
            this.serdeProperties = serdeProperties;
            this.fileFormat = fileFormat != null ? fileFormat : queryOptions.getDefault_file_format();
            this.location = location;
            this.cachingOp = cachingOp;
            Preconditions.checkNotNull(tblProperties);
            this.tblProperties = tblProperties;
            this.bucketInfo = bucketInfo;
        }

        public Options(String comment, TQueryOptions queryOptions) {
            this(null, new Pair<ImmutableList, TSortingOrder>(ImmutableList.of(), TSortingOrder.LEXICAL), comment, RowFormat.DEFAULT_ROW_FORMAT, new HashMap<String, String>(), null, null, null, new HashMap<String, String>(), queryOptions);
        }
    }
}

